/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions;

import buildcraftAdditions.api.item.BCAItemManager;
import buildcraftAdditions.api.item.dust.IDust;
import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.compat.ModuleManager;
import buildcraftAdditions.compat.imc.IMCHandler;
import buildcraftAdditions.compat.imc.IMCSender;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.core.GuiHandler;
import buildcraftAdditions.core.SpecialListMananger;
import buildcraftAdditions.creative.TabBCAdditions;
import buildcraftAdditions.creative.TabCanisters;
import buildcraftAdditions.creative.TabDusts;
import buildcraftAdditions.items.dust.DustManager;
import buildcraftAdditions.items.dust.DustTypes;
import buildcraftAdditions.listeners.EventListener;
import buildcraftAdditions.networking.PacketHandler;
import buildcraftAdditions.proxy.CommonProxy;
import buildcraftAdditions.recipe.duster.DusterRecipeManager;
import buildcraftAdditions.recipe.refinery.CoolingTowerRecipeManager;
import buildcraftAdditions.recipe.refinery.RefineryRecipeManager;
import buildcraftAdditions.reference.ArmorLoader;
import buildcraftAdditions.reference.BlockLoader;
import buildcraftAdditions.reference.ItemLoader;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="bcadditions", name="BuildCraft Additions", version="2.2.5", guiFactory="buildcraftAdditions.config.GuiFactory", dependencies="required-after:BuildCraft|Core;required-after:eureka;before:zCraftingManager;required-after:Forge@[10.13.2.1236,);", acceptedMinecraftVersions="1.7.10")
public class BuildcraftAdditions {
    public static final CreativeTabs bcadditions = new TabBCAdditions();
    public static final CreativeTabs bcaCannisters = new TabCanisters();
    public static final CreativeTabs bcaDusts = new TabDusts();
    @Mod.Instance(value="bcadditions")
    public static BuildcraftAdditions instance;
    @SidedProxy(clientSide="buildcraftAdditions.proxy.ClientProxy", serverSide="buildcraftAdditions.proxy.CommonProxy")
    public static CommonProxy proxy;
    public ModuleManager manager = new ModuleManager();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.manager.setupModules();
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        PacketHandler.init();
        BlockLoader.loadBlocks();
        ItemLoader.loadItems();
        ArmorLoader.loadArmor();
        proxy.registerEntities();
        SpecialListMananger.init();
        BCARecipeManager.duster = new DusterRecipeManager();
        BCARecipeManager.cooling = new CoolingTowerRecipeManager();
        BCARecipeManager.refinery = new RefineryRecipeManager();
        BCAItemManager.dusts = new DustManager();
        OreDictionary.registerOre((String)"rodBlaze", (Item)Items.field_151072_bj);
        OreDictionary.registerOre((String)"dustBlaze", (Item)Items.field_151065_br);
        OreDictionary.registerOre((String)"materialSnowball", (Item)Items.field_151126_ay);
        OreDictionary.registerOre((String)"blockSand", (Block)Blocks.field_150354_m);
        OreDictionary.registerOre((String)"blockSoulSand", (Block)Blocks.field_150425_aM);
        this.manager.preInit(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)GuiHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)new EventListener.FML());
        MinecraftForge.EVENT_BUS.register((Object)new EventListener.Forge());
        proxy.addListeners();
        IMCSender.sendMessages();
        BlockLoader.registerTileEntities();
        int meta = 1;
        BCAItemManager.dusts.addDust(meta++, "Iron", 13815497, DustTypes.METAL_DUST);
        BCAItemManager.dusts.addDust(meta++, "Gold", 16310039, DustTypes.METAL_DUST);
        BCAItemManager.dusts.addDust(meta, "Diamond", 1305852, DustTypes.GEM_DUST);
        meta = 55;
        BCAItemManager.dusts.addDust(meta++, "Emerald", 45112, DustTypes.GEM_DUST);
        BCAItemManager.dusts.addDust(meta++, "Coal", 0x1B1B1B, new DustTypes.SimpleDustAlwaysValid(new ItemStack(Items.field_151044_h)));
        BCAItemManager.dusts.addDust(meta++, "Charcoal", 5458234, new DustTypes.SimpleDustAlwaysValid(new ItemStack(Items.field_151044_h, 1, 1)));
        BCAItemManager.dusts.addDust(meta++, "Obsidian", 1511716, new DustTypes.SimpleDustAlwaysValid(new ItemStack(Blocks.field_150343_Z), 4));
        BCAItemManager.dusts.addDust(meta++, "EnderPearl", 1072721, new DustTypes.SimpleDustAlwaysValid(new ItemStack(Items.field_151079_bi)));
        BCAItemManager.dusts.addDust(meta, "NetherQuartz", 14404799, new DustTypes.SimpleDustAlwaysValid(new ItemStack(Items.field_151044_h, 1, 1)));
        meta = 83;
        BCAItemManager.dusts.addDust(meta, "GildedRedMetal", 16739867, new DustTypes.DustAlwaysValid());
        BCARecipeManager.duster.addRecipe("oreRedstone", new ItemStack(Items.field_151137_ax, 10));
        BCARecipeManager.duster.addRecipe("oreCoal", new ItemStack(Items.field_151044_h, 2));
        BCARecipeManager.duster.addRecipe("oreLapis", new ItemStack(Items.field_151100_aR, 12, 4));
        BCARecipeManager.duster.addRecipe("oreQuartz", new ItemStack(Items.field_151128_bU, 2));
        BCARecipeManager.duster.addRecipe("stone", new ItemStack(Blocks.field_150351_n));
        BCARecipeManager.duster.addRecipe("cobblestone", new ItemStack((Block)Blocks.field_150354_m));
        BCARecipeManager.duster.addRecipe("oreDiamond", new ItemStack(Items.field_151045_i, 2));
        BCARecipeManager.duster.addRecipe("oreEmerald", new ItemStack(Items.field_151166_bC, 2));
        BCARecipeManager.duster.addRecipe("rodBlaze", new ItemStack(Items.field_151065_br, 4));
        this.manager.init(event);
        BlockLoader.addRecipes();
        ItemLoader.addRecipes();
        ArmorLoader.addRecipes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.manager.postInit(event);
    }

    @Mod.EventHandler
    public void doneLoading(FMLLoadCompleteEvent event) {
        IMCHandler.handleIMC((List<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)this));
        this.manager.doneLoadingEvent(event);
        for (IDust iDust : BCAItemManager.dusts.getDusts()) {
            if (iDust == null) continue;
            iDust.getDustType().register(iDust.getMeta(), iDust.getName(), iDust.getDustStack());
        }
        if (OreDictionary.getOres((String)"dustGold").isEmpty() || OreDictionary.getOres((String)"dustIron").isEmpty()) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(ItemLoader.gildedRedMetalIngot, new Object[]{"ingotGold", "ingotGold", "ingotGold", "ingotIron", "ingotIron", "dustRedstone"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ItemLoader.conductivePlateRaw, new Object[]{"DD", "DD", Character.valueOf('D'), "ingotGildedRedMetal"}));
        } else {
            ItemStack dust = BCAItemManager.dusts.getDust("GildedRedMetal").getDustStack().func_77946_l();
            dust.field_77994_a = 6;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(dust, new Object[]{"dustGold", "dustGold", "dustGold", "dustIron", "dustIron", "dustRedstone"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ItemLoader.conductivePlateRaw, new Object[]{"DD", "DD", Character.valueOf('D'), "dustGildedRedMetal"}));
        }
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        IMCHandler.handleIMC((List<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (mapping.name.equals("bcadditions:condictuvePlateRaw")) {
                mapping.remap(ItemLoader.conductivePlateRaw);
                continue;
            }
            if (mapping.name.equals("bcadditions:PowerCapsuleTier1")) {
                mapping.remap(ItemLoader.powerCapsuleTier1);
                continue;
            }
            if (mapping.name.equals("bcadditions:backpackstandGhost")) {
                mapping.remap(BlockLoader.backpackStandGhost);
                continue;
            }
            if (mapping.name.equals("bcadditions:blankUpgrade")) {
                mapping.remap(ItemLoader.blankUpgrade);
                continue;
            }
            if (mapping.name.equals("bcadditions:condictuvePlate")) {
                mapping.remap(ItemLoader.conductivePlate);
                continue;
            }
            if (mapping.name.equals("bcadditions:toolUpgradeChaisaw")) {
                mapping.remap((Item)ItemLoader.toolUpgradeChainsaw);
                continue;
            }
            if (mapping.name.equals("bcadditions:ingotGildedRedMetal")) {
                mapping.remap(ItemLoader.gildedRedMetalIngot);
                continue;
            }
            if (mapping.name.equals("bcadditions:itemKineticMultiTool")) {
                mapping.remap(ItemLoader.kineticMultiTool);
                continue;
            }
            if (mapping.name.equals("bcadditions:robotDebugTool")) {
                mapping.ignore();
                continue;
            }
            if (!mapping.name.contains("converter")) continue;
            mapping.ignore();
        }
    }
}

