/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.tileentity;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import shetiphian.core.TileEntityBase;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.misc.TankFunctions;
import shetiphian.endertanks.common.misc.UUIDHelper;

public class TileEntityEnderTank
extends TileEntityBase
implements IFluidHandler {
    private String code = "000";
    private UUID ownerID = null;
    private String owner = "all";
    private ItemStack personalItem;
    private ArrayList<ItemStack> pumpUpgrades = new ArrayList();

    public void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("code", this.code);
        nbtTag.func_74778_a("owner", this.owner);
        if (this.ownerID != null) {
            nbtTag.func_74778_a("ownerID", this.ownerID.toString());
        }
        if (!this.pumpUpgrades.isEmpty()) {
            NBTTagList listItems = new NBTTagList();
            for (ItemStack stack : this.pumpUpgrades) {
                NBTTagCompound compound = new NBTTagCompound();
                stack.func_77955_b(compound);
                listItems.func_74742_a((NBTBase)compound);
            }
            nbtTag.func_74782_a("PumpUpgrades", (NBTBase)listItems);
        }
        if (this.personalItem != null) {
            NBTTagCompound compound = new NBTTagCompound();
            this.personalItem.func_77955_b(compound);
            nbtTag.func_74782_a("PersonalUpgrade", (NBTBase)compound);
        }
    }

    public void processNBT(NBTTagCompound nbtTag) {
        this.code = nbtTag.func_74779_i("code");
        this.owner = nbtTag.func_74779_i("owner");
        this.ownerID = UUIDHelper.stringToUUID((String)nbtTag.func_74779_i("ownerID"));
        if (nbtTag.func_74764_b("PumpUpgrades")) {
            this.pumpUpgrades.clear();
            NBTTagList listItems = nbtTag.func_150295_c("PumpUpgrades", 10);
            for (int entry = 0; entry < listItems.func_74745_c(); ++entry) {
                NBTTagCompound compound = listItems.func_150305_b(entry);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)compound);
                if (stack == null) continue;
                this.pumpUpgrades.add(stack);
            }
        } else if (nbtTag.func_74764_b("pump")) {
            for (byte x = 0; x < nbtTag.func_74771_c("pump"); x = (byte)(x + 1)) {
                this.pumpUpgrades.add(new ItemStack((Block)Blocks.field_150331_J));
            }
        }
        if (nbtTag.func_74764_b("PersonalUpgrade")) {
            this.personalItem = ItemStack.func_77949_a((NBTTagCompound)nbtTag.func_74775_l("PersonalUpgrade"));
        }
        if (!this.isPublic() && this.personalItem == null) {
            this.personalItem = new ItemStack(Values.oldPersonalItem);
        }
    }

    public void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        FluidTankInfo tankinfo = this.getTankInfo();
        if (tankinfo.fluid != null) {
            nbtTag.func_74778_a("liquid", tankinfo.fluid.getFluid().getLocalizedName(tankinfo.fluid));
            nbtTag.func_74768_a("amount", tankinfo.fluid.amount);
            nbtTag.func_74768_a("capacity", TankFunctions.getCapacity(this.getOwnerID(), this.getCode()));
        } else {
            nbtTag.func_74778_a("liquid", "NONE");
        }
    }

    public void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (this.ownerID != null && UUIDHelper.uuidLookup.containsKey((Object)this.ownerID)) {
            this.owner = (String)UUIDHelper.uuidLookup.get((Object)this.ownerID);
        }
    }

    public int fill(ForgeDirection side, FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFill(side, resource.getFluid())) {
            return 0;
        }
        FluidTank activeTank = TankFunctions.getTank(this.getOwnerID(), this.getCode());
        int amountUsed = activeTank.fill(resource, doFill);
        resource.amount -= amountUsed;
        if (doFill && amountUsed > 0) {
            TankFunctions.updateTank(this.getOwnerID(), this.getCode(), activeTank.getFluid());
        }
        return amountUsed;
    }

    public FluidStack drain(ForgeDirection side, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(side, resource.getFluid())) {
            return null;
        }
        FluidTank activeTank = TankFunctions.getTank(this.getOwnerID(), this.getCode());
        return activeTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection side, int amount, boolean doDrain) {
        if (!this.canDrain(side, null)) {
            return null;
        }
        FluidTank activeTank = TankFunctions.getTank(this.getOwnerID(), this.getCode());
        return activeTank.drain(amount, doDrain);
    }

    public boolean canFill(ForgeDirection side, Fluid fluid) {
        FluidStack currentLiquid;
        if (this.hasError()) {
            return false;
        }
        if (side != ForgeDirection.DOWN && side != ForgeDirection.UP) {
            return false;
        }
        FluidTank activeTank = TankFunctions.getTank(this.getOwnerID(), this.getCode());
        if (activeTank.getFluidAmount() >= activeTank.getCapacity()) {
            return false;
        }
        if (fluid != null && (currentLiquid = activeTank.getFluid()) != null) {
            if (currentLiquid.amount < 1) {
                activeTank.setFluid(null);
            } else if (currentLiquid.getFluid() != fluid) {
                return false;
            }
        }
        return true;
    }

    public boolean canDrain(ForgeDirection side, Fluid fluid) {
        if (this.hasError()) {
            return false;
        }
        if (side != ForgeDirection.DOWN && side != ForgeDirection.UP) {
            return false;
        }
        FluidTank activeTank = TankFunctions.getTank(this.getOwnerID(), this.getCode());
        if (activeTank.getFluidAmount() < 1) {
            return false;
        }
        return fluid == null || activeTank.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        if (side != ForgeDirection.DOWN && side != ForgeDirection.UP) {
            return null;
        }
        return new FluidTankInfo[]{this.getTankInfo()};
    }

    public FluidTankInfo getTankInfo() {
        return TankFunctions.getTank(this.getOwnerID(), this.getCode()).getInfo();
    }

    public int getPumpCapacity() {
        return this.pumpUpgrades.isEmpty() ? 250 : this.pumpUpgrades.size() * 1000;
    }

    public byte getPumpUpgradeCount() {
        return (byte)this.pumpUpgrades.size();
    }

    public void addPumpUpgrade(ItemStack stack) {
        this.pumpUpgrades.add(stack);
    }

    public boolean canEdit(EntityPlayer player) {
        if (this.isPublic() || player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.ownerID != null ? this.ownerID.equals(player.func_110124_au()) : this.owner.equals(player.getDisplayName());
    }

    public String getOwnerID() {
        if (this.owner.equals("all")) {
            return "all";
        }
        if (this.ownerID != null) {
            return this.ownerID.toString();
        }
        return this.owner;
    }

    public void setOwner(EntityPlayer player, ItemStack stack) {
        this.personalItem = stack;
        this.owner = player.getDisplayName();
        this.ownerID = UUIDHelper.uuidLookup.containsKey((Object)player.func_110124_au()) ? player.func_110124_au() : UUIDHelper.getOfflineUUID((String)this.owner);
    }

    public ArrayList<ItemStack> getAllUpgrades() {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        if (!this.pumpUpgrades.isEmpty()) {
            upgrades.addAll(this.pumpUpgrades);
        }
        if (this.personalItem != null) {
            upgrades.add(this.personalItem);
        }
        return upgrades;
    }

    public boolean isPublic() {
        return this.owner.equals("all");
    }

    public String getCode() {
        while (this.code.length() < 3) {
            this.code = "0" + this.code;
        }
        return this.code;
    }

    public void setCode(String code) {
        while (code.length() < 3) {
            code = "0" + code;
        }
        this.code = code;
    }

    public boolean hasError() {
        return !this.isPublic() && this.ownerID == null;
    }
}

