/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.misc.TankData;
import shetiphian.endertanks.common.misc.UUIDHelper;

public class TankFunctions {
    private static TankData getTankData(String owner, String code) {
        TankData tankData = (TankData)Values.tankDatabase.get((Object)owner, (Object)code);
        return tankData == null ? new TankData() : tankData;
    }

    public static FluidTank getTank(String owner, String code) {
        FluidTank tank = new FluidTank(TankFunctions.getCapacity(owner, code));
        tank.setFluid(TankFunctions.getTankData((String)owner, (String)code).fluidStack);
        return tank;
    }

    public static void updateTank(String owner, String code, FluidStack fluidStack) {
        TankData tankData = TankFunctions.getTankData(owner, code);
        tankData.fluidStack = fluidStack != null && fluidStack.amount < 1 ? null : fluidStack;
        Values.tankDatabase.put((Object)owner, (Object)code, (Object)tankData);
    }

    public static int getCapacity(String owner, String code) {
        return TankFunctions.getCapacityInBuckets(owner, code) * 1000;
    }

    public static short getCapacityInBuckets(String owner, String code) {
        return TankFunctions.getTankData(owner, code).getCapacity();
    }

    public static void setCapacityInBuckets(String owner, String code, short capacity) {
        TankData tankData = TankFunctions.getTankData(owner, code);
        tankData.setCapacity(capacity);
        Values.tankDatabase.put((Object)owner, (Object)code, (Object)tankData);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.world == null || event.world.field_72995_K || !(event.entity instanceof EntityPlayer)) {
            return;
        }
        UUIDHelper.updateCachedName((EntityPlayer)event.entity);
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (event.world == null || event.world.field_72995_K || event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        Set networks = Values.tankDatabase.rowKeySet();
        for (String owner : networks) {
            Map networkMap = Values.tankDatabase.row((Object)owner);
            NBTTagCompound fileNBT = new NBTTagCompound();
            for (Map.Entry pocket : networkMap.entrySet()) {
                if (!((TankData)pocket.getValue()).saveCheck()) continue;
                NBTTagCompound nbtPocket = ((TankData)pocket.getValue()).writeToNBT(new NBTTagCompound());
                fileNBT.func_74782_a((String)pocket.getKey(), (NBTBase)nbtPocket);
            }
            try {
                FileOutputStream fileoutputstream = new FileOutputStream(this.getSaveFile(event.world, owner));
                CompressedStreamTools.func_74799_a((NBTTagCompound)fileNBT, (OutputStream)fileoutputstream);
                fileoutputstream.close();
            }
            catch (Throwable t) {}
        }
        this.handleSingleFileDataBase(event.world, false);
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (event.world == null || event.world.field_72995_K || event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        Values.tankDatabase.clear();
        this.handleSingleFileDataBase(event.world, true);
        List<File> fileList = this.getSaveFiles(event.world);
        for (File file : fileList) {
            String owner = this.getOwnerID(file.getName().replace(".dat", ""));
            NBTTagCompound fileNBT = this.getNBTtag(file);
            for (String code : fileNBT.func_150296_c()) {
                Values.tankDatabase.put((Object)owner, (Object)code, (Object)new TankData().loadFromNBT(fileNBT.func_74775_l(code)));
            }
        }
    }

    private void handleSingleFileDataBase(World world, boolean read) {
        File fileDatabase = null;
        try {
            fileDatabase = new File(EnderTanks.proxy.getSaveDir(world, Values.mincraftDir), "EnderTank.dat");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (fileDatabase == null || !fileDatabase.exists()) {
            return;
        }
        if (read) {
            NBTTagCompound nbtData = this.getNBTtag(fileDatabase);
            for (String key : nbtData.func_150296_c()) {
                String[] code = key.split(":");
                if (code.length != 2) continue;
                Values.tankDatabase.put((Object)this.getOwnerID(code[0]), (Object)code[1], (Object)new TankData().loadFromNBT(nbtData.func_74775_l(key)));
            }
        } else {
            File newName = null;
            try {
                newName = new File(EnderTanks.proxy.getSaveDir(world, Values.mincraftDir), "EnderTank.old.dat");
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (newName != null) {
                fileDatabase.renameTo(newName);
            }
        }
    }

    private List<File> getSaveFiles(World world) {
        ArrayList<File> fileList = new ArrayList<File>();
        String saveDir = EnderTanks.proxy.getSaveDir(world, Values.mincraftDir) + "/endertanks";
        File[] listOfFiles = null;
        try {
            File saveFolder = new File(saveDir);
            listOfFiles = saveFolder.listFiles();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".dat")) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    private File getSaveFile(World world, String owner) {
        String saveDir = EnderTanks.proxy.getSaveDir(world, Values.mincraftDir) + "/endertanks";
        File file = null;
        try {
            file = new File(saveDir);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            file = new File(saveDir, this.getSaveNameForOwner(owner));
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return file;
    }

    private NBTTagCompound getNBTtag(File file) {
        NBTTagCompound nbtData = new NBTTagCompound();
        try {
            FileInputStream fileinputstream = new FileInputStream(file);
            nbtData = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
            fileinputstream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nbtData;
    }

    private String getSaveNameForOwner(String owner) {
        String save = owner.equals("all") ? "[-Public-]" : (UUIDHelper.uuidLookup.containsKey((Object)UUIDHelper.stringToUUID((String)owner)) ? (String)UUIDHelper.uuidLookup.get((Object)UUIDHelper.stringToUUID((String)owner)) + "@" + owner : (String)UUIDHelper.uuidLookupOffline.get((Object)UUIDHelper.stringToUUID((String)owner)) + "@Offline");
        return save + ".dat";
    }

    private String getOwnerID(String owner) {
        if (owner.equals("[-Public-]") || owner.equals("all")) {
            return "all";
        }
        if (owner.contains("@")) {
            String username = owner.substring(0, owner.indexOf("@"));
            if (owner.contains("Offline")) {
                UUID uuid = UUIDHelper.getOfflineUUID((String)username);
                if (uuid != null & !UUIDHelper.uuidLookupOffline.containsKey((Object)uuid)) {
                    UUIDHelper.uuidLookupOffline.put((Object)uuid, (Object)username);
                    return uuid.toString();
                }
            } else {
                UUID uuid = UUIDHelper.stringToUUID((String)owner.substring(owner.indexOf("@") + 1, owner.length()));
                if (uuid != null & !UUIDHelper.uuidLookup.containsKey((Object)uuid)) {
                    UUIDHelper.uuidLookup.put((Object)uuid, (Object)username);
                    return uuid.toString();
                }
            }
        } else {
            owner = Values.oldDataOnline ? UUIDHelper.getCachedUUID(owner) : UUIDHelper.getOfflineUUID((String)owner).toString();
        }
        return owner;
    }
}

