/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import shetiphian.endertanks.Values;

public class ConfigHandler {
    public static ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration config;
    public String[] personalItems;
    public String[] sCapacityItems;
    public String[] lCapacityItems;
    public String[] pumpItems;

    public void setupConfig(File file) {
        this.config = new Configuration(file);
        this.config.load();
        this.syncConfig();
    }

    public void syncConfig() {
        this.config.addCustomCategoryComment("UPGRADE-ITEMS", "Items used to upgrade the EnderTanks");
        this.config.setCategoryRequiresWorldRestart("UPGRADE-ITEMS", false);
        this.config.setCategoryRequiresMcRestart("UPGRADE-ITEMS", false);
        this.personalItems = this.config.getStringList("Personal", "UPGRADE-ITEMS", new String[]{"minecraft:diamond"}, "Items Listed are used to make the tanks personal\n");
        this.sCapacityItems = this.config.getStringList("SmallCapacity", "UPGRADE-ITEMS", new String[]{"minecraft:ender_pearl"}, "Items Listed upgrade storage capacity by 'SmallCapacityUpgrade'\n");
        this.lCapacityItems = this.config.getStringList("LargeCapacity", "UPGRADE-ITEMS", new String[]{"minecraft:ender_eye"}, "Items Listed upgrade storage capacity by 'LargeCapacityUpgrade'\n");
        this.pumpItems = this.config.getStringList("Pump", "UPGRADE-ITEMS", new String[]{"minecraft:piston"}, "Items Listed are used to increase the tanks internal pump\n");
        this.config.addCustomCategoryComment("UPGRADE-SETTINGS", "NOTE: Capacity numbers are in buckets");
        this.config.setCategoryRequiresWorldRestart("UPGRADE-SETTINGS", true);
        this.config.setCategoryRequiresMcRestart("UPGRADE-SETTINGS", false);
        Values.tankPumpMax = (byte)this.config.getInt("PumpUpgrades", "UPGRADE-SETTINGS", 4, 0, 8, "How many internal pump upgrades can a tank have?\n default internal pump is only 1/4 bucket, upgrades make it a bucket per upgrade.\n");
        Values.tankSizeMin = (byte)this.config.getInt("CapacityMin", "UPGRADE-SETTINGS", 32, 4, 64, "Minimum capacity an EnderTank holds.\n");
        Values.tankSizeMax = (short)this.config.getInt("CapacityMax", "UPGRADE-SETTINGS", 256, 16, 512, "Maximum capacity an EnderTank holds.\n");
        if (Values.tankSizeMax < Values.tankSizeMin) {
            Values.tankSizeMax = Values.tankSizeMin;
        }
        Values.smallCapacity = (byte)this.config.getInt("SmallCapacityUpgrade", "UPGRADE-SETTINGS", 8, 2, 16, "Capacity increased by 'SmallCapacity' Items.\n");
        Values.largeCapacity = (byte)this.config.getInt("LargeCapacityUpgrade", "UPGRADE-SETTINGS", 16, 4, 32, "Capacity increased by 'LargeCapacity' Items.\n");
        this.config.addCustomCategoryComment("COLOR-VALUES", "Color Values for Bands,\nFormat: Decimal Values (0 to 16,777,215)\nYou can use this website to get the decimal value of any color:\nhttp://www.colorhexa.com\nOr by using the Color Mixer from this website:\nhttp://www.mathsisfun.com/hexadecimal-decimal-colors.html\n");
        this.config.setCategoryRequiresWorldRestart("COLOR-VALUES", false);
        this.config.setCategoryRequiresMcRestart("COLOR-VALUES", false);
        String[] colorNames = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
        for (int scan = 0; scan < colorNames.length; scan = (int)((byte)(scan + 1))) {
            Values.colorValues[scan] = this.config.getInt(colorNames[scan], "COLOR-VALUES", Values.colorValues[scan], 0, 0xFFFFFF, "");
        }
        this.config.addCustomCategoryComment("CONVERSION-DATA", "These settings are only used to convert pre-1.7.10 saves");
        this.config.setCategoryRequiresWorldRestart("CONVERSION-DATA", true);
        this.config.setCategoryRequiresMcRestart("CONVERSION-DATA", false);
        Values.oldDataOnline = this.config.getBoolean("DatabaseOnline", "CONVERSION-DATA", true, "If you play in offline mode set this to false,\nit is used to convert the database for 1.8+ name change support.\nIf converted in the wrong mode, just change this setting and rename EnderTank.old.dat back to EnderTank.dat\n");
        String oldPersonalItem = this.config.get("Personal-Item", "personalItem", "diamond", "This was the old personal item\nnow its only used to update existing tanks\n'UpgradeItems' replaces this and supports mod items\n [default: diamond]").getString();
        this.config.moveProperty("personalItem", "Personal-Item", "CONVERSION-DATA");
        if (this.config.hasChanged()) {
            this.config.save();
        }
        try {
            Values.oldPersonalItem = GameData.getItemRegistry().func_148741_d(oldPersonalItem) ? (Item)GameData.getItemRegistry().func_82594_a(oldPersonalItem) : Items.field_151045_i;
        }
        catch (Exception e) {
            Values.oldPersonalItem = Items.field_151045_i;
        }
    }
}

