/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import shetiphian.core.Function;
import shetiphian.core.Localization;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.RecipeRegistry;
import shetiphian.endertanks.common.misc.TankFunctions;
import shetiphian.endertanks.common.misc.UUIDHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class ItemEnderBucket
extends Item {
    byte withupdate = (byte)3;
    byte withoutupdate = 0;
    private IIcon[] iconIndex = new IIcon[6];

    public ItemEnderBucket() {
        this.func_77655_b("shetiphian.endertanks.bucket");
        this.field_77777_bU = 1;
        this.field_77787_bX = true;
        this.func_77637_a((CreativeTabs)Values.tabEnderTanks);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int value : RecipeRegistry.damageValues) {
            list.add(new ItemStack(item, 1, value));
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        boolean isSneaking = entityPlayer.func_70093_af();
        MovingObjectPosition blockHit = this.func_77621_a(world, entityPlayer, !isSneaking);
        if (isSneaking && blockHit != null) {
            if (world.func_147439_a(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d) == Values.blockEnderTank) {
                TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_147438_o(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d);
                if (tankTile.hasError()) {
                    if (!world.field_72995_K) {
                        Localization.addChat((EntityPlayer)entityPlayer, (String)Localization.get((String)"error.bucket.nolink2.msg"));
                    }
                } else {
                    if (tankTile.canEdit(entityPlayer)) {
                        ItemStack newStack = new ItemStack((Item)this, 1, Integer.parseInt(tankTile.getCode(), 16));
                        this.setOwner(newStack, tankTile.getOwnerID());
                        return newStack;
                    }
                    if (!world.field_72995_K) {
                        Localization.addChat((EntityPlayer)entityPlayer, (String)Localization.get((String)"error.bucket.nolink.msg"));
                    }
                }
            } else {
                this.placeLiquid(itemStack, entityPlayer, world, blockHit);
            }
        } else if (!(blockHit != null && this.pickupLiquid(itemStack, entityPlayer, world, blockHit) || world.field_72995_K)) {
            FluidTank bucketTank = TankFunctions.getTank(this.getOwner(itemStack), this.getCode(itemStack));
            FluidStack bucketLiquid = bucketTank.getFluid();
            BlockEnderTank.sendTankInfo(entityPlayer, bucketLiquid, this.getOwner(itemStack), this.getCode(itemStack), true);
        }
        return itemStack;
    }

    private boolean pickupLiquid(ItemStack itemStack, EntityPlayer entityPlayer, World world, MovingObjectPosition blockHit) {
        TileEntity te = world.func_147438_o(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d);
        FluidTank bucketTank = TankFunctions.getTank(this.getOwner(itemStack), this.getCode(itemStack));
        FluidStack bucketLiquid = bucketTank.getFluid();
        int getAmmount = 1000;
        if (te != null && te instanceof IFluidHandler) {
            FluidStack getLiquid;
            if (bucketLiquid != null && bucketLiquid.amount + getAmmount > bucketTank.getCapacity()) {
                getAmmount = bucketTank.getCapacity() - bucketLiquid.amount;
            }
            if ((getLiquid = ((IFluidHandler)te).drain(ForgeDirection.getOrientation((int)blockHit.field_72310_e), getAmmount, false)) == null) {
                return false;
            }
            getAmmount = getLiquid.amount;
            if (entityPlayer.field_71075_bZ.field_75098_d || bucketLiquid == null || bucketLiquid.amount == 0 || getLiquid.isFluidEqual(bucketLiquid)) {
                if (!world.field_72995_K) {
                    ((IFluidHandler)te).drain(ForgeDirection.getOrientation((int)blockHit.field_72310_e), getAmmount, true);
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        if (bucketLiquid == null || bucketLiquid.amount == 0) {
                            bucketLiquid = getLiquid;
                        } else {
                            bucketLiquid.amount += getAmmount;
                        }
                        TankFunctions.updateTank(this.getOwner(itemStack), this.getCode(itemStack), bucketLiquid);
                    }
                }
                return true;
            }
        } else {
            if (bucketLiquid != null && bucketLiquid.amount + getAmmount > bucketTank.getCapacity()) {
                return false;
            }
            if (blockHit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                if (!world.func_72962_a(entityPlayer, blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d)) {
                    return false;
                }
                Block block = world.func_147439_a(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d);
                FluidStack getLiquid = null;
                if (block instanceof IFluidBlock) {
                    getLiquid = ((IFluidBlock)block).drain(world, blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d, false);
                } else {
                    Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                    if (fluid != null) {
                        getLiquid = new FluidStack(fluid, 1000);
                    }
                }
                if (getLiquid != null && (entityPlayer.field_71075_bZ.field_75098_d || bucketLiquid == null || bucketLiquid.amount == 0 || getLiquid.isFluidEqual(bucketLiquid))) {
                    if (!world.field_72995_K) {
                        if (block instanceof IFluidBlock) {
                            ((IFluidBlock)block).drain(world, blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d, true);
                        } else {
                            Function.removeBlock((World)world, (int)blockHit.field_72311_b, (int)blockHit.field_72312_c, (int)blockHit.field_72309_d, (boolean)true);
                        }
                        if (!entityPlayer.field_71075_bZ.field_75098_d) {
                            if (bucketLiquid == null || bucketLiquid.amount == 0) {
                                bucketLiquid = getLiquid;
                            } else {
                                bucketLiquid.amount += getLiquid.amount;
                            }
                            TankFunctions.updateTank(this.getOwner(itemStack), this.getCode(itemStack), bucketLiquid);
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void placeLiquid(ItemStack itemStack, EntityPlayer entityPlayer, World world, MovingObjectPosition blockHit) {
        TileEntity te = world.func_147438_o(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d);
        FluidTank bucketTank = TankFunctions.getTank(this.getOwner(itemStack), this.getCode(itemStack));
        FluidStack bucketLiquid = bucketTank.getFluid();
        if (bucketLiquid == null || bucketLiquid.amount == 0) {
            return;
        }
        int placeAmmount = 1000;
        if (te != null && te instanceof IFluidHandler) {
            if (!entityPlayer.field_71075_bZ.field_75098_d && bucketLiquid.amount - placeAmmount < 0) {
                placeAmmount = bucketLiquid.amount;
            }
            FluidStack placeLiquid = new FluidStack(bucketLiquid.fluidID, placeAmmount, bucketLiquid.tag);
            int amountUsed = ((IFluidHandler)te).fill(ForgeDirection.getOrientation((int)blockHit.field_72310_e), placeLiquid, false);
            if (amountUsed > 0 && !world.field_72995_K) {
                ((IFluidHandler)te).fill(ForgeDirection.getOrientation((int)blockHit.field_72310_e), placeLiquid, true);
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    bucketLiquid.amount -= amountUsed;
                    TankFunctions.updateTank(this.getOwner(itemStack), this.getCode(itemStack), bucketTank.getFluid());
                }
            }
        } else {
            ItemStack returnBucket;
            ItemStack emptyBucket;
            ItemStack phantombucket;
            if (blockHit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return;
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d && bucketLiquid.amount - placeAmmount < 0) {
                return;
            }
            byte[][] mapSide = new byte[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
            int spotX = blockHit.field_72311_b + mapSide[blockHit.field_72310_e][0];
            int spotY = blockHit.field_72312_c + mapSide[blockHit.field_72310_e][1];
            int spotZ = blockHit.field_72309_d + mapSide[blockHit.field_72310_e][2];
            if (!entityPlayer.func_82247_a(spotX, spotY, spotZ, blockHit.field_72310_e, itemStack)) {
                return;
            }
            if (!world.func_147437_c(spotX, spotY, spotZ) && world.func_147439_a(spotX, spotY, spotZ).func_149688_o().func_76220_a()) {
                return;
            }
            FluidStack placeLiquid = new FluidStack(bucketLiquid.fluidID, placeAmmount, bucketLiquid.tag);
            if (world.field_73011_w.field_76575_d && placeLiquid.getFluid().getBlock() == Blocks.field_150355_j) {
                double soundX = entityPlayer.field_70169_q + (entityPlayer.field_70165_t - entityPlayer.field_70169_q) + 0.5;
                double soundY = entityPlayer.field_70167_r + (entityPlayer.field_70163_u - entityPlayer.field_70167_r) * 1.62 - (double)entityPlayer.field_70129_M + 0.5;
                double soundZ = entityPlayer.field_70166_s + (entityPlayer.field_70161_v - entityPlayer.field_70166_s) + 0.5;
                world.func_72908_a(soundX, soundY, soundZ, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                for (int var11 = 0; var11 < 8; ++var11) {
                    world.func_72869_a("largesmoke", (double)spotX + Math.random(), (double)spotY + Math.random(), (double)spotZ + Math.random(), 0.0, 0.0, 0.0);
                }
                if (!world.field_72995_K && !entityPlayer.field_71075_bZ.field_75098_d) {
                    bucketLiquid.amount -= placeAmmount;
                    TankFunctions.updateTank(this.getOwner(itemStack), this.getCode(itemStack), bucketTank.getFluid());
                }
            } else if (!world.field_72995_K && (phantombucket = FluidContainerRegistry.fillFluidContainer((FluidStack)placeLiquid, (ItemStack)(emptyBucket = new ItemStack(Items.field_151133_ar)))) != null && ItemStack.func_77989_b((ItemStack)(returnBucket = phantombucket.func_77973_b().func_77659_a(phantombucket, world, entityPlayer)), (ItemStack)emptyBucket) && !entityPlayer.field_71075_bZ.field_75098_d) {
                bucketLiquid.amount -= placeAmmount;
                TankFunctions.updateTank(this.getOwner(itemStack), this.getCode(itemStack), bucketTank.getFluid());
            }
        }
    }

    private void setOwner(ItemStack itemStack, String owner) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        itemStack.field_77990_d.func_74778_a("Owner", owner);
    }

    private String getOwner(ItemStack itemStack) {
        if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("Owner")) {
            this.setOwner(itemStack, "all");
            return "all";
        }
        String owner = itemStack.field_77990_d.func_74779_i("Owner");
        if (!owner.equals("all") && UUIDHelper.stringToUUID((String)owner) == null) {
            this.setOwner(itemStack, "all");
            return "all";
        }
        return owner;
    }

    private String getCode(ItemStack itemStack) {
        String code = Integer.toHexString(itemStack.func_77960_j());
        while (code.length() < 3) {
            code = "0" + code;
        }
        return code;
    }

    private int getColorForBand(ItemStack itemStack, int band) {
        String code = this.getCode(itemStack);
        int[] index = new int[3];
        for (int scan = 0; scan < 3; scan = (int)((byte)(scan + 1))) {
            int value = Integer.parseInt("" + code.charAt(scan), 16);
            int color = Values.colorValues[value];
            if (color < 0) {
                color = 0 - color;
            }
            if (color > 0xFFFFFF) {
                color = 0xFFFFFF;
            }
            index[scan] = color;
        }
        return index[band];
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        list.add(Localization.get((String)"info.tank.code.msg") + " " + this.getCode(itemStack).toUpperCase());
        if (!this.getOwner(itemStack).equals("all")) {
            list.add("[-" + this.getOwner(itemStack) + "-]");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.iconIndex[0] = iconRegister.func_94245_a("endertanks:bucket_base");
        this.iconIndex[1] = iconRegister.func_94245_a("endertanks:bucket_normal");
        this.iconIndex[2] = iconRegister.func_94245_a("endertanks:bucket_private");
        this.iconIndex[3] = iconRegister.func_94245_a("endertanks:bucket_band1");
        this.iconIndex[4] = iconRegister.func_94245_a("endertanks:bucket_band2");
        this.iconIndex[5] = iconRegister.func_94245_a("endertanks:bucket_band3");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        switch (pass) {
            case 1: {
                if (this.getOwner(itemStack).equals("all")) {
                    return this.iconIndex[1];
                }
                return this.iconIndex[2];
            }
            case 2: {
                return this.iconIndex[3];
            }
            case 3: {
                return this.iconIndex[4];
            }
            case 4: {
                return this.iconIndex[5];
            }
        }
        return this.iconIndex[0];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int pass) {
        switch (pass) {
            case 2: {
                return this.getColorForBand(itemStack, 0);
            }
            case 3: {
                return this.getColorForBand(itemStack, 1);
            }
            case 4: {
                return this.getColorForBand(itemStack, 2);
            }
        }
        return 0xFFFFFF;
    }
}

