/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.Function;
import shetiphian.core.Localization;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.misc.TankFunctions;
import shetiphian.endertanks.common.misc.UUIDHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class BlockEnderTank
extends BlockContainer {
    private IIcon[] iconIndex = new IIcon[5];
    public static Class<? extends TileEntityEnderTank> tankTile;
    private ArrayList<ItemStack> dropList = new ArrayList();

    public BlockEnderTank() {
        super(Material.field_151592_s);
        this.func_149663_c("shetiphian.endertanks.tank");
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        this.func_149711_c(0.5f);
        this.func_149647_a((CreativeTabs)Values.tabEnderTanks);
    }

    public TileEntity func_149915_a(World world, int var2) {
        try {
            return (TileEntity)tankTile.newInstance();
        }
        catch (Exception exception) {
            return new TileEntityEnderTank();
        }
    }

    public int func_149645_b() {
        return Values.renderID;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess iBlockAccess, int x, int y, int z) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconIndex[0] = iconRegister.func_94245_a("endertanks:tank_normal_tb");
        this.iconIndex[1] = iconRegister.func_94245_a("endertanks:tank_normal_s");
        this.iconIndex[2] = iconRegister.func_94245_a("endertanks:tank_private_tb");
        this.iconIndex[3] = iconRegister.func_94245_a("endertanks:tank_private_s");
        this.iconIndex[4] = iconRegister.func_94245_a("endertanks:tank_bands");
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side > 9) {
            return this.iconIndex[side -= 10];
        }
        return this.iconIndex[4];
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int quantityDropped(int metadata, int fortune, Random random) {
        return 1;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return true;
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer entityPlayer) {
        this.dropList.clear();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityEnderTank) {
            TileEntityEnderTank tankTile = (TileEntityEnderTank)tile;
            this.dropList.add(new ItemStack((Block)this, 1, Integer.parseInt(tankTile.getCode(), 16)));
            this.dropList.addAll(tankTile.getAllUpgrades());
        } else {
            this.dropList.add(new ItemStack((Block)this));
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return this.dropList;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_147438_o(x, y, z);
        if (tankTile == null) {
            return null;
        }
        return new ItemStack((Block)this, 1, Integer.parseInt(tankTile.getCode(), 16));
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.func_149674_a(world, x, y, z, null);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.func_149674_a(world, x, y, z, null);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        this.func_149674_a(world, x, y, z, null);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K && world.func_72864_z(x, y, z)) {
            TileEntity thisTile = world.func_147438_o(x, y, z);
            if (thisTile != null && thisTile instanceof TileEntityEnderTank) {
                int pumpCapacity;
                TileEntityEnderTank tankTile = (TileEntityEnderTank)thisTile;
                FluidTank thisTank = TankFunctions.getTank(tankTile.getOwnerID(), tankTile.getCode());
                FluidStack thisLiquid = thisTank.getFluid();
                TileEntity otherTile = world.func_147438_o(x, y + 1, z);
                int moveAmount = pumpCapacity = tankTile.getPumpCapacity();
                if (otherTile != null && otherTile instanceof IFluidHandler) {
                    FluidStack getLiquid;
                    if (thisLiquid != null && thisTank.getCapacity() - thisLiquid.amount < moveAmount) {
                        moveAmount = thisTank.getCapacity() - thisLiquid.amount;
                    }
                    if ((getLiquid = ((IFluidHandler)otherTile).drain(ForgeDirection.DOWN, moveAmount, false)) != null && (thisLiquid == null || getLiquid.isFluidEqual(thisLiquid) || thisLiquid.amount < 1)) {
                        getLiquid = ((IFluidHandler)otherTile).drain(ForgeDirection.DOWN, moveAmount, true);
                        if (thisLiquid == null || thisLiquid.amount == 0) {
                            thisLiquid = getLiquid;
                        } else {
                            thisLiquid.amount += getLiquid.amount;
                        }
                        TankFunctions.updateTank(tankTile.getOwnerID(), tankTile.getCode(), thisLiquid);
                    }
                }
                moveAmount = pumpCapacity;
                thisTank = TankFunctions.getTank(tankTile.getOwnerID(), tankTile.getCode());
                thisLiquid = thisTank.getFluid();
                otherTile = world.func_147438_o(x, y - 1, z);
                if (thisLiquid != null && thisTile != null && otherTile != null && otherTile instanceof IFluidHandler) {
                    FluidStack placeLiquid;
                    int usedAmount;
                    if (thisLiquid.amount < pumpCapacity) {
                        moveAmount = thisLiquid.amount;
                    }
                    if ((usedAmount = ((IFluidHandler)otherTile).fill(ForgeDirection.UP, placeLiquid = new FluidStack(thisLiquid.fluidID, moveAmount, thisLiquid.tag), false)) > 0) {
                        ((IFluidHandler)otherTile).fill(ForgeDirection.UP, placeLiquid, true);
                        thisLiquid.amount -= usedAmount;
                        TankFunctions.updateTank(tankTile.getOwnerID(), tankTile.getCode(), thisLiquid);
                    }
                }
            }
            world.func_147464_a(x, y, z, (Block)this, 20);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((double)x + 0.125), (double)y, (double)((double)z + 0.125), (double)((double)x + 0.875), (double)((double)y + 1.0), (double)((double)z + 0.875));
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 vec3d, Vec3 vec3d1) {
        TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_147438_o(x, y, z);
        if (tankTile == null) {
            return null;
        }
        float ringMin = 0.09375f;
        float ringMax = 0.90625f;
        float ringOffset = 0.03125f;
        float ringShift = 0.09375f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        MovingObjectPosition fullblock = super.func_149731_a(world, x, y, z, vec3d, vec3d1);
        if (fullblock == null) {
            return fullblock;
        }
        MovingObjectPosition areaHit = null;
        double hitDist = 100.0;
        if (fullblock.field_72310_e > 1) {
            for (int codeBand = 0; codeBand < 4; codeBand = (int)((byte)(codeBand + 1))) {
                switch (codeBand) {
                    case 0: {
                        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(ringMin, 0.5f + ringShift - ringOffset, ringMin, ringMax, 0.5f + ringShift + ringOffset, ringMax);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(ringMin, 0.5f - ringOffset, ringMin, ringMax, 0.5f + ringOffset, ringMax);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(ringMin, 0.5f - ringShift - ringOffset, ringMin, ringMax, 0.5f - ringShift + ringOffset, ringMax);
                    }
                }
                MovingObjectPosition ringHit = super.func_149731_a(world, x, y, z, vec3d, vec3d1);
                if (ringHit == null) continue;
                ringHit.subHit = codeBand;
                double ringDist = ringHit.field_72307_f.func_72436_e(vec3d);
                if (!(ringDist < hitDist)) continue;
                hitDist = ringDist;
                areaHit = ringHit;
            }
            if (areaHit != null && areaHit.subHit > 0) {
                switch (areaHit.subHit) {
                    case 1: {
                        this.func_149676_a(ringMin, 0.5f + ringShift - ringOffset, ringMin, ringMax, 0.5f + ringShift + ringOffset, ringMax);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(ringMin, 0.5f - ringOffset, ringMin, ringMax, 0.5f + ringOffset, ringMax);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(ringMin, 0.5f - ringShift - ringOffset, ringMin, ringMax, 0.5f - ringShift + ringOffset, ringMax);
                    }
                }
                return areaHit;
            }
        }
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        return fullblock;
    }

    public float func_149737_a(EntityPlayer entityPlayer, World world, int x, int y, int z) {
        TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_147438_o(x, y, z);
        if (tankTile.canEdit(entityPlayer)) {
            return super.func_149737_a(entityPlayer, world, x, y, z);
        }
        return -1.0f;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float posX, float posY, float posZ) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_147438_o(x, y, z);
        if (tankTile == null) {
            return false;
        }
        ItemStack currentItem = entityPlayer.field_71071_by.func_70448_g();
        if (currentItem != null) {
            MovingObjectPosition areaHit;
            ItemStack filledItem;
            FluidStack tankLiquid;
            if (FluidContainerRegistry.isFilledContainer((ItemStack)currentItem)) {
                FluidStack containerLiquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)currentItem);
                int usedAmmount = tankTile.fill(ForgeDirection.UP, containerLiquid, !world.field_72995_K);
                if (usedAmmount != 0 && !entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, this.consumeItem(currentItem));
                }
                return true;
            }
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)currentItem) && (tankLiquid = tankTile.getTankInfo().fluid) != null && (filledItem = FluidContainerRegistry.fillFluidContainer((FluidStack)tankLiquid, (ItemStack)currentItem)) != null && !entityPlayer.field_71075_bZ.field_75098_d) {
                if (currentItem.field_77994_a > 1) {
                    if (!entityPlayer.field_71071_by.func_70441_a(filledItem)) {
                        return false;
                    }
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, this.consumeItem(currentItem));
                } else {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, this.consumeItem(currentItem));
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, filledItem);
                }
                tankTile.drain(ForgeDirection.DOWN, 1000, !world.field_72995_K);
                return true;
            }
            if (world.field_72995_K) {
                return true;
            }
            if (tankTile.isPublic()) {
                for (ItemStack stack : Values.itemPersonal) {
                    if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)stack)) continue;
                    tankTile.setOwner(entityPlayer, stack.func_77946_l());
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        --currentItem.field_77994_a;
                    }
                    Function.syncTile((TileEntity)tankTile);
                    return true;
                }
            }
            if (!tankTile.canEdit(entityPlayer)) {
                return true;
            }
            short capacity = TankFunctions.getCapacityInBuckets(tankTile.getOwnerID(), tankTile.getCode());
            if (capacity < Values.tankSizeMax) {
                int newValue = 0;
                if (capacity + Values.smallCapacity < Values.tankSizeMax) {
                    for (ItemStack stack : Values.itemCapacitySmall) {
                        if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)stack)) continue;
                        newValue = Values.smallCapacity;
                        break;
                    }
                }
                if (newValue == 0 && capacity + Values.largeCapacity < Values.tankSizeMax) {
                    for (ItemStack stack : Values.itemCapacityLarge) {
                        if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)stack)) continue;
                        newValue = Values.largeCapacity;
                        break;
                    }
                }
                if (newValue > 0) {
                    TankFunctions.setCapacityInBuckets(tankTile.getOwnerID(), tankTile.getCode(), (short)(capacity + newValue));
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        --currentItem.field_77994_a;
                    }
                    String tankInfo = Localization.get((String)"info.tank.capacity.msg");
                    tankInfo = tankInfo + " " + TankFunctions.getCapacity(tankTile.getOwnerID(), tankTile.getCode());
                    Localization.addChat((EntityPlayer)entityPlayer, (String)tankInfo);
                    return true;
                }
            }
            if (tankTile.getPumpUpgradeCount() < Values.tankPumpMax) {
                for (ItemStack stack : Values.itemPump) {
                    if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)stack)) continue;
                    tankTile.addPumpUpgrade(stack.func_77946_l());
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        --currentItem.field_77994_a;
                    }
                    String tankInfo = Localization.get((String)"info.tank.pump.upgrade.msg");
                    tankInfo = tankInfo + " " + tankTile.getPumpCapacity() + "mB";
                    Localization.addChat((EntityPlayer)entityPlayer, (String)tankInfo);
                    Function.syncTile((TileEntity)tankTile);
                    return true;
                }
            }
            if ((areaHit = this.retraceBlock(world, (EntityPlayerMP)entityPlayer, x, y, z)) == null) {
                return false;
            }
            if (tankTile.canEdit(entityPlayer) && areaHit.subHit >= 1 && areaHit.subHit <= 3) {
                String[] dyes = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};
                for (int scan = 0; scan < 16; scan = (int)((byte)(scan + 1))) {
                    ArrayList results = OreDictionary.getOres((String)dyes[scan]);
                    for (ItemStack check : results) {
                        if (!OreDictionary.itemMatches((ItemStack)currentItem, (ItemStack)check, (boolean)true)) continue;
                        int ring = areaHit.subHit - 1;
                        char color = Integer.toHexString(scan).charAt(0);
                        char[] code = tankTile.getCode().toCharArray();
                        if (code[ring] == color) continue;
                        code[ring] = color;
                        tankTile.setCode("" + code[0] + code[1] + code[2]);
                        if (!entityPlayer.field_71075_bZ.field_75098_d) {
                            --currentItem.field_77994_a;
                        }
                        Function.syncTile((TileEntity)tankTile);
                        return true;
                    }
                }
            }
        }
        if (!world.field_72995_K) {
            this.sendTankInfo(entityPlayer, tankTile);
        }
        return true;
    }

    private ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    private MovingObjectPosition retraceBlock(World world, EntityPlayerMP thePlayer, int x, int y, int z) {
        Vec3 headVec = Vec3.func_72443_a((double)thePlayer.field_70165_t, (double)(thePlayer.field_70163_u + (double)thePlayer.func_70047_e() - (double)thePlayer.field_70129_M), (double)thePlayer.field_70161_v);
        Vec3 lookVec = thePlayer.func_70676_i(1.0f);
        double reach = thePlayer.field_71134_c.getBlockReachDistance();
        Vec3 endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return world.func_147439_a(x, y, z).func_149731_a(world, x, y, z, headVec, endVec);
    }

    private void sendTankInfo(EntityPlayer entityPlayer, TileEntityEnderTank tankTile) {
        FluidStack fluidStack = TankFunctions.getTank(tankTile.getOwnerID(), tankTile.getCode()).getFluid();
        String tankInfo = BlockEnderTank.infoTankHeader(false) + "\u00a7r<br>" + BlockEnderTank.infoTankData(fluidStack, tankTile.getOwnerID(), tankTile.getCode()) + " " + BlockEnderTank.infoPump(tankTile.getPumpCapacity()) + " " + BlockEnderTank.infoTankOwner(tankTile.getOwnerID());
        BlockEnderTank.sendTankInfo(entityPlayer, tankInfo);
    }

    public static void sendTankInfo(EntityPlayer entityPlayer, FluidStack fluidStack, String owner, String code, boolean bucket) {
        String tankInfo = BlockEnderTank.infoTankHeader(bucket) + "\u00a7r<br>" + BlockEnderTank.infoTankData(fluidStack, owner, code) + " " + BlockEnderTank.infoTankOwner(owner);
        BlockEnderTank.sendTankInfo(entityPlayer, tankInfo);
    }

    public static String infoTankData(FluidStack fluidStack, String owner, String code) {
        String info = "";
        if (fluidStack == null || fluidStack.amount < 1) {
            info = info + Localization.get((String)"info.tank.empty.msg");
        } else {
            info = info + (float)fluidStack.amount / 1000.0f + "K / ";
            info = info + TankFunctions.getCapacity(owner, code) / 1000 + "K ";
            info = info + Localization.get((String)"info.tank.amount.msg") + " ";
            info = info + fluidStack.getFluid().getLocalizedName(fluidStack);
        }
        return info;
    }

    private static String infoTankHeader(boolean bucket) {
        return bucket ? Localization.get((String)"info.bucket.header.msg") : Localization.get((String)"info.tank.header.msg");
    }

    public static String infoTankOwner(String owner) {
        if (owner.equals("all")) {
            return "[-" + Localization.get((String)"info.tank.public.msg") + "-]";
        }
        if (UUIDHelper.uuidLookup.containsKey((Object)UUIDHelper.stringToUUID((String)owner))) {
            return "[-" + (String)UUIDHelper.uuidLookup.get((Object)UUIDHelper.stringToUUID((String)owner)) + "-]";
        }
        if (UUIDHelper.uuidLookupOffline.containsKey((Object)UUIDHelper.stringToUUID((String)owner))) {
            return "[-!!" + (String)UUIDHelper.uuidLookupOffline.get((Object)UUIDHelper.stringToUUID((String)owner)) + "!!-]";
        }
        if (UUIDHelper.stringToUUID((String)owner) != null || owner.isEmpty()) {
            return "[-!Name Not Found!-]";
        }
        return "[-!!" + owner.substring(0, owner.length() > 20 ? 20 : owner.length()) + "!!-]";
    }

    private static String infoPump(int capacity) {
        return "<" + Localization.get((String)"info.tank.pump.msg") + ": " + capacity + "mB" + ">";
    }

    private static void sendTankInfo(EntityPlayer entityPlayer, String tankInfo) {
        Localization.addChat((EntityPlayer)entityPlayer, (String)tankInfo);
    }
}

