/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.client.renderer;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class RenderEnderTank
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    private Minecraft mc = FMLClientHandler.instance().getClient();
    private FloatBuffer floatBuffer = GLAllocation.func_74529_h((int)16);
    private ResourceLocation textureTunnel = new ResourceLocation("minecraft", "textures/environment/end_sky.png");
    private ResourceLocation textureParticle = new ResourceLocation("minecraft", "textures/entity/end_portal.png");
    private float counter;

    public void renderEndPortalTileEntity(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        if (!(tileEntity instanceof TileEntityEnderTank)) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        float pX = (float)this.field_147501_a.field_147560_j;
        float pY = (float)this.field_147501_a.field_147561_k;
        float pZ = (float)this.field_147501_a.field_147558_l;
        GL11.glDisable((int)2896);
        Random random = new Random(31100L);
        float[] red = new float[16];
        float[] green = new float[16];
        float[] blue = new float[16];
        blue[0] = 1.0f;
        green[0] = 1.0f;
        red[0] = 1.0f;
        for (int build = 0; build < 16; build = (int)((byte)(build + 1))) {
            red[build] = random.nextFloat() * 0.5f + 0.1f;
            green[build] = random.nextFloat() * 0.5f + 0.4f;
            blue[build] = random.nextFloat() * 0.5f + 0.5f;
        }
        for (int side = 0; side < 6; side = (int)((byte)(side + 1))) {
            for (int layer = 0; layer < 16; layer = (int)((byte)(layer + 1))) {
                GL11.glPushMatrix();
                float f5 = 16 - layer;
                float f6 = 0.0625f;
                float f7 = 1.0f / (f5 + 1.0f);
                if (layer == 0) {
                    this.mc.func_110434_K().func_110577_a(this.textureTunnel);
                    f7 = 0.1f;
                    f5 = 65.0f;
                    f6 = 0.125f;
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                }
                if (layer > 0) {
                    this.mc.func_110434_K().func_110577_a(this.textureParticle);
                    if (layer == 1) {
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)1, (int)1);
                        f6 = 0.5f;
                    }
                }
                float f8 = 0.0f;
                float f9 = 0.0f;
                float f10 = 0.0f;
                float f11 = 0.0f;
                float offset = 0.83f;
                if (side == 0) {
                    offset = 0.96f;
                } else if (side == 1) {
                    offset = 0.025f;
                } else if (side % 2 == 1) {
                    offset = 0.15f;
                }
                switch (side) {
                    case 0: {
                        f8 = (float)(-(y + (double)offset));
                        f9 = f8 + ActiveRenderInfo.field_74590_b;
                        f10 = f8 + f5 + ActiveRenderInfo.field_74590_b;
                        f11 = f9 / f10;
                        f11 = (float)(y + (double)offset) + f11;
                        GL11.glTranslatef((float)pX, (float)f11, (float)pZ);
                        break;
                    }
                    case 1: {
                        f8 = (float)(y + (double)offset);
                        f9 = f8 - ActiveRenderInfo.field_74590_b;
                        f10 = f8 + f5 - ActiveRenderInfo.field_74590_b;
                        f11 = f9 / f10;
                        f11 = (float)(y + (double)offset) + f11;
                        GL11.glTranslatef((float)pX, (float)f11, (float)pZ);
                        break;
                    }
                    case 2: {
                        f8 = (float)(-(z + (double)offset));
                        f9 = f8 + ActiveRenderInfo.field_74591_c;
                        f10 = f8 + f5 + ActiveRenderInfo.field_74591_c;
                        f11 = f9 / f10;
                        f11 = (float)(z + (double)offset) + f11;
                        GL11.glTranslatef((float)pX, (float)pY, (float)f11);
                        break;
                    }
                    case 3: {
                        f8 = (float)(z + (double)offset);
                        f9 = f8 - ActiveRenderInfo.field_74591_c;
                        f10 = f8 + f5 - ActiveRenderInfo.field_74591_c;
                        f11 = f9 / f10;
                        f11 = (float)(z + (double)offset) + f11;
                        GL11.glTranslatef((float)pX, (float)pY, (float)f11);
                        break;
                    }
                    case 4: {
                        f8 = (float)(-(x + (double)offset));
                        f9 = f8 + ActiveRenderInfo.field_74592_a;
                        f10 = f8 + f5 + ActiveRenderInfo.field_74592_a;
                        f11 = f9 / f10;
                        f11 = (float)(x + (double)offset) + f11;
                        GL11.glTranslatef((float)f11, (float)pY, (float)pZ);
                        break;
                    }
                    case 5: {
                        f8 = (float)(x + (double)offset);
                        f9 = f8 - ActiveRenderInfo.field_74592_a;
                        f10 = f8 + f5 - ActiveRenderInfo.field_74592_a;
                        f11 = f9 / f10;
                        f11 = (float)(x + (double)offset) + f11;
                        GL11.glTranslatef((float)f11, (float)pY, (float)pZ);
                    }
                }
                GL11.glTexGeni((int)8192, (int)9472, (int)9217);
                GL11.glTexGeni((int)8193, (int)9472, (int)9217);
                GL11.glTexGeni((int)8194, (int)9472, (int)9217);
                GL11.glTexGeni((int)8195, (int)9472, (int)9216);
                if (side == 0 || side == 1) {
                    GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.getFloatBuffer(1.0f, 0.0f, 0.0f, 0.0f));
                    GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.getFloatBuffer(0.0f, 0.0f, 1.0f, 0.0f));
                    GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this.getFloatBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.getFloatBuffer(0.0f, 1.0f, 0.0f, 0.0f));
                } else if (side == 2 || side == 3) {
                    GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.getFloatBuffer(1.0f, 0.0f, 0.0f, 0.0f));
                    GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.getFloatBuffer(0.0f, 1.0f, 0.0f, 0.0f));
                    GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this.getFloatBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.getFloatBuffer(0.0f, 0.0f, 1.0f, 0.0f));
                } else if (side == 4 || side == 5) {
                    GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.getFloatBuffer(0.0f, 1.0f, 0.0f, 0.0f));
                    GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.getFloatBuffer(0.0f, 0.0f, 1.0f, 0.0f));
                    GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this.getFloatBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.getFloatBuffer(1.0f, 0.0f, 0.0f, 0.0f));
                }
                GL11.glEnable((int)3168);
                GL11.glEnable((int)3169);
                GL11.glEnable((int)3170);
                GL11.glEnable((int)3171);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                GL11.glTranslatef((float)0.0f, (float)((float)(Minecraft.func_71386_F() % 700000L) / 700000.0f), (float)0.0f);
                GL11.glScalef((float)f6, (float)f6, (float)f6);
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
                GL11.glRotatef((float)((float)(layer * layer * 4321 + layer * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
                if (side == 0 || side == 1) {
                    GL11.glTranslatef((float)(-pX), (float)(-pZ), (float)(-pY));
                    GL11.glTranslatef((float)(ActiveRenderInfo.field_74592_a * f5 / f9), (float)(ActiveRenderInfo.field_74591_c * f5 / f9), (float)(-pY));
                } else if (side == 2 || side == 3) {
                    GL11.glTranslatef((float)(-pX), (float)(-pY), (float)(-pZ));
                    GL11.glTranslatef((float)(ActiveRenderInfo.field_74592_a * f5 / f9), (float)(ActiveRenderInfo.field_74590_b * f5 / f9), (float)(-pZ));
                } else if (side == 4 || side == 5) {
                    GL11.glTranslatef((float)(-pZ), (float)(-pY), (float)(-pX));
                    GL11.glTranslatef((float)(ActiveRenderInfo.field_74591_c * f5 / f9), (float)(ActiveRenderInfo.field_74590_b * f5 / f9), (float)(-pX));
                }
                float minXZ = 0.13f;
                float minY = 0.005f;
                float maxXZ = 0.87f;
                float maxY = 0.995f;
                tessellator.func_78382_b();
                if (((TileEntityEnderTank)tileEntity).hasError()) {
                    float errormode = 0.0f;
                    this.counter = this.counter > 2.0f ? 0.0f : this.counter + 2.0E-5f;
                    errormode = this.counter > 1.0f ? 1.0f - (-1.0f + this.counter) : this.counter;
                    tessellator.func_78369_a(red[layer] * f7 + errormode, green[layer] * f7, blue[layer] * f7, 1.0f);
                } else {
                    tessellator.func_78369_a(red[layer] * f7, green[layer] * f7, blue[layer] * f7, 1.0f);
                }
                switch (side) {
                    case 0: {
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)maxY, z + (double)minXZ);
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)maxY, z + (double)maxXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)maxY, z + (double)maxXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)maxY, z + (double)minXZ);
                        break;
                    }
                    case 1: {
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)minY, z + (double)maxXZ);
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)minY, z + (double)minXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)minY, z + (double)minXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)minY, z + (double)maxXZ);
                        break;
                    }
                    case 2: {
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)maxY, z + (double)maxXZ);
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)minY, z + (double)maxXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)minY, z + (double)maxXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)maxY, z + (double)maxXZ);
                        break;
                    }
                    case 3: {
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)minY, z + (double)minXZ);
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)maxY, z + (double)minXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)maxY, z + (double)minXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)minY, z + (double)minXZ);
                        break;
                    }
                    case 4: {
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)maxY, z + (double)minXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)maxY, z + (double)maxXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)minY, z + (double)maxXZ);
                        tessellator.func_78377_a(x + (double)maxXZ, y + (double)minY, z + (double)minXZ);
                        break;
                    }
                    case 5: {
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)minY, z + (double)minXZ);
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)minY, z + (double)maxXZ);
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)maxY, z + (double)maxXZ);
                        tessellator.func_78377_a(x + (double)minXZ, y + (double)maxY, z + (double)minXZ);
                    }
                }
                tessellator.func_78381_a();
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
            }
            GL11.glDisable((int)3042);
            GL11.glDisable((int)3168);
            GL11.glDisable((int)3169);
            GL11.glDisable((int)3170);
            GL11.glDisable((int)3171);
        }
        GL11.glEnable((int)2896);
    }

    private FloatBuffer getFloatBuffer(float par1, float par2, float par3, float par4) {
        this.floatBuffer.clear();
        this.floatBuffer.put(par1).put(par2).put(par3).put(par4);
        this.floatBuffer.flip();
        return this.floatBuffer;
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderEndPortalTileEntity(tileEntity, x, y, z, partialTick);
    }

    private int[] getBandColors(String code) {
        while (code.length() < 3) {
            code = "0" + code;
        }
        int[] index = new int[5];
        index[3] = 0;
        index[4] = 0xFFFFFF;
        for (int scan = 0; scan < 3; scan = (int)((byte)(scan + 1))) {
            int value = Integer.parseInt("" + code.charAt(scan), 16);
            int color = Values.colorValues[value];
            if (color < 0) {
                color = 0 - color;
            }
            if (color > 0xFFFFFF) {
                color = 0xFFFFFF;
            }
            index[scan] = color;
        }
        return index;
    }

    private boolean renderColoredBlock(Block block, int x, int y, int z, int color, RenderBlocks renderer) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float redShift = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
            float greenShift = (red * 30.0f + green * 70.0f) / 100.0f;
            float blueShift = (red * 30.0f + blue * 70.0f) / 100.0f;
            red = redShift;
            green = greenShift;
            blue = blueShift;
        }
        return Minecraft.func_71379_u() && block.func_149750_m() == 0 ? renderer.func_147751_a(block, x, y, z, red, green, blue) : renderer.func_147736_d(block, x, y, z, red, green, blue);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (!(block instanceof BlockEnderTank)) {
            return;
        }
        if (metadata < 0) {
            metadata = 0;
        } else if (metadata > 4095) {
            metadata = 4095;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        float ringMin = 0.09375f;
        float ringMax = 0.90625f;
        float ringOffset = 0.03125f;
        float ringShift = 0.09375f;
        float minXZ = 0.13f;
        float minY = 0.005f;
        float maxXZ = 0.87f;
        float maxY = 0.995f;
        int[] color = this.getBandColors(Integer.toHexString(metadata));
        for (int draw = 0; draw < 5; draw = (int)((byte)(draw + 1))) {
            switch (draw) {
                case 0: {
                    renderer.func_147782_a((double)ringMin, (double)(0.5f + ringShift - ringOffset), (double)ringMin, (double)ringMax, (double)(0.5f + ringShift + ringOffset), (double)ringMax);
                    break;
                }
                case 1: {
                    renderer.func_147782_a((double)ringMin, (double)(0.5f - ringOffset), (double)ringMin, (double)ringMax, (double)(0.5f + ringOffset), (double)ringMax);
                    break;
                }
                case 2: {
                    renderer.func_147782_a((double)ringMin, (double)(0.5f - ringShift - ringOffset), (double)ringMin, (double)ringMax, (double)(0.5f - ringShift + ringOffset), (double)ringMax);
                    break;
                }
                case 3: {
                    renderer.func_147782_a((double)minXZ, (double)minY, (double)minXZ, (double)maxXZ, (double)maxY, (double)maxXZ);
                    break;
                }
                case 4: {
                    renderer.func_147782_a((double)0.1255f, 0.0, (double)0.1255f, (double)0.8745f, 1.0, (double)0.8745f);
                }
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            IIcon texture = draw == 4 ? block.func_149733_h(10) : block.func_149733_h(14);
            if (texture != null) {
                tessellator.func_78382_b();
                tessellator.func_78378_d(color[draw]);
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                renderer.func_147768_a(block, 0.0, 0.0, 0.0, texture);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78378_d(color[draw]);
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                renderer.func_147806_b(block, 0.0, 0.0, 0.0, texture);
                tessellator.func_78381_a();
            }
            if ((texture = draw == 4 ? block.func_149733_h(11) : block.func_149733_h(14)) != null) {
                tessellator.func_78382_b();
                tessellator.func_78378_d(color[draw]);
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                renderer.func_147764_f(block, 0.0, 0.0, 0.0, texture);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78378_d(color[draw]);
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                renderer.func_147798_e(block, 0.0, 0.0, 0.0, texture);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78378_d(color[draw]);
                tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                renderer.func_147761_c(block, 0.0, 0.0, 0.0, texture);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78378_d(color[draw]);
                tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                renderer.func_147734_d(block, 0.0, 0.0, 0.0, texture);
                tessellator.func_78381_a();
            }
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockEnderTank) || !(world.func_147438_o(x, y, z) instanceof TileEntityEnderTank)) {
            return false;
        }
        float ringMin = 0.09375f;
        float ringMax = 0.90625f;
        float ringOffset = 0.03125f;
        float ringShift = 0.09375f;
        int[] color = this.getBandColors(((TileEntityEnderTank)world.func_147438_o(x, y, z)).getCode());
        renderer.func_147782_a((double)ringMin, 0.5 + (double)ringShift - (double)ringOffset, (double)ringMin, (double)ringMax, 0.5 + (double)ringShift + (double)ringOffset, (double)ringMax);
        this.renderColoredBlock(block, x, y, z, color[0], renderer);
        renderer.func_147782_a((double)ringMin, (double)(0.5f - ringOffset), (double)ringMin, (double)ringMax, (double)(0.5f + ringOffset), (double)ringMax);
        this.renderColoredBlock(block, x, y, z, color[1], renderer);
        renderer.func_147782_a((double)ringMin, 0.5 - (double)ringShift - (double)ringOffset, (double)ringMin, (double)ringMax, 0.5 - (double)ringShift + (double)ringOffset, (double)ringMax);
        this.renderColoredBlock(block, x, y, z, color[2], renderer);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityEnderTank) {
            Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
            int type = 0;
            if (!((TileEntityEnderTank)tileEntity).isPublic()) {
                type = 1;
            }
            renderer.func_147782_a((double)0.1255f, 0.0, (double)0.1255f, (double)0.8745f, 1.0, (double)0.8745f);
            IIcon texture = block.func_149733_h(10 + type * 2);
            if (texture != null) {
                renderer.func_147768_a(block, (double)x, (double)y, (double)z, texture);
                renderer.func_147806_b(block, (double)x, (double)y, (double)z, texture);
            }
            if ((texture = block.func_149733_h(11 + type * 2)) != null) {
                renderer.func_147764_f(block, (double)x, (double)y, (double)z, texture);
                renderer.func_147798_e(block, (double)x, (double)y, (double)z, texture);
                renderer.func_147761_c(block, (double)x, (double)y, (double)z, texture);
                renderer.func_147734_d(block, (double)x, (double)y, (double)z, texture);
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return Values.renderID;
    }
}

