/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenStructure {
    private Block hullPlain_block;
    private int hullPlain_metadata;
    private Block hullGlass_block;
    private int hullGlass_metadata;
    private Block solarPanel_block;
    private int solarPanel_metadata;
    private Block cable_block;
    private int cable_metadata;
    private final boolean corrupted;
    private final Random rand;

    public WorldGenStructure(boolean corrupted, Random rand) {
        this.corrupted = corrupted;
        this.rand = rand;
        switch (rand.nextInt(7)) {
            default: {
                this.hullPlain_block = Blocks.field_150406_ce;
                this.hullPlain_metadata = rand.nextInt(16);
                this.hullGlass_block = Blocks.field_150399_cn;
                this.hullGlass_metadata = this.hullPlain_metadata;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.hullPlain_block = WarpDrive.blockHulls_plain[0];
                this.hullPlain_metadata = rand.nextInt(16);
                this.hullGlass_block = WarpDrive.blockHulls_glass[0];
                this.hullGlass_metadata = this.hullPlain_metadata;
                break;
            }
            case 6: {
                this.hullPlain_block = WarpDrive.blockHulls_plain[1];
                this.hullPlain_metadata = rand.nextInt(16);
                this.hullGlass_block = WarpDrive.blockHulls_glass[1];
                this.hullGlass_metadata = this.hullPlain_metadata;
                break;
            }
            case 10: {
                if (!WarpDriveConfig.isIndustrialCraft2Loaded) break;
                this.hullPlain_block = WarpDriveConfig.getModBlock("IC2", "blockAlloy");
                this.hullPlain_metadata = 0;
                this.hullGlass_block = WarpDriveConfig.getModBlock("IC2", "blockAlloyGlass");
                this.hullGlass_metadata = 0;
            }
        }
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            if (WarpDriveConfig.isAdvancedSolarPanelLoaded) {
                this.solarPanel_block = WarpDriveConfig.getModBlock("AdvancedSolarPanel", "BlockAdvSolarPanel");
                this.solarPanel_metadata = rand.nextInt(2);
            } else {
                this.solarPanel_block = WarpDriveConfig.getModBlock("IC2", "blockGenerator");
                this.solarPanel_metadata = 3;
            }
        } else if (WarpDriveConfig.isEnderIOLoaded) {
            this.solarPanel_block = WarpDriveConfig.getModBlock("EnderIO", "blockSolarPanel");
            this.solarPanel_metadata = 0;
        } else {
            this.solarPanel_block = Blocks.field_150350_a;
            this.solarPanel_metadata = 0;
        }
        this.cable_block = Blocks.field_150350_a;
        this.cable_metadata = 0;
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            this.cable_block = WarpDriveConfig.getModBlock("IC2", "blockCable");
            this.cable_metadata = 0;
            switch (rand.nextInt(4)) {
                case 0: {
                    this.cable_metadata = 0;
                    break;
                }
                case 1: {
                    this.cable_metadata = 3;
                    break;
                }
                case 2: {
                    this.cable_metadata = 6;
                    break;
                }
                case 3: {
                    this.cable_metadata = 9;
                    break;
                }
            }
        }
    }

    public void setHullPlain(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(400) == 1) {
            world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 17.0f, false, true);
        } else if (this.corrupted && this.rand.nextInt(10) == 1) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        } else {
            world.func_147465_d(x, y, z, this.hullPlain_block, this.hullPlain_metadata, 2);
        }
    }

    public void setHullGlass(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(5) == 1) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        } else {
            world.func_147465_d(x, y, z, this.hullGlass_block, this.hullGlass_metadata, 2);
        }
    }

    public void setCable(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(3) == 1) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        } else {
            world.func_147465_d(x, y, z, this.cable_block, this.cable_metadata, 2);
        }
    }

    public void setSolarPanel(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(3) == 1) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        } else {
            world.func_147465_d(x, y, z, this.solarPanel_block, this.solarPanel_metadata, 2);
        }
    }
}

