/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cpw.mods.fml.common.IWorldGenerator;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.filler.Filler;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.Orb;
import cr0s.warpdrive.config.structures.OrbInstance;
import cr0s.warpdrive.config.structures.StructureManager;
import cr0s.warpdrive.world.WorldGenSmallShip;
import cr0s.warpdrive.world.WorldGenStation;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class SpaceWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        try {
            if (world.field_73011_w.field_76574_g != WarpDriveConfig.G_SPACE_DIMENSION_ID) {
                return;
            }
            int x = chunkX * 16 + (5 - random.nextInt(10));
            int z = chunkZ * 16 + (5 - random.nextInt(10));
            if (WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS > 0 && (Math.abs(x) > WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS || Math.abs(z) > WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS)) {
                return;
            }
            int y = WarpDriveConfig.SPACE_GENERATOR_Y_MIN_CENTER + random.nextInt(WarpDriveConfig.SPACE_GENERATOR_Y_MAX_CENTER - WarpDriveConfig.SPACE_GENERATOR_Y_MIN_CENTER);
            if (random.nextInt(800) == 1) {
                AbstractStructure moon = StructureManager.getStructure(world.field_73012_v, "moon", null);
                moon.func_76484_a(world, world.field_73012_v, x, y, z);
            } else if (random.nextInt(150) == 1) {
                AbstractStructure moon = StructureManager.getStructure(world.field_73012_v, "asteroid", null);
                moon.func_76484_a(world, world.field_73012_v, x, y, z);
            } else if (random.nextInt(600) == 1) {
                SpaceWorldGenerator.generateAsteroidField(world, x, y, z);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void generateSmallShip(World world, int x, int y, int z, int jitter) {
        int x2 = x + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int y2 = y + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int z2 = z + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        WarpDrive.logger.info("Generating small ship at " + x2 + "," + y2 + "," + z2);
        new WorldGenSmallShip(world.field_73012_v.nextFloat() > 0.2f).func_76484_a(world, world.field_73012_v, x2, y2, z2);
    }

    private static void generateStation(World world, int x, int y, int z, int jitter) {
        int x2 = x + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int y2 = y + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int z2 = z + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        WarpDrive.logger.info("Generating small ship at " + x2 + "," + y2 + "," + z2);
        new WorldGenStation(world.field_73012_v.nextBoolean()).func_76484_a(world, world.field_73012_v, x2, y2, z2);
    }

    private static float binomialRandom(World world) {
        float linear = world.field_73012_v.nextFloat();
        return 1.25f - 0.625f / (0.5f + 2.0f * linear);
    }

    public static void generateAsteroidField(World world, int x, int y1, int z) {
        AbstractStructure moon;
        int aZ;
        int aY;
        int aX;
        float verticalRange;
        float horizontalRange;
        double yawn;
        double bearing;
        float binomial;
        int i;
        LocalProfiler.start("SpaceWorldGenerator.generateAsteroidField");
        float surfacePerAsteroid = 80.0f + world.field_73012_v.nextFloat() * 300.0f;
        int maxDistance = 30 + world.field_73012_v.nextInt(170);
        int maxDistanceBig = Math.round((float)maxDistance * (0.6f + 0.2f * world.field_73012_v.nextFloat()));
        int maxDistanceSmall = Math.round((float)maxDistance * 1.1f);
        float bigRatio = 0.3f + world.field_73012_v.nextFloat() * 0.3f;
        float surfaceBig = (float)(Math.PI * Math.pow(maxDistanceBig, 2.0));
        float surfaceSmall = (float)(Math.PI * Math.pow(maxDistanceSmall, 2.0));
        int numOfBigAsteroids = Math.round(bigRatio * surfaceBig / surfacePerAsteroid);
        int numOfSmallAsteroids = Math.round((1.0f - bigRatio) * surfaceSmall / surfacePerAsteroid);
        int numOfClouds = Math.round((float)numOfBigAsteroids * 1.0f / (10.0f + (float)world.field_73012_v.nextInt(10)));
        int maxHeight = 70 + world.field_73012_v.nextInt(50);
        int y2 = Math.min(WarpDriveConfig.SPACE_GENERATOR_Y_MAX_BORDER - maxHeight, Math.max(y1, WarpDriveConfig.SPACE_GENERATOR_Y_MIN_BORDER + maxHeight));
        WarpDrive.logger.info("Generating asteroid field at " + x + "," + y2 + "," + z + " qty " + numOfBigAsteroids + ", " + numOfSmallAsteroids + ", " + numOfClouds + " over " + maxDistance + ", " + maxHeight + " surfacePerAsteroid " + String.format("%.1f", Float.valueOf(surfacePerAsteroid)));
        for (i = 1; i <= numOfBigAsteroids; ++i) {
            binomial = SpaceWorldGenerator.binomialRandom(world);
            bearing = (double)world.field_73012_v.nextFloat() * 2.0 * Math.PI;
            yawn = (double)world.field_73012_v.nextFloat() * Math.PI;
            horizontalRange = Math.max(6.0f, binomial * (float)maxDistanceBig);
            verticalRange = Math.max(3.0f, binomial * (float)maxHeight);
            aX = (int)((long)x + Math.round((double)horizontalRange * Math.cos(bearing)));
            aY = (int)((long)y2 + Math.round((double)verticalRange * Math.cos(yawn)));
            aZ = (int)((long)z + Math.round((double)horizontalRange * Math.sin(bearing)));
            if (WarpDriveConfig.LOGGING_WORLDGEN) {
                WarpDrive.logger.info(String.format("Big asteroid: %.3f %.3f r %.3f r makes %3d, %3d, %3d", binomial, bearing, yawn, aX, aY, aZ));
            }
            moon = StructureManager.getStructure(world.field_73012_v, "asteroid", null);
            moon.func_76484_a(world, world.field_73012_v, aX, aY, aZ);
        }
        for (i = 1; i <= numOfSmallAsteroids; ++i) {
            binomial = SpaceWorldGenerator.binomialRandom(world);
            bearing = (double)world.field_73012_v.nextFloat() * 2.0 * Math.PI;
            yawn = (double)world.field_73012_v.nextFloat() * Math.PI;
            horizontalRange = Math.max(6.0f, binomial * (float)maxDistanceSmall);
            verticalRange = Math.max(3.0f, binomial * (float)maxHeight);
            aX = (int)((long)x + Math.round((double)horizontalRange * Math.cos(bearing)));
            aY = (int)((long)y2 + Math.round((double)verticalRange * Math.cos(yawn)));
            aZ = (int)((long)z + Math.round((double)horizontalRange * Math.sin(bearing)));
            if (world.field_73012_v.nextInt(400) != 1) {
                moon = StructureManager.getStructure(world.field_73012_v, "asteroid", null);
                moon.func_76484_a(world, world.field_73012_v, aX, aY, aZ);
                continue;
            }
            if (world.field_73012_v.nextInt(20) != 1) {
                SpaceWorldGenerator.generateSmallShip(world, aX, aY, aZ, 8);
                continue;
            }
            SpaceWorldGenerator.generateStation(world, aX, aY, aZ, 8);
        }
        for (i = 1; i <= numOfClouds; ++i) {
            AbstractStructure gasCloud;
            binomial = SpaceWorldGenerator.binomialRandom(world);
            bearing = (double)world.field_73012_v.nextFloat() * 2.0 * Math.PI;
            yawn = (double)world.field_73012_v.nextFloat() * Math.PI;
            horizontalRange = Math.max(6.0f, binomial * (float)maxDistanceBig);
            verticalRange = Math.max(3.0f, binomial * (float)maxHeight);
            aX = (int)((long)x + Math.round((double)horizontalRange * Math.cos(bearing)));
            aY = (int)((long)y2 + Math.round((double)verticalRange * Math.cos(yawn)));
            aZ = (int)((long)z + Math.round((double)horizontalRange * Math.sin(bearing)));
            if (!world.field_73012_v.nextBoolean() || (gasCloud = StructureManager.getStructure(world.field_73012_v, "gascloud", null)) == null) continue;
            gasCloud.func_76484_a(world, world.field_73012_v, aX, aY, aZ);
        }
        LocalProfiler.stop();
    }

    @Deprecated
    public static void generateSphereDirect(OrbInstance orbInstance, World world, int xCoord, int yCoord, int zCoord) {
        double radiusC = (double)orbInstance.getTotalThickness() + 0.5;
        double radiusSq = radiusC * radiusC;
        int ceilRadius = (int)Math.ceil(radiusC);
        for (int x = 0; x <= ceilRadius; ++x) {
            double dX2 = ((double)x + 0.5) * ((double)x + 0.5);
            for (int y = 0; y <= ceilRadius; ++y) {
                double dX2Y2 = dX2 + ((double)y + 0.5) * ((double)y + 0.5);
                for (int z = 0; z <= ceilRadius; ++z) {
                    double dZ2 = ((double)z + 0.5) * ((double)z + 0.5);
                    double dSq = dX2Y2 + dZ2;
                    if (dSq > radiusSq) continue;
                    Orb.OrbShell orbShell = orbInstance.getShellForSqRadius(dSq);
                    Filler filler = orbShell.getRandomBlock(world.field_73012_v);
                    filler.setBlock(world, xCoord + x, yCoord + y, zCoord + z);
                    filler.setBlock(world, xCoord - x, yCoord + y, zCoord + z);
                    filler.setBlock(world, xCoord + x, yCoord - y, zCoord + z);
                    filler.setBlock(world, xCoord + x, yCoord + y, zCoord - z);
                    filler.setBlock(world, xCoord - x, yCoord - y, zCoord + z);
                    filler.setBlock(world, xCoord + x, yCoord - y, zCoord - z);
                    filler.setBlock(world, xCoord - x, yCoord + y, zCoord - z);
                    filler.setBlock(world, xCoord - x, yCoord - y, zCoord - z);
                }
            }
        }
    }
}

