/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.render.RenderBlank;
import cr0s.warpdrive.world.HyperSpaceGenerator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManagerHell;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class HyperSpaceWorldProvider
extends WorldProvider {
    public HyperSpaceWorldProvider() {
        this.field_76578_c = new WorldChunkManagerHell(WarpDrive.spaceBiome, 0.0f);
        this.field_76576_e = true;
    }

    public String func_80007_l() {
        return "Hyperspace";
    }

    public boolean func_76567_e() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        return 0.0f;
    }

    public boolean func_76569_d() {
        return true;
    }

    public int func_76557_i() {
        return 1;
    }

    public double getHorizon() {
        return 1.0;
    }

    public void updateWeather() {
        super.resetRainAndThunder();
    }

    public BiomeGenBase getBiomeGenForCoords(int x, int z) {
        return WarpDrive.spaceBiome;
    }

    public void setAllowedSpawnTypes(boolean allowHostile, boolean allowPeaceful) {
        super.setAllowedSpawnTypes(true, true);
    }

    public float func_76563_a(long par1, float par3) {
        return 0.5f;
    }

    protected void func_76556_a() {
        float f = 0.0f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getSaveFolder() {
        return this.field_76574_g == 0 ? null : "WarpDriveHyperSpace" + this.field_76574_g;
    }

    public boolean func_76566_a(int par1, int par2) {
        int var3 = this.field_76579_a.func_72825_h(par1, par2);
        return var3 != 0;
    }

    public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
        this.setCloudRenderer(new RenderBlank());
        this.setSkyRenderer(new RenderBlank());
        return Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
    }

    public Vec3 func_76562_b(float par1, float par2) {
        return Vec3.func_72443_a((double)0.1, (double)0.0, (double)0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return true;
    }

    public ChunkCoordinates func_76554_h() {
        return null;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID;
    }

    public IChunkProvider func_76555_c() {
        return new HyperSpaceGenerator(this.field_76579_a, 46L);
    }

    public boolean canBlockFreeze(int x, int y, int z, boolean byWater) {
        return false;
    }

    public ChunkCoordinates getRandomizedSpawnPoint() {
        ChunkCoordinates var5 = new ChunkCoordinates(this.field_76579_a.func_72861_E());
        int spawnFuzz = 100;
        int spawnFuzzHalf = spawnFuzz / 2;
        var5.field_71574_a += this.field_76579_a.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf;
        var5.field_71573_c += this.field_76579_a.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf;
        var5.field_71572_b = 200;
        if (this.field_76579_a.func_147437_c(var5.field_71574_a, var5.field_71572_b, var5.field_71573_c)) {
            this.field_76579_a.func_147465_d(var5.field_71574_a, var5.field_71572_b, var5.field_71573_c, Blocks.field_150348_b, 0, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a + 1, var5.field_71572_b + 1, var5.field_71573_c, Blocks.field_150359_w, 0, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a + 1, var5.field_71572_b + 2, var5.field_71573_c, Blocks.field_150359_w, 0, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a - 1, var5.field_71572_b + 1, var5.field_71573_c, Blocks.field_150359_w, 0, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a - 1, var5.field_71572_b + 2, var5.field_71573_c, Blocks.field_150359_w, 0, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a, var5.field_71572_b + 1, var5.field_71573_c + 1, Blocks.field_150359_w, 0, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a, var5.field_71572_b + 2, var5.field_71573_c + 1, Blocks.field_150359_w, 0, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a, var5.field_71572_b + 1, var5.field_71573_c - 1, Blocks.field_150359_w, 0, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a, var5.field_71572_b + 2, var5.field_71573_c - 1, Blocks.field_150359_w, 0, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a, var5.field_71572_b + 3, var5.field_71573_c, Blocks.field_150359_w, 0, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a, var5.field_71572_b, var5.field_71573_c, WarpDrive.blockAir, 15, 2);
            this.field_76579_a.func_147465_d(var5.field_71574_a, var5.field_71572_b + 1, var5.field_71573_c, WarpDrive.blockAir, 15, 2);
        }
        return var5;
    }

    public boolean func_76564_j() {
        return false;
    }

    public boolean isDaytime() {
        return false;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }
}

