/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFireworkSparkFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntitySnowShovelFX;
import net.minecraft.init.Items;
import net.minecraft.world.World;

public class MessageSpawnParticle
implements IMessage,
IMessageHandler<MessageSpawnParticle, IMessage> {
    private String type;
    private Vector3 origin;
    private Vector3 direction;
    private float baseRed;
    private float baseGreen;
    private float baseBlue;
    private float fadeRed;
    private float fadeGreen;
    private float fadeBlue;

    public MessageSpawnParticle() {
    }

    public MessageSpawnParticle(String type, Vector3 origin, Vector3 direction, float baseRed, float baseGreen, float baseBlue, float fadeRed, float fadeGreen, float fadeBlue) {
        this.type = type;
        this.origin = origin;
        this.direction = direction;
        this.baseRed = baseRed;
        this.baseGreen = baseGreen;
        this.baseBlue = baseBlue;
        this.fadeRed = fadeRed;
        this.fadeGreen = fadeGreen;
        this.fadeBlue = fadeBlue;
    }

    public void fromBytes(ByteBuf buffer) {
        byte typeSize = buffer.readByte();
        this.type = buffer.toString(buffer.readerIndex(), (int)typeSize, StandardCharsets.US_ASCII);
        buffer.skipBytes((int)typeSize);
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.origin = new Vector3(x, y, z);
        x = buffer.readDouble();
        y = buffer.readDouble();
        z = buffer.readDouble();
        this.direction = new Vector3(x, y, z);
        this.baseRed = buffer.readFloat();
        this.baseGreen = buffer.readFloat();
        this.baseBlue = buffer.readFloat();
        this.fadeRed = buffer.readFloat();
        this.fadeGreen = buffer.readFloat();
        this.fadeBlue = buffer.readFloat();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.type.length());
        buffer.writeBytes(this.type.getBytes(StandardCharsets.US_ASCII), 0, this.type.length());
        buffer.writeDouble(this.origin.x);
        buffer.writeDouble(this.origin.y);
        buffer.writeDouble(this.origin.z);
        buffer.writeDouble(this.direction.x);
        buffer.writeDouble(this.direction.y);
        buffer.writeDouble(this.direction.z);
        buffer.writeFloat(this.baseRed);
        buffer.writeFloat(this.baseGreen);
        buffer.writeFloat(this.baseBlue);
        buffer.writeFloat(this.fadeRed);
        buffer.writeFloat(this.fadeGreen);
        buffer.writeFloat(this.fadeBlue);
    }

    private int integerFromRGB(float red, float green, float blue) {
        return (Math.round(red * 255.0f) << 16) + (Math.round(green * 255.0f) << 8) + Math.round(blue * 255.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private void handle(World worldObj) {
        double noiseLevel = this.direction.getMagnitude() * 0.35;
        for (int i = 0; i < 5; ++i) {
            EntityBreakingFX effect;
            Vector3 directionRandomized = new Vector3(this.direction.x + noiseLevel * (double)(worldObj.field_73012_v.nextFloat() - worldObj.field_73012_v.nextFloat()), this.direction.y + noiseLevel * (double)(worldObj.field_73012_v.nextFloat() - worldObj.field_73012_v.nextFloat()), this.direction.z + noiseLevel * (double)(worldObj.field_73012_v.nextFloat() - worldObj.field_73012_v.nextFloat()));
            switch (this.type) {
                default: {
                    effect = new EntityExplodeFX(worldObj, this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z);
                    break;
                }
                case "fireworksSpark": {
                    EntityFireworkSparkFX entityFireworkSparkFX = new EntityFireworkSparkFX(worldObj, this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z, FMLClientHandler.instance().getClient().field_71452_i);
                    entityFireworkSparkFX.func_92046_g(this.integerFromRGB(this.fadeRed, this.fadeGreen, this.fadeBlue));
                    effect = entityFireworkSparkFX;
                    break;
                }
                case "flame": {
                    effect = new EntityFlameFX(worldObj, this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z);
                    break;
                }
                case "snowballpoof": {
                    effect = new EntityBreakingFX(worldObj, this.origin.x, this.origin.y, this.origin.z, Items.field_151126_ay);
                    break;
                }
                case "snowshovel": {
                    effect = new EntitySnowShovelFX(worldObj, this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z);
                }
            }
            if (this.baseRed >= 0.0f && this.baseGreen >= 0.0f && this.baseBlue >= 0.0f) {
                effect.func_70538_b(this.baseRed, this.baseGreen, this.baseBlue);
            }
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)effect);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageSpawnParticle messageSpawnParticle, MessageContext context) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            WarpDrive.logger.error("WorldObj is null, ignoring beam packet");
            return null;
        }
        if (WarpDriveConfig.LOGGING_EFFECTS) {
            WarpDrive.logger.info("Received particle effect '" + messageSpawnParticle.type + "' from " + messageSpawnParticle.origin + " toward " + messageSpawnParticle.direction + " as RGB " + messageSpawnParticle.baseRed + " " + messageSpawnParticle.baseGreen + " " + messageSpawnParticle.baseBlue + " fading to " + messageSpawnParticle.fadeRed + " " + messageSpawnParticle.fadeGreen + " " + messageSpawnParticle.fadeBlue);
        }
        messageSpawnParticle.handle((World)Minecraft.func_71410_x().field_71441_e);
        return null;
    }
}

