/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.block.energy.BlockEnergyBank;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemTuningFork
extends Item {
    private IIcon[] icons;

    public ItemTuningFork() {
        this.func_77656_e(0);
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        this.func_77625_d(1);
        this.func_77655_b("warpdrive.tool.TuningFork");
        this.func_77664_n();
        this.func_77627_a(true);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            this.icons[i] = iconRegister.func_94245_a("warpdrive:tool/tuningFork_" + ItemTuningFork.getDyeColorName(i));
        }
    }

    public static String getDyeColorName(int metadata) {
        return ItemDye.field_150921_b[metadata];
    }

    public IIcon func_77617_a(int damage) {
        if (damage < this.icons.length) {
            return this.icons[damage];
        }
        return Blocks.field_150480_ab.func_149840_c(0);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (int dyeColor = 0; dyeColor < 16; ++dyeColor) {
            list.add(new ItemStack(item, 1, dyeColor));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        int damage = itemStack.func_77960_j();
        if (damage >= 0 && damage < 16) {
            return this.func_77658_a() + "." + ItemDye.field_150923_a[damage];
        }
        return this.func_77658_a();
    }

    public static int getVideoChannel(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningFork)) {
            return -1;
        }
        return itemStack.func_77960_j() % 16 + 100;
    }

    public static int getBeamFrequency(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningFork)) {
            return -1;
        }
        return (itemStack.func_77960_j() % 16 + 1) * 10;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return false;
        }
        boolean hasVideoChannel = tileEntity instanceof IVideoChannel;
        boolean hasBeamFrequency = tileEntity instanceof IBeamFrequency;
        if (!hasVideoChannel && !hasBeamFrequency) {
            return false;
        }
        if (!(!hasVideoChannel || entityPlayer.func_70093_af() && hasBeamFrequency)) {
            ((IVideoChannel)tileEntity).setVideoChannel(ItemTuningFork.getVideoChannel(itemStack));
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"item.warpdrive.tool.TuningFork.use.setVideoChannel", (Object[])new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningFork.getVideoChannel(itemStack)}));
            world.func_72956_a((Entity)entityPlayer, "WarpDrive:ding", 0.1f, 1.0f);
        } else if (hasBeamFrequency) {
            ((IBeamFrequency)tileEntity).setBeamFrequency(ItemTuningFork.getBeamFrequency(itemStack));
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"item.warpdrive.tool.TuningFork.use.setBeamFrequency", (Object[])new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningFork.getBeamFrequency(itemStack)}));
            world.func_72956_a((Entity)entityPlayer, "WarpDrive:ding", 0.1f, 1.0f);
        } else {
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, "Error: invalid state, please contact the mod authors\nof " + itemStack + "\nand " + tileEntity);
        }
        return true;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        Block block = world.func_147439_a(x, y, z);
        return block instanceof BlockEnergyBank || super.doesSneakBypassUse(world, x, y, z, player);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean advancedItemTooltips) {
        super.func_77624_a(itemStack, entityPlayer, list, advancedItemTooltips);
        String tooltip = "";
        tooltip = tooltip + StatCollector.func_74837_a((String)"item.warpdrive.tool.TuningFork.tooltip.videoChannel", (Object[])new Object[]{ItemTuningFork.getVideoChannel(itemStack)});
        tooltip = tooltip + "\n" + StatCollector.func_74837_a((String)"item.warpdrive.tool.TuningFork.tooltip.beamFrequency", (Object[])new Object[]{ItemTuningFork.getBeamFrequency(itemStack)});
        tooltip = tooltip + "\n\n" + StatCollector.func_74838_a((String)"item.warpdrive.tool.TuningFork.tooltip.usage");
        WarpDrive.addTooltip(list, tooltip);
    }
}

