/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IAirCanister;
import cr0s.warpdrive.api.IBreathingHelmet;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class ItemHelmet
extends ItemArmor
implements IBreathingHelmet {
    public ItemHelmet(ItemArmor.ArmorMaterial mat, int slot) {
        super(mat, 0, slot);
        this.func_77655_b("warpdrive.armor.Helmet");
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        this.func_111206_d("warpdrive:warpArmorHelmet");
    }

    public String getArmorTexture(ItemStack is, Entity en, int parSlot, String type) {
        return "warpdrive:textures/armor/warpArmor_1.png";
    }

    @Override
    public boolean canBreath(Entity player) {
        return true;
    }

    @Override
    public boolean removeAir(Entity entity) {
        if (WarpDriveConfig.LOGGING_BREATHING) {
            WarpDrive.logger.info("Checking breathing!");
        }
        if (entity instanceof EntityPlayerMP) {
            IAirCanister airCanister;
            ItemStack itemStack;
            EntityPlayerMP entityPlayer = (EntityPlayerMP)entity;
            ItemStack[] playerInventory = entityPlayer.field_71071_by.field_70462_a;
            int slotAirCanisterFound = -1;
            float fillingRatioAirCanisterFound = 0.0f;
            for (int slotIndex = 0; slotIndex < playerInventory.length; ++slotIndex) {
                IAirCanister airCanister2;
                ItemStack itemStack2 = playerInventory[slotIndex];
                if (itemStack2 == null || !(itemStack2.func_77973_b() instanceof IAirCanister) || !(airCanister2 = (IAirCanister)itemStack2.func_77973_b()).containsAir(itemStack2)) continue;
                float fillingRatio = 1.0f - (float)itemStack2.func_77960_j() / (float)itemStack2.func_77958_k();
                fillingRatio -= (float)(itemStack2.field_77994_a / 1000);
                if (!(fillingRatioAirCanisterFound <= 0.0f) && !(fillingRatio < fillingRatioAirCanisterFound)) continue;
                slotAirCanisterFound = slotIndex;
                fillingRatioAirCanisterFound = fillingRatio;
            }
            if (slotAirCanisterFound >= 0 && (itemStack = playerInventory[slotAirCanisterFound]) != null && itemStack.func_77973_b() instanceof IAirCanister && (airCanister = (IAirCanister)itemStack.func_77973_b()).containsAir(itemStack)) {
                if (itemStack.field_77994_a > 1) {
                    --itemStack.field_77994_a;
                    ItemStack toAdd = itemStack.func_77946_l();
                    toAdd.field_77994_a = 1;
                    toAdd.func_77964_b(itemStack.func_77960_j() + 1);
                    if (itemStack.func_77960_j() >= itemStack.func_77958_k()) {
                        toAdd = airCanister.emptyDrop(itemStack);
                    }
                    if (!entityPlayer.field_71071_by.func_70441_a(toAdd)) {
                        EntityItem entityItem = new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, toAdd);
                        entityPlayer.field_70170_p.func_72838_d((Entity)entityItem);
                    }
                    entityPlayer.func_71120_a(entityPlayer.field_71069_bz);
                } else {
                    itemStack.func_77964_b(itemStack.func_77960_j() + 1);
                    if (itemStack.func_77960_j() >= itemStack.func_77958_k()) {
                        playerInventory[slotAirCanisterFound] = airCanister.emptyDrop(itemStack);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int ticksPerCanDamage() {
        return 300;
    }
}

