/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IAirCanister;
import cr0s.warpdrive.block.energy.BlockEnergyBank;
import cr0s.warpdrive.data.EnumComponentType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemComponent
extends Item
implements IAirCanister {
    private IIcon[] icons;
    private static ItemStack[] itemStackCache;

    public ItemComponent() {
        this.func_77627_a(true);
        this.func_77655_b("warpdrive.crafting.component");
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        this.icons = new IIcon[EnumComponentType.length];
        itemStackCache = new ItemStack[EnumComponentType.length];
    }

    public static ItemStack getItemStack(EnumComponentType enumComponentType) {
        if (enumComponentType != null) {
            int damage = enumComponentType.ordinal();
            if (itemStackCache[damage] == null) {
                ItemComponent.itemStackCache[damage] = new ItemStack((Item)WarpDrive.itemComponent, 1, damage);
            }
            return itemStackCache[damage];
        }
        return null;
    }

    public static ItemStack getItemStackNoCache(EnumComponentType enumComponentType, int amount) {
        return new ItemStack((Item)WarpDrive.itemComponent, amount, enumComponentType.ordinal());
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        for (EnumComponentType enumComponentType : EnumComponentType.values()) {
            this.icons[enumComponentType.ordinal()] = par1IconRegister.func_94245_a("warpdrive:component/" + enumComponentType.unlocalizedName);
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        int damage = itemStack.func_77960_j();
        if (damage >= 0 && damage < EnumComponentType.length) {
            return "item.warpdrive.crafting." + EnumComponentType.get((int)damage).unlocalizedName;
        }
        return this.func_77658_a();
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= 0 && damage < EnumComponentType.length) {
            return this.icons[damage];
        }
        return this.icons[0];
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (EnumComponentType enumComponentType : EnumComponentType.values()) {
            list.add(new ItemStack(item, 1, enumComponentType.ordinal()));
        }
    }

    @Override
    public boolean canContainAir(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemComponent && itemStack.func_77960_j() == EnumComponentType.AIR_CANISTER.ordinal();
    }

    @Override
    public boolean containsAir(ItemStack itemStack) {
        return false;
    }

    @Override
    public ItemStack fullDrop(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirCanisterFull.fullDrop(itemStack);
        }
        return null;
    }

    @Override
    public ItemStack emptyDrop(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirCanisterFull.emptyDrop(itemStack);
        }
        return null;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        Block block = world.func_147439_a(x, y, z);
        return block instanceof BlockEnergyBank || super.doesSneakBypassUse(world, x, y, z, player);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean advancedItemTooltips) {
        super.func_77624_a(itemStack, entityPlayer, list, advancedItemTooltips);
        String tooltip = "";
        switch (EnumComponentType.get(itemStack.func_77960_j())) {
            case AIR_CANISTER: {
                tooltip = tooltip + StatCollector.func_74837_a((String)"item.warpdrive.crafting.AirCanisterEmpty.tooltip", (Object[])new Object[0]);
                break;
            }
        }
        WarpDrive.addTooltip(list, tooltip);
    }
}

