/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.event.AbstractSequencer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WorldHandler {
    public void onChunkLoaded(ChunkWatchEvent event) {
        ChunkCoordIntPair chunk = event.chunk;
        WarpDrive.logger.info("onChunkLoaded " + chunk.field_77276_a + " " + chunk.field_77275_b);
        WarpDrive.cloaks.onChunkLoaded(event.player, chunk.field_77276_a, chunk.field_77275_b);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer && !event.world.field_72995_K) {
            WarpDrive.cloaks.onPlayerEnteringDimension((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WarpDrive.cloaks.onPlayerEnteringDimension(event.player);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        WarpDrive.cloaks.onClientChangingDimension();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldUnload(WorldEvent.Unload event) {
        WarpDrive.cloaks.onClientChangingDimension();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        AbstractSequencer.updateTick();
    }
}

