/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.data.VectorI;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Transformation
implements ITransformation {
    private final VectorI sourceCore;
    private final VectorI targetCore;
    private final VectorI move;
    private final byte rotationSteps;
    private final World targetWorld;

    public Transformation(JumpShip ship, World targetWorld, int moveX, int moveY, int moveZ, byte rotationSteps) {
        this.sourceCore = new VectorI(ship.coreX, ship.coreY, ship.coreZ);
        this.targetWorld = targetWorld;
        this.move = new VectorI(moveX, moveY, moveZ);
        this.targetCore = this.sourceCore.add(this.move);
        this.rotationSteps = (byte)((rotationSteps + 4) % 4);
    }

    @Override
    public World getTargetWorld() {
        return this.targetWorld;
    }

    @Override
    public byte getRotationSteps() {
        return this.rotationSteps;
    }

    @Override
    public float getRotationYaw() {
        return 90.0f * (float)this.rotationSteps;
    }

    @Override
    public Vec3 apply(double sourceX, double sourceY, double sourceZ) {
        if (this.rotationSteps == 0) {
            return Vec3.func_72443_a((double)(sourceX + (double)this.move.x), (double)(sourceY + (double)this.move.y), (double)(sourceZ + (double)this.move.z));
        }
        double dX = sourceX - (double)this.sourceCore.x - 0.5;
        double dZ = sourceZ - (double)this.sourceCore.z - 0.5;
        switch (this.rotationSteps) {
            case 1: {
                return Vec3.func_72443_a((double)((double)this.targetCore.x + 0.5 - dZ), (double)(sourceY + (double)this.move.y), (double)((double)this.targetCore.z + 0.5 + dX));
            }
            case 2: {
                return Vec3.func_72443_a((double)((double)this.targetCore.x + 0.5 - dX), (double)(sourceY + (double)this.move.y), (double)((double)this.targetCore.z + 0.5 - dZ));
            }
            case 3: {
                return Vec3.func_72443_a((double)((double)this.targetCore.x + 0.5 + dZ), (double)(sourceY + (double)this.move.y), (double)((double)this.targetCore.z + 0.5 - dX));
            }
        }
        return null;
    }

    @Override
    public ChunkCoordinates apply(int sourceX, int sourceY, int sourceZ) {
        if (this.rotationSteps == 0) {
            return new ChunkCoordinates(sourceX + this.move.x, sourceY + this.move.y, sourceZ + this.move.z);
        }
        int dX = sourceX - this.sourceCore.x;
        int dZ = sourceZ - this.sourceCore.z;
        switch (this.rotationSteps) {
            case 1: {
                return new ChunkCoordinates(this.targetCore.x - dZ, sourceY + this.move.y, this.targetCore.z + dX);
            }
            case 2: {
                return new ChunkCoordinates(this.targetCore.x - dX, sourceY + this.move.y, this.targetCore.z - dZ);
            }
            case 3: {
                return new ChunkCoordinates(this.targetCore.x + dZ, sourceY + this.move.y, this.targetCore.z - dX);
            }
        }
        return null;
    }

    @Override
    public ChunkCoordinates apply(TileEntity tileEntity) {
        return this.apply(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    @Override
    public ChunkCoordinates apply(ChunkCoordinates chunkCoordinates) {
        return this.apply(chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c);
    }

    public void rotate(Entity entity) {
        if (this.rotationSteps == 0) {
            return;
        }
        entity.field_70177_z = (entity.field_70177_z + 270.0f * (float)this.rotationSteps) % 360.0f - 180.0f;
    }
}

