/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.StarMapRegistryItem;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class StarMapRegistry {
    private final LinkedList<StarMapRegistryItem> registry = new LinkedList();

    public int searchInRegistry(StarMapRegistryItem entryKey) {
        int res = -1;
        for (int i = 0; i < this.registry.size(); ++i) {
            StarMapRegistryItem entry = this.registry.get(i);
            if (entry.dimensionId != entryKey.dimensionId || entry.x != entryKey.x || entry.y != entryKey.y || entry.z != entryKey.z) continue;
            return i;
        }
        return res;
    }

    public boolean isInRegistry(StarMapRegistryItem entryKey) {
        return this.searchInRegistry(entryKey) != -1;
    }

    public void updateInRegistry(StarMapRegistryItem entryKey) {
        int idx = this.searchInRegistry(entryKey);
        if (idx != -1) {
            this.registry.set(idx, entryKey);
        } else {
            this.registry.add(entryKey);
            if (WarpDriveConfig.LOGGING_STARMAP) {
                this.printRegistry("added");
            }
        }
    }

    public void removeFromRegistry(StarMapRegistryItem entryKey) {
        int idx = this.searchInRegistry(entryKey);
        if (idx != -1) {
            this.registry.remove(idx);
            if (WarpDriveConfig.LOGGING_STARMAP) {
                this.printRegistry("removed");
            }
        }
    }

    public ArrayList<StarMapRegistryItem> radarScan(TileEntity tileEntity, int radius) {
        ArrayList<StarMapRegistryItem> res = new ArrayList<StarMapRegistryItem>(this.registry.size());
        this.cleanup();
        int radius2 = radius * radius;
        for (StarMapRegistryItem entry : this.registry) {
            double dX = entry.x - tileEntity.field_145851_c;
            double dY = entry.y - tileEntity.field_145848_d;
            double dZ = entry.z - tileEntity.field_145849_e;
            double distance2 = dX * dX + dY * dY + dZ * dZ;
            if (!(distance2 <= (double)radius2) || entry.isolationRate != 0.0 && !(tileEntity.func_145831_w().field_73012_v.nextDouble() >= entry.isolationRate) || entry.getSpaceCoordinates() == null) continue;
            res.add(entry);
        }
        return res;
    }

    public void printRegistry(String trigger) {
        WarpDrive.logger.info("Starmap registry (" + this.registry.size() + " entries after " + trigger + "):");
        for (StarMapRegistryItem entry : this.registry) {
            WarpDrive.logger.info("- " + (Object)((Object)entry.type) + " '" + entry.name + "' @ " + entry.dimensionId + ": " + entry.x + ", " + entry.y + ", " + entry.z + " with " + entry.isolationRate + " isolation rate");
        }
    }

    public boolean isWarpCoreIntersectsWithOthers(TileEntityShipCore core) {
        StringBuilder reason = new StringBuilder();
        this.cleanup();
        core.validateShipSpatialParameters(reason);
        AxisAlignedBB aabb1 = AxisAlignedBB.func_72330_a((double)core.minX, (double)core.minY, (double)core.minZ, (double)core.maxX, (double)core.maxY, (double)core.maxZ);
        for (StarMapRegistryItem entry : this.registry) {
            AxisAlignedBB aabb2;
            double d5;
            double d4;
            double d3;
            double distance2;
            TileEntity tileEntity;
            if (entry.dimensionId != core.func_145831_w().field_73011_w.field_76574_g || entry.type != StarMapRegistryItem.EnumStarMapEntryType.SHIP || entry.x == core.field_145851_c && entry.y == core.field_145848_d && entry.z == core.field_145849_e || !((tileEntity = core.func_145831_w().func_147438_o(entry.x, entry.y, entry.z)) instanceof TileEntityShipCore)) continue;
            TileEntityShipCore shipCore = (TileEntityShipCore)core.func_145831_w().func_147438_o(entry.x, entry.y, entry.z);
            if (shipCore.controller == null || shipCore.controller.getMode() == TileEntityShipCore.EnumShipCoreMode.IDLE || !shipCore.validateShipSpatialParameters(reason) || !((distance2 = (d3 = (double)(entry.x - core.field_145851_c)) * d3 + (d4 = (double)(entry.y - core.field_145848_d)) * d4 + (d5 = (double)(entry.z - core.field_145849_e)) * d5) <= (double)((2 * WarpDriveConfig.SHIP_MAX_SIDE_SIZE - 1) * (2 * WarpDriveConfig.SHIP_MAX_SIDE_SIZE - 1))) || !aabb1.func_72326_a(aabb2 = AxisAlignedBB.func_72330_a((double)entry.minX, (double)entry.minY, (double)entry.minZ, (double)entry.maxX, (double)entry.maxY, (double)entry.maxZ))) continue;
            return true;
        }
        return false;
    }

    private void cleanup() {
        LocalProfiler.start("StarMapRegistry cleanup");
        for (int i = this.registry.size() - 1; i >= 0; --i) {
            StarMapRegistryItem entry = this.registry.get(i);
            boolean isValid = false;
            if (entry != null) {
                boolean isLoaded;
                WorldServer world = DimensionManager.getWorld((int)entry.dimensionId);
                if (world == null) continue;
                if (world.func_72863_F() instanceof ChunkProviderServer) {
                    ChunkProviderServer chunkProviderServer = (ChunkProviderServer)world.func_72863_F();
                    try {
                        isLoaded = chunkProviderServer.field_73244_f.func_76161_b(ChunkCoordIntPair.func_77272_a((int)(entry.x >> 4), (int)(entry.z >> 4)));
                    }
                    catch (NoSuchFieldError exception) {
                        isLoaded = chunkProviderServer.func_73149_a(entry.x >> 4, entry.z >> 4);
                    }
                } else {
                    isLoaded = world.func_72863_F().func_73149_a(entry.x >> 4, entry.z >> 4);
                }
                if (!isLoaded) continue;
                Block block = world.func_147439_a(entry.x, entry.y, entry.z);
                TileEntity tileEntity = world.func_147438_o(entry.x, entry.y, entry.z);
                isValid = true;
                switch (entry.type) {
                    case UNDEFINED: {
                        break;
                    }
                    case SHIP: {
                        isValid = block == WarpDrive.blockShipCore && tileEntity != null && !tileEntity.func_145837_r();
                        break;
                    }
                    case JUMPGATE: {
                        break;
                    }
                    case PLANET: {
                        break;
                    }
                    case STAR: {
                        break;
                    }
                    case STRUCTURE: {
                        break;
                    }
                    case WARP_ECHO: {
                        break;
                    }
                }
            }
            if (isValid) continue;
            if (WarpDriveConfig.LOGGING_STARMAP) {
                if (entry == null) {
                    WarpDrive.logger.info("Cleaning up starmap object ~null~");
                } else {
                    WarpDrive.logger.info("Cleaning up starmap object " + (Object)((Object)entry.type) + " at " + entry.dimensionId + " " + entry.x + " " + entry.y + " " + entry.z);
                }
            }
            this.registry.remove(i);
        }
        LocalProfiler.stop();
    }
}

