/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class JumpShip {
    public World worldObj;
    public int coreX;
    public int coreY;
    public int coreZ;
    public int dx;
    public int dz;
    public int maxX;
    public int maxZ;
    public int maxY;
    public int minX;
    public int minZ;
    public int minY;
    public JumpBlock[] jumpBlocks;
    public int actualMass;
    public TileEntityShipCore shipCore;
    public List<MovingEntity> entitiesOnShip;

    public void messageToAllPlayersOnShip(String message) {
        if (this.entitiesOnShip == null) {
            this.shipCore.messageToAllPlayersOnShip(message);
        } else {
            WarpDrive.logger.info(this + " messageToAllPlayersOnShip: " + message);
            for (MovingEntity me : this.entitiesOnShip) {
                if (!(me.entity instanceof EntityPlayer)) continue;
                WarpDrive.addChatMessage((ICommandSender)((EntityPlayer)me.entity), "[" + (this.shipCore != null && !this.shipCore.shipName.isEmpty() ? this.shipCore.shipName : "WarpCore") + "] " + message);
            }
        }
    }

    public String saveEntities() {
        String result = null;
        this.entitiesOnShip = new ArrayList<MovingEntity>();
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)((double)this.maxX + 0.99), (double)((double)this.maxY + 0.99), (double)((double)this.maxZ + 0.99));
        List list = this.worldObj.func_72839_b(null, axisalignedbb);
        for (Entity entity : list) {
            if (entity == null) continue;
            String id = EntityList.func_75621_b((Entity)entity);
            if (Dictionary.ENTITIES_ANCHOR.contains(id)) {
                result = "Anchor entity " + id + " detected at " + Math.floor(entity.field_70165_t) + ", " + Math.floor(entity.field_70163_u) + ", " + Math.floor(entity.field_70161_v) + ", aborting jump...";
                continue;
            }
            if (Dictionary.ENTITIES_LEFTBEHIND.contains(id)) {
                if (!WarpDriveConfig.LOGGING_JUMPBLOCKS) continue;
                WarpDrive.logger.info("Leaving entity " + id + " behind: " + entity);
                continue;
            }
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS && WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("Adding entity " + id + ": " + entity);
            }
            MovingEntity movingEntity = new MovingEntity(entity);
            this.entitiesOnShip.add(movingEntity);
        }
        return result;
    }

    public boolean isUnlimited() {
        if (this.entitiesOnShip == null) {
            return false;
        }
        for (MovingEntity movingEntity : this.entitiesOnShip) {
            if (!(movingEntity.entity instanceof EntityPlayer)) continue;
            String playerName = ((EntityPlayer)movingEntity.entity).getDisplayName();
            for (String unlimitedName : WarpDriveConfig.SHIP_VOLUME_UNLIMITED_PLAYERNAMES) {
                if (!unlimitedName.equals(playerName)) continue;
                return true;
            }
        }
        return false;
    }

    public void setMinMaxes(int minXV, int maxXV, int minYV, int maxYV, int minZV, int maxZV) {
        this.minX = minXV;
        this.maxX = maxXV;
        this.minY = minYV;
        this.maxY = maxYV;
        this.minZ = minZV;
        this.maxZ = maxZV;
    }

    public String toString() {
        return String.format("%s/%d '%s' @ '%s' (%d %d %d)", this.getClass().getSimpleName(), this.hashCode(), this.shipCore == null ? "~NULL~" : this.shipCore.uuid + ":" + this.shipCore.shipName, this.worldObj == null || this.worldObj.func_72912_H() == null ? "~NULL~" : this.worldObj.func_72912_H().func_76065_j(), this.coreX, this.coreY, this.coreZ);
    }

    public boolean checkBorders(StringBuilder reason) {
        for (int x = this.minX - 1; x <= this.maxX + 1; ++x) {
            boolean xBorder = x == this.minX - 1 || x == this.maxX + 1;
            for (int z = this.minZ - 1; z <= this.maxZ + 1; ++z) {
                boolean zBorder = z == this.minZ - 1 || z == this.maxZ + 1;
                for (int y = this.minY - 1; y <= this.maxY + 1; ++y) {
                    TileEntity tileEntity;
                    boolean yBorder;
                    boolean bl = yBorder = y == this.minY - 1 || y == this.maxY + 1;
                    if (y < 0 || y > 255 || !xBorder && !yBorder && !zBorder) continue;
                    Block block = this.worldObj.func_147439_a(x, y, z);
                    if (this.worldObj.func_147437_c(x, y, z) || Dictionary.BLOCKS_LEFTBEHIND.contains(block) || Dictionary.BLOCKS_ANCHOR.contains(block) || (tileEntity = this.worldObj.func_147438_o(x, y, z)) == null) continue;
                    reason.append("Ship snagged by " + block.func_149732_F() + " at " + x + ", " + y + ", " + z + ". Damage report pending...");
                    this.worldObj.func_72876_a((Entity)null, (double)x, (double)y, (double)z, Math.min(120.0f, 4.0f * (float)(this.jumpBlocks.length / 50)), false);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean save(StringBuilder reason) {
        VectorI vPosition = new VectorI();
        try {
            int estimatedVolume = (this.maxX - this.minX + 1) * (this.maxY - this.minY + 1) * (this.maxZ - this.minZ + 1);
            JumpBlock[][] placeTimeJumpBlocks = new JumpBlock[][]{new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume]};
            int[] placeTimeIndexes = new int[]{0, 0, 0, 0, 0};
            int actualVolume = 0;
            int newMass = 0;
            int xc1 = this.minX >> 4;
            int xc2 = this.maxX >> 4;
            int zc1 = this.minZ >> 4;
            int zc2 = this.maxZ >> 4;
            for (int xc = xc1; xc <= xc2; ++xc) {
                int x1 = Math.max(this.minX, xc << 4);
                int x2 = Math.min(this.maxX, (xc << 4) + 15);
                for (int zc = zc1; zc <= zc2; ++zc) {
                    int z1 = Math.max(this.minZ, zc << 4);
                    int z2 = Math.min(this.maxZ, (zc << 4) + 15);
                    for (int y = this.minY; y <= this.maxY; ++y) {
                        vPosition.y = y;
                        for (int x = x1; x <= x2; ++x) {
                            vPosition.x = x;
                            for (int z = z1; z <= z2; ++z) {
                                Integer placeTime;
                                vPosition.z = z;
                                Block block = this.worldObj.func_147439_a(x, y, z);
                                if (block == Blocks.field_150350_a || Dictionary.BLOCKS_LEFTBEHIND.contains(block)) continue;
                                ++actualVolume;
                                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                                    WarpDrive.logger.info("Block(" + x + " " + y + " " + z + ") is " + block.func_149739_a() + "@" + this.worldObj.func_72805_g(x, y, z));
                                }
                                if (!Dictionary.BLOCKS_NOMASS.contains(block)) {
                                    ++newMass;
                                }
                                if (Dictionary.BLOCKS_ANCHOR.contains(block)) {
                                    reason.append(block.func_149739_a() + " detected onboard at " + x + " " + y + " " + z + ". Aborting.");
                                    return false;
                                }
                                int blockMeta = this.worldObj.func_72805_g(x, y, z);
                                TileEntity tileEntity = this.worldObj.func_147438_o(x, y, z);
                                JumpBlock jumpBlock = new JumpBlock(block, blockMeta, tileEntity, x, y, z);
                                if (jumpBlock.blockTileEntity != null && jumpBlock.externals != null) {
                                    for (Map.Entry<String, NBTBase> external : jumpBlock.externals.entrySet()) {
                                        IBlockTransformer blockTransformer = WarpDriveConfig.blockTransformers.get(external.getKey());
                                        if (blockTransformer == null || blockTransformer.isJumpReady(jumpBlock.block, jumpBlock.blockMeta, jumpBlock.blockTileEntity, reason)) continue;
                                        reason.append(" Jump aborted by " + jumpBlock.block.func_149732_F() + " at " + jumpBlock.x + " " + jumpBlock.y + " " + jumpBlock.z);
                                        return false;
                                    }
                                }
                                if ((placeTime = Dictionary.BLOCKS_PLACE.get(block)) == null) {
                                    placeTime = tileEntity == null ? Integer.valueOf(2) : Integer.valueOf(3);
                                }
                                placeTimeJumpBlocks[placeTime.intValue()][placeTimeIndexes[placeTime.intValue()]] = jumpBlock;
                                int n = placeTime;
                                placeTimeIndexes[n] = placeTimeIndexes[n] + 1;
                            }
                        }
                    }
                }
            }
            this.jumpBlocks = new JumpBlock[actualVolume];
            int indexShip = 0;
            for (int placeTime = 0; placeTime < 5; ++placeTime) {
                for (int placeTimeIndex = 0; placeTimeIndex < placeTimeIndexes[placeTime]; ++placeTimeIndex) {
                    this.jumpBlocks[indexShip] = placeTimeJumpBlocks[placeTime][placeTimeIndex];
                    ++indexShip;
                }
            }
            this.actualMass = newMass;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            reason.append("Exception while saving ship, probably a corrupted block at " + vPosition.x + " " + vPosition.y + " " + vPosition.z);
            return false;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Ship saved as " + this.jumpBlocks.length + " blocks");
        }
        return true;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.coreX = tag.func_74762_e("coreX");
        this.coreY = tag.func_74762_e("coreY");
        this.coreZ = tag.func_74762_e("coreZ");
        this.dx = tag.func_74762_e("dx");
        this.dz = tag.func_74762_e("dz");
        this.maxX = tag.func_74762_e("maxX");
        this.maxZ = tag.func_74762_e("maxZ");
        this.maxY = tag.func_74762_e("maxY");
        this.minX = tag.func_74762_e("minX");
        this.minZ = tag.func_74762_e("minZ");
        this.minY = tag.func_74762_e("minY");
        this.actualMass = tag.func_74762_e("actualMass");
        NBTTagList tagList = tag.func_150295_c("jumpBlocks", 10);
        this.jumpBlocks = new JumpBlock[tagList.func_74745_c()];
        for (int index = 0; index < tagList.func_74745_c(); ++index) {
            this.jumpBlocks[index] = new JumpBlock();
            this.jumpBlocks[index].readFromNBT(tagList.func_150305_b(index));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("coreX", this.coreX);
        tag.func_74768_a("coreY", this.coreY);
        tag.func_74768_a("coreZ", this.coreZ);
        tag.func_74768_a("dx", this.dx);
        tag.func_74768_a("dz", this.dz);
        tag.func_74768_a("maxX", this.maxX);
        tag.func_74768_a("maxZ", this.maxZ);
        tag.func_74768_a("maxY", this.maxY);
        tag.func_74768_a("minX", this.minX);
        tag.func_74768_a("minZ", this.minZ);
        tag.func_74768_a("minY", this.minY);
        tag.func_74768_a("actualMass", this.actualMass);
        NBTTagList tagListJumpBlocks = new NBTTagList();
        for (JumpBlock jumpBlock : this.jumpBlocks) {
            NBTTagCompound tagCompoundBlock = new NBTTagCompound();
            jumpBlock.writeToNBT(tagCompoundBlock);
            tagListJumpBlocks.func_74742_a((NBTBase)tagCompoundBlock);
        }
        tag.func_74782_a("jumpBlocks", (NBTBase)tagListJumpBlocks);
    }
}

