/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IForceFieldShape;
import cr0s.warpdrive.api.IForceFieldUpgrade;
import cr0s.warpdrive.api.IForceFieldUpgradeEffector;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldProjector;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumForceFieldUpgrade;
import cr0s.warpdrive.data.EnumPermissionNode;
import cr0s.warpdrive.data.ForceFieldRegistry;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ForceFieldSetup
extends GlobalPosition {
    private static final float FORCEFIELD_BASE_SCAN_SPEED_BLOCKS_PER_SECOND = 100.0f;
    private static final float FORCEFIELD_BASE_PLACE_SPEED_BLOCKS_PER_SECOND = 20.0f;
    private static final float FORCEFIELD_MAX_SCAN_SPEED_BLOCKS_PER_SECOND = 10000.0f;
    private static final float FORCEFIELD_MAX_PLACE_SPEED_BLOCKS_PER_SECOND = 4000.0f;
    private static final float FORCEFIELD_UPGRADE_BOOST_FACTOR_PER_PROJECTOR_TIER = 0.5f;
    public static final float FORCEFIELD_UPGRADE_BOOST_FACTOR_PER_RELAY_TIER = 0.25f;
    public static final double FORCEFIELD_ACCELERATION_FACTOR = 0.16;
    public static final int FORCEFIELD_RELAY_RANGE = 20;
    private static final int FORCEFIELD_MAX_FACTOR_ENTITY_COST = 5;
    private static final double FORCEFIELD_TAU_FACTOR_ENTITY_COST = -Math.log(5.0);
    public final int beamFrequency;
    public final byte tier;
    public final Set<TileEntityForceFieldProjector> projectors = new HashSet<TileEntityForceFieldProjector>();
    private Block blockCamouflage;
    private int metadataCamouflage;
    private int colorMultiplierCamouflage;
    private int lightCamouflage;
    private static final List<Integer> ALLOWED_RENDER_TYPES = Arrays.asList(0, 1, 2, 3, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 41);
    private final HashMap<IForceFieldUpgradeEffector, Float> upgrades = new HashMap(EnumForceFieldUpgrade.length);
    public final Collection<IInventory> inventories = new ArrayList<IInventory>(12);
    public float scanSpeed;
    public float placeSpeed;
    public double startupEnergyCost;
    public double scanEnergyCost;
    public double placeEnergyCost;
    private double entityEnergyCost;
    public float breaking_maxHardness;
    public float temperatureLevel;
    public float accelerationLevel;
    public boolean hasCollection;
    public boolean hasFusion;
    public boolean isInverted;
    public boolean hasStabilize;
    public float thickness;
    public float pumping_maxViscosity;
    public float rotationYaw;
    public float rotationPitch;
    public float rotationRoll;
    public VectorI vTranslation = new VectorI(0, 0, 0);
    public final VectorI vMin = new VectorI(-8, -8, -8);
    public final VectorI vMax = new VectorI(8, 8, 8);
    public IForceFieldShape shapeProvider;
    public boolean isDoubleSided = true;

    public ForceFieldSetup(int dimensionId, int x, int y, int z, byte tier, int beamFrequency) {
        super(dimensionId, x, y, z);
        this.tier = tier;
        this.beamFrequency = beamFrequency;
        this.refresh();
        if (WarpDriveConfig.LOGGING_FORCEFIELD) {
            WarpDrive.logger.info(String.format("Force field projector energy costs: startup %.3f / %d scan %.3f place %.3f entity %.3f speeds: scan %.3f place %.3f sustain cost: scan %.3f place %.3f", this.startupEnergyCost, Math.round(this.startupEnergyCost + this.placeEnergyCost * (double)this.placeSpeed * 8.0 / 20.0), this.scanEnergyCost, this.placeEnergyCost, this.entityEnergyCost, Float.valueOf(this.scanSpeed), Float.valueOf(this.placeSpeed), this.scanEnergyCost * (double)this.scanSpeed, this.placeEnergyCost * (double)this.placeSpeed));
        }
    }

    public boolean isAccessGranted(EntityPlayer entityPlayer, EnumPermissionNode enumPermissionNode) {
        return false;
    }

    private static boolean isValidCamouflage(Block block) {
        return block != null && block != Blocks.field_150350_a && ALLOWED_RENDER_TYPES.contains(block.func_149645_b()) && !Dictionary.BLOCKS_NOCAMOUFLAGE.contains(block);
    }

    public Block getCamouflageBlock() {
        if (ForceFieldSetup.isValidCamouflage(this.blockCamouflage)) {
            return this.blockCamouflage;
        }
        return null;
    }

    public int getCamouflageMetadata() {
        if (ForceFieldSetup.isValidCamouflage(this.blockCamouflage)) {
            return this.metadataCamouflage;
        }
        return 0;
    }

    public int getCamouflageColorMultiplier() {
        if (ForceFieldSetup.isValidCamouflage(this.blockCamouflage)) {
            return this.colorMultiplierCamouflage;
        }
        return 0;
    }

    public int getCamouflageLight() {
        if (ForceFieldSetup.isValidCamouflage(this.blockCamouflage)) {
            return this.lightCamouflage;
        }
        return 0;
    }

    private float getScaledUpgrade(IForceFieldUpgradeEffector effector) {
        Float scaledValue = this.upgrades.get(effector);
        return scaledValue == null ? 0.0f : scaledValue.floatValue();
    }

    private void refresh() {
        Set<TileEntity> tileEntities = ForceFieldRegistry.getTileEntities(this.beamFrequency, this.getWorldServerIfLoaded(), this.x, this.y, this.z);
        HashMap<IForceFieldUpgradeEffector, Float> upgradeValues = new HashMap<IForceFieldUpgradeEffector, Float>(EnumForceFieldUpgrade.length);
        Vector3 v3Min = new Vector3(-1.0, -1.0, -1.0);
        Vector3 v3Max = new Vector3(1.0, 1.0, 1.0);
        Vector3 v3Translation = new Vector3(0.0, 0.0, 0.0);
        for (TileEntity tileEntity : tileEntities) {
            Block blockCandidate;
            IForceFieldUpgradeEffector iForceFieldUpgradeEffector;
            if (tileEntity.func_145831_w() == null || tileEntity.func_145831_w().field_73011_w.field_76574_g != this.dimensionId) continue;
            if (tileEntity instanceof TileEntityForceFieldProjector) {
                TileEntityForceFieldProjector tileEntityForceFieldProjector = (TileEntityForceFieldProjector)tileEntity;
                if (tileEntity.field_145851_c == this.x && tileEntity.field_145848_d == this.y && tileEntity.field_145849_e == this.z) {
                    this.shapeProvider = tileEntityForceFieldProjector.getShapeProvider();
                    this.isDoubleSided = tileEntityForceFieldProjector.isDoubleSided;
                    this.vTranslation = new VectorI(tileEntityForceFieldProjector);
                    this.rotationYaw = tileEntityForceFieldProjector.getRotationYaw();
                    this.rotationPitch = tileEntityForceFieldProjector.getRotationPitch();
                    this.rotationRoll = tileEntityForceFieldProjector.getRotationRoll();
                    v3Min = tileEntityForceFieldProjector.getMin();
                    v3Max = tileEntityForceFieldProjector.getMax();
                    v3Translation = tileEntityForceFieldProjector.getTranslation();
                    for (Map.Entry<Object, Integer> entry : tileEntityForceFieldProjector.getUpgradesOfType(null).entrySet()) {
                        IForceFieldUpgradeEffector upgradeEffector2;
                        if (!(entry.getKey() instanceof IForceFieldUpgrade) || (upgradeEffector2 = ((IForceFieldUpgrade)entry.getKey()).getUpgradeEffector()) == null) continue;
                        Float currentValue = (Float)upgradeValues.get(upgradeEffector2);
                        if (currentValue == null) {
                            currentValue = Float.valueOf(0.0f);
                        }
                        float addedValue = ((IForceFieldUpgrade)entry.getKey()).getUpgradeValue() * (float)entry.getValue().intValue();
                        upgradeValues.put(upgradeEffector2, Float.valueOf(currentValue.floatValue() + (addedValue *= 1.0f + (float)(this.tier - 1) * 0.5f)));
                    }
                } else if (((TileEntityForceFieldProjector)tileEntity).isEnabled && ((TileEntityForceFieldProjector)tileEntity).isCalculated() && ((TileEntityForceFieldProjector)tileEntity).isValid()) {
                    this.projectors.add((TileEntityForceFieldProjector)tileEntity);
                }
            }
            if (!(tileEntity instanceof IForceFieldUpgrade) || (iForceFieldUpgradeEffector = ((IForceFieldUpgrade)tileEntity).getUpgradeEffector()) == null) continue;
            Float currentValue = (Float)upgradeValues.get(iForceFieldUpgradeEffector);
            if (currentValue == null) {
                currentValue = Float.valueOf(0.0f);
            }
            upgradeValues.put(iForceFieldUpgradeEffector, Float.valueOf(currentValue.floatValue() + ((IForceFieldUpgrade)tileEntity).getUpgradeValue()));
            if (iForceFieldUpgradeEffector == EnumForceFieldUpgrade.CAMOUFLAGE && ForceFieldSetup.isValidCamouflage(blockCandidate = tileEntity.func_145831_w().func_147439_a(tileEntity.field_145851_c, tileEntity.field_145848_d + 1, tileEntity.field_145849_e))) {
                this.blockCamouflage = blockCandidate;
                this.metadataCamouflage = tileEntity.func_145831_w().func_72805_g(tileEntity.field_145851_c, tileEntity.field_145848_d + 1, tileEntity.field_145849_e);
                this.colorMultiplierCamouflage = 0x808080;
                this.lightCamouflage = blockCandidate.getLightValue((IBlockAccess)tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d + 1, tileEntity.field_145849_e);
            }
            if (iForceFieldUpgradeEffector != EnumForceFieldUpgrade.ITEM_PORT) continue;
            this.inventories.addAll(TileEntityAbstractBase.getConnectedInventories(tileEntity));
        }
        this.scanSpeed = 100.0f * (this.isDoubleSided ? 2.1f : 1.0f);
        this.placeSpeed = 20.0f * (this.isDoubleSided ? 2.1f : 1.0f);
        this.startupEnergyCost = 60.0f + 20.0f * (float)this.tier;
        this.scanEnergyCost = 0.4f + 0.4f * (float)this.tier;
        this.placeEnergyCost = 3.0f + 3.0f * (float)this.tier;
        this.entityEnergyCost = 2.0;
        if (this.isDoubleSided) {
            this.scanSpeed *= 2.1f;
            this.placeSpeed *= 2.1f;
            this.startupEnergyCost += (double)(20.0f * (float)this.tier);
            this.scanEnergyCost *= (double)0.45f;
            this.placeEnergyCost *= (double)0.45f;
            this.entityEnergyCost *= (double)0.45f;
        }
        for (Map.Entry entry : upgradeValues.entrySet()) {
            float scaledValue = ((IForceFieldUpgradeEffector)entry.getKey()).getScaledValue(1.0f, ((Float)entry.getValue()).floatValue());
            if (scaledValue == 0.0f) continue;
            this.upgrades.put((IForceFieldUpgradeEffector)entry.getKey(), Float.valueOf(scaledValue));
            float speedRatio = ((IForceFieldUpgradeEffector)entry.getKey()).getScanSpeedFactor(scaledValue);
            if (speedRatio > 0.0f) {
                this.scanSpeed *= speedRatio;
            }
            if ((speedRatio = ((IForceFieldUpgradeEffector)entry.getKey()).getPlaceSpeedFactor(scaledValue)) > 0.0f) {
                this.placeSpeed *= speedRatio;
            }
            this.startupEnergyCost += (double)((IForceFieldUpgradeEffector)entry.getKey()).getStartupEnergyCost(scaledValue);
            this.scanEnergyCost += (double)((IForceFieldUpgradeEffector)entry.getKey()).getScanEnergyCost(scaledValue);
            this.placeEnergyCost += (double)((IForceFieldUpgradeEffector)entry.getKey()).getPlaceEnergyCost(scaledValue);
            this.entityEnergyCost += (double)((IForceFieldUpgradeEffector)entry.getKey()).getEntityEffectEnergyCost(scaledValue);
        }
        this.scanSpeed = Math.min(10000.0f, this.scanSpeed);
        this.placeSpeed = Math.min(4000.0f, this.placeSpeed);
        double d = this.getScaledUpgrade(EnumForceFieldUpgrade.RANGE);
        if (d == 0.0) {
            d = 8.0;
            v3Min = new Vector3(-1.0, -1.0, -1.0);
            v3Max = new Vector3(1.0, 1.0, 1.0);
        }
        this.vMin.x = (int)Math.round(Math.min(0.0, Math.max(-1.0, v3Min.x)) * d);
        this.vMin.y = (int)Math.round(Math.min(0.0, Math.max(-1.0, v3Min.y)) * d);
        this.vMin.z = (int)Math.round(Math.min(0.0, Math.max(-1.0, v3Min.z)) * d);
        this.vMax.x = (int)Math.round(Math.min(1.0, Math.max(0.0, v3Max.x)) * d);
        this.vMax.y = (int)Math.round(Math.min(1.0, Math.max(0.0, v3Max.y)) * d);
        this.vMax.z = (int)Math.round(Math.min(1.0, Math.max(0.0, v3Max.z)) * d);
        this.vTranslation.x += (int)Math.round(Math.min(1.0, Math.max(-1.0, v3Translation.x)) * d);
        this.vTranslation.y += (int)Math.round(Math.min(1.0, Math.max(-1.0, v3Translation.y)) * d);
        this.vTranslation.z += (int)Math.round(Math.min(1.0, Math.max(-1.0, v3Translation.z)) * d);
        this.accelerationLevel = this.getScaledUpgrade(EnumForceFieldUpgrade.ATTRACTION) - this.getScaledUpgrade(EnumForceFieldUpgrade.REPULSION);
        this.hasCollection = this.getScaledUpgrade(EnumForceFieldUpgrade.ITEM_PORT) > 0.0f && this.accelerationLevel > 1.0f;
        this.hasFusion = this.getScaledUpgrade(EnumForceFieldUpgrade.FUSION) > 0.0f;
        this.isInverted = this.getScaledUpgrade(EnumForceFieldUpgrade.INVERSION) > 0.0f;
        this.hasStabilize = this.getScaledUpgrade(EnumForceFieldUpgrade.STABILIZATION) > 0.0f && this.accelerationLevel < 1.0f;
        this.temperatureLevel = Math.max(0.1f, 300.0f + this.getScaledUpgrade(EnumForceFieldUpgrade.HEATING) - this.getScaledUpgrade(EnumForceFieldUpgrade.COOLING));
        this.breaking_maxHardness = this.getScaledUpgrade(EnumForceFieldUpgrade.BREAKING);
        this.pumping_maxViscosity = this.getScaledUpgrade(EnumForceFieldUpgrade.PUMPING);
        this.thickness = 1.0f + this.getScaledUpgrade(EnumForceFieldUpgrade.THICKNESS);
    }

    public double getEntityEnergyCost(int countEntityInteractions) {
        return this.entityEnergyCost * 5.0 * Math.exp(FORCEFIELD_TAU_FACTOR_ENTITY_COST / (double)countEntityInteractions);
    }

    public int onEntityEffect(World world, int blockX, int blockY, int blockZ, Entity entity) {
        int countdown = 0;
        TileEntity tileEntity = world.func_147438_o(this.x, this.y, this.z);
        if (tileEntity instanceof TileEntityForceFieldProjector && ((TileEntityForceFieldProjector)tileEntity).onEntityInteracted(entity.func_110124_au())) {
            for (Map.Entry<IForceFieldUpgradeEffector, Float> entry : this.upgrades.entrySet()) {
                Float value = entry.getValue();
                if (entry.getKey() == EnumForceFieldUpgrade.COOLING || entry.getKey() == EnumForceFieldUpgrade.HEATING) {
                    value = Float.valueOf(this.temperatureLevel);
                } else if (entry.getKey() == EnumForceFieldUpgrade.ATTRACTION || entry.getKey() == EnumForceFieldUpgrade.REPULSION) {
                    value = Float.valueOf(this.accelerationLevel);
                }
                countdown += entry.getKey().onEntityEffect(value.floatValue(), world, this.x, this.y, this.z, blockX, blockY, blockZ, entity);
            }
        }
        return countdown;
    }

    public double applyDamage(World world, DamageSource damageSource, double damageLevel) {
        assert (damageSource != null);
        TileEntity tileEntity = world.func_147438_o(this.x, this.y, this.z);
        if (tileEntity instanceof TileEntityForceFieldProjector) {
            double scaledDamage = damageLevel * this.entityEnergyCost / 2000.0;
            ((TileEntityForceFieldProjector)tileEntity).onEnergyDamage(scaledDamage);
            return 0.0;
        }
        return damageLevel;
    }

    public String toString() {
        return String.format("%s @ DIM%d (%d %d %d) (%d %d %d) -> (%d %d %d)", this.getClass().getSimpleName(), this.dimensionId, this.x, this.y, this.z, this.vMin.x, this.vMin.y, this.vMin.z, this.vMax.x, this.vMax.y, this.vMax.z);
    }
}

