/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.filler.FillerManager;
import cr0s.warpdrive.config.filler.FillerSet;
import cr0s.warpdrive.config.structures.AbstractInstance;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.OrbInstance;
import java.util.Random;
import net.minecraft.world.World;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Orb
extends AbstractStructure {
    protected OrbShell[] orbShells;
    protected boolean hasStarCore = false;
    protected String schematicName;

    public Orb(String group, String name) {
        super(group, name);
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        super.loadFromXmlElement(element);
        NodeList nodeListShells = element.getElementsByTagName("shell");
        this.orbShells = new OrbShell[nodeListShells.getLength()];
        int shellIndexOut = 0;
        for (int shellIndexIn = 0; shellIndexIn < nodeListShells.getLength(); ++shellIndexIn) {
            Element elementShell = (Element)nodeListShells.item(shellIndexIn);
            String orbShellName = elementShell.getAttribute("name");
            this.orbShells[shellIndexOut] = new OrbShell(this.getFullName(), orbShellName);
            try {
                this.orbShells[shellIndexOut].loadFromXmlElement(elementShell);
                ++shellIndexOut;
                continue;
            }
            catch (InvalidXmlException exception) {
                exception.printStackTrace();
                WarpDrive.logger.error("Skipping invalid shell " + orbShellName);
            }
        }
        NodeList nodeListSchematic = element.getElementsByTagName("schematic");
        if (nodeListSchematic.getLength() > 1) {
            WarpDrive.logger.error("Too many schematic defined, only first one will be used in structure " + this.getFullName());
        }
        if (nodeListSchematic.getLength() > 0) {
            this.schematicName = ((Element)nodeListSchematic.item(0)).getAttribute("group");
        }
        return true;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        return this.instantiate(random).func_76484_a(world, random, x, y, z);
    }

    @Override
    public AbstractInstance instantiate(Random random) {
        return new OrbInstance(this, random);
    }

    public class OrbShell
    extends FillerSet {
        private final String parentFullName;
        protected int minThickness;
        protected int maxThickness;

        public OrbShell(String parentFullName, String name) {
            super(null, name);
            this.parentFullName = parentFullName;
        }

        @Override
        public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
            if (WarpDriveConfig.LOGGING_WORLDGEN) {
                WarpDrive.logger.info("  + found shell " + element.getAttribute("name"));
            }
            super.loadFromXmlElement(element);
            for (String importGroupName : this.getImportGroupNames()) {
                FillerSet fillerSet = FillerManager.getFillerSet(importGroupName);
                if (fillerSet == null) {
                    WarpDrive.logger.warn("Skipping missing FillerSet " + importGroupName + " in shell " + this.parentFullName + ":" + this.name);
                    continue;
                }
                this.loadFrom(fillerSet);
            }
            for (String importGroup : this.getImportGroups()) {
                if (FillerManager.doesGroupExist(importGroup)) continue;
                WarpDrive.logger.warn("An invalid FillerSet group " + importGroup + " is referenced in shell " + this.parentFullName + ":" + this.name);
            }
            try {
                this.minThickness = Integer.parseInt(element.getAttribute("minThickness"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Invalid minThickness in shell " + this.name + " of structure " + this.parentFullName);
            }
            try {
                this.maxThickness = Integer.parseInt(element.getAttribute("maxThickness"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Invalid maxThickness in shell " + this.name + " of structure " + this.parentFullName);
            }
            if (this.maxThickness < this.minThickness) {
                throw new InvalidXmlException("Invalid maxThickness " + this.maxThickness + " lower than minThickness " + this.minThickness + " in shell " + this.name + " of orb " + this.parentFullName);
            }
            return true;
        }

        public OrbShell instantiate(Random random) {
            OrbShell orbShell = new OrbShell(this.parentFullName, this.name);
            orbShell.minThickness = this.minThickness;
            orbShell.maxThickness = this.maxThickness;
            try {
                orbShell.loadFrom(this);
                for (String importGroup : this.getImportGroups()) {
                    FillerSet fillerSet = FillerManager.getRandomFillerSetFromGroup(random, importGroup);
                    if (fillerSet == null) {
                        WarpDrive.logger.info("Ignoring invalid group " + importGroup + " in shell " + this.name + " of structure " + this.parentFullName);
                        continue;
                    }
                    if (WarpDriveConfig.LOGGING_WORLDGEN) {
                        WarpDrive.logger.info("Filling " + this.parentFullName + ":" + this.name + " with " + importGroup + ":" + fillerSet.getName());
                    }
                    orbShell.loadFrom(fillerSet);
                }
            }
            catch (InvalidXmlException exception) {
                exception.printStackTrace();
                WarpDrive.logger.error("Failed to instantiate shell " + this.name + " from structure " + this.parentFullName);
            }
            if (orbShell.isEmpty()) {
                if (WarpDriveConfig.LOGGING_WORLDGEN) {
                    WarpDrive.logger.info("Ignoring empty shell " + this.name + " in structure " + this.parentFullName + "");
                }
                return null;
            }
            return orbShell;
        }
    }
}

