/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.config.IXmlRepresentable;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.structures.AbstractInstance;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractStructure
extends WorldGenerator
implements IXmlRepresentable {
    protected String group;
    protected String name;
    protected HashMap<String, String> variables = new HashMap();

    public AbstractStructure(String group, String name) {
        this.group = group;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.group + ":" + this.name;
    }

    public abstract AbstractInstance instantiate(Random var1);

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        NodeList nodeListVariables = element.getElementsByTagName("variable");
        for (int variableIndex = 0; variableIndex < nodeListVariables.getLength(); ++variableIndex) {
            Element elementVariable = (Element)nodeListVariables.item(variableIndex);
            String variableName = elementVariable.getAttribute("name");
            String variableExpression = elementVariable.getTextContent();
            this.variables.put(variableName, variableExpression);
        }
        return true;
    }

    @Override
    @Deprecated
    public void saveToXmlElement(Element element, Document document) throws InvalidXmlException {
        throw new InvalidXmlException("Not implemented");
    }
}

