/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.compat.CompatAdvancedRepulsionSystems;
import cr0s.warpdrive.compat.CompatAppliedEnergistics2;
import cr0s.warpdrive.compat.CompatArsMagica2;
import cr0s.warpdrive.compat.CompatBiblioCraft;
import cr0s.warpdrive.compat.CompatBotania;
import cr0s.warpdrive.compat.CompatCarpentersBlocks;
import cr0s.warpdrive.compat.CompatComputerCraft;
import cr0s.warpdrive.compat.CompatEnderIO;
import cr0s.warpdrive.compat.CompatEvilCraft;
import cr0s.warpdrive.compat.CompatForgeMultipart;
import cr0s.warpdrive.compat.CompatImmersiveEngineering;
import cr0s.warpdrive.compat.CompatIndustrialCraft2;
import cr0s.warpdrive.compat.CompatJABBA;
import cr0s.warpdrive.compat.CompatMekanism;
import cr0s.warpdrive.compat.CompatMetallurgy;
import cr0s.warpdrive.compat.CompatNatura;
import cr0s.warpdrive.compat.CompatOpenComputers;
import cr0s.warpdrive.compat.CompatRedstonePaste;
import cr0s.warpdrive.compat.CompatSGCraft;
import cr0s.warpdrive.compat.CompatStargateTech2;
import cr0s.warpdrive.compat.CompatTConstruct;
import cr0s.warpdrive.compat.CompatThaumcraft;
import cr0s.warpdrive.compat.CompatThermalDynamics;
import cr0s.warpdrive.compat.CompatThermalExpansion;
import cr0s.warpdrive.compat.CompatWarpDrive;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.RandomCollection;
import cr0s.warpdrive.config.filler.FillerManager;
import cr0s.warpdrive.config.structures.StructureManager;
import cr0s.warpdrive.config.structures.StructureReference;
import cr0s.warpdrive.data.Planet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WarpDriveConfig {
    private static final boolean unused = false;
    private static File configDirectory;
    private static DocumentBuilder xmlDocumentBuilder;
    private static final String[] defaultXMLfilenames;
    public static boolean isForgeMultipartLoaded;
    public static boolean isAdvancedSolarPanelLoaded;
    public static boolean isAppliedEnergistics2Loaded;
    public static boolean isICBMLoaded;
    public static boolean isIndustrialCraft2Loaded;
    public static boolean isComputerCraftLoaded;
    public static boolean isOpenComputersLoaded;
    public static boolean isCoFHCoreLoaded;
    public static boolean isThermalExpansionLoaded;
    public static boolean isArsMagica2Loaded;
    public static boolean isImmersiveEngineeringLoaded;
    public static boolean isGregTech5Loaded;
    public static boolean isEnderIOLoaded;
    public static boolean isAdvancedRepulsionSystemLoaded;
    public static ItemStack IC2_compressedAir;
    public static ItemStack IC2_emptyCell;
    public static Block IC2_rubberWood;
    public static ItemStack IC2_Resin;
    public static Block CC_Computer;
    public static Block CC_peripheral;
    public static Block CCT_Turtle;
    public static Block CCT_Expanded;
    public static Block CCT_Advanced;
    public static int G_SPACE_BIOME_ID;
    public static int G_SPACE_PROVIDER_ID;
    public static int G_SPACE_DIMENSION_ID;
    public static int G_HYPERSPACE_PROVIDER_ID;
    public static int G_HYPERSPACE_DIMENSION_ID;
    public static int G_SPACE_WORLDBORDER_BLOCKS;
    public static int G_ENTITY_SPHERE_GENERATOR_ID;
    public static int G_ENTITY_STAR_CORE_ID;
    public static int G_ENTITY_CAMERA_ID;
    public static final int LUA_SCRIPTS_NONE = 0;
    public static final int LUA_SCRIPTS_TEMPLATES = 1;
    public static final int LUA_SCRIPTS_ALL = 2;
    public static int G_LUA_SCRIPTS;
    public static String G_SCHEMALOCATION;
    public static int G_BLOCKS_PER_TICK;
    public static boolean RECIPES_ENABLE_DYNAMIC;
    public static boolean RECIPES_ENABLE_IC2;
    public static boolean RECIPES_ENABLE_HARD_IC2;
    public static boolean RECIPES_ENABLE_VANILLA;
    public static boolean LOGGING_JUMP;
    public static boolean LOGGING_JUMPBLOCKS;
    public static boolean LOGGING_ENERGY;
    public static boolean LOGGING_EFFECTS;
    public static boolean LOGGING_CLOAKING;
    public static boolean LOGGING_VIDEO_CHANNEL;
    public static boolean LOGGING_TARGETING;
    public static boolean LOGGING_WEAPON;
    public static boolean LOGGING_CAMERA;
    public static boolean LOGGING_BUILDING;
    public static boolean LOGGING_COLLECTION;
    public static boolean LOGGING_TRANSPORTER;
    public static boolean LOGGING_LUA;
    public static boolean LOGGING_RADAR;
    public static boolean LOGGING_BREATHING;
    public static boolean LOGGING_WORLDGEN;
    public static boolean LOGGING_PROFILING;
    public static boolean LOGGING_DICTIONARY;
    public static boolean LOGGING_STARMAP;
    public static boolean LOGGING_BREAK_PLACE;
    public static boolean LOGGING_FORCEFIELD;
    public static boolean LOGGING_FORCEFIELD_REGISTRY;
    public static Planet[] PLANETS;
    public static int SPACE_GENERATOR_Y_MIN_CENTER;
    public static int SPACE_GENERATOR_Y_MAX_CENTER;
    public static int SPACE_GENERATOR_Y_MIN_BORDER;
    public static int SPACE_GENERATOR_Y_MAX_BORDER;
    public static RandomCollection<StructureReference> SPACE_GENERATOR_STRUCTURES_CHANCES;
    public static int SHIP_MAX_ENERGY_STORED;
    public static int SHIP_NORMALJUMP_ENERGY_PER_BLOCK;
    public static int SHIP_NORMALJUMP_ENERGY_PER_DISTANCE;
    public static int SHIP_HYPERJUMP_ENERGY_PER_BLOCK;
    public static int SHIP_HYPERJUMP_ENERGY_PER_DISTANCE;
    public static int SHIP_TELEPORT_ENERGY_PER_ENTITY;
    public static int SHIP_MAX_JUMP_DISTANCE;
    public static int SHIP_VOLUME_MAX_ON_PLANET_SURFACE;
    public static int SHIP_VOLUME_MIN_FOR_HYPERSPACE;
    public static int SHIP_MAX_SIDE_SIZE;
    public static int SHIP_COOLDOWN_INTERVAL_SECONDS;
    public static int SHIP_COLLISION_TOLERANCE_BLOCKS;
    public static int SHIP_SHORTJUMP_THRESHOLD_BLOCKS;
    public static int SHIP_SHORTJUMP_WARMUP_SECONDS;
    public static int SHIP_LONGJUMP_WARMUP_SECONDS;
    public static int SHIP_WARMUP_RANDOM_TICKS;
    public static int SHIP_CORE_REGISTRY_UPDATE_INTERVAL_SECONDS;
    public static int SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS;
    public static int SHIP_CORE_ISOLATION_UPDATE_INTERVAL_SECONDS;
    public static String[] SHIP_VOLUME_UNLIMITED_PLAYERNAMES;
    public static boolean SHIP_WARMUP_SICKNESS;
    public static int SHIP_SUMMON_MAX_RANGE;
    public static boolean SHIP_SUMMON_ACROSS_DIMENSIONS;
    public static int RADAR_MAX_ENERGY_STORED;
    public static int RADAR_SCAN_MIN_ENERGY_COST;
    public static double[] RADAR_SCAN_ENERGY_COST_FACTORS;
    public static int RADAR_SCAN_MIN_DELAY_SECONDS;
    public static double[] RADAR_SCAN_DELAY_FACTORS_SECONDS;
    public static int RADAR_MAX_ISOLATION_RANGE;
    public static int RADAR_MIN_ISOLATION_BLOCKS;
    public static int RADAR_MAX_ISOLATION_BLOCKS;
    public static double RADAR_MIN_ISOLATION_EFFECT;
    public static double RADAR_MAX_ISOLATION_EFFECT;
    public static int SS_MAX_ENERGY_STORED;
    public static int SS_ENERGY_PER_BLOCK_SCAN;
    public static int SS_ENERGY_PER_BLOCK_DEPLOY;
    public static int SS_MAX_DEPLOY_RADIUS_BLOCKS;
    public static int SS_SEARCH_INTERVAL_TICKS;
    public static int SS_SCAN_BLOCKS_PER_SECOND;
    public static int SS_DEPLOY_BLOCKS_PER_INTERVAL;
    public static int SS_DEPLOY_INTERVAL_TICKS;
    public static int LASER_MEDIUM_MAX_ENERGY_STORED;
    public static int LASER_CANNON_MAX_MEDIUMS_COUNT;
    public static int LASER_CANNON_MAX_LASER_ENERGY;
    public static int LASER_CANNON_EMIT_FIRE_DELAY_TICKS;
    public static int LASER_CANNON_EMIT_SCAN_DELAY_TICKS;
    public static double LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY;
    public static double LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK;
    public static double LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK;
    public static double LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK;
    public static int LASER_CANNON_RANGE_MAX;
    public static int LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS;
    public static int LASER_CANNON_ENTITY_HIT_ENERGY;
    public static int LASER_CANNON_ENTITY_HIT_BASE_DAMAGE;
    public static int LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE;
    public static int LASER_CANNON_ENTITY_HIT_MAX_DAMAGE;
    public static int LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD;
    public static float LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH;
    public static int LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH;
    public static float LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH;
    public static int LASER_CANNON_BLOCK_HIT_ENERGY_MIN;
    public static int LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS;
    public static int LASER_CANNON_BLOCK_HIT_ENERGY_MAX;
    public static double LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS;
    public static double LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX;
    public static float LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD;
    public static float LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH;
    public static int LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH;
    public static float LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH;
    public static int MINING_LASER_MAX_MEDIUMS_COUNT;
    public static int MINING_LASER_RADIUS_BLOCKS;
    public static int MINING_LASER_WARMUP_DELAY_TICKS;
    public static int MINING_LASER_SCAN_DELAY_TICKS;
    public static int MINING_LASER_MINE_DELAY_TICKS;
    public static int MINING_LASER_SPACE_ENERGY_PER_LAYER;
    public static int MINING_LASER_PLANET_ENERGY_PER_LAYER;
    public static int MINING_LASER_SPACE_ENERGY_PER_BLOCK;
    public static int MINING_LASER_PLANET_ENERGY_PER_BLOCK;
    public static double MINING_LASER_ORESONLY_ENERGY_FACTOR;
    public static double MINING_LASER_SILKTOUCH_ENERGY_FACTOR;
    public static double MINING_LASER_SILKTOUCH_DEUTERIUM_L;
    public static double MINING_LASER_FORTUNE_ENERGY_FACTOR;
    public static int TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM;
    public static int TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM;
    public static int TREE_FARM_totalMaxRadius;
    public static int TREE_FARM_MAX_MEDIUMS_COUNT;
    public static int TREE_FARM_MAX_LOG_DISTANCE;
    public static int TREE_FARM_MAX_LOG_DISTANCE_PER_MEDIUM;
    public static int CLOAKING_MAX_ENERGY_STORED;
    public static int CLOAKING_COIL_CAPTURE_BLOCKS;
    public static int CLOAKING_MAX_FIELD_RADIUS;
    public static int CLOAKING_TIER1_ENERGY_PER_BLOCK;
    public static int CLOAKING_TIER2_ENERGY_PER_BLOCK;
    public static int CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS;
    public static int AIRGEN_ENERGY_PER_CANISTER;
    public static int AIRGEN_ENERGY_PER_NEWAIRBLOCK;
    public static int AIRGEN_ENERGY_PER_EXISTINGAIRBLOCK;
    public static int AIRGEN_MAX_ENERGY_STORED;
    public static int AIRGEN_AIR_GENERATION_TICKS;
    public static int IC2_REACTOR_MAX_ENERGY_STORED;
    public static double IC2_REACTOR_ENERGY_PER_HEAT;
    public static int IC2_REACTOR_COOLING_INTERVAL_TICKS;
    public static int TRANSPORTER_MAX_ENERGY_STORED;
    public static boolean TRANSPORTER_USE_RELATIVE_COORDS;
    public static double TRANSPORTER_ENERGY_PER_BLOCK;
    public static double TRANSPORTER_MAX_BOOST_MUL;
    public static int ENAN_REACTOR_MAX_ENERGY_STORED;
    public static int ENAN_REACTOR_UPDATE_INTERVAL_TICKS;
    public static int ENAN_REACTOR_MAX_LASERS_PER_SECOND;
    public static int[] ENERGY_BANK_MAX_ENERGY_STORED;
    public static int[] ENERGY_BANK_IC2_TIER;
    public static int[] ENERGY_BANK_TRANSFER_PER_TICK;
    public static double[] ENERGY_BANK_EFFICIENCY_PER_UPGRADE;
    public static int LIFT_MAX_ENERGY_STORED;
    public static int LIFT_ENERGY_PER_ENTITY;
    public static int LIFT_UPDATE_INTERVAL_TICKS;
    public static int CL_MAX_ENERGY;
    public static int CL_MAX_DISTANCE;
    public static int CL_RF_PER_CHUNKTICK;
    public static float[] HULL_HARDNESS;
    public static float[] HULL_BLAST_RESISTANCE;
    public static HashMap<String, IBlockTransformer> blockTransformers;

    public static Block getModBlock(String mod, String id) {
        try {
            return GameRegistry.findBlock((String)mod, (String)id);
        }
        catch (Exception exception) {
            WarpDrive.logger.info("Failed to get mod block for " + mod + ":" + id);
            exception.printStackTrace();
            return null;
        }
    }

    public static ItemStack getModItemStack(String mod, String id, int meta) {
        try {
            ItemStack item = new ItemStack((Item)Item.field_150901_e.func_82594_a(mod + ":" + id));
            if (meta != -1) {
                item.func_77964_b(meta);
            }
            return item;
        }
        catch (Exception exception) {
            WarpDrive.logger.info("Failed to get mod item for " + mod + ":" + id + "@" + meta);
            return null;
        }
    }

    public static void onFMLpreInitialization(String stringConfigDirectory) {
        configDirectory = new File(stringConfigDirectory, "WarpDrive");
        configDirectory.mkdir();
        if (!configDirectory.isDirectory()) {
            throw new RuntimeException("Unable to create config directory " + configDirectory);
        }
        WarpDriveConfig.loadWarpDriveConfig(new File(configDirectory, "WarpDrive.cfg"));
    }

    public static void loadWarpDriveConfig(File file) {
        Configuration config = new Configuration(file);
        config.load();
        G_SPACE_BIOME_ID = WarpDriveConfig.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "space_biome_id", G_SPACE_BIOME_ID, "Space biome ID").getInt());
        G_SPACE_PROVIDER_ID = WarpDriveConfig.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "space_provider_id", G_SPACE_PROVIDER_ID, "Space dimension provider ID").getInt());
        G_SPACE_DIMENSION_ID = WarpDriveConfig.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "space_dimension_id", G_SPACE_DIMENSION_ID, "Space dimension world ID").getInt());
        G_HYPERSPACE_PROVIDER_ID = WarpDriveConfig.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "hyperspace_provider_id", G_HYPERSPACE_PROVIDER_ID, "Hyperspace dimension provider ID").getInt());
        G_HYPERSPACE_DIMENSION_ID = WarpDriveConfig.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "hyperspace_dimension_id", G_HYPERSPACE_DIMENSION_ID, "Hyperspace dimension world ID").getInt());
        G_SPACE_WORLDBORDER_BLOCKS = WarpDriveConfig.clamp(0, 3000000, config.get("general", "space_worldborder_blocks", G_SPACE_WORLDBORDER_BLOCKS, "World border applied to hyperspace & space, set to 0 to disable it").getInt());
        G_ENTITY_SPHERE_GENERATOR_ID = WarpDriveConfig.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_sphere_generator_id", G_ENTITY_SPHERE_GENERATOR_ID, "Entity sphere generator ID").getInt());
        G_ENTITY_STAR_CORE_ID = WarpDriveConfig.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_star_core_id", G_ENTITY_STAR_CORE_ID, "Entity star core ID").getInt());
        G_ENTITY_CAMERA_ID = WarpDriveConfig.clamp(Integer.MIN_VALUE, Integer.MAX_VALUE, config.get("general", "entity_camera_id", G_ENTITY_CAMERA_ID, "Entity camera ID").getInt());
        G_LUA_SCRIPTS = WarpDriveConfig.clamp(0, 2, config.get("general", "lua_scripts", G_LUA_SCRIPTS, "LUA scripts to load when connecting machines: 0 = none, 1 = templates in a subfolder, 2 = ready to roll (templates are still provided)").getInt());
        G_SCHEMALOCATION = config.get("general", "schematic_location", G_SCHEMALOCATION, "Folder where to save ship schematics").getString();
        G_BLOCKS_PER_TICK = WarpDriveConfig.clamp(100, 100000, config.get("general", "blocks_per_tick", G_BLOCKS_PER_TICK, "Number of blocks to move per ticks, too high will cause lag spikes on ship jumping or deployment, too low may break the ship wirings").getInt());
        RECIPES_ENABLE_DYNAMIC = config.get("recipes", "enable_dynamic", RECIPES_ENABLE_DYNAMIC, "Mixed recipes dynamically integrating with other mods (Advanced Repulsion Systems, Advanced Solar Panels, IC2, GregTech 5, EnderIO, ThermalExpansion, Immersive Engineering)").getBoolean(true);
        RECIPES_ENABLE_VANILLA = config.get("recipes", "enable_vanilla", RECIPES_ENABLE_VANILLA, "Vanilla recipes by DarkholmeTenk (you need to disable Dynamic recipes to use those, no longer updated)").getBoolean(false);
        RECIPES_ENABLE_IC2 = config.get("recipes", "enable_ic2", RECIPES_ENABLE_IC2, "Original recipes based on IndustrialCraft2 by Cr0s (you need to disable Dynamic recipes to use those, no longer updated)").getBoolean(false);
        RECIPES_ENABLE_HARD_IC2 = config.get("recipes", "enable_hard_ic2", RECIPES_ENABLE_HARD_IC2, "Harder recipes based on IC2 by YuRaNnNzZZ (you need to disable Dynamic recipes to use those)").getBoolean(false);
        LOGGING_JUMP = config.get("logging", "enable_jump_logs", LOGGING_JUMP, "Basic jump logs, should always be enabled").getBoolean(true);
        LOGGING_JUMPBLOCKS = config.get("logging", "enable_jumpblocks_logs", LOGGING_JUMPBLOCKS, "Detailed jump logs to help debug the mod, will spam your logs...").getBoolean(false);
        LOGGING_ENERGY = config.get("logging", "enable_energy_logs", LOGGING_ENERGY, "Detailed energy logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        if (WarpDrive.isDev) {
            LOGGING_EFFECTS = config.get("logging", "enable_effects_logs", LOGGING_EFFECTS, "Detailed effects logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_CLOAKING = config.get("logging", "enable_cloaking_logs", LOGGING_CLOAKING, "Detailed cloaking logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_VIDEO_CHANNEL = config.get("logging", "enable_videoChannel_logs", LOGGING_VIDEO_CHANNEL, "Detailed video channel logs to help debug the mod, will spam your console!").getBoolean(false);
            LOGGING_TARGETING = config.get("logging", "enable_targeting_logs", LOGGING_TARGETING, "Detailed targeting logs to help debug the mod, will spam your console!").getBoolean(false);
        } else {
            LOGGING_EFFECTS = false;
            LOGGING_CLOAKING = false;
            LOGGING_VIDEO_CHANNEL = false;
            LOGGING_TARGETING = false;
        }
        LOGGING_WEAPON = config.get("logging", "enable_weapon_logs", LOGGING_WEAPON, "Detailed weapon logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_CAMERA = config.get("logging", "enable_camera_logs", LOGGING_CAMERA, "Detailed camera logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_BUILDING = config.get("logging", "enable_building_logs", LOGGING_BUILDING, "Detailed building logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_COLLECTION = config.get("logging", "enable_collection_logs", LOGGING_COLLECTION, "Detailed collection logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_TRANSPORTER = config.get("logging", "enable_transporter_logs", LOGGING_TRANSPORTER, "Detailed transporter logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_LUA = config.get("logging", "enable_LUA_logs", LOGGING_LUA, "Detailed LUA logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_RADAR = config.get("logging", "enable_radar_logs", LOGGING_RADAR, "Detailed radar logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_BREATHING = config.get("logging", "enable_breathing_logs", LOGGING_BREATHING, "Detailed breathing logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_WORLDGEN = config.get("logging", "enable_worldgen_logs", LOGGING_WORLDGEN, "Detailed world generation logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_PROFILING = config.get("logging", "enable_profiling_logs", LOGGING_PROFILING, "Profiling logs, enable it to check for lag").getBoolean(true);
        LOGGING_DICTIONARY = config.get("logging", "enable_dictionary_logs", LOGGING_DICTIONARY, "Dictionary logs, enable it to dump blocks hardness and blast resistance at boot").getBoolean(true);
        LOGGING_STARMAP = config.get("logging", "enable_starmap_logs", LOGGING_STARMAP, "Starmap logs, enable it to dump starmap registry updates").getBoolean(false);
        LOGGING_BREAK_PLACE = config.get("logging", "enable_break_place_logs", LOGGING_BREAK_PLACE, "Detailed break/place event logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_FORCEFIELD = config.get("logging", "enable_forcefield_logs", LOGGING_FORCEFIELD, "Detailed forcefield logs to help debug the mod, enable it before reporting a bug").getBoolean(false);
        LOGGING_FORCEFIELD_REGISTRY = config.get("logging", "enable_forcefield_registry_logs", LOGGING_FORCEFIELD_REGISTRY, "ForceField registry logs, enable it to dump forcefield registry updates").getBoolean(false);
        config.addCustomCategoryComment("planets", "Planets are other dimensions connected through the Space dimension. Default is overworld with 100k radius.\nEach planet orbit is square shaped and defined as a list of 7 integers (all measured in blocks).");
        ConfigCategory categoryPlanets = config.getCategory("planets");
        String[] planetsName = categoryPlanets.getValues().keySet().toArray(new String[0]);
        if (planetsName.length == 0) {
            planetsName = new String[]{"overworld"};
        }
        int[] defaultPlanet = new int[]{0, 0, 0, 100000, 100000, 0, 0};
        PLANETS = new Planet[planetsName.length];
        int index = 0;
        for (String name : planetsName) {
            int[] planetInts = config.get("planets", name, defaultPlanet, "dimensionId, dimensionCenterX, dimensionCenterZ, radiusX, radiusZ, spaceCenterX, spaceCenterZ").getIntList();
            if (planetInts.length != 7) {
                WarpDrive.logger.warn("Invalid planet definition '" + name + "' (exactly 7 integers are expected), using default instead");
                planetInts = (int[])defaultPlanet.clone();
            }
            Planet planet = new Planet(planetInts[0], planetInts[1], planetInts[2], planetInts[3], planetInts[4], planetInts[5], planetInts[6]);
            WarpDrive.logger.info("Adding '" + name + "' as " + planet);
            WarpDriveConfig.PLANETS[index] = planet;
            ++index;
        }
        SHIP_MAX_ENERGY_STORED = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("ship", "max_energy_stored", SHIP_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        SHIP_NORMALJUMP_ENERGY_PER_BLOCK = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("ship", "normaljump_energy_per_block", SHIP_NORMALJUMP_ENERGY_PER_BLOCK, "Energy cost per non-air block without warping").getInt());
        SHIP_NORMALJUMP_ENERGY_PER_DISTANCE = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("ship", "normaljump_energy_per_distance", SHIP_NORMALJUMP_ENERGY_PER_DISTANCE, "Energy cost per non-air block without warping").getInt());
        SHIP_HYPERJUMP_ENERGY_PER_DISTANCE = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("ship", "hyperjump_energy_per_distance", SHIP_HYPERJUMP_ENERGY_PER_DISTANCE, "Energy cost per non-air block while warping").getInt());
        SHIP_HYPERJUMP_ENERGY_PER_BLOCK = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("ship", "hyperjump_energy_per_block", SHIP_HYPERJUMP_ENERGY_PER_BLOCK, "Energy cost per non-air block while warping").getInt());
        SHIP_TELEPORT_ENERGY_PER_ENTITY = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("ship", "teleport_energy_per_entity", SHIP_TELEPORT_ENERGY_PER_ENTITY, "Energy cost per entity").getInt());
        SHIP_MAX_JUMP_DISTANCE = WarpDriveConfig.clamp(0, 30000000, config.get("ship", "max_jump_distance", SHIP_MAX_JUMP_DISTANCE, "Maximum jump length value in blocks").getInt());
        SHIP_VOLUME_MAX_ON_PLANET_SURFACE = WarpDriveConfig.clamp(0, 10000000, config.get("ship", "volume_max_on_planet_surface", SHIP_VOLUME_MAX_ON_PLANET_SURFACE, "Maximum ship mass (in blocks) to jump on a planet").getInt());
        SHIP_VOLUME_MIN_FOR_HYPERSPACE = WarpDriveConfig.clamp(0, 10000000, config.get("ship", "volume_min_for_hyperspace", SHIP_VOLUME_MIN_FOR_HYPERSPACE, "Minimum ship mass (in blocks) to enter or exit hyperspace without a jumpgate").getInt());
        SHIP_VOLUME_UNLIMITED_PLAYERNAMES = config.get("ship", "volume_unlimited_playernames", SHIP_VOLUME_UNLIMITED_PLAYERNAMES, "List of player names which have unlimited block counts to their ship").getStringList();
        SHIP_MAX_SIDE_SIZE = WarpDriveConfig.clamp(0, 30000000, config.get("ship", "max_side_size", SHIP_MAX_SIDE_SIZE, "Maximum ship size on each axis in blocks").getInt());
        SHIP_COLLISION_TOLERANCE_BLOCKS = WarpDriveConfig.clamp(0, 30000000, config.get("ship", "collision_tolerance_blocks", SHIP_COLLISION_TOLERANCE_BLOCKS, "Tolerance in block in case of collision before causing damages...").getInt());
        SHIP_COOLDOWN_INTERVAL_SECONDS = WarpDriveConfig.clamp(0, 3600, config.get("ship", "cooldown_interval_seconds", SHIP_COOLDOWN_INTERVAL_SECONDS, "Cooldown seconds to wait after jumping").getInt());
        SHIP_SHORTJUMP_THRESHOLD_BLOCKS = WarpDriveConfig.clamp(0, 30000000, config.get("ship", "shortjump_threshold_blocs", SHIP_SHORTJUMP_THRESHOLD_BLOCKS, "Short jump definition").getInt());
        SHIP_SHORTJUMP_WARMUP_SECONDS = WarpDriveConfig.clamp(0, 3600, config.get("ship", "shortjump_warmup_seconds", SHIP_SHORTJUMP_WARMUP_SECONDS, "(measured in seconds)").getInt());
        SHIP_LONGJUMP_WARMUP_SECONDS = WarpDriveConfig.clamp(0, 3600, config.get("ship", "longjump_warmup_seconds", SHIP_LONGJUMP_WARMUP_SECONDS, "(measured in seconds)").getInt());
        SHIP_WARMUP_RANDOM_TICKS = WarpDriveConfig.clamp(10, 200, config.get("ship", "warmup_random_ticks", SHIP_WARMUP_RANDOM_TICKS, "Random variation added to warmup (measured in ticks)").getInt());
        SHIP_WARMUP_SICKNESS = config.get("ship", "warmup_sickness", true, "Enable warp sickness during warmup").getBoolean(true);
        SHIP_SUMMON_MAX_RANGE = config.get("ship", "summon_max_range", SHIP_SUMMON_MAX_RANGE, "Maximum range from which players can be summoned (measured in blocks), set to -1 for unlimited range").getInt();
        SHIP_SUMMON_ACROSS_DIMENSIONS = config.get("ship", "summon_across_dimensions", false, "Enable summoning players from another dimension").getBoolean(false);
        SHIP_CORE_REGISTRY_UPDATE_INTERVAL_SECONDS = WarpDriveConfig.clamp(0, 300, config.get("ship", "core_registry_update_interval", SHIP_CORE_REGISTRY_UPDATE_INTERVAL_SECONDS, "(measured in seconds)").getInt());
        SHIP_CORE_ISOLATION_UPDATE_INTERVAL_SECONDS = WarpDriveConfig.clamp(0, 300, config.get("ship", "core_isolation_update_interval", SHIP_CORE_ISOLATION_UPDATE_INTERVAL_SECONDS, "(measured in seconds)").getInt());
        SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS = WarpDriveConfig.clamp(0, 300, config.get("ship", "controller_update_interval", SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS, "(measured in seconds)").getInt());
        RADAR_MAX_ENERGY_STORED = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("radar", "max_energy_stored", RADAR_MAX_ENERGY_STORED, "maximum energy stored").getInt());
        RADAR_SCAN_MIN_ENERGY_COST = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("radar", "min_energy_cost", RADAR_SCAN_MIN_ENERGY_COST, "minimum energy cost per scan (0+), independently of radius").getInt());
        if ((RADAR_SCAN_ENERGY_COST_FACTORS = config.get("radar", "factors_energy_cost", RADAR_SCAN_ENERGY_COST_FACTORS, "energy cost factors {a, b, c, d}. You need to provide exactly 4 values.\nThe equation used is a + b * radius + c * radius^2 + d * radius^3").getDoubleList()).length != 4) {
            RADAR_SCAN_ENERGY_COST_FACTORS = new double[4];
            Arrays.fill(RADAR_SCAN_ENERGY_COST_FACTORS, 1.0);
        }
        RADAR_SCAN_MIN_DELAY_SECONDS = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("radar", "scan_min_delay_seconds", RADAR_SCAN_MIN_DELAY_SECONDS, "minimum scan delay per scan (1+), (measured in seconds)").getInt());
        if ((RADAR_SCAN_DELAY_FACTORS_SECONDS = config.get("radar", "scan_delay_factors_seconds", RADAR_SCAN_DELAY_FACTORS_SECONDS, "scan delay factors {a, b, c, d}. You need to provide exactly 4 values.\nThe equation used is a + b * radius + c * radius^2 + d * radius^3, (measured in seconds)").getDoubleList()).length != 4) {
            RADAR_SCAN_DELAY_FACTORS_SECONDS = new double[4];
            Arrays.fill(RADAR_SCAN_DELAY_FACTORS_SECONDS, 1.0);
        }
        RADAR_MAX_ISOLATION_RANGE = WarpDriveConfig.clamp(2, 8, config.get("radar", "max_isolation_range", RADAR_MAX_ISOLATION_RANGE, "radius around core where isolation blocks count (2 to 8), higher is lagger").getInt());
        RADAR_MIN_ISOLATION_BLOCKS = WarpDriveConfig.clamp(0, 20, config.get("radar", "min_isolation_blocks", RADAR_MIN_ISOLATION_BLOCKS, "number of isolation blocks required to get some isolation (0 to 20)").getInt());
        RADAR_MAX_ISOLATION_BLOCKS = WarpDriveConfig.clamp(5, 94, config.get("radar", "max_isolation_blocks", RADAR_MAX_ISOLATION_BLOCKS, "number of isolation blocks required to reach maximum effect (5 to 94)").getInt());
        RADAR_MIN_ISOLATION_EFFECT = WarpDriveConfig.clamp(0.01, 0.95, config.get("radar", "min_isolation_effect", RADAR_MIN_ISOLATION_EFFECT, "isolation effect achieved with min number of isolation blocks (0.01 to 0.95)").getDouble(0.12));
        RADAR_MAX_ISOLATION_EFFECT = WarpDriveConfig.clamp(0.01, 1.0, config.get("radar", "max_isolation_effect", RADAR_MAX_ISOLATION_EFFECT, "isolation effect achieved with max number of isolation blocks (0.01 to 1.00)").getDouble(1.0));
        SS_MAX_ENERGY_STORED = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("ship_scanner", "max_energy_stored", SS_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        if ((SS_ENERGY_PER_BLOCK_SCAN = config.get("ship_scanner", "energy_per_block_when_scanning", SS_ENERGY_PER_BLOCK_SCAN, "Energy consumed per block when scanning a ship (use -1 to consume everything)").getInt()) != -1) {
            SS_ENERGY_PER_BLOCK_SCAN = WarpDriveConfig.clamp(0, SS_MAX_ENERGY_STORED, SS_ENERGY_PER_BLOCK_SCAN);
        }
        if ((SS_ENERGY_PER_BLOCK_DEPLOY = config.get("ship_scanner", "energy_per_block_when_deploying", SS_ENERGY_PER_BLOCK_DEPLOY, "Energy consumed per block when deploying a ship (use -1 to consume everything)").getInt()) != -1) {
            SS_ENERGY_PER_BLOCK_DEPLOY = WarpDriveConfig.clamp(0, SS_MAX_ENERGY_STORED, SS_ENERGY_PER_BLOCK_DEPLOY);
        }
        SS_MAX_DEPLOY_RADIUS_BLOCKS = WarpDriveConfig.clamp(5, 150, config.get("ship_scanner", "max_deploy_radius_blocks", SS_MAX_DEPLOY_RADIUS_BLOCKS, "Max distance from ship scanner to ship core, measured in blocks (5-150)").getInt());
        SS_SEARCH_INTERVAL_TICKS = WarpDriveConfig.clamp(5, 150, config.get("ship_scanner", "search_interval_ticks", SS_SEARCH_INTERVAL_TICKS, "Max distance from ship scanner to ship core, measured in blocks (5-150)").getInt());
        SS_SCAN_BLOCKS_PER_SECOND = WarpDriveConfig.clamp(1, 50000, config.get("ship_scanner", "scan_blocks_per_second", SS_SCAN_BLOCKS_PER_SECOND, "Scanning speed, measured in blocks (1-5000)").getInt());
        SS_DEPLOY_BLOCKS_PER_INTERVAL = WarpDriveConfig.clamp(1, 3000, config.get("ship_scanner", "deploy_blocks_per_interval", SS_DEPLOY_BLOCKS_PER_INTERVAL, "Deployment speed, measured in blocks (1-3000)").getInt());
        SS_DEPLOY_INTERVAL_TICKS = WarpDriveConfig.clamp(1, 60, config.get("ship_scanner", "deploy_interval_ticks", SS_DEPLOY_INTERVAL_TICKS, "Delay between deployment of 2 sets of blocks, measured in ticks (1-60)").getInt());
        LASER_MEDIUM_MAX_ENERGY_STORED = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("laser_medium", "max_energy_stored", LASER_MEDIUM_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        LASER_CANNON_MAX_MEDIUMS_COUNT = WarpDriveConfig.clamp(1, 64, config.get("laser_cannon", "max_mediums_count", LASER_CANNON_MAX_MEDIUMS_COUNT, "Maximum number of laser mediums per laser").getInt());
        LASER_CANNON_MAX_LASER_ENERGY = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("laser_cannon", "max_laser_energy", LASER_CANNON_MAX_LASER_ENERGY, "Maximum energy in beam after accounting for boosters beams").getInt());
        LASER_CANNON_EMIT_FIRE_DELAY_TICKS = WarpDriveConfig.clamp(1, 100, config.get("laser_cannon", "emit_fire_delay_ticks", LASER_CANNON_EMIT_FIRE_DELAY_TICKS, "Delay while booster beams are accepted, before actually shooting").getInt());
        LASER_CANNON_EMIT_SCAN_DELAY_TICKS = WarpDriveConfig.clamp(1, 100, config.get("laser_cannon", "emit_scan_delay_ticks", LASER_CANNON_EMIT_SCAN_DELAY_TICKS, "Delay while booster beams are accepted, before actually scanning").getInt());
        LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY = WarpDriveConfig.clamp(0.01, 10.0, config.get("laser_cannon", "booster_beam_energy_efficiency", LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY, "Energy factor applied from boosting to main laser").getDouble(0.6));
        LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK = WarpDriveConfig.clamp(0.0, 0.1, config.get("laser_cannon", "energy_attenuation_per_air_block", LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK, "Energy attenuation when going through air blocks (on a planet or any gaz in space)").getDouble());
        LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK = WarpDriveConfig.clamp(0.0, 0.1, config.get("laser_cannon", "energy_attenuation_per_air_block", LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK, "Energy attenuation when going through void blocks (in space or hyperspace)").getDouble());
        LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK = WarpDriveConfig.clamp(0.0, 1.0, config.get("laser_cannon", "energy_attenuation_per_air_block", LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK, "Energy attenuation when going through a broken block").getDouble());
        LASER_CANNON_RANGE_MAX = WarpDriveConfig.clamp(64, 512, config.get("laser_cannon", "range_max", LASER_CANNON_RANGE_MAX, "Maximum distance travelled").getInt());
        LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS = WarpDriveConfig.clamp(0, 300, config.get("laser_cannon", "entity_hit_set_on_fire_seconds", LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS, "Duration of fire effect on entity hit (in seconds)").getInt());
        LASER_CANNON_ENTITY_HIT_ENERGY = WarpDriveConfig.clamp(0, LASER_CANNON_MAX_LASER_ENERGY, config.get("laser_cannon", "entity_hit_energy", LASER_CANNON_ENTITY_HIT_ENERGY, "Base energy consumed from hitting an entity").getInt());
        LASER_CANNON_ENTITY_HIT_BASE_DAMAGE = WarpDriveConfig.clamp(0, LASER_CANNON_MAX_LASER_ENERGY, config.get("laser_cannon", "entity_hit_base_damage", LASER_CANNON_ENTITY_HIT_BASE_DAMAGE, "Minimum damage to entity hit (measured in half hearts)").getInt());
        LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE = WarpDriveConfig.clamp(0, LASER_CANNON_MAX_LASER_ENERGY, config.get("laser_cannon", "entity_hit_energy_per_damage", LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE, "Energy required by additional hit point (won't be consumed)").getInt());
        LASER_CANNON_ENTITY_HIT_MAX_DAMAGE = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "entity_hit_max_damage", LASER_CANNON_ENTITY_HIT_MAX_DAMAGE, "Maximum damage to entity hit, set to 0 to disable damage completely").getInt());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "entity_hit_energy_threshold_for_explosion", LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD, "Minimum energy to cause explosion effect").getInt());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH = (float)WarpDriveConfig.clamp(0.0, 100.0, config.get("laser_cannon", "entity_hit_explosion_base_strength", (double)LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH, "Explosion base strength, 4 is Vanilla TNT").getDouble());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("laser_cannon", "entity_hit_explosion_energy_per_strength", LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH, "Energy per added explosion strength").getInt());
        LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH = (float)WarpDriveConfig.clamp(0.0, 1000.0, config.get("laser_cannon", "entity_hit_explosion_max_strength", (double)LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH, "Maximum explosion strength, set to 0 to disable explosion completely").getDouble());
        LASER_CANNON_BLOCK_HIT_ENERGY_MIN = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_energy_min", LASER_CANNON_BLOCK_HIT_ENERGY_MIN, "Minimum energy required for breaking a block").getInt());
        LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_energy_per_block_hardness", LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS, "Energy cost per block hardness for breaking a block").getInt());
        LASER_CANNON_BLOCK_HIT_ENERGY_MAX = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_energy_max", LASER_CANNON_BLOCK_HIT_ENERGY_MAX, "Maximum energy required for breaking a block").getInt());
        LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS = WarpDriveConfig.clamp(0.0, 1.0, config.get("laser_cannon", "block_hit_absorption_per_block_hardness", LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS, "Probability of energy absorption (i.e. block not breaking) per block hardness. Set to 1.0 to always break the block.").getDouble());
        LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX = WarpDriveConfig.clamp(0.0, 1.0, config.get("laser_cannon", "block_hit_absorption_max", LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX, "Maximum probability of energy absorption (i.e. block not breaking)").getDouble());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD = (float)WarpDriveConfig.clamp(0.0, 10000.0, config.get("laser_cannon", "block_hit_explosion_hardness_threshold", (double)LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD, "Minimum block hardness required to cause an explosion").getDouble());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH = (float)WarpDriveConfig.clamp(0.0, 1000.0, config.get("laser_cannon", "block_hit_explosion_base_strength", (double)LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH, "Explosion base strength, 4 is Vanilla TNT").getDouble());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("laser_cannon", "block_hit_explosion_energy_per_strength", LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH, "Energy per added explosion strength").getInt());
        LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH = (float)WarpDriveConfig.clamp(0.0, 1000.0, config.get("laser_cannon", "block_hit_explosion_max_strength", (double)LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH, "Maximum explosion strength, set to 0 to disable explosion completely").getDouble());
        MINING_LASER_MAX_MEDIUMS_COUNT = WarpDriveConfig.clamp(1, 64, config.get("mining_laser", "max_mediums_count", MINING_LASER_MAX_MEDIUMS_COUNT, "Maximum number of laser mediums").getInt());
        MINING_LASER_RADIUS_BLOCKS = WarpDriveConfig.clamp(1, 64, config.get("mining_laser", "radius_blocks", MINING_LASER_RADIUS_BLOCKS, "Mining radius").getInt());
        MINING_LASER_WARMUP_DELAY_TICKS = WarpDriveConfig.clamp(1, 300, config.get("mining_laser", "warmup_delay_ticks", MINING_LASER_WARMUP_DELAY_TICKS, "Warmup duration (buffer on startup when energy source is weak)").getInt());
        MINING_LASER_SCAN_DELAY_TICKS = WarpDriveConfig.clamp(1, 300, config.get("mining_laser", "scan_delay_ticks", MINING_LASER_SCAN_DELAY_TICKS, "Scan duration per layer").getInt());
        MINING_LASER_MINE_DELAY_TICKS = WarpDriveConfig.clamp(1, 300, config.get("mining_laser", "mine_delay_ticks", MINING_LASER_MINE_DELAY_TICKS, "Mining duration per scanned block").getInt());
        MINING_LASER_PLANET_ENERGY_PER_LAYER = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "planet_energy_per_layer", MINING_LASER_PLANET_ENERGY_PER_LAYER, "Energy cost per layer on a planet").getInt());
        MINING_LASER_PLANET_ENERGY_PER_BLOCK = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "planet_energy_per_block", MINING_LASER_PLANET_ENERGY_PER_BLOCK, "Energy cost per block in space").getInt());
        MINING_LASER_SPACE_ENERGY_PER_LAYER = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "space_energy_per_layer", MINING_LASER_SPACE_ENERGY_PER_LAYER, "Energy cost per layer on a planet").getInt());
        MINING_LASER_SPACE_ENERGY_PER_BLOCK = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("mining_laser", "space_energy_per_block", MINING_LASER_SPACE_ENERGY_PER_BLOCK, "Energy cost per block in space").getInt());
        MINING_LASER_ORESONLY_ENERGY_FACTOR = WarpDriveConfig.clamp(1.5, 1000.0, config.get("mining_laser", "oresonly_energy_factor", MINING_LASER_ORESONLY_ENERGY_FACTOR, "Energy cost multiplier per block when mining only ores").getDouble(MINING_LASER_ORESONLY_ENERGY_FACTOR));
        MINING_LASER_SILKTOUCH_ENERGY_FACTOR = WarpDriveConfig.clamp(1.5, 1000.0, config.get("mining_laser", "silktouch_energy_factor", MINING_LASER_SILKTOUCH_ENERGY_FACTOR, "Energy cost multiplier per block when mining with silktouch").getDouble(MINING_LASER_SILKTOUCH_ENERGY_FACTOR));
        TREE_FARM_MAX_MEDIUMS_COUNT = WarpDriveConfig.clamp(1, 10, config.get("tree_farm", "max_mediums_count", TREE_FARM_MAX_MEDIUMS_COUNT, "Maximum number of laser mediums").getInt());
        TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM = WarpDriveConfig.clamp(1, 30, config.get("tree_farm", "max_scan_radius_no_laser_medium", TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM, "Maximum scan radius without any laser medium, on X and Z axis, measured in blocks").getInt());
        TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM = WarpDriveConfig.clamp(0, 5, config.get("tree_farm", "max_scan_radius_per_laser_medium", TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM, "Bonus to maximum scan radius per laser medium, on X and Z axis, measured in blocks").getInt());
        TREE_FARM_totalMaxRadius = TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM + TREE_FARM_MAX_MEDIUMS_COUNT * TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM;
        TREE_FARM_MAX_LOG_DISTANCE = WarpDriveConfig.clamp(1, 64, config.get("tree_farm", "max_reach_distance", TREE_FARM_MAX_LOG_DISTANCE, "Maximum reach distance of the laser without any laser medium, measured in blocks").getInt());
        TREE_FARM_MAX_LOG_DISTANCE_PER_MEDIUM = WarpDriveConfig.clamp(0, 16, config.get("tree_farm", "max_reach_distance_per_laser_medium", TREE_FARM_MAX_LOG_DISTANCE_PER_MEDIUM, "Bonus to maximum reach distance per laser medium, measured in blocks").getInt());
        CLOAKING_MAX_ENERGY_STORED = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("cloaking", "max_energy_stored", CLOAKING_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        CLOAKING_COIL_CAPTURE_BLOCKS = WarpDriveConfig.clamp(0, 30, config.get("cloaking", "coil_capture_blocks", CLOAKING_COIL_CAPTURE_BLOCKS, "Extra blocks covered after the outer coils").getInt());
        CLOAKING_MAX_FIELD_RADIUS = WarpDriveConfig.clamp(CLOAKING_COIL_CAPTURE_BLOCKS + 3, 128, config.get("cloaking", "max_field_radius", CLOAKING_MAX_FIELD_RADIUS, "Maximum distance between cloaking core and any cloaked side").getInt());
        CLOAKING_TIER1_ENERGY_PER_BLOCK = WarpDriveConfig.clamp(0, Integer.MAX_VALUE, config.get("cloaking", "tier1_energy_per_block", CLOAKING_TIER1_ENERGY_PER_BLOCK, "Energy cost per non-air block in a Tier1 cloak").getInt());
        CLOAKING_TIER2_ENERGY_PER_BLOCK = WarpDriveConfig.clamp(CLOAKING_TIER1_ENERGY_PER_BLOCK, Integer.MAX_VALUE, config.get("cloaking", "tier2_energy_per_block", CLOAKING_TIER2_ENERGY_PER_BLOCK, "Energy cost per non-air block in a Tier2 cloak").getInt());
        CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS = WarpDriveConfig.clamp(1, 30, config.get("cloaking", "field_refresh_interval_seconds", CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS, "Update speed of cloak simulation").getInt());
        AIRGEN_MAX_ENERGY_STORED = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("air_generator", "max_energy_stored", AIRGEN_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        AIRGEN_ENERGY_PER_CANISTER = WarpDriveConfig.clamp(1, AIRGEN_MAX_ENERGY_STORED, config.get("air_generator", "energy_per_canister", AIRGEN_ENERGY_PER_CANISTER, "Energy cost per air canister refilled").getInt());
        AIRGEN_ENERGY_PER_NEWAIRBLOCK = WarpDriveConfig.clamp(1, AIRGEN_MAX_ENERGY_STORED, config.get("air_generator", "energy_per_new_air_block", AIRGEN_ENERGY_PER_NEWAIRBLOCK, "Energy cost to start air distribution per open side per interval").getInt());
        AIRGEN_ENERGY_PER_EXISTINGAIRBLOCK = WarpDriveConfig.clamp(1, AIRGEN_MAX_ENERGY_STORED, config.get("air_generator", "energy_per_existing_air_block", AIRGEN_ENERGY_PER_EXISTINGAIRBLOCK, "Energy cost to sustain air distribution per open side per interval").getInt());
        AIRGEN_AIR_GENERATION_TICKS = WarpDriveConfig.clamp(1, 300, config.get("air_generator", "air_generation_interval_ticks", AIRGEN_AIR_GENERATION_TICKS, "Update speed of air generation").getInt());
        IC2_REACTOR_MAX_ENERGY_STORED = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("ic2_reactor_laser", "max_energy_stored", IC2_REACTOR_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        IC2_REACTOR_ENERGY_PER_HEAT = WarpDriveConfig.clamp(2.0, 100000.0, config.get("ic2_reactor_laser", "energy_per_heat", IC2_REACTOR_ENERGY_PER_HEAT, "Energy cost per heat absorbed").getDouble(2.0));
        IC2_REACTOR_COOLING_INTERVAL_TICKS = WarpDriveConfig.clamp(0, 1200, config.get("ic2_reactor_laser", "cooling_interval_ticks", IC2_REACTOR_COOLING_INTERVAL_TICKS, "Update speed of the check for reactors to cooldown").getInt());
        TRANSPORTER_MAX_ENERGY_STORED = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("transporter", "max_energy_stored", TRANSPORTER_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        TRANSPORTER_USE_RELATIVE_COORDS = config.get("transporter", "use_relative_coords", TRANSPORTER_USE_RELATIVE_COORDS, "Should transporter use relative coordinates?").getBoolean(true);
        TRANSPORTER_ENERGY_PER_BLOCK = WarpDriveConfig.clamp(1.0, (double)TRANSPORTER_MAX_ENERGY_STORED / 10.0, config.get("transporter", "energy_per_block", TRANSPORTER_ENERGY_PER_BLOCK, "Energy cost per block distance").getDouble(100.0));
        TRANSPORTER_MAX_BOOST_MUL = WarpDriveConfig.clamp(1.0, 1000.0, config.get("transporter", "max_boost", TRANSPORTER_MAX_BOOST_MUL, "Maximum energy boost allowed").getDouble(4.0));
        ENAN_REACTOR_MAX_ENERGY_STORED = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("enantiomorphic_reactor", "max_energy_stored", ENAN_REACTOR_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        ENAN_REACTOR_UPDATE_INTERVAL_TICKS = WarpDriveConfig.clamp(1, 300, config.get("enantiomorphic_reactor", "update_interval_ticks", ENAN_REACTOR_UPDATE_INTERVAL_TICKS, "Update speed of the reactor simulation").getInt());
        ENAN_REACTOR_MAX_LASERS_PER_SECOND = WarpDriveConfig.clamp(4, 80, config.get("enantiomorphic_reactor", "max_lasers", ENAN_REACTOR_MAX_LASERS_PER_SECOND, "Maximum number of stabilisation laser shots per seconds before loosing efficiency").getInt());
        ENERGY_BANK_MAX_ENERGY_STORED = config.get("energy_bank", "max_energy_stored", ENERGY_BANK_MAX_ENERGY_STORED, "Maximum energy stored for each energy bank").getIntList();
        assert (ENERGY_BANK_MAX_ENERGY_STORED.length == 3);
        WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[0] = WarpDriveConfig.clamp(0, ENERGY_BANK_MAX_ENERGY_STORED[1], ENERGY_BANK_MAX_ENERGY_STORED[0]);
        WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[1] = WarpDriveConfig.clamp(ENERGY_BANK_MAX_ENERGY_STORED[0], ENERGY_BANK_MAX_ENERGY_STORED[2], ENERGY_BANK_MAX_ENERGY_STORED[1]);
        WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[2] = WarpDriveConfig.clamp(ENERGY_BANK_MAX_ENERGY_STORED[1], Integer.MAX_VALUE, ENERGY_BANK_MAX_ENERGY_STORED[2]);
        ENERGY_BANK_IC2_TIER = config.get("energy_bank", "ic2_tier", ENERGY_BANK_IC2_TIER, "IC2 energy tier for each energy bank (0 is BatBox, etc.)").getIntList();
        assert (ENERGY_BANK_IC2_TIER.length == 3);
        WarpDriveConfig.ENERGY_BANK_IC2_TIER[0] = WarpDriveConfig.clamp(0, ENERGY_BANK_IC2_TIER[1], ENERGY_BANK_IC2_TIER[0]);
        WarpDriveConfig.ENERGY_BANK_IC2_TIER[1] = WarpDriveConfig.clamp(ENERGY_BANK_IC2_TIER[0], ENERGY_BANK_IC2_TIER[2], ENERGY_BANK_IC2_TIER[1]);
        WarpDriveConfig.ENERGY_BANK_IC2_TIER[2] = WarpDriveConfig.clamp(ENERGY_BANK_IC2_TIER[1], Integer.MAX_VALUE, ENERGY_BANK_IC2_TIER[2]);
        ENERGY_BANK_TRANSFER_PER_TICK = config.get("energy_bank", "transfer_per_tick", ENERGY_BANK_TRANSFER_PER_TICK, "Internal energy transferred per tick for each energy bank").getIntList();
        assert (ENERGY_BANK_TRANSFER_PER_TICK.length == 3);
        WarpDriveConfig.ENERGY_BANK_TRANSFER_PER_TICK[0] = WarpDriveConfig.clamp(0, ENERGY_BANK_TRANSFER_PER_TICK[1], ENERGY_BANK_TRANSFER_PER_TICK[0]);
        WarpDriveConfig.ENERGY_BANK_TRANSFER_PER_TICK[1] = WarpDriveConfig.clamp(ENERGY_BANK_TRANSFER_PER_TICK[0], ENERGY_BANK_TRANSFER_PER_TICK[2], ENERGY_BANK_TRANSFER_PER_TICK[1]);
        WarpDriveConfig.ENERGY_BANK_TRANSFER_PER_TICK[2] = WarpDriveConfig.clamp(ENERGY_BANK_TRANSFER_PER_TICK[1], Integer.MAX_VALUE, ENERGY_BANK_TRANSFER_PER_TICK[2]);
        ENERGY_BANK_EFFICIENCY_PER_UPGRADE = config.get("energy_bank", "efficiency_per_upgrade", ENERGY_BANK_EFFICIENCY_PER_UPGRADE, "Energy transfer efficiency for each upgrade apply, first value is without upgrades (0.8 means 20% loss)").getDoubleList();
        assert (ENERGY_BANK_EFFICIENCY_PER_UPGRADE.length >= 1);
        WarpDriveConfig.ENERGY_BANK_EFFICIENCY_PER_UPGRADE[0] = Math.min(1.0, WarpDriveConfig.clamp(0.5, ENERGY_BANK_EFFICIENCY_PER_UPGRADE[1], ENERGY_BANK_EFFICIENCY_PER_UPGRADE[0]));
        WarpDriveConfig.ENERGY_BANK_EFFICIENCY_PER_UPGRADE[1] = Math.min(1.0, WarpDriveConfig.clamp(ENERGY_BANK_EFFICIENCY_PER_UPGRADE[0], ENERGY_BANK_EFFICIENCY_PER_UPGRADE[2], ENERGY_BANK_EFFICIENCY_PER_UPGRADE[1]));
        WarpDriveConfig.ENERGY_BANK_EFFICIENCY_PER_UPGRADE[2] = Math.min(1.0, WarpDriveConfig.clamp(ENERGY_BANK_EFFICIENCY_PER_UPGRADE[1], 2.147483647E9, ENERGY_BANK_EFFICIENCY_PER_UPGRADE[2]));
        LIFT_MAX_ENERGY_STORED = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("lift", "max_energy_stored", LIFT_MAX_ENERGY_STORED, "Maximum energy stored").getInt());
        LIFT_ENERGY_PER_ENTITY = WarpDriveConfig.clamp(1, Integer.MAX_VALUE, config.get("lift", "energy_per_entity", LIFT_ENERGY_PER_ENTITY, "Energy consumed per entity moved").getInt());
        LIFT_UPDATE_INTERVAL_TICKS = WarpDriveConfig.clamp(1, 60, config.get("lift", "update_interval_ticks", LIFT_UPDATE_INTERVAL_TICKS, "Update speed of the check for entities").getInt());
        Dictionary.loadConfig(config);
        blockTransformers = new HashMap();
        config.save();
    }

    public static void registerBlockTransformer(String modId, IBlockTransformer blockTransformer) {
        blockTransformers.put(modId, blockTransformer);
        WarpDrive.logger.info(modId + " blockTransformer registered");
    }

    public static int clamp(int min, int max, int value) {
        return Math.min(max, Math.max(value, min));
    }

    public static double clamp(double min, double max, double value) {
        return Math.min(max, Math.max(value, min));
    }

    public static void onFMLInitialization() {
        boolean isThermalDynamicsLoaded;
        boolean isThaumcraftLoaded;
        boolean isTConstructLoaded;
        boolean isStargateTech2Loaded;
        boolean isSGCraftLoaded;
        boolean isRedstonePasteLoaded;
        boolean isNaturaLoaded;
        boolean isMetallurgyLoaded;
        boolean isMekanismLoaded;
        boolean isJABBAloaded;
        boolean isEvilCraftLoaded;
        boolean isCarpentersBlocksLoaded;
        boolean isBiblioCraftLoaded;
        boolean isBotaniaLoaded;
        CompatWarpDrive.register();
        isForgeMultipartLoaded = Loader.isModLoaded((String)"ForgeMultipart");
        if (isForgeMultipartLoaded) {
            isForgeMultipartLoaded = CompatForgeMultipart.register();
        }
        if (isIndustrialCraft2Loaded = Loader.isModLoaded((String)"IC2")) {
            WarpDriveConfig.loadIC2();
            CompatIndustrialCraft2.register();
        }
        if (isComputerCraftLoaded = Loader.isModLoaded((String)"ComputerCraft")) {
            WarpDriveConfig.loadCC();
            CompatComputerCraft.register();
        }
        isAdvancedSolarPanelLoaded = Loader.isModLoaded((String)"AdvancedSolarPanel");
        isCoFHCoreLoaded = Loader.isModLoaded((String)"CoFHCore");
        isThermalExpansionLoaded = Loader.isModLoaded((String)"ThermalExpansion");
        if (isThermalExpansionLoaded) {
            CompatThermalExpansion.register();
        }
        if (isAppliedEnergistics2Loaded = Loader.isModLoaded((String)"appliedenergistics2")) {
            CompatAppliedEnergistics2.register();
        }
        if (isOpenComputersLoaded = Loader.isModLoaded((String)"OpenComputers")) {
            CompatOpenComputers.register();
        }
        if (isArsMagica2Loaded = Loader.isModLoaded((String)"arsmagica2")) {
            CompatArsMagica2.register();
        }
        if (isImmersiveEngineeringLoaded = Loader.isModLoaded((String)"ImmersiveEngineering")) {
            CompatImmersiveEngineering.register();
        }
        isGregTech5Loaded = false;
        if (Loader.isModLoaded((String)"gregtech")) {
            String gregTechVersion = FMLCommonHandler.instance().findContainerFor((Object)"gregtech").getVersion();
            boolean bl = isGregTech5Loaded = gregTechVersion.equalsIgnoreCase("MC1710") || gregTechVersion.startsWith("5.");
        }
        if (isEnderIOLoaded = Loader.isModLoaded((String)"EnderIO")) {
            CompatEnderIO.register();
        }
        if (isAdvancedRepulsionSystemLoaded = Loader.isModLoaded((String)"AdvancedRepulsionSystems")) {
            CompatAdvancedRepulsionSystems.register();
        }
        if (isBotaniaLoaded = Loader.isModLoaded((String)"Botania")) {
            CompatBotania.register();
        }
        if (isBiblioCraftLoaded = Loader.isModLoaded((String)"BiblioCraft")) {
            CompatBiblioCraft.register();
        }
        if (isCarpentersBlocksLoaded = Loader.isModLoaded((String)"CarpentersBlocks")) {
            CompatCarpentersBlocks.register();
        }
        if (isEvilCraftLoaded = Loader.isModLoaded((String)"evilcraft")) {
            CompatEvilCraft.register();
        }
        if (isJABBAloaded = Loader.isModLoaded((String)"JABBA")) {
            CompatJABBA.register();
        }
        if (isMekanismLoaded = Loader.isModLoaded((String)"Mekanism")) {
            CompatMekanism.register();
        }
        if (isMetallurgyLoaded = Loader.isModLoaded((String)"Metallurgy")) {
            CompatMetallurgy.register();
        }
        if (isNaturaLoaded = Loader.isModLoaded((String)"Natura")) {
            CompatNatura.register();
        }
        if (isRedstonePasteLoaded = Loader.isModLoaded((String)"RedstonePasteMod")) {
            CompatRedstonePaste.register();
        }
        if (isSGCraftLoaded = Loader.isModLoaded((String)"SGCraft")) {
            CompatSGCraft.register();
        }
        if (isStargateTech2Loaded = Loader.isModLoaded((String)"StargateTech2")) {
            CompatStargateTech2.register();
        }
        if (isTConstructLoaded = Loader.isModLoaded((String)"TConstruct")) {
            CompatTConstruct.register();
        }
        if (isThaumcraftLoaded = Loader.isModLoaded((String)"Thaumcraft")) {
            CompatThaumcraft.register();
        }
        if (isThermalDynamicsLoaded = Loader.isModLoaded((String)"ThermalDynamics")) {
            CompatThermalDynamics.register();
        }
    }

    public static void onFMLPostInitialization() {
        File[] files = configDirectory.listFiles((file_notUsed, name) -> name.endsWith(".xml"));
        if (files.length == 0) {
            for (String defaultXMLfilename : defaultXMLfilenames) {
                WarpDriveConfig.unpackResourceToFolder(defaultXMLfilename, "config", configDirectory);
            }
        }
        WarpDriveConfig.unpackResourceToFolder("WarpDrive.xsd", "config", configDirectory);
        FillerManager.load(configDirectory);
        StructureManager.load(configDirectory);
        Dictionary.apply();
    }

    private static void loadIC2() {
        try {
            IC2_emptyCell = WarpDriveConfig.getModItemStack("IC2", "itemCellEmpty", -1);
            IC2_compressedAir = WarpDriveConfig.getModItemStack("IC2", "itemCellEmpty", 5);
            IC2_rubberWood = WarpDriveConfig.getModBlock("IC2", "blockRubWood");
            IC2_Resin = WarpDriveConfig.getModItemStack("IC2", "itemHarz", -1);
        }
        catch (Exception exception) {
            WarpDrive.logger.error("Error loading IndustrialCraft2 classes");
            exception.printStackTrace();
        }
    }

    private static void loadCC() {
        try {
            CC_Computer = WarpDriveConfig.getModBlock("ComputerCraft", "CC-Computer");
            CC_peripheral = WarpDriveConfig.getModBlock("ComputerCraft", "CC-Peripheral");
            CCT_Turtle = WarpDriveConfig.getModBlock("ComputerCraft", "CC-Turtle");
            CCT_Expanded = WarpDriveConfig.getModBlock("ComputerCraft", "CC-TurtleExpanded");
            CCT_Advanced = WarpDriveConfig.getModBlock("ComputerCraft", "CC-TurtleAdvanced");
        }
        catch (Exception exception) {
            WarpDrive.logger.error("Error loading ComputerCraft classes");
            exception.printStackTrace();
        }
    }

    public static DocumentBuilder getXmlDocumentBuilder() {
        if (xmlDocumentBuilder == null) {
            ErrorHandler xmlErrorHandler = new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    WarpDrive.logger.warn("XML warning: " + exception.getLocalizedMessage());
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    WarpDrive.logger.warn("XML fatal error: " + exception.getLocalizedMessage());
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    WarpDrive.logger.warn("XML error: " + exception.getLocalizedMessage());
                }
            };
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(false);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            try {
                xmlDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException exception) {
                exception.printStackTrace();
            }
            xmlDocumentBuilder.setErrorHandler(xmlErrorHandler);
        }
        return xmlDocumentBuilder;
    }

    private static void unpackResourceToFolder(String filename, String sourceResourcePath, File targetFolder) {
        String resourceName = sourceResourcePath + "/" + filename;
        File destination = new File(targetFolder, filename);
        try {
            int bytesRead;
            InputStream inputStream = WarpDrive.class.getClassLoader().getResourceAsStream(resourceName);
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] byteBuffer = new byte[Math.max(8192, inputStream.available())];
            while ((bytesRead = inputStream.read(byteBuffer)) >= 0) {
                outputStream.write(byteBuffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {
            WarpDrive.logger.error("Failed to unpack resource '" + resourceName + "' into " + destination);
            exception.printStackTrace();
        }
    }

    static {
        defaultXMLfilenames = new String[]{"filler-default.xml", "filler-netherores.xml", "filler-undergroundbiomes.xml", "structures-default.xml", "structures-netherores.xml"};
        isForgeMultipartLoaded = false;
        isAdvancedSolarPanelLoaded = false;
        isAppliedEnergistics2Loaded = false;
        isICBMLoaded = false;
        isIndustrialCraft2Loaded = false;
        isComputerCraftLoaded = false;
        isOpenComputersLoaded = false;
        isCoFHCoreLoaded = false;
        isThermalExpansionLoaded = false;
        isArsMagica2Loaded = false;
        isImmersiveEngineeringLoaded = false;
        isGregTech5Loaded = false;
        isEnderIOLoaded = false;
        isAdvancedRepulsionSystemLoaded = false;
        G_SPACE_BIOME_ID = 95;
        G_SPACE_PROVIDER_ID = 14;
        G_SPACE_DIMENSION_ID = -2;
        G_HYPERSPACE_PROVIDER_ID = 15;
        G_HYPERSPACE_DIMENSION_ID = -3;
        G_SPACE_WORLDBORDER_BLOCKS = 100000;
        G_ENTITY_SPHERE_GENERATOR_ID = 241;
        G_ENTITY_STAR_CORE_ID = 242;
        G_ENTITY_CAMERA_ID = 243;
        G_LUA_SCRIPTS = 2;
        G_SCHEMALOCATION = "warpDrive_schematics";
        G_BLOCKS_PER_TICK = 3500;
        RECIPES_ENABLE_DYNAMIC = true;
        RECIPES_ENABLE_IC2 = false;
        RECIPES_ENABLE_HARD_IC2 = false;
        RECIPES_ENABLE_VANILLA = false;
        LOGGING_JUMP = false;
        LOGGING_JUMPBLOCKS = false;
        LOGGING_ENERGY = false;
        LOGGING_EFFECTS = false;
        LOGGING_CLOAKING = false;
        LOGGING_VIDEO_CHANNEL = false;
        LOGGING_TARGETING = false;
        LOGGING_WEAPON = false;
        LOGGING_CAMERA = false;
        LOGGING_BUILDING = false;
        LOGGING_COLLECTION = false;
        LOGGING_TRANSPORTER = false;
        LOGGING_LUA = false;
        LOGGING_RADAR = false;
        LOGGING_BREATHING = false;
        LOGGING_WORLDGEN = false;
        LOGGING_PROFILING = true;
        LOGGING_DICTIONARY = false;
        LOGGING_STARMAP = false;
        LOGGING_BREAK_PLACE = false;
        LOGGING_FORCEFIELD = false;
        LOGGING_FORCEFIELD_REGISTRY = false;
        PLANETS = null;
        SPACE_GENERATOR_Y_MIN_CENTER = 55;
        SPACE_GENERATOR_Y_MAX_CENTER = 128;
        SPACE_GENERATOR_Y_MIN_BORDER = 5;
        SPACE_GENERATOR_Y_MAX_BORDER = 200;
        SPACE_GENERATOR_STRUCTURES_CHANCES = null;
        SHIP_MAX_ENERGY_STORED = 100000000;
        SHIP_NORMALJUMP_ENERGY_PER_BLOCK = 10;
        SHIP_NORMALJUMP_ENERGY_PER_DISTANCE = 100;
        SHIP_HYPERJUMP_ENERGY_PER_BLOCK = 100;
        SHIP_HYPERJUMP_ENERGY_PER_DISTANCE = 1000;
        SHIP_TELEPORT_ENERGY_PER_ENTITY = 1000000;
        SHIP_MAX_JUMP_DISTANCE = 128;
        SHIP_VOLUME_MAX_ON_PLANET_SURFACE = 3000;
        SHIP_VOLUME_MIN_FOR_HYPERSPACE = 1200;
        SHIP_MAX_SIDE_SIZE = 127;
        SHIP_COOLDOWN_INTERVAL_SECONDS = 30;
        SHIP_COLLISION_TOLERANCE_BLOCKS = 3;
        SHIP_SHORTJUMP_THRESHOLD_BLOCKS = 50;
        SHIP_SHORTJUMP_WARMUP_SECONDS = 10;
        SHIP_LONGJUMP_WARMUP_SECONDS = 30;
        SHIP_WARMUP_RANDOM_TICKS = 60;
        SHIP_CORE_REGISTRY_UPDATE_INTERVAL_SECONDS = 10;
        SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS = 2;
        SHIP_CORE_ISOLATION_UPDATE_INTERVAL_SECONDS = 10;
        SHIP_VOLUME_UNLIMITED_PLAYERNAMES = new String[]{"notch", "someone"};
        SHIP_WARMUP_SICKNESS = true;
        SHIP_SUMMON_MAX_RANGE = 500;
        SHIP_SUMMON_ACROSS_DIMENSIONS = false;
        RADAR_MAX_ENERGY_STORED = 100000000;
        RADAR_SCAN_MIN_ENERGY_COST = 10000;
        RADAR_SCAN_ENERGY_COST_FACTORS = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        RADAR_SCAN_MIN_DELAY_SECONDS = 1;
        RADAR_SCAN_DELAY_FACTORS_SECONDS = new double[]{1.0, 0.001, 0.0, 0.0};
        RADAR_MAX_ISOLATION_RANGE = 2;
        RADAR_MIN_ISOLATION_BLOCKS = 2;
        RADAR_MAX_ISOLATION_BLOCKS = 16;
        RADAR_MIN_ISOLATION_EFFECT = 0.12;
        RADAR_MAX_ISOLATION_EFFECT = 1.0;
        SS_MAX_ENERGY_STORED = 500000000;
        SS_ENERGY_PER_BLOCK_SCAN = 100;
        SS_ENERGY_PER_BLOCK_DEPLOY = 5000;
        SS_MAX_DEPLOY_RADIUS_BLOCKS = 50;
        SS_SEARCH_INTERVAL_TICKS = 20;
        SS_SCAN_BLOCKS_PER_SECOND = 10;
        SS_DEPLOY_BLOCKS_PER_INTERVAL = 10;
        SS_DEPLOY_INTERVAL_TICKS = 4;
        LASER_MEDIUM_MAX_ENERGY_STORED = 100000;
        LASER_CANNON_MAX_MEDIUMS_COUNT = 10;
        LASER_CANNON_MAX_LASER_ENERGY = 3400000;
        LASER_CANNON_EMIT_FIRE_DELAY_TICKS = 5;
        LASER_CANNON_EMIT_SCAN_DELAY_TICKS = 1;
        LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY = 0.6;
        LASER_CANNON_ENERGY_ATTENUATION_PER_AIR_BLOCK = 2.0E-4;
        LASER_CANNON_ENERGY_ATTENUATION_PER_VOID_BLOCK = 5.0E-6;
        LASER_CANNON_ENERGY_ATTENUATION_PER_BROKEN_BLOCK = 0.23;
        LASER_CANNON_RANGE_MAX = 500;
        LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS = 20;
        LASER_CANNON_ENTITY_HIT_ENERGY = 15000;
        LASER_CANNON_ENTITY_HIT_BASE_DAMAGE = 3;
        LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE = 30000;
        LASER_CANNON_ENTITY_HIT_MAX_DAMAGE = 100;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_THRESHOLD = 900000;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH = 4.0f;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH = 125000;
        LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH = 4.0f;
        LASER_CANNON_BLOCK_HIT_ENERGY_MIN = 75000;
        LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_HARDNESS = 150000;
        LASER_CANNON_BLOCK_HIT_ENERGY_MAX = 750000;
        LASER_CANNON_BLOCK_HIT_ABSORPTION_PER_BLOCK_HARDNESS = 0.01;
        LASER_CANNON_BLOCK_HIT_ABSORPTION_MAX = 0.8;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_HARDNESS_THRESHOLD = 5.0f;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH = 8.0f;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH = 125000;
        LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH = 50.0f;
        MINING_LASER_MAX_MEDIUMS_COUNT = 1;
        MINING_LASER_RADIUS_BLOCKS = 5;
        MINING_LASER_WARMUP_DELAY_TICKS = 20;
        MINING_LASER_SCAN_DELAY_TICKS = 20;
        MINING_LASER_MINE_DELAY_TICKS = 3;
        MINING_LASER_SPACE_ENERGY_PER_LAYER = 20000;
        MINING_LASER_PLANET_ENERGY_PER_LAYER = 33000;
        MINING_LASER_SPACE_ENERGY_PER_BLOCK = 1500;
        MINING_LASER_PLANET_ENERGY_PER_BLOCK = 2500;
        MINING_LASER_ORESONLY_ENERGY_FACTOR = 15.0;
        MINING_LASER_SILKTOUCH_ENERGY_FACTOR = 1.5;
        MINING_LASER_SILKTOUCH_DEUTERIUM_L = 0.0;
        MINING_LASER_FORTUNE_ENERGY_FACTOR = 1.5;
        TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM = 3;
        TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM = 2;
        TREE_FARM_totalMaxRadius = 0;
        TREE_FARM_MAX_MEDIUMS_COUNT = 5;
        TREE_FARM_MAX_LOG_DISTANCE = 8;
        TREE_FARM_MAX_LOG_DISTANCE_PER_MEDIUM = 4;
        CLOAKING_MAX_ENERGY_STORED = 500000000;
        CLOAKING_COIL_CAPTURE_BLOCKS = 5;
        CLOAKING_MAX_FIELD_RADIUS = 63;
        CLOAKING_TIER1_ENERGY_PER_BLOCK = 32;
        CLOAKING_TIER2_ENERGY_PER_BLOCK = 128;
        CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS = 3;
        AIRGEN_ENERGY_PER_CANISTER = 200;
        AIRGEN_ENERGY_PER_NEWAIRBLOCK = 12;
        AIRGEN_ENERGY_PER_EXISTINGAIRBLOCK = 4;
        AIRGEN_MAX_ENERGY_STORED = 1400;
        AIRGEN_AIR_GENERATION_TICKS = 40;
        IC2_REACTOR_MAX_ENERGY_STORED = 1000000;
        IC2_REACTOR_ENERGY_PER_HEAT = 2.0;
        IC2_REACTOR_COOLING_INTERVAL_TICKS = 10;
        TRANSPORTER_MAX_ENERGY_STORED = 1000000;
        TRANSPORTER_USE_RELATIVE_COORDS = true;
        TRANSPORTER_ENERGY_PER_BLOCK = 100.0;
        TRANSPORTER_MAX_BOOST_MUL = 4.0;
        ENAN_REACTOR_MAX_ENERGY_STORED = 100000000;
        ENAN_REACTOR_UPDATE_INTERVAL_TICKS = 5;
        ENAN_REACTOR_MAX_LASERS_PER_SECOND = 6;
        ENERGY_BANK_MAX_ENERGY_STORED = new int[]{800000, 4000000, 20000000};
        ENERGY_BANK_IC2_TIER = new int[]{2, 3, 4};
        ENERGY_BANK_TRANSFER_PER_TICK = new int[]{200, 1000, 5000};
        ENERGY_BANK_EFFICIENCY_PER_UPGRADE = new double[]{0.95, 0.98, 1.0};
        LIFT_MAX_ENERGY_STORED = 900;
        LIFT_ENERGY_PER_ENTITY = 150;
        LIFT_UPDATE_INTERVAL_TICKS = 10;
        CL_MAX_ENERGY = 1000000;
        CL_MAX_DISTANCE = 2;
        CL_RF_PER_CHUNKTICK = 320;
        HULL_HARDNESS = new float[]{25.0f, 50.0f, 80.0f};
        HULL_BLAST_RESISTANCE = new float[]{60.0f, 90.0f, 120.0f};
        blockTransformers = null;
    }
}

