/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class CompatThermalExpansion
implements IBlockTransformer {
    private static Class<?> tileEntityTEBase;
    private static final short[] mrot;
    private static final int[] rotFacing;
    private static final byte[] rotLightDefault;
    private static final byte[] rotLightStyle4;

    public static void register() {
        try {
            tileEntityTEBase = Class.forName("cofh.thermalexpansion.block.TileTEBase");
            WarpDriveConfig.registerBlockTransformer("ThermalExpansion", new CompatThermalExpansion());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return tileEntityTEBase.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(TileEntity tileEntity) {
        return null;
    }

    @Override
    public void remove(TileEntity tileEntity) {
    }

    private byte[] rotate_byteArray(byte rotationSteps, byte[] data) {
        byte[] newData = (byte[])data.clone();
        block5: for (int index = 0; index < data.length; ++index) {
            switch (rotationSteps) {
                case 1: {
                    newData[CompatThermalExpansion.mrot[index]] = data[index];
                    continue block5;
                }
                case 2: {
                    newData[CompatThermalExpansion.mrot[CompatThermalExpansion.mrot[index]]] = data[index];
                    continue block5;
                }
                case 3: {
                    newData[CompatThermalExpansion.mrot[CompatThermalExpansion.mrot[CompatThermalExpansion.mrot[index]]]] = data[index];
                    continue block5;
                }
            }
        }
        return newData;
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("Align")) {
            byte style = nbtTileEntity.func_74771_c("Style");
            byte align = nbtTileEntity.func_74771_c("Align");
            if (style == 4) {
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74774_a("Align", rotLightStyle4[align]);
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74774_a("Align", rotLightStyle4[rotLightStyle4[align]]);
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74774_a("Align", rotLightStyle4[rotLightStyle4[rotLightStyle4[align]]]);
                        break;
                    }
                }
            } else {
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74774_a("Align", rotLightDefault[align]);
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74774_a("Align", rotLightDefault[rotLightDefault[align]]);
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74774_a("Align", rotLightDefault[rotLightDefault[rotLightDefault[align]]]);
                        break;
                    }
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("Facing")) {
            int facing = nbtTileEntity.func_74762_e("Facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("Facing", rotFacing[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("Facing", rotFacing[rotFacing[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("Facing", rotFacing[rotFacing[rotFacing[facing]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity.func_74764_b("SideCache")) {
            nbtTileEntity.func_74773_a("SideCache", this.rotate_byteArray(rotationSteps, nbtTileEntity.func_74770_j("SideCache")));
        }
        return metadata;
    }

    @Override
    public void restoreExternals(TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrot = new short[]{0, 1, 5, 4, 2, 3};
        rotFacing = new int[]{0, 1, 5, 4, 2, 3};
        rotLightDefault = new byte[]{0, 1, 5, 4, 2, 3};
        rotLightStyle4 = new byte[]{8, 9, 13, 12, 4, 5, 6, 7, 0, 1, 10, 11, 2, 3, 14, 15};
    }
}

