/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class CompatRedstonePaste
implements IBlockTransformer {
    private static Class<?> classTileEntityRedstonePaste;
    private static final int[] rotFaceIndex;
    private static final int[] rotFaceHorizontal;
    private static final int[] rotFaceVerticalCorner;
    private static final int[] rotFaceDataHorizontal;
    private static final int[] rotFaceDataVerticalCorner;

    public static void register() {
        try {
            classTileEntityRedstonePaste = Class.forName("fyber.redstonepastemod.TileEntityRedstonePaste");
            WarpDriveConfig.registerBlockTransformer("RedstonePasteMod", new CompatRedstonePaste());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classTileEntityRedstonePaste.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(TileEntity tileEntity) {
        return null;
    }

    @Override
    public void remove(TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("faces") && nbtTileEntity.func_74764_b("facedata") && nbtTileEntity.func_74764_b("facetype")) {
            int[] oldFaces = nbtTileEntity.func_74759_k("faces");
            int[] oldFacedata = nbtTileEntity.func_74759_k("facedata");
            int[] oldFacetype = nbtTileEntity.func_74759_k("facetype");
            int[] newFaces = new int[6];
            int[] newFacedata = new int[6];
            int[] newFaceType = new int[6];
            block25: for (int oldIndex = 0; oldIndex < 6; ++oldIndex) {
                int newIndex;
                switch (rotationSteps) {
                    case 1: {
                        newIndex = rotFaceIndex[oldIndex];
                        break;
                    }
                    case 2: {
                        newIndex = rotFaceIndex[rotFaceIndex[oldIndex]];
                        break;
                    }
                    case 3: {
                        newIndex = rotFaceIndex[rotFaceIndex[rotFaceIndex[oldIndex]]];
                        break;
                    }
                    default: {
                        newIndex = oldIndex;
                    }
                }
                newFaceType[newIndex] = oldFacetype[oldIndex];
                switch (oldFacetype[oldIndex]) {
                    case 0: {
                        newFacedata[newIndex] = oldFacedata[oldIndex];
                        if (oldIndex == 0 || oldIndex == 1) {
                            switch (rotationSteps) {
                                case 1: {
                                    newFaces[newIndex] = rotFaceHorizontal[oldFaces[oldIndex]];
                                    continue block25;
                                }
                                case 2: {
                                    newFaces[newIndex] = rotFaceHorizontal[rotFaceHorizontal[oldFaces[oldIndex]]];
                                    continue block25;
                                }
                                case 3: {
                                    newFaces[newIndex] = rotFaceHorizontal[rotFaceHorizontal[rotFaceHorizontal[oldFaces[oldIndex]]]];
                                    continue block25;
                                }
                            }
                            newFaces[newIndex] = oldFaces[oldIndex];
                            continue block25;
                        }
                        if (!(oldIndex != 2 && oldIndex != 5 || newIndex != 2 && newIndex != 5)) {
                            newFaces[newIndex] = oldFaces[oldIndex];
                            continue block25;
                        }
                        if (!(oldIndex != 3 && oldIndex != 4 || newIndex != 3 && newIndex != 4)) {
                            newFaces[newIndex] = oldFaces[oldIndex];
                            continue block25;
                        }
                        newFaces[newIndex] = rotFaceVerticalCorner[oldFaces[oldIndex]];
                        continue block25;
                    }
                    case 2: {
                        newFaces[newIndex] = oldFaces[oldIndex];
                        if (oldIndex == 0 || oldIndex == 1) {
                            switch (rotationSteps) {
                                case 1: {
                                    newFacedata[newIndex] = rotFaceDataHorizontal[oldFacedata[oldIndex]];
                                    continue block25;
                                }
                                case 2: {
                                    newFacedata[newIndex] = rotFaceDataHorizontal[rotFaceDataHorizontal[oldFacedata[oldIndex]]];
                                    continue block25;
                                }
                                case 3: {
                                    newFacedata[newIndex] = rotFaceDataHorizontal[rotFaceDataHorizontal[rotFaceDataHorizontal[oldFacedata[oldIndex]]]];
                                    continue block25;
                                }
                            }
                            newFacedata[newIndex] = oldFacedata[oldIndex];
                            continue block25;
                        }
                        if (!(oldIndex != 2 && oldIndex != 5 || newIndex != 2 && newIndex != 5)) {
                            newFacedata[newIndex] = oldFacedata[oldIndex];
                            continue block25;
                        }
                        if (!(oldIndex != 3 && oldIndex != 4 || newIndex != 3 && newIndex != 4)) {
                            newFacedata[newIndex] = oldFacedata[oldIndex];
                            continue block25;
                        }
                        newFacedata[newIndex] = rotFaceDataVerticalCorner[oldFacedata[oldIndex]];
                        continue block25;
                    }
                    case 3: {
                        newFaces[newIndex] = oldFaces[oldIndex];
                        int rawData = oldFacedata[oldIndex] & 3;
                        int signalStrength = oldFacedata[oldIndex] & 0xFC;
                        if (oldIndex == 0 || oldIndex == 1) {
                            switch (rotationSteps) {
                                case 1: {
                                    newFacedata[newIndex] = rotFaceDataHorizontal[rawData] + signalStrength;
                                    continue block25;
                                }
                                case 2: {
                                    newFacedata[newIndex] = rotFaceDataHorizontal[rotFaceDataHorizontal[rawData]] + signalStrength;
                                    continue block25;
                                }
                                case 3: {
                                    newFacedata[newIndex] = rotFaceDataHorizontal[rotFaceDataHorizontal[rotFaceDataHorizontal[rawData]]] + signalStrength;
                                    continue block25;
                                }
                            }
                            newFacedata[newIndex] = rawData + signalStrength;
                            continue block25;
                        }
                        if (!(oldIndex != 2 && oldIndex != 5 || newIndex != 2 && newIndex != 5)) {
                            newFacedata[newIndex] = rawData + signalStrength;
                            continue block25;
                        }
                        if (!(oldIndex != 3 && oldIndex != 4 || newIndex != 3 && newIndex != 4)) {
                            newFacedata[newIndex] = rawData + signalStrength;
                            continue block25;
                        }
                        newFacedata[newIndex] = rotFaceVerticalCorner[rawData] + signalStrength;
                        continue block25;
                    }
                    default: {
                        newFacedata[newIndex] = oldFacedata[oldIndex];
                        newFaces[newIndex] = oldFaces[oldIndex];
                    }
                }
            }
            nbtTileEntity.func_74783_a("faces", newFaces);
            nbtTileEntity.func_74783_a("facedata", newFacedata);
            nbtTileEntity.func_74783_a("facetype", newFaceType);
        }
        return metadata;
    }

    @Override
    public void restoreExternals(TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFaceIndex = new int[]{0, 1, 5, 4, 2, 3};
        rotFaceHorizontal = new int[]{0, 8, 4, 12, 1, 9, 5, 13, 2, 10, 6, 14, 3, 11, 7, 15};
        rotFaceVerticalCorner = new int[]{0, 1, 2, 3, 8, 9, 10, 11, 4, 5, 6, 7, 12, 13, 14, 15};
        rotFaceDataHorizontal = new int[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 13, 14, 15, 12, 17, 18, 19, 16, 21, 22, 23, 20, 25, 26, 27, 24, 29, 30, 31, 28};
        rotFaceDataVerticalCorner = new int[]{0, 3, 2, 1, 4, 7, 6, 5, 8, 11, 10, 9, 12, 15, 14, 13, 16, 19, 18, 17, 20, 23, 22, 21, 24, 27, 26, 25, 28, 31, 30, 29};
    }
}

