/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class CompatEnderIO
implements IBlockTransformer {
    private static Class<?> classTileEntityEIO;
    private static Class<?> classBlockReservoir;
    private static final short[] mrot;
    private static final Map<String, String> rotSideNames;
    private static final Map<String, String> rotFaceNames;
    private static final short[] rotFront;
    private static final short[] rotRight;
    private static final short[] rotPosHorizontal;

    public static void register() {
        try {
            classTileEntityEIO = Class.forName("crazypants.enderio.TileEntityEio");
            classBlockReservoir = Class.forName("crazypants.enderio.machine.reservoir.BlockReservoir");
            WarpDriveConfig.registerBlockTransformer("EnderIO", new CompatEnderIO());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classTileEntityEIO.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(TileEntity tileEntity) {
        return null;
    }

    @Override
    public void remove(TileEntity tileEntity) {
    }

    private byte[] rotate_byteArray(byte rotationSteps, byte[] data) {
        byte[] newData = (byte[])data.clone();
        block5: for (int index = 0; index < data.length; ++index) {
            switch (rotationSteps) {
                case 1: {
                    newData[CompatEnderIO.mrot[index]] = data[index];
                    continue block5;
                }
                case 2: {
                    newData[CompatEnderIO.mrot[CompatEnderIO.mrot[index]]] = data[index];
                    continue block5;
                }
                case 3: {
                    newData[CompatEnderIO.mrot[CompatEnderIO.mrot[CompatEnderIO.mrot[index]]]] = data[index];
                    continue block5;
                }
            }
        }
        return newData;
    }

    private NBTTagCompound rotate_conduit(byte rotationSteps, NBTTagCompound nbtConduit) {
        NBTTagCompound nbtNewConduit = new NBTTagCompound();
        Set keys = nbtConduit.func_150296_c();
        block14: for (String key : keys) {
            NBTBase base = nbtConduit.func_74781_a(key);
            switch (base.func_74732_a()) {
                case 11: {
                    int[] data = nbtConduit.func_74759_k(key);
                    int[] newData = (int[])data.clone();
                    block15: for (int index = 0; index < data.length; ++index) {
                        switch (rotationSteps) {
                            case 1: {
                                newData[index] = mrot[data[index]];
                                continue block15;
                            }
                            case 2: {
                                newData[index] = mrot[mrot[data[index]]];
                                continue block15;
                            }
                            case 3: {
                                newData[index] = mrot[mrot[mrot[data[index]]]];
                                continue block15;
                            }
                        }
                    }
                    nbtNewConduit.func_74783_a(key, newData);
                    continue block14;
                }
                case 7: {
                    nbtNewConduit.func_74773_a(key, this.rotate_byteArray(rotationSteps, nbtConduit.func_74770_j(key)));
                    continue block14;
                }
            }
            String[] parts = key.split("\\.");
            if (parts.length != 2 || !rotSideNames.containsKey(parts[1])) {
                nbtNewConduit.func_74782_a(key, base);
                continue;
            }
            switch (rotationSteps) {
                case 1: {
                    nbtNewConduit.func_74782_a(parts[0] + "." + rotSideNames.get(parts[1]), base);
                    continue block14;
                }
                case 2: {
                    nbtNewConduit.func_74782_a(parts[0] + "." + rotSideNames.get(rotSideNames.get(parts[1])), base);
                    continue block14;
                }
                case 3: {
                    nbtNewConduit.func_74782_a(parts[0] + "." + rotSideNames.get(rotSideNames.get(rotSideNames.get(parts[1]))), base);
                    continue block14;
                }
            }
            nbtNewConduit.func_74782_a(key, base);
        }
        return nbtNewConduit;
    }

    private void rotateReservoir(NBTTagCompound nbtTileEntity, ITransformation transformation, byte rotationSteps) {
        if (nbtTileEntity.func_74764_b("front")) {
            short front = nbtTileEntity.func_74765_d("front");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74777_a("front", rotFront[front]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74777_a("front", rotFront[rotFront[front]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74777_a("front", rotFront[rotFront[rotFront[front]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity.func_74764_b("right")) {
            short right = nbtTileEntity.func_74765_d("right");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74777_a("right", rotRight[right]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74777_a("right", rotRight[rotRight[right]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74777_a("right", rotRight[rotRight[rotRight[right]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity.func_74764_b("multiblock") && nbtTileEntity.func_74764_b("pos")) {
            int[] oldCoords = nbtTileEntity.func_74759_k("multiblock");
            ChunkCoordinates[] targets = new ChunkCoordinates[oldCoords.length / 3];
            for (int index = 0; index < oldCoords.length / 3; ++index) {
                targets[index] = transformation.apply(oldCoords[3 * index], oldCoords[3 * index + 1], oldCoords[3 * index + 2]);
            }
            if (targets[0].field_71572_b == targets[1].field_71572_b && targets[1].field_71572_b == targets[2].field_71572_b && targets[2].field_71572_b == targets[3].field_71572_b) {
                short pos = nbtTileEntity.func_74765_d("pos");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74777_a("pos", rotPosHorizontal[pos]);
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74777_a("pos", rotPosHorizontal[rotPosHorizontal[pos]]);
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74777_a("pos", rotPosHorizontal[rotPosHorizontal[rotPosHorizontal[pos]]]);
                        break;
                    }
                }
            } else {
                short pos;
                ChunkCoordinates newPos = transformation.apply(nbtTileEntity.func_74762_e("x"), nbtTileEntity.func_74762_e("y"), nbtTileEntity.func_74762_e("z"));
                if (targets[0].field_71574_a == targets[1].field_71574_a && targets[1].field_71574_a == targets[2].field_71574_a && targets[2].field_71574_a == targets[3].field_71574_a) {
                    int minZ = Math.min(targets[0].field_71573_c, Math.min(targets[1].field_71573_c, targets[2].field_71573_c));
                    pos = (short)((nbtTileEntity.func_74765_d("pos") & 2) + (newPos.field_71573_c == minZ ? 1 : 0));
                    nbtTileEntity.func_74777_a("pos", pos);
                } else {
                    int minX = Math.min(targets[0].field_71574_a, Math.min(targets[1].field_71574_a, targets[2].field_71574_a));
                    pos = (short)((nbtTileEntity.func_74765_d("pos") & 2) + (newPos.field_71574_a == minX ? 1 : 0));
                    nbtTileEntity.func_74777_a("pos", pos);
                }
            }
            int[] newCoords = new int[oldCoords.length];
            for (int index = 0; index < oldCoords.length / 3; ++index) {
                newCoords[3 * index] = targets[index].field_71574_a;
                newCoords[3 * index + 1] = targets[index].field_71572_b;
                newCoords[3 * index + 2] = targets[index].field_71573_c;
            }
            nbtTileEntity.func_74783_a("multiblock", newCoords);
        }
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity.func_74764_b("facing")) {
            short facing = nbtTileEntity.func_74765_d("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74777_a("facing", mrot[facing]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74777_a("facing", mrot[mrot[facing]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74777_a("facing", mrot[mrot[mrot[facing]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (classBlockReservoir.isInstance(block)) {
            this.rotateReservoir(nbtTileEntity, transformation, rotationSteps);
        }
        HashMap<String, Short> map = new HashMap<String, Short>();
        for (String string : rotFaceNames.keySet()) {
            if (!nbtTileEntity.func_74764_b(string)) continue;
            short face = nbtTileEntity.func_74765_d(string);
            switch (rotationSteps) {
                case 1: {
                    map.put(rotFaceNames.get(string), face);
                    break;
                }
                case 2: {
                    map.put(rotFaceNames.get(rotFaceNames.get(string)), face);
                    break;
                }
                case 3: {
                    map.put(rotFaceNames.get(rotFaceNames.get(rotFaceNames.get(string))), face);
                    break;
                }
                default: {
                    map.put(string, face);
                }
            }
            nbtTileEntity.func_82580_o(string);
        }
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                nbtTileEntity.func_74777_a((String)entry.getKey(), ((Short)entry.getValue()).shortValue());
            }
        }
        if (nbtTileEntity.func_74764_b("conduits")) {
            NBTTagList nbtConduits = nbtTileEntity.func_150295_c("conduits", 10);
            NBTTagList nBTTagList = new NBTTagList();
            for (int index = 0; index < nbtConduits.func_74745_c(); ++index) {
                NBTTagCompound conduitTypeAndContent = nbtConduits.func_150305_b(index);
                NBTTagCompound newConduitTypeAndContent = new NBTTagCompound();
                newConduitTypeAndContent.func_74778_a("conduitType", conduitTypeAndContent.func_74779_i("conduitType"));
                newConduitTypeAndContent.func_74782_a("conduit", (NBTBase)this.rotate_conduit(rotationSteps, conduitTypeAndContent.func_74775_l("conduit")));
                nBTTagList.func_74742_a((NBTBase)newConduitTypeAndContent);
            }
            nbtTileEntity.func_74782_a("conduits", (NBTBase)nBTTagList);
        }
        return metadata;
    }

    @Override
    public void restoreExternals(TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrot = new short[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("EAST", "SOUTH");
        map.put("SOUTH", "WEST");
        map.put("WEST", "NORTH");
        map.put("NORTH", "EAST");
        rotSideNames = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("face2", "face5");
        map.put("face5", "face3");
        map.put("face3", "face4");
        map.put("face4", "face2");
        map.put("faceDisplay2", "faceDisplay5");
        map.put("faceDisplay5", "faceDisplay3");
        map.put("faceDisplay3", "faceDisplay4");
        map.put("faceDisplay4", "faceDisplay2");
        rotFaceNames = Collections.unmodifiableMap(map);
        rotFront = new short[]{0, 1, 5, 3, 4, 2, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotRight = new short[]{0, 1, 4, 3, 2, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotPosHorizontal = new short[]{1, 3, 0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

