/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class CompatBiblioCraft
implements IBlockTransformer {
    private static Class<?> classBlockArmorStand;
    private static Class<?> classBlockPrintingPress;
    private static final byte[] mrotArmorStand;
    private static final int[] rotAngle;
    private static final int[] rotCaseAngle;

    public static void register() {
        try {
            classBlockArmorStand = Class.forName("jds.bibliocraft.blocks.BlockArmorStand");
            classBlockPrintingPress = Class.forName("jds.bibliocraft.blocks.BlockPrintPress");
            WarpDriveConfig.registerBlockTransformer("BiblioCraft", new CompatBiblioCraft());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        if (block == null) {
            return false;
        }
        String canonicalName = block.getClass().getCanonicalName();
        return canonicalName != null && canonicalName.startsWith("jds.bibliocraft.");
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(TileEntity tileEntity) {
        return null;
    }

    @Override
    public void remove(TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockArmorStand.isInstance(block) || classBlockPrintingPress.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotArmorStand[metadata];
                }
                case 2: {
                    return mrotArmorStand[mrotArmorStand[metadata]];
                }
                case 3: {
                    return mrotArmorStand[mrotArmorStand[mrotArmorStand[metadata]]];
                }
            }
            return metadata;
        }
        String key = null;
        if (nbtTileEntity.func_74764_b("angle")) {
            key = "angle";
        } else if (nbtTileEntity.func_74764_b("Angle")) {
            key = "Angle";
        } else if (nbtTileEntity.func_74764_b("deskAngle")) {
            key = "deskAngle";
        } else if (nbtTileEntity.func_74764_b("labelAngle")) {
            key = "labelAngle";
        } else if (nbtTileEntity.func_74764_b("bookcaseAngle")) {
            key = "bookcaseAngle";
        } else if (nbtTileEntity.func_74764_b("rackAngle")) {
            key = "rackAngle";
        } else if (nbtTileEntity.func_74764_b("genericShelfAngle")) {
            key = "genericShelfAngle";
        } else if (nbtTileEntity.func_74764_b("potionshelfAngle")) {
            key = "potionshelfAngle";
        }
        if (key != null) {
            int angle = nbtTileEntity.func_74762_e(key);
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a(key, rotAngle[angle]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a(key, rotAngle[rotAngle[angle]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a(key, rotAngle[rotAngle[rotAngle[angle]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("caseAngle")) {
            int angle = nbtTileEntity.func_74762_e("caseAngle");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("caseAngle", rotCaseAngle[angle]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("caseAngle", rotCaseAngle[rotCaseAngle[angle]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("caseAngle", rotCaseAngle[rotCaseAngle[rotCaseAngle[angle]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotArmorStand = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 8, 9, 10, 11, 12, 13, 14, 15};
        rotAngle = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotCaseAngle = new int[]{0, 1, 2, 3, 5, 6, 7, 4, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

