/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.world.SpaceTeleporter;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;

public class CommandSpace
extends CommandBase {
    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "space";
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_71515_b(ICommandSender sender, String[] params) {
        if (sender == null) {
            return;
        }
        MinecraftServer server = MinecraftServer.func_71276_C();
        int targetDimensionId = Integer.MAX_VALUE;
        EntityPlayerMP[] entityPlayerMPs = null;
        if (sender instanceof EntityPlayerMP) {
            entityPlayerMPs = new EntityPlayerMP[]{(EntityPlayerMP)sender};
        }
        if (params.length != 0) {
            EntityPlayerMP[] entityPlayerMPs_found;
            if (params.length == 1) {
                if (params[0].equalsIgnoreCase("help") || params[0].equalsIgnoreCase("?")) {
                    WarpDrive.addChatMessage(sender, this.func_71518_a(sender));
                    return;
                }
                entityPlayerMPs_found = this.getOnlinePlayerByNameOrSelector(sender, params[0]);
                if (entityPlayerMPs_found != null) {
                    entityPlayerMPs = entityPlayerMPs_found;
                } else {
                    if (!(sender instanceof EntityPlayer)) {
                        WarpDrive.addChatMessage(sender, "/space: player not found '" + params[0] + "'");
                        return;
                    }
                    targetDimensionId = this.getDimensionId(params[0]);
                }
            } else {
                if (params.length != 2) {
                    WarpDrive.addChatMessage(sender, "/space: too many arguments " + params.length);
                    return;
                }
                entityPlayerMPs_found = this.getOnlinePlayerByNameOrSelector(sender, params[0]);
                if (entityPlayerMPs_found == null) {
                    WarpDrive.addChatMessage(sender, "/space: player not found '" + params[0] + "'");
                    return;
                }
                entityPlayerMPs = entityPlayerMPs_found;
                targetDimensionId = this.getDimensionId(params[1]);
            }
        }
        if (entityPlayerMPs == null || entityPlayerMPs.length <= 0) {
            WarpDrive.addChatMessage(sender, "/space: undefined player");
            return;
        }
        EntityPlayerMP[] entityPlayerMPArray = entityPlayerMPs;
        int n = entityPlayerMPArray.length;
        int n2 = 0;
        while (n2 < n) {
            int newZ;
            int newY;
            int newX;
            WorldServer targetWorld;
            EntityPlayerMP entityPlayerMP = entityPlayerMPArray[n2];
            if (targetDimensionId == Integer.MAX_VALUE) {
                targetDimensionId = entityPlayerMP.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID ? 0 : WarpDriveConfig.G_SPACE_DIMENSION_ID;
            }
            if ((targetWorld = server.func_71218_a(targetDimensionId)) == null) {
                WarpDrive.addChatMessage(sender, "/space: undefined dimension '" + targetDimensionId + "'");
                return;
            }
            String message = "Teleporting player " + entityPlayerMP.func_70005_c_() + " to dimension " + targetDimensionId + "...";
            WarpDrive.addChatMessage(sender, message);
            WarpDrive.logger.info(message);
            if (sender != entityPlayerMP) {
                WarpDrive.addChatMessage((ICommandSender)entityPlayerMP, sender.func_70005_c_() + " is teleporting you to dimension " + targetDimensionId);
            }
            if (targetWorld.func_147437_c(newX = MathHelper.func_76128_c((double)entityPlayerMP.field_70165_t), (newY = Math.min(255, Math.max(0, MathHelper.func_76128_c((double)entityPlayerMP.field_70163_u)))) - 1, newZ = MathHelper.func_76128_c((double)entityPlayerMP.field_70161_v)) && !entityPlayerMP.field_71075_bZ.field_75101_c || !targetWorld.func_147437_c(newX, newY, newZ) || !targetWorld.func_147437_c(newX, newY + 1, newZ)) {
                newY = targetWorld.func_72825_h(newX, newZ) + 1;
                if (newY == 0) {
                    newY = 128;
                } else {
                    for (int safeY = newY - 3; safeY > Math.max(1, newY - 20); --safeY) {
                        if (targetWorld.func_147437_c(newX, safeY - 1, newZ) || !targetWorld.func_147437_c(newX, safeY, newZ) || !targetWorld.func_147437_c(newX, safeY + 1, newZ)) continue;
                        newY = safeY;
                        break;
                    }
                }
            }
            SpaceTeleporter teleporter = new SpaceTeleporter(targetWorld, 0, newX, newY, newZ);
            server.func_71203_ab().transferPlayerToDimension(entityPlayerMP, targetDimensionId, (Teleporter)teleporter);
            entityPlayerMP.func_70634_a((double)newX + 0.5, (double)newY + 0.2, (double)newZ + 0.5);
            entityPlayerMP.func_71016_p();
            ++n2;
        }
        return;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/space (<playerName>) ([overworld|nether|end|theend|space|hyper|hyperspace|<dimensionId>])";
    }

    private EntityPlayerMP[] getOnlinePlayerByNameOrSelector(ICommandSender sender, String playerNameOrSelector) {
        List onlinePlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayer onlinePlayer : onlinePlayers) {
            if (!onlinePlayer.func_70005_c_().equalsIgnoreCase(playerNameOrSelector) || !(onlinePlayer instanceof EntityPlayerMP)) continue;
            return new EntityPlayerMP[]{(EntityPlayerMP)onlinePlayer};
        }
        EntityPlayerMP[] entityPlayerMPs_found = PlayerSelector.func_82380_c((ICommandSender)sender, (String)playerNameOrSelector);
        if (entityPlayerMPs_found != null && entityPlayerMPs_found.length > 0) {
            return (EntityPlayerMP[])entityPlayerMPs_found.clone();
        }
        return null;
    }

    private int getDimensionId(String stringDimension) {
        if (stringDimension.equalsIgnoreCase("overworld")) {
            return 0;
        }
        if (stringDimension.equalsIgnoreCase("nether")) {
            return -1;
        }
        if (stringDimension.equalsIgnoreCase("end") || stringDimension.equalsIgnoreCase("theend")) {
            return 1;
        }
        if (stringDimension.equalsIgnoreCase("space")) {
            return WarpDriveConfig.G_SPACE_DIMENSION_ID;
        }
        if (stringDimension.equalsIgnoreCase("hyper") || stringDimension.equalsIgnoreCase("hyperspace")) {
            return WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID;
        }
        try {
            return Integer.parseInt(stringDimension);
        }
        catch (Exception exception) {
            WarpDrive.logger.info("/space: invalid dimension '" + stringDimension + "', expecting integer or overworld/nether/end/theend/space/hyper/hyperspace");
            return 0;
        }
    }
}

