/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.DamageTeleportation;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.UpgradeType;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemUpgrade;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTransporter
extends TileEntityAbstractEnergy {
    private double scanRange = 2.0;
    private int scanDist = 4;
    private double beaconEffect = 0.0;
    private double powerBoost = 1.0;
    private double baseLockStrength = -1.0;
    private double lockStrengthMul = 1.0;
    private boolean isLocked = false;
    private static final Vector3 centreOnMe = new Vector3(0.5, 1.0, 0.5);
    private Vector3 sourceVec = new Vector3();
    private Vector3 destVec = new Vector3();
    private DamageTeleportation damageTeleportation = new DamageTeleportation();

    public TileEntityTransporter() {
        this.IC2_sinkTier = 2;
        this.IC2_sourceTier = 2;
        this.peripheralName = "warpdriveTransporter";
        this.addMethods(new String[]{"source", "dest", "lock", "release", "lockStrength", "energize", "powerBoost", "getEnergyRequired", "upgrades"});
        this.setUpgradeMaxCount(ItemUpgrade.getItemStack(UpgradeType.Energy), 2);
        this.setUpgradeMaxCount(ItemUpgrade.getItemStack(UpgradeType.Power), 4);
        this.setUpgradeMaxCount(ItemUpgrade.getItemStack(UpgradeType.Range), 4);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.isLocked) {
            this.lockStrengthMul = this.lockStrengthMul > 0.8 ? (this.lockStrengthMul *= 0.995) : (this.lockStrengthMul *= 0.98);
        }
    }

    @Override
    public String getStatus() {
        return super.getStatus() + "\n" + StatCollector.func_74837_a((String)"warpdrive.transporter.status", (Object[])new Object[]{this.sourceVec.x, this.sourceVec.y, this.sourceVec.z, this.destVec.x, this.destVec.y, this.destVec.z});
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] source(Context context, Arguments arguments) {
        return this.setVec3(true, this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] dest(Context context, Arguments arguments) {
        return this.setVec3(false, this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] lock(Context context, Arguments arguments) {
        return new Object[]{this.lock(this.sourceVec, this.destVec)};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] release(Context context, Arguments arguments) {
        this.unlock();
        return new Object[]{null};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] lockStrength(Context context, Arguments arguments) {
        return new Object[]{this.getLockStrength()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] energize(Context context, Arguments arguments) {
        return new Object[]{this.energize()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] powerBoost(Context context, Arguments arguments) {
        return new Object[]{this.powerBoost(this.argumentsOCtoCC(arguments))};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyRequired(Context context, Arguments arguments) {
        return new Object[]{this.getEnergyRequired()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] help(Context context, Arguments arguments) {
        return new Object[]{TileEntityTransporter.helpStr(this.argumentsOCtoCC(arguments))};
    }

    private static String helpStr(Object[] function) {
        if (function != null && function.length > 0) {
            String methodName;
            switch (methodName = function[0].toString().toLowerCase()) {
                case "source": {
                    if (WarpDriveConfig.TRANSPORTER_USE_RELATIVE_COORDS) {
                        return "source(x,y,z): sets the coordinates (relative to the transporter) to teleport from\ndest(): returns the relative x,y,z coordinates of the source";
                    }
                    return "source(x,y,z): sets the absolute coordinates to teleport from\ndest(): returns the x,y,z coordinates of the source";
                }
                case "dest": {
                    if (WarpDriveConfig.TRANSPORTER_USE_RELATIVE_COORDS) {
                        return "dest(x,y,z): sets the coordinates (relative to the transporter) to teleport to\ndest(): returns the relative x,y,z coordinates of the destination";
                    }
                    return "dest(x,y,z): sets the absolute coordinates to teleport to\ndest(): returns the x,y,z coordinates of the destination";
                }
                case "lock": {
                    return "lock(): locks the source and dest coordinates in and returns the lock strength (float)";
                }
                case "release": {
                    return "release(): releases the current lock";
                }
                case "lockstrength": {
                    return "lockStrength(): returns the current lock strength (float)";
                }
                case "energize": {
                    return "energize(): attempts to teleport all entities at source to dest. Returns the number of entities transported (-1 indicates a problem).";
                }
                case "powerboost": {
                    return "powerBoost(boostAmount): sets the level of power to use (1 being default), returns the level of power\npowerBoost(): returns the level of power";
                }
                case "getEnergyRequired": {
                    return "getEnergyRequired(): returns the amount of energy it will take for a single entity to transport with the current settings";
                }
            }
        }
        return null;
    }

    private Object[] setVec3(boolean src, Object ... arguments) {
        Vector3 vec;
        Vector3 vector3 = vec = src ? this.sourceVec : this.destVec;
        if (vec == null) {
            Vector3 sV;
            Vector3 vector32 = sV = WarpDriveConfig.TRANSPORTER_USE_RELATIVE_COORDS ? new Vector3(this) : new Vector3(0.0, 0.0, 0.0);
            if (src) {
                this.sourceVec = sV;
            } else {
                this.destVec = sV;
            }
            vec = src ? this.sourceVec : this.destVec;
        }
        try {
            if (arguments.length >= 3) {
                this.unlock();
                vec.x = TileEntityTransporter.toDouble(arguments[0]);
                vec.y = TileEntityTransporter.toDouble(arguments[1]);
                vec.z = TileEntityTransporter.toDouble(arguments[2]);
            } else if (arguments.length == 1) {
                this.unlock();
                if (WarpDriveConfig.TRANSPORTER_USE_RELATIVE_COORDS) {
                    vec.x = TileEntityTransporter.centreOnMe.x;
                    vec.y = TileEntityTransporter.centreOnMe.y;
                    vec.z = TileEntityTransporter.centreOnMe.z;
                } else {
                    vec.x = (double)this.field_145851_c + TileEntityTransporter.centreOnMe.x;
                    vec.y = (double)this.field_145848_d + TileEntityTransporter.centreOnMe.y;
                    vec.z = (double)this.field_145849_e + TileEntityTransporter.centreOnMe.z;
                }
            }
        }
        catch (NumberFormatException e) {
            return this.setVec3(src, "this");
        }
        return new Object[]{vec.x, vec.y, vec.z};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "source": {
                return this.setVec3(true, arguments);
            }
            case "dest": {
                return this.setVec3(false, arguments);
            }
            case "lock": {
                return new Object[]{this.lock(this.sourceVec, this.destVec)};
            }
            case "release": {
                this.unlock();
                return null;
            }
            case "lockStrength": {
                return new Object[]{this.getLockStrength()};
            }
            case "energize": {
                return new Object[]{this.energize()};
            }
            case "powerBoost": {
                return new Object[]{this.powerBoost(arguments)};
            }
            case "getEnergyRequired": {
                return new Object[]{this.getEnergyRequired()};
            }
            case "help": {
                return new Object[]{TileEntityTransporter.helpStr(arguments)};
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    private Integer getEnergyRequired() {
        if (this.sourceVec != null && this.destVec != null) {
            return (int)Math.ceil(Math.pow(3.0, this.powerBoost - 1.0) * WarpDriveConfig.TRANSPORTER_ENERGY_PER_BLOCK * this.sourceVec.distanceTo(this.destVec));
        }
        return null;
    }

    private double powerBoost(Object[] arguments) {
        try {
            if (arguments.length >= 1) {
                this.powerBoost = TileEntityTransporter.clamp(1.0, WarpDriveConfig.TRANSPORTER_MAX_BOOST_MUL, TileEntityTransporter.toDouble(arguments[0]));
            }
        }
        catch (NumberFormatException e) {
            this.powerBoost = 1.0;
        }
        return this.powerBoost;
    }

    private int energize() {
        if (this.isLocked) {
            int count = 0;
            double ls = this.getLockStrength();
            if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                WarpDrive.logger.info(this + " lock strength " + this.getLockStrength());
            }
            ArrayList<Entity> entitiesToTransport = this.findEntities(this.sourceVec, ls);
            Integer energyRequired = this.getEnergyRequired();
            if (energyRequired == null) {
                return -1;
            }
            Vector3 modDest = this.destVec.clone().translate(centreOnMe);
            for (Entity ent : entitiesToTransport) {
                if (this.energy_consume(energyRequired, false)) {
                    if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                        WarpDrive.logger.info(this + " Transporting entity " + ent.func_145782_y());
                    }
                    this.inflictNegativeEffect(ent, ls);
                    this.transportEnt(ent, modDest);
                    ++count;
                    continue;
                }
                if (!WarpDriveConfig.LOGGING_TRANSPORTER) break;
                WarpDrive.logger.info(this + " Insufficient energy to transport entity " + ent.func_145782_y());
                break;
            }
            return count;
        }
        return -1;
    }

    private void transportEnt(Entity ent, Vector3 dest) {
        if (ent instanceof EntityLivingBase) {
            EntityLivingBase livingEnt = (EntityLivingBase)ent;
            if (WarpDriveConfig.TRANSPORTER_USE_RELATIVE_COORDS) {
                livingEnt.func_70634_a((double)this.field_145851_c + dest.x, (double)this.field_145848_d + dest.y, (double)this.field_145849_e + dest.z);
            } else {
                livingEnt.func_70634_a(dest.x, dest.y, dest.z);
            }
        } else if (WarpDriveConfig.TRANSPORTER_USE_RELATIVE_COORDS) {
            ent.func_70107_b((double)this.field_145851_c + dest.x, (double)this.field_145848_d + dest.y, (double)this.field_145849_e + dest.z);
        } else {
            ent.func_70107_b(dest.x, dest.y, dest.z);
        }
    }

    private void inflictNegativeEffect(Entity ent, double lockStrength) {
        double value = Math.random() + lockStrength;
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(this + " Inflicting negative effect " + value);
        }
        if (value < 0.1) {
            ent.func_70097_a((DamageSource)this.damageTeleportation, 1000.0f);
        }
        if (value < 0.2) {
            ent.func_70097_a((DamageSource)this.damageTeleportation, 10.0f);
        }
        if (value < 0.5) {
            ent.func_70097_a((DamageSource)this.damageTeleportation, 1.0f);
        }
    }

    private double beaconScan(int xV, int yV, int zV) {
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(this + "BeaconScan:" + xV + "," + yV + "," + zV);
        }
        double beacon = 0.0;
        int beaconCount = 0;
        int xL = xV - this.scanDist;
        int xU = xV + this.scanDist;
        int yL = yV - this.scanDist;
        int yU = yV + this.scanDist;
        int zL = zV - this.scanDist;
        int zU = zV + this.scanDist;
        for (int x = xL; x <= xU; ++x) {
            for (int y = yL; y <= yU; ++y) {
                if (y < 0 || y > 254) continue;
                for (int z = zL; z <= zU; ++z) {
                    if (!this.field_145850_b.func_147439_a(x, y, z).func_149667_c(WarpDrive.blockTransportBeacon)) continue;
                    double dist = 1 + Math.abs(x - xV) + Math.abs(y - yV) + Math.abs(z - zV);
                    ++beaconCount;
                    if (this.field_145850_b.func_72805_g(x, y, z) == 0) {
                        beacon += 1.0 / dist;
                        continue;
                    }
                    beacon -= 1.0 / dist;
                }
            }
        }
        if (beaconCount > 0) {
            beacon /= Math.sqrt(beaconCount);
        }
        return beacon;
    }

    private double beaconScan(Vector3 s, Vector3 d) {
        s = this.absoluteVector(s);
        d = this.absoluteVector(d);
        return this.beaconScan(TileEntityTransporter.toInt(s.x), TileEntityTransporter.toInt(s.y), TileEntityTransporter.toInt(s.z)) + this.beaconScan(TileEntityTransporter.toInt(d.x), TileEntityTransporter.toInt(d.y), TileEntityTransporter.toInt(d.z));
    }

    private Vector3 absoluteVector(Vector3 a) {
        if (WarpDriveConfig.TRANSPORTER_USE_RELATIVE_COORDS) {
            return a.clone().translate(new Vector3(this));
        }
        return a;
    }

    private double calculatePower(Vector3 d) {
        Vector3 myCoords = WarpDriveConfig.TRANSPORTER_USE_RELATIVE_COORDS ? centreOnMe : new Vector3(this).translate(centreOnMe);
        return TileEntityTransporter.calculatePower(myCoords, d);
    }

    private static double calculatePower(Vector3 s, Vector3 d) {
        double dist = s.distanceTo(d);
        return TileEntityTransporter.clamp(0.0, 1.0, Math.pow(Math.E, -dist / 300.0));
    }

    private static double min(double ... ds) {
        double curMin = Double.MAX_VALUE;
        for (double d : ds) {
            curMin = Math.min(curMin, d);
        }
        return curMin;
    }

    private double getLockStrength() {
        if (this.isLocked) {
            int rangeUgrades = this.getUpgradeCount(ItemUpgrade.getItemStack(UpgradeType.Range));
            double upgradeBoost = Math.pow(1.2, rangeUgrades);
            return TileEntityTransporter.clamp(0.0, 1.0, this.baseLockStrength * this.lockStrengthMul * Math.pow(2.0, this.powerBoost - 1.0) * upgradeBoost * (1.0 + this.beaconEffect));
        }
        return -1.0;
    }

    private void unlock() {
        this.isLocked = false;
        this.baseLockStrength = 0.0;
    }

    private double lock(Vector3 source, Vector3 dest) {
        if (source != null && dest != null) {
            double basePower = TileEntityTransporter.min(this.calculatePower(source), this.calculatePower(dest), TileEntityTransporter.calculatePower(source, dest));
            this.beaconEffect = this.beaconScan(source, dest);
            this.baseLockStrength = basePower;
            this.lockStrengthMul = 1.0;
            this.isLocked = true;
            if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                WarpDrive.logger.info(this + " Beacon effect " + this.beaconEffect + " Lock strength " + this.baseLockStrength + "," + this.getLockStrength());
            }
            return this.getLockStrength();
        }
        this.unlock();
        return 0.0;
    }

    private AxisAlignedBB getAABB() {
        Vector3 tS = new Vector3(this);
        Vector3 bS = new Vector3(this);
        Vector3 scanPos = new Vector3(this.scanRange / 2.0, 2.0, this.scanRange / 2.0);
        Vector3 scanNeg = new Vector3(-this.scanRange / 2.0, -1.0, -this.scanRange / 2.0);
        if (WarpDriveConfig.TRANSPORTER_USE_RELATIVE_COORDS) {
            tS.translate(this.sourceVec).translate(scanPos);
            bS.translate(this.sourceVec).translate(scanNeg);
        } else {
            tS = this.sourceVec.clone().translate(scanPos);
            bS = this.sourceVec.clone().translate(scanNeg);
        }
        return AxisAlignedBB.func_72330_a((double)bS.x, (double)bS.y, (double)bS.z, (double)tS.x, (double)tS.y, (double)tS.z);
    }

    private ArrayList<Entity> findEntities(Vector3 source, double lockStrength) {
        AxisAlignedBB bb = this.getAABB();
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(this + " Transporter:" + bb);
        }
        List data = this.field_145850_b.func_72839_b(null, bb);
        ArrayList<Entity> output = new ArrayList<Entity>(data.size());
        for (Object entity : data) {
            if (lockStrength >= 1.0 || this.field_145850_b.field_73012_v.nextDouble() < lockStrength) {
                if (!(entity instanceof Entity)) continue;
                if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                    WarpDrive.logger.info(this + " Entity '" + entity + "' found and added");
                }
                output.add((Entity)entity);
                continue;
            }
            if (!WarpDriveConfig.LOGGING_TRANSPORTER) continue;
            WarpDrive.logger.info(this + " Entity '" + entity + "' discarded");
        }
        return output;
    }

    @Override
    public int energy_getMaxStorage() {
        int energyUgrades = this.getUpgradeCount(ItemUpgrade.getItemStack(UpgradeType.Energy));
        int max = (int)Math.floor((double)WarpDriveConfig.TRANSPORTER_MAX_ENERGY_STORED * Math.pow(1.2, energyUgrades));
        return max;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74780_a("powerBoost", this.powerBoost);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.powerBoost = tag.func_74769_h("powerBoost");
    }
}

