/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.VectorI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Arrays;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;

public class TileEntityShipController
extends TileEntityAbstractInterfaced {
    private int distance = 0;
    private int direction = 0;
    private int moveFront = 0;
    private int moveUp = 0;
    private int moveRight = 0;
    private byte rotationSteps = 0;
    private TileEntityShipCore.EnumShipCoreMode mode = TileEntityShipCore.EnumShipCoreMode.IDLE;
    private boolean jumpFlag = false;
    private boolean summonFlag = false;
    private String toSummon = "";
    private String targetJumpgateName = "";
    private int front;
    private int right;
    private int up;
    private int back;
    private int left;
    private int down;
    public final ArrayList<String> players = new ArrayList();
    public String playersString = "";
    private String beaconFrequency = "";
    boolean ready = false;
    private final int updateInterval_ticks;
    private int updateTicks = this.updateInterval_ticks = 20 * WarpDriveConfig.SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS;
    private int bootTicks = 20;
    private TileEntityShipCore core = null;

    public TileEntityShipController() {
        this.peripheralName = "warpdriveShipController";
        this.addMethods(new String[]{"dim_positive", "dim_negative", "mode", "distance", "direction", "energy", "getAttachedPlayers", "summon", "summon_all", "jump", "getShipSize", "beaconFrequency", "getOrientation", "coreFrequency", "isInSpace", "isInHyperspace", "targetJumpgate", "isAttached", "getEnergyRequired", "movement", "rotationSteps"});
        this.CC_scripts = Arrays.asList("startup");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.bootTicks > 0) {
            --this.bootTicks;
            if (this.core == null) {
                this.updateTicks = 1;
            }
        }
        --this.updateTicks;
        if (this.updateTicks <= 0) {
            this.updateTicks = this.updateInterval_ticks;
            this.core = this.findCoreBlock();
            if (this.core != null) {
                if (this.mode.getCode() != this.func_145832_p()) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.mode.getCode(), 3);
                }
            } else if (this.func_145832_p() != 0) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            }
        }
    }

    private void setMode(int mode) {
        TileEntityShipCore.EnumShipCoreMode[] modes = TileEntityShipCore.EnumShipCoreMode.values();
        if (mode >= 0 && mode <= modes.length) {
            this.mode = modes[mode];
            this.func_70296_d();
            if (WarpDriveConfig.LOGGING_JUMP && this.field_145850_b != null) {
                WarpDrive.logger.info(this + " Mode set to " + (Object)((Object)this.mode) + " (" + this.mode.getCode() + ")");
            }
        }
    }

    private void setDirection(int parDirection) {
        this.direction = parDirection == 1 ? -1 : (parDirection == 2 ? -2 : (parDirection == 255 ? 270 : parDirection));
        this.func_70296_d();
        if (WarpDriveConfig.LOGGING_JUMP && this.field_145850_b != null) {
            WarpDrive.logger.info(this + " Direction set to " + this.direction);
        }
    }

    private void setMovement(int parMoveFront, int parMoveUp, int parMoveRight) {
        this.moveFront = parMoveFront;
        this.moveUp = parMoveUp;
        this.moveRight = parMoveRight;
        this.func_70296_d();
        if (WarpDriveConfig.LOGGING_JUMP && this.field_145850_b != null) {
            WarpDrive.logger.info(this + " Movement set to " + this.moveFront + " front, " + this.moveUp + " up, " + this.moveRight + " right");
        }
    }

    private void setRotationSteps(byte parRotationSteps) {
        this.rotationSteps = (byte)((parRotationSteps + 4) % 4);
        this.func_70296_d();
        if (WarpDriveConfig.LOGGING_JUMP && this.field_145850_b != null) {
            WarpDrive.logger.info(this + " RotationSteps set to " + this.rotationSteps);
        }
    }

    private void doJump() {
        if (this.core != null) {
            this.core.randomWarmupAddition = this.field_145850_b.field_73012_v.nextInt(WarpDriveConfig.SHIP_WARMUP_RANDOM_TICKS);
        } else {
            WarpDrive.logger.error(this + " doJump without a core");
        }
        this.setJumpFlag(true);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setMode(tag.func_74762_e("mode"));
        this.setFront(tag.func_74762_e("front"));
        this.setRight(tag.func_74762_e("right"));
        this.setUp(tag.func_74762_e("up"));
        this.setBack(tag.func_74762_e("back"));
        this.setLeft(tag.func_74762_e("left"));
        this.setDown(tag.func_74762_e("down"));
        this.setDistance(tag.func_74762_e("distance"));
        this.setDirection(tag.func_74762_e("direction"));
        this.setMovement(tag.func_74762_e("moveFront"), tag.func_74762_e("moveUp"), tag.func_74762_e("moveRight"));
        this.setRotationSteps(tag.func_74771_c("rotationSteps"));
        this.playersString = tag.func_74779_i("players");
        this.updatePlayersList();
        this.setBeaconFrequency(tag.func_74779_i("bfreq"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.updatePlayersString();
        tag.func_74778_a("players", this.playersString);
        tag.func_74768_a("mode", this.mode.getCode());
        tag.func_74768_a("front", this.front);
        tag.func_74768_a("right", this.right);
        tag.func_74768_a("up", this.up);
        tag.func_74768_a("back", this.back);
        tag.func_74768_a("left", this.left);
        tag.func_74768_a("down", this.down);
        tag.func_74768_a("distance", this.distance);
        tag.func_74768_a("direction", this.direction);
        tag.func_74768_a("moveFront", this.moveFront);
        tag.func_74768_a("moveUp", this.moveUp);
        tag.func_74768_a("moveRight", this.moveRight);
        tag.func_74774_a("rotationSteps", this.rotationSteps);
        tag.func_74778_a("bfreq", this.getBeaconFrequency());
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.writeItemDropNBT(nbtTagCompound);
        nbtTagCompound.func_82580_o("players");
        nbtTagCompound.func_82580_o("mode");
        nbtTagCompound.func_82580_o("front");
        nbtTagCompound.func_82580_o("right");
        nbtTagCompound.func_82580_o("up");
        nbtTagCompound.func_82580_o("back");
        nbtTagCompound.func_82580_o("left");
        nbtTagCompound.func_82580_o("down");
        nbtTagCompound.func_82580_o("distance");
        nbtTagCompound.func_82580_o("direction");
        nbtTagCompound.func_82580_o("moveFront");
        nbtTagCompound.func_82580_o("moveUp");
        nbtTagCompound.func_82580_o("moveRight");
        nbtTagCompound.func_82580_o("rotationSteps");
        nbtTagCompound.func_82580_o("bfreq");
        return nbtTagCompound;
    }

    public String attachPlayer(EntityPlayer entityPlayer) {
        for (int i = 0; i < this.players.size(); ++i) {
            String name = this.players.get(i);
            if (!entityPlayer.getDisplayName().equals(name)) continue;
            this.players.remove(i);
            return StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{this.func_145838_q().func_149732_F()}) + StatCollector.func_74837_a((String)"warpdrive.ship.playerDetached", (Object[])new Object[]{this.core != null && !this.core.shipName.isEmpty() ? this.core.shipName : "-", this.getAttachedPlayersList()});
        }
        entityPlayer.func_70097_a(DamageSource.field_76377_j, 1.0f);
        this.players.add(entityPlayer.getDisplayName());
        this.updatePlayersString();
        return StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{this.func_145838_q().func_149732_F()}) + StatCollector.func_74837_a((String)"warpdrive.ship.playerAttached", (Object[])new Object[]{this.core != null && !this.core.shipName.isEmpty() ? this.core.shipName : "-", this.getAttachedPlayersList()});
    }

    @Override
    public String getStatus() {
        return super.getStatus() + StatCollector.func_74837_a((String)"warpdrive.ship.attachedPlayers", (Object[])new Object[]{this.getAttachedPlayersList()});
    }

    public void updatePlayersString() {
        this.playersString = "";
        for (int i = 0; i < this.players.size(); ++i) {
            String nick = this.players.get(i);
            this.playersString = this.playersString + nick + "|";
        }
    }

    public void updatePlayersList() {
        String[] playersArray = this.playersString.split("\\|");
        for (int i = 0; i < playersArray.length; ++i) {
            String nick = playersArray[i];
            if (nick.isEmpty()) continue;
            this.players.add(nick);
        }
    }

    public String getAttachedPlayersList() {
        StringBuilder list = new StringBuilder("");
        for (int i = 0; i < this.players.size(); ++i) {
            String nick = this.players.get(i);
            list.append(nick + (i == this.players.size() - 1 ? "" : ", "));
        }
        if (this.players.isEmpty()) {
            list = new StringBuilder("<nobody>");
        }
        return list.toString();
    }

    public boolean isJumpFlag() {
        return this.jumpFlag;
    }

    public void setJumpFlag(boolean jumpFlag) {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " setJumpFlag(" + jumpFlag + ")");
        }
        this.jumpFlag = jumpFlag;
    }

    public int getFront() {
        return this.front;
    }

    private void setFront(int front) {
        this.front = front;
    }

    public int getRight() {
        return this.right;
    }

    private void setRight(int right) {
        this.right = right;
    }

    public int getUp() {
        return this.up;
    }

    private void setUp(int up) {
        this.up = up;
    }

    public int getBack() {
        return this.back;
    }

    private void setBack(int back) {
        this.back = back;
    }

    public int getLeft() {
        return this.left;
    }

    private void setLeft(int left) {
        this.left = left;
    }

    public int getDown() {
        return this.down;
    }

    private void setDown(int down) {
        this.down = down;
    }

    private void setDistance(int distance) {
        this.distance = Math.max(1, Math.min(WarpDriveConfig.SHIP_MAX_JUMP_DISTANCE, distance));
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Jump distance set to " + distance);
        }
    }

    public int getDistance() {
        return this.distance;
    }

    public int getDirection() {
        return this.direction;
    }

    public byte getRotationSteps() {
        return this.rotationSteps;
    }

    public TileEntityShipCore.EnumShipCoreMode getMode() {
        return this.mode;
    }

    public boolean isSummonAllFlag() {
        return this.summonFlag;
    }

    public void setSummonAllFlag(boolean summonFlag) {
        this.summonFlag = summonFlag;
    }

    public String getToSummon() {
        return this.toSummon;
    }

    public void setToSummon(String toSummon) {
        this.toSummon = toSummon;
    }

    public String getBeaconFrequency() {
        return this.beaconFrequency;
    }

    public void setBeaconFrequency(String beaconFrequency) {
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(this + " Beacon frequency set to " + beaconFrequency);
        }
        this.beaconFrequency = beaconFrequency;
    }

    private TileEntityShipCore findCoreBlock() {
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        if (tileEntity != null && tileEntity instanceof TileEntityShipCore) {
            return (TileEntityShipCore)tileEntity;
        }
        tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        if (tileEntity != null && tileEntity instanceof TileEntityShipCore) {
            return (TileEntityShipCore)tileEntity;
        }
        tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        if (tileEntity != null && tileEntity instanceof TileEntityShipCore) {
            return (TileEntityShipCore)tileEntity;
        }
        tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        if (tileEntity != null && tileEntity instanceof TileEntityShipCore) {
            return (TileEntityShipCore)tileEntity;
        }
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] dim_positive(Context context, Arguments arguments) {
        return this.dim_positive(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] dim_negative(Context context, Arguments arguments) {
        return this.dim_negative(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] mode(Context context, Arguments arguments) {
        return this.mode(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] distance(Context context, Arguments arguments) {
        return this.distance(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] direction(Context context, Arguments arguments) {
        return this.direction(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] movement(Context context, Arguments arguments) {
        return this.movement(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] rotationSteps(Context context, Arguments arguments) {
        return this.rotationSteps(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getAttachedPlayers(Context context, Arguments arguments) {
        return this.getAttachedPlayers();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] summon(Context context, Arguments arguments) {
        return this.summon(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] summon_all(Context context, Arguments arguments) {
        this.setSummonAllFlag(true);
        return null;
    }

    @Override
    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] position(Context context, Arguments arguments) {
        if (this.core == null) {
            return null;
        }
        return new Object[]{this.core.field_145851_c, this.core.field_145848_d, this.core.field_145849_e};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] energy(Context context, Arguments arguments) {
        if (this.core == null) {
            return null;
        }
        return this.core.energy();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyRequired(Context context, Arguments arguments) {
        if (this.core == null) {
            return null;
        }
        return this.getEnergyRequired(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] jump(Context context, Arguments arguments) {
        this.doJump();
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getShipSize(Context context, Arguments arguments) {
        return this.getShipSize();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] beaconFrequency(Context context, Arguments arguments) {
        return this.beaconFrequency(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getOrientation(Context context, Arguments arguments) {
        if (this.core != null) {
            return new Object[]{this.core.dx, 0, this.core.dz};
        }
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] coreFrequency(Context context, Arguments arguments) {
        return this.shipName(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isInSpace(Context context, Arguments arguments) {
        return new Boolean[]{this.field_145850_b.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isInHyperspace(Context context, Arguments arguments) {
        return new Boolean[]{this.field_145850_b.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] targetJumpgate(Context context, Arguments arguments) {
        return this.targetJumpgate(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isAttached(Context context, Arguments arguments) {
        if (this.core != null) {
            return new Object[]{this.core.controller != null};
        }
        return null;
    }

    private Object[] dim_positive(Object[] arguments) {
        try {
            if (arguments.length == 3) {
                int argInt0 = TileEntityShipController.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(TileEntityShipController.toInt(arguments[0])));
                int argInt1 = TileEntityShipController.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(TileEntityShipController.toInt(arguments[1])));
                int argInt2 = TileEntityShipController.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(TileEntityShipController.toInt(arguments[2])));
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.info(this + " Positive dimensions set to front " + argInt0 + ", right " + argInt1 + ", up " + argInt2);
                }
                this.setFront(argInt0);
                this.setRight(argInt1);
                this.setUp(Math.min(255 - this.field_145848_d, argInt2));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.getFront(), this.getRight(), this.getUp()};
        }
        return new Integer[]{this.getFront(), this.getRight(), this.getUp()};
    }

    private Object[] dim_negative(Object[] arguments) {
        try {
            if (arguments.length == 3) {
                int argInt0 = TileEntityShipController.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(TileEntityShipController.toInt(arguments[0])));
                int argInt1 = TileEntityShipController.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(TileEntityShipController.toInt(arguments[1])));
                int argInt2 = TileEntityShipController.clamp(0, WarpDriveConfig.SHIP_MAX_SIDE_SIZE, Math.abs(TileEntityShipController.toInt(arguments[2])));
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.info(this + " Negative dimensions set to back " + argInt0 + ", left " + argInt1 + ", down " + argInt2);
                }
                this.setBack(argInt0);
                this.setLeft(argInt1);
                this.setDown(Math.min(this.field_145848_d, argInt2));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.getBack(), this.getLeft(), this.getDown()};
        }
        return new Integer[]{this.getBack(), this.getLeft(), this.getDown()};
    }

    private Object[] mode(Object[] arguments) {
        try {
            if (arguments.length == 1) {
                this.setMode(TileEntityShipController.toInt(arguments[0]));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.mode.getCode()};
        }
        return new Integer[]{this.mode.getCode()};
    }

    private Object[] distance(Object[] arguments) {
        try {
            if (arguments.length == 1) {
                this.setDistance(TileEntityShipController.toInt(arguments[0]));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.getDistance()};
        }
        return new Integer[]{this.getDistance()};
    }

    private Object[] direction(Object[] arguments) {
        try {
            if (arguments.length == 1) {
                this.setDirection(TileEntityShipController.toInt(arguments[0]));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.getDirection()};
        }
        return new Integer[]{this.getDirection()};
    }

    private Object[] movement(Object[] arguments) {
        try {
            if (arguments.length == 3) {
                this.setMovement(TileEntityShipController.toInt(arguments[0]), TileEntityShipController.toInt(arguments[1]), TileEntityShipController.toInt(arguments[2]));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.moveFront, this.moveUp, this.moveRight};
        }
        return new Integer[]{this.moveFront, this.moveUp, this.moveRight};
    }

    private Object[] rotationSteps(Object[] arguments) {
        try {
            if (arguments.length == 1) {
                this.setRotationSteps((byte)TileEntityShipController.toInt(arguments[0]));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.rotationSteps};
        }
        return new Integer[]{this.rotationSteps};
    }

    private Object[] getAttachedPlayers() {
        String list = "";
        if (!this.players.isEmpty()) {
            for (int i = 0; i < this.players.size(); ++i) {
                String nick = this.players.get(i);
                list = list + nick + (i == this.players.size() - 1 ? "" : ",");
            }
        }
        return new Object[]{list, this.players.toArray()};
    }

    private Object[] summon(Object[] arguments) {
        int playerIndex;
        if (arguments.length != 1) {
            return new Object[]{false};
        }
        try {
            playerIndex = TileEntityShipController.toInt(arguments[0]);
        }
        catch (Exception exception) {
            return new Object[]{false};
        }
        if (playerIndex >= 0 && playerIndex < this.players.size()) {
            this.setToSummon(this.players.get(playerIndex));
            return new Object[]{true};
        }
        return new Object[]{false};
    }

    private Object[] getEnergyRequired(Object[] arguments) {
        try {
            if (arguments.length == 1 && this.core != null) {
                Object[] objectArray = new Object[1];
                objectArray[0] = TileEntityShipCore.calculateRequiredEnergy(this.getMode(), this.core.shipMass, TileEntityShipController.toInt(arguments[0]));
                return objectArray;
            }
        }
        catch (Exception exception) {
            return new Integer[]{-1};
        }
        return new Integer[]{-1};
    }

    private Object[] getShipSize() {
        if (this.core == null) {
            return null;
        }
        StringBuilder reason = new StringBuilder();
        try {
            if (!this.core.validateShipSpatialParameters(reason)) {
                this.core.messageToAllPlayersOnShip(reason.toString());
                if (this.core.controller == null) {
                    return null;
                }
            }
            return new Object[]{this.core.shipMass};
        }
        catch (Exception exception) {
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    private Object[] beaconFrequency(Object[] arguments) {
        if (arguments.length == 1) {
            this.setBeaconFrequency((String)arguments[0]);
        }
        return new Object[]{this.beaconFrequency};
    }

    private Object[] shipName(Object[] arguments) {
        if (this.core == null) {
            return null;
        }
        if (arguments.length == 1) {
            this.core.shipName = ((String)arguments[0]).replace("/", "").replace(".", "").replace("\\", ".");
        }
        return new Object[]{this.core.shipName};
    }

    private Object[] targetJumpgate(Object[] arguments) {
        if (arguments.length == 1) {
            this.setTargetJumpgateName((String)arguments[0]);
        }
        return new Object[]{this.targetJumpgateName};
    }

    protected void cooldownDone() {
        this.sendEvent("shipCoreCooldownDone", new Object[0]);
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "dim_positive": {
                return this.dim_positive(arguments);
            }
            case "dim_negative": {
                return this.dim_negative(arguments);
            }
            case "mode": {
                return this.mode(arguments);
            }
            case "distance": {
                return this.distance(arguments);
            }
            case "direction": {
                return this.direction(arguments);
            }
            case "getAttachedPlayers": {
                return this.getAttachedPlayers();
            }
            case "summon": {
                return this.summon(arguments);
            }
            case "summon_all": {
                this.setSummonAllFlag(true);
                break;
            }
            case "position": {
                if (this.core == null) {
                    return null;
                }
                return new Object[]{this.core.field_145851_c, this.core.field_145848_d, this.core.field_145849_e};
            }
            case "energy": {
                if (this.core == null) {
                    return null;
                }
                return this.core.energy();
            }
            case "getEnergyRequired": {
                return this.getEnergyRequired(arguments);
            }
            case "jump": {
                this.doJump();
                break;
            }
            case "getShipSize": {
                return this.getShipSize();
            }
            case "beaconFrequency": {
                return this.beaconFrequency(arguments);
            }
            case "getOrientation": {
                if (this.core != null) {
                    return new Object[]{this.core.dx, 0, this.core.dz};
                }
                return null;
            }
            case "coreFrequency": {
                return this.shipName(arguments);
            }
            case "isInSpace": {
                return new Boolean[]{this.field_145850_b.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID};
            }
            case "isInHyperspace": {
                return new Boolean[]{this.field_145850_b.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID};
            }
            case "targetJumpgate": {
                return this.targetJumpgate(arguments);
            }
            case "isAttached": {
                if (this.core == null) break;
                return new Object[]{this.core.controller != null};
            }
            case "movement": {
                return this.movement(arguments);
            }
            case "rotationSteps": {
                return this.rotationSteps(arguments);
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    public String getTargetJumpgateName() {
        return this.targetJumpgateName;
    }

    public void setTargetJumpgateName(String parTargetJumpgateName) {
        this.targetJumpgateName = parTargetJumpgateName;
    }

    public VectorI getMovement() {
        if (this.moveFront != 0 || this.moveUp != 0 || this.moveRight != 0) {
            return new VectorI(this.moveFront, this.moveUp, this.moveRight);
        }
        switch (this.direction) {
            case -1: {
                return new VectorI(0, this.distance, 0);
            }
            case -2: {
                return new VectorI(0, -this.distance, 0);
            }
            case 0: {
                return new VectorI(this.distance, 0, 0);
            }
            case 180: {
                return new VectorI(-this.distance, 0, 0);
            }
            case 90: {
                return new VectorI(0, 0, -this.distance);
            }
            case 270: {
                return new VectorI(0, 0, this.distance);
            }
        }
        WarpDrive.logger.error(this + " Invalid direction " + this.direction);
        return new VectorI(0, 0, 0);
    }

    public String toString() {
        return String.format("%s '%s' @ '%s' (%d %d %d)", this.getClass().getSimpleName(), this.core == null ? this.beaconFrequency : this.core.shipName, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

