/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.item.ItemComponent;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockShipCore
extends BlockAbstractContainer {
    private IIcon[] iconBuffer;
    private static final int ICON_BOTTOM = 1;
    private static final int ICON_SIDE_INACTIVE = 0;
    private static final int ICON_TOP = 2;
    private static final int ICON_SIDE_ACTIVATED = 3;
    private static final int ICON_SIDE_HEATED = 4;

    public BlockShipCore() {
        super(Material.field_151573_f);
        this.func_149663_c("warpdrive.movement.ShipCore");
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconBuffer = new IIcon[5];
        this.iconBuffer[0] = par1IconRegister.func_94245_a("warpdrive:movement/shipCoreSideInactive");
        this.iconBuffer[1] = par1IconRegister.func_94245_a("warpdrive:movement/shipCoreBottom");
        this.iconBuffer[2] = par1IconRegister.func_94245_a("warpdrive:movement/shipCoreTop");
        this.iconBuffer[3] = par1IconRegister.func_94245_a("warpdrive:movement/shipCoreSideActive");
        this.iconBuffer[4] = par1IconRegister.func_94245_a("warpdrive:movement/shipCoreSideHeated");
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (side == 0) {
            return this.iconBuffer[1];
        }
        if (side == 1) {
            return this.iconBuffer[2];
        }
        if (metadata == 0) {
            return this.iconBuffer[0];
        }
        if (metadata == 1) {
            return this.iconBuffer[3];
        }
        if (metadata == 2) {
            return this.iconBuffer[4];
        }
        return null;
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0) {
            return this.iconBuffer[1];
        }
        if (side == 1) {
            return this.iconBuffer[2];
        }
        return this.iconBuffer[4];
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityShipCore();
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityShipCore && ((TileEntityShipCore)tileEntity).jumpCount == 0) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        EntityTNTPrimed entityTNTPrimed = new EntityTNTPrimed(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), null);
        entityTNTPrimed.field_70516_a = 10 + world.field_73012_v.nextInt(10);
        world.func_72838_d((Entity)entityTNTPrimed);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        itemStacks.add(ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 1));
        if (fortune > 0 && world.field_73012_v.nextBoolean()) {
            itemStacks.add(ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 1));
        }
        if (fortune > 1 && world.field_73012_v.nextBoolean()) {
            itemStacks.add(ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 1));
        }
        if (fortune > 1 & world.field_73012_v.nextBoolean()) {
            itemStacks.add(ItemComponent.getItemStackNoCache(EnumComponentType.POWER_INTERFACE, 1));
        }
        return itemStacks;
    }

    public float func_149737_a(EntityPlayer entityPlayer, World world, int x, int y, int z) {
        boolean willBreak = true;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityShipCore && ((TileEntityShipCore)tileEntity).jumpCount == 0) {
            willBreak = false;
        }
        return (willBreak ? 0.02f : 1.0f) * super.func_149737_a(entityPlayer, world, x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (world.field_72995_K) {
            return false;
        }
        if (entityPlayer.func_70694_bm() == null && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityShipCore) {
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, ((TileEntityShipCore)tileEntity).getStatus());
            return true;
        }
        return false;
    }
}

