/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldProjector;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.VectorI;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class TileEntityForceField
extends TileEntityAbstractBase {
    private VectorI vProjector;
    private int cache_beamFrequency;
    public Block cache_blockCamouflage;
    public int cache_metadataCamouflage;
    protected int cache_colorMultiplierCamouflage;
    protected int cache_lightCamouflage;
    private int gracePeriod_calls = 3;

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("projector")) {
            this.vProjector = VectorI.readFromNBT(tag.func_74775_l("projector"));
            this.cache_beamFrequency = tag.func_74762_e("beamFrequency");
            if (tag.func_74764_b("projector")) {
                try {
                    this.cache_blockCamouflage = Block.func_149684_b((String)tag.func_74779_i("camouflageBlock"));
                    this.cache_metadataCamouflage = tag.func_74771_c("camouflageMeta");
                    this.cache_colorMultiplierCamouflage = tag.func_74762_e("camouflageColorMultiplier");
                    this.cache_lightCamouflage = tag.func_74771_c("camouflageLight");
                    if (Dictionary.BLOCKS_NOCAMOUFLAGE.contains(this.cache_blockCamouflage)) {
                        this.cache_blockCamouflage = null;
                        this.cache_metadataCamouflage = 0;
                        this.cache_colorMultiplierCamouflage = 0;
                        this.cache_lightCamouflage = 0;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.cache_blockCamouflage = null;
                this.cache_metadataCamouflage = 0;
                this.cache_colorMultiplierCamouflage = 0;
                this.cache_lightCamouflage = 0;
            }
        } else {
            this.vProjector = null;
            this.cache_beamFrequency = -1;
            this.cache_blockCamouflage = null;
            this.cache_metadataCamouflage = 0;
            this.cache_colorMultiplierCamouflage = 0;
            this.cache_lightCamouflage = 0;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.vProjector != null) {
            tagCompound.func_74782_a("projector", (NBTBase)this.vProjector.writeToNBT(new NBTTagCompound()));
            tagCompound.func_74768_a("beamFrequency", this.cache_beamFrequency);
            if (this.cache_blockCamouflage != null) {
                tagCompound.func_74778_a("camouflageBlock", Block.field_149771_c.func_148750_c((Object)this.cache_blockCamouflage));
                tagCompound.func_74774_a("camouflageMeta", (byte)this.cache_metadataCamouflage);
                tagCompound.func_74768_a("camouflageColorMultiplier", this.cache_colorMultiplierCamouflage);
                tagCompound.func_74774_a("camouflageLight", (byte)this.cache_lightCamouflage);
            }
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    public void setProjector(VectorI vectorI) {
        this.vProjector = vectorI;
        ForceFieldSetup forceFieldSetup = this.getForceFieldSetup();
        if (forceFieldSetup != null) {
            this.cache_beamFrequency = forceFieldSetup.beamFrequency;
            if (this.func_145832_p() == forceFieldSetup.getCamouflageMetadata()) {
                this.cache_blockCamouflage = forceFieldSetup.getCamouflageBlock();
                this.cache_metadataCamouflage = forceFieldSetup.getCamouflageMetadata();
                this.cache_colorMultiplierCamouflage = forceFieldSetup.getCamouflageColorMultiplier();
                this.cache_lightCamouflage = forceFieldSetup.getCamouflageLight();
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public TileEntityForceFieldProjector getProjector() {
        TileEntity tileEntity;
        if (this.vProjector != null && (tileEntity = this.vProjector.getTileEntity((IBlockAccess)this.field_145850_b)) instanceof TileEntityForceFieldProjector) {
            TileEntityForceFieldProjector tileEntityForceFieldProjector = (TileEntityForceFieldProjector)tileEntity;
            if (this.field_145850_b.field_72995_K) {
                return tileEntityForceFieldProjector;
            }
            if (tileEntityForceFieldProjector.isPartOfForceField(new VectorI(this))) {
                if (tileEntityForceFieldProjector.isOn()) {
                    return tileEntityForceFieldProjector;
                }
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                    WarpDrive.logger.info("Removed a force field from an offline projector at " + (this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j()) + " " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            --this.gracePeriod_calls;
            if (this.gracePeriod_calls < 0) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (WarpDriveConfig.LOGGING_FORCEFIELD) {
                    WarpDrive.logger.info("Removed a force field with no projector defined at " + (this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j()) + " " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e);
                }
            }
        }
        return null;
    }

    public ForceFieldSetup getForceFieldSetup() {
        TileEntityForceFieldProjector tileEntityForceFieldProjector = this.getProjector();
        if (tileEntityForceFieldProjector == null) {
            return null;
        }
        return tileEntityForceFieldProjector.getForceFieldSetup();
    }
}

