/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.forcefield.BlockAbstractForceField;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.ForceFieldRegistry;
import cr0s.warpdrive.data.Vector3;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.StatCollector;

public class TileEntityAbstractForceField
extends TileEntityAbstractEnergy
implements IBeamFrequency {
    protected byte tier = (byte)-1;
    protected int beamFrequency = -1;
    public boolean isEnabled = true;
    protected Vector3 vRGB;
    protected boolean isConnected = true;

    public TileEntityAbstractForceField() {
        this.addMethods(new String[]{"enable", "beamFrequency"});
    }

    @Override
    protected void onFirstUpdateTick() {
        Block block = this.func_145838_q();
        if (block instanceof BlockAbstractForceField) {
            this.tier = ((BlockAbstractForceField)block).tier;
        } else {
            WarpDrive.logger.error("Missing block for " + this + " at " + this.field_145850_b + " " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e);
        }
        if (this.beamFrequency >= 0 && this.beamFrequency <= 65000) {
            ForceFieldRegistry.updateInRegistry(this);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.isConnected = this.beamFrequency > 0 && this.beamFrequency <= 65000;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        ForceFieldRegistry.removeFromRegistry(this);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
    }

    @Override
    public int getBeamFrequency() {
        return this.beamFrequency;
    }

    @Override
    public void setBeamFrequency(int parBeamFrequency) {
        if (this.beamFrequency != parBeamFrequency && parBeamFrequency <= 65000 && parBeamFrequency > 0) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Beam frequency set from " + this.beamFrequency + " to " + parBeamFrequency);
            }
            if (this.field_145850_b != null) {
                ForceFieldRegistry.removeFromRegistry(this);
            }
            this.beamFrequency = parBeamFrequency;
            this.vRGB = IBeamFrequency.getBeamColor(this.beamFrequency);
        }
        this.func_70296_d();
        if (this.field_145850_b != null) {
            ForceFieldRegistry.updateInRegistry(this);
        }
    }

    String getBeamFrequencyStatus() {
        if (this.beamFrequency == -1) {
            return StatCollector.func_74837_a((String)"warpdrive.beamFrequency.statusLine.undefined", (Object[])new Object[0]);
        }
        if (this.beamFrequency < 0) {
            return StatCollector.func_74837_a((String)"warpdrive.beamFrequency.statusLine.invalid", (Object[])new Object[]{this.beamFrequency});
        }
        return StatCollector.func_74837_a((String)"warpdrive.beamFrequency.statusLine.valid", (Object[])new Object[]{this.beamFrequency});
    }

    @Override
    public String getStatus() {
        return super.getStatus() + "\n" + this.getBeamFrequencyStatus();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tier = tag.func_74771_c("tier");
        this.setBeamFrequency(tag.func_74762_e("beamFrequency"));
        this.isEnabled = tag.func_74767_n("isEnabled");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("tier", this.tier);
        tag.func_74768_a("beamFrequency", this.beamFrequency);
        tag.func_74757_a("isEnabled", this.isEnabled);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        tagCompound.func_74757_a("isConnected", this.isConnected);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
        this.isConnected = tagCompound.func_74767_n("isConnected");
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) throws Exception {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] beamFrequency(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setBeamFrequency(arguments.checkInteger(0));
        }
        return new Integer[]{this.beamFrequency};
    }

    public Object[] enable(Object[] arguments) throws Exception {
        if (arguments.length == 1) {
            boolean enable;
            try {
                enable = TileEntityAbstractForceField.toBool(arguments[0]);
            }
            catch (Exception exception) {
                throw new Exception("Function expects a boolean value");
            }
            this.isEnabled = enable;
        }
        return new Object[]{this.isEnabled};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        try {
            switch (methodName) {
                case "enable": {
                    return this.enable(arguments);
                }
                case "beamFrequency": {
                    if (arguments.length == 1) {
                        this.setBeamFrequency(TileEntityAbstractForceField.toInt(arguments[0]));
                    }
                    return new Integer[]{this.beamFrequency};
                }
            }
        }
        catch (Exception exception) {
            return new String[]{exception.getMessage()};
        }
        return super.callMethod(computer, context, method, arguments);
    }

    public String toString() {
        return String.format("%s Beam '%d' @ '%s' (%d %d %d)", this.getClass().getSimpleName(), this.beamFrequency, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

