/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemIC2reactorLaserFocus;
import cr0s.warpdrive.network.PacketHandler;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityIC2reactorLaserMonitor
extends TileEntityAbstractEnergy {
    private int ticks = WarpDriveConfig.IC2_REACTOR_COOLING_INTERVAL_TICKS;
    private byte activeSides = 0;
    private boolean updateFlag = false;
    private boolean isFirstTick = true;
    private static final int[] deltaX = new int[]{-2, 2, 0, 0, 0, 0};
    private static final int[] deltaY = new int[]{0, 0, -2, 2, 0, 0};
    private static final int[] deltaZ = new int[]{0, 0, 0, 0, -2, 2};
    private static final byte[] deltaSides = new byte[]{1, 2, 4, 8, 16, 32};

    public TileEntityIC2reactorLaserMonitor() {
        this.IC2_sinkTier = 2;
        this.IC2_sourceTier = 2;
    }

    protected boolean isSideActive(int side) {
        switch (side) {
            case 4: {
                return (deltaSides[0] & this.activeSides) != 0;
            }
            case 5: {
                return (deltaSides[1] & this.activeSides) != 0;
            }
            case 0: {
                return (deltaSides[2] & this.activeSides) != 0;
            }
            case 1: {
                return (deltaSides[3] & this.activeSides) != 0;
            }
            case 2: {
                return (deltaSides[4] & this.activeSides) != 0;
            }
            case 3: {
                return (deltaSides[5] & this.activeSides) != 0;
            }
        }
        return false;
    }

    @Optional.Method(modid="IC2")
    private Set<IReactor> findReactors() {
        HashSet<IReactor> output = new HashSet<IReactor>();
        byte newActiveSides = 0;
        for (int i = 0; i < deltaX.length; ++i) {
            IReactor reactor;
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + deltaX[i], this.field_145848_d + deltaY[i], this.field_145849_e + deltaZ[i]);
            if (tileEntity == null) continue;
            if (tileEntity instanceof IReactor) {
                newActiveSides = (byte)(newActiveSides | deltaSides[i]);
                output.add((IReactor)tileEntity);
                continue;
            }
            if (!(tileEntity instanceof IReactorChamber) || (reactor = ((IReactorChamber)tileEntity).getReactor()) == null) continue;
            ChunkCoordinates coords = reactor.getPosition();
            if (Math.abs(coords.field_71574_a - this.field_145851_c) == 1 || Math.abs(coords.field_71572_b - this.field_145848_d) == 1 || Math.abs(coords.field_71573_c - this.field_145849_e) == 1) continue;
            newActiveSides = (byte)(newActiveSides | deltaSides[i]);
            output.add(reactor);
        }
        if (this.activeSides != newActiveSides) {
            this.updateFlag = !this.updateFlag;
            this.activeSides = newActiveSides;
        }
        return output;
    }

    @Optional.Method(modid="IC2")
    private boolean coolReactor(IReactor reactor) {
        boolean didCoolReactor = false;
        for (int x = 0; x < 9 && !didCoolReactor; ++x) {
            for (int y = 0; y < 6 && !didCoolReactor; ++y) {
                ItemStack item = reactor.getItemAt(x, y);
                if (item == null || !(item.func_77973_b() instanceof ItemIC2reactorLaserFocus)) continue;
                int heatInLaserFocus = item.func_77960_j();
                int heatRemovable = (int)Math.floor(Math.min((double)this.energy_getEnergyStored() / WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT, (double)heatInLaserFocus));
                if (heatRemovable <= 0) continue;
                didCoolReactor = true;
                if (!this.energy_consume((int)Math.ceil((double)heatRemovable * WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT), false)) continue;
                item.func_77964_b(heatInLaserFocus - heatRemovable);
            }
        }
        return didCoolReactor;
    }

    @Override
    @Optional.Method(modid="IC2")
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isFirstTick) {
            this.isFirstTick = false;
            this.updateFlag = (this.func_145832_p() & 1) == 0;
            WarpDrive.logger.info("" + this + " isFirstTick " + this.activeSides + " " + this.updateFlag);
        }
        --this.ticks;
        if (this.ticks <= 0) {
            this.ticks = WarpDriveConfig.IC2_REACTOR_COOLING_INTERVAL_TICKS;
            Vector3 myPos = new Vector3(this).translate(0.5);
            Set<IReactor> reactors = this.findReactors();
            this.setMetadata();
            if (reactors.isEmpty()) {
                return;
            }
            for (IReactor reactor : reactors) {
                if (!this.coolReactor(reactor)) continue;
                PacketHandler.sendBeamPacket(this.field_145850_b, myPos, new Vector3(reactor.getPosition()).translate(0.5), 0.0f, 0.8f, 1.0f, 20, 0, 20);
            }
        }
    }

    private void setMetadata() {
        int metadata = (this.updateFlag ? 0 : 1) | (this.activeSides != 0 ? 2 : 0);
        if ((double)this.energy_getEnergyStored() >= WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT) {
            metadata |= 8;
        }
        if (this.func_145832_p() != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 3);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("activeSides", this.activeSides);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.activeSides = tag.func_74771_c("activeSides");
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    @Override
    @Optional.Method(modid="IC2")
    public String getStatus() {
        if (this.field_145850_b == null) {
            return super.getStatus();
        }
        Set<IReactor> reactors = this.findReactors();
        if (reactors != null && !reactors.isEmpty()) {
            return super.getStatus() + StatCollector.func_74837_a((String)"warpdrive.IC2reactorLaserMonitor.multipleReactors", (Object[])new Object[]{reactors.size()});
        }
        return super.getStatus() + StatCollector.func_74837_a((String)"warpdrive.IC2reactorLaserMonitor.noReactor", (Object[])new Object[0]);
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.IC2_REACTOR_MAX_ENERGY_STORED;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }
}

