/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.energy.TileEntityEnanReactorLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Arrays;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnanReactorCore
extends TileEntityAbstractEnergy {
    private int containedEnergy = 0;
    private static final int PR_MIN_GENERATION = 4;
    private static final int PR_MAX_GENERATION = 64000;
    private static final double PR_MIN_INSTABILITY = 0.004;
    private static final double PR_MAX_INSTABILITY = 0.06;
    private static final int PR_MAX_EXPLOSION_RADIUS = 6;
    private static final double PR_MAX_EXPLOSION_REMOVAL_CHANCE = 0.1;
    private static final double PR_MAX_LASER_ENERGY = 200000.0;
    private static final double PR_MAX_LASER_EFFECT = 3.6363636363636362;
    private int tickCount = 0;
    private final double[] instabilityValues = new double[]{0.0, 0.0, 0.0, 0.0};
    private float lasersReceived = 0.0f;
    private int lastGenerationRate = 0;
    private int releasedThisTick = 0;
    private int releasedThisCycle = 0;
    private int releasedLastCycle = 0;
    private boolean hold = true;
    private boolean active = false;
    private static final int MODE_DONT_RELEASE = 0;
    private static final int MODE_MANUAL_RELEASE = 1;
    private static final int MODE_RELEASE_ABOVE = 2;
    private static final int MODE_RELEASE_AT_RATE = 3;
    private static final String[] MODE_STRING = new String[]{"OFF", "MANUAL", "ABOVE", "RATE"};
    private int releaseMode = 0;
    private int releaseRate = 0;
    private int releaseAbove = 0;
    private boolean init = false;

    public TileEntityEnanReactorCore() {
        this.peripheralName = "warpdriveEnanReactorCore";
        this.addMethods(new String[]{"active", "energy", "instability", "release", "releaseRate", "releaseAbove"});
        this.CC_scripts = Arrays.asList("startup");
    }

    private void increaseInstability(ForgeDirection from, boolean isNatural) {
        if (this.energy_canOutput(from)) {
            return;
        }
        int side = from.ordinal() - 2;
        if (this.containedEnergy > WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS * 4 * 100) {
            double amountToIncrease = (double)WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS * Math.max(0.004, 0.06 * Math.pow(this.field_145850_b.field_73012_v.nextDouble() * (double)this.containedEnergy / (double)WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED, 0.1));
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("InsInc" + amountToIncrease);
            }
            int n = side;
            this.instabilityValues[n] = this.instabilityValues[n] + amountToIncrease * (isNatural ? 1.0 : 0.25);
        } else {
            double amountToDecrease = (double)WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS * Math.max(0.004, this.instabilityValues[side] * 0.02);
            this.instabilityValues[side] = Math.max(0.0, this.instabilityValues[side] - amountToDecrease);
        }
    }

    private void increaseInstability(boolean isNatural) {
        this.increaseInstability(ForgeDirection.NORTH, isNatural);
        this.increaseInstability(ForgeDirection.SOUTH, isNatural);
        this.increaseInstability(ForgeDirection.EAST, isNatural);
        this.increaseInstability(ForgeDirection.WEST, isNatural);
    }

    public void decreaseInstability(ForgeDirection from, int energy) {
        if (this.energy_canOutput(from)) {
            return;
        }
        this.hold = false;
        int amount = TileEntityEnanReactorCore.convertInternalToRF_floor(energy);
        if (amount <= 1) {
            return;
        }
        this.lasersReceived = Math.min(10.0f, this.lasersReceived + 1.0f / (float)WarpDriveConfig.ENAN_REACTOR_MAX_LASERS_PER_SECOND);
        double nospamFactor = 1.0;
        if (this.lasersReceived > 1.0f) {
            nospamFactor = 0.5;
            this.field_145850_b.func_72885_a((Entity)null, (double)(this.field_145851_c + from.offsetX), (double)(this.field_145848_d + from.offsetY), (double)(this.field_145849_e + from.offsetZ), 1.0f, false, false);
        }
        double normalisedAmount = Math.min(1.0, Math.max(0.0, (double)amount / 200000.0));
        double baseLaserEffect = 0.5 + 0.5 * Math.cos(Math.PI - (1.0 + Math.log10(0.1 + 0.9 * normalisedAmount)) * Math.PI);
        double randomVariation = 0.8 + 0.4 * this.field_145850_b.field_73012_v.nextDouble();
        double amountToRemove = 3.6363636363636362 * baseLaserEffect * randomVariation * nospamFactor;
        int side = from.ordinal() - 2;
        if (WarpDriveConfig.LOGGING_ENERGY && side == 3) {
            WarpDrive.logger.info("Instability on " + from + " decreased by " + String.format("%.1f", amountToRemove) + "/" + String.format("%.1f", 3.6363636363636362) + " after consuming " + amount + "/" + 200000.0 + " lasersReceived is " + String.format("%.1f", Float.valueOf(this.lasersReceived)) + " hence nospamFactor is " + nospamFactor);
        }
        this.instabilityValues[side] = Math.max(0.0, this.instabilityValues[side] - amountToRemove);
        this.updateSideTextures();
    }

    private void generateEnergy() {
        double stabilityOffset = 0.5;
        for (int i = 0; i < 4; ++i) {
            stabilityOffset *= Math.max(0.01, this.instabilityValues[i] / 100.0);
        }
        if (this.active) {
            int amountToGenerate = (int)Math.ceil((double)WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS * (0.5 + stabilityOffset) * (4.0 + 64000.0 * Math.pow((double)this.containedEnergy / (double)WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED, 0.6)));
            this.containedEnergy = Math.min(this.containedEnergy + amountToGenerate, WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED);
            this.lastGenerationRate = amountToGenerate / WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS;
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("Generated " + amountToGenerate);
            }
        } else {
            int amountToDecay = (int)((double)WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS * (1.0 - stabilityOffset) * (4.0 + (double)this.containedEnergy * 0.01));
            this.containedEnergy = Math.max(0, this.containedEnergy - amountToDecay);
            this.lastGenerationRate = 0;
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("Decayed " + amountToDecay);
            }
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info("tickCount " + this.tickCount + " releasedThisTick " + this.releasedThisTick + " lasersReceived " + this.lasersReceived + " releasedThisCycle " + this.releasedThisCycle + " containedEnergy " + this.containedEnergy);
        }
        this.releasedThisTick = 0;
        this.lasersReceived = Math.max(0.0f, this.lasersReceived - 0.05f);
        ++this.tickCount;
        if (this.tickCount < WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS) {
            return;
        }
        this.tickCount = 0;
        this.releasedLastCycle = this.releasedThisCycle;
        this.releasedThisCycle = 0;
        if (!this.init) {
            this.init = true;
            this.updatedNeighbours();
        }
        this.updateSideTextures();
        if (!this.hold) {
            if (this.shouldExplode()) {
                this.explode();
            }
            this.increaseInstability(true);
            this.generateEnergy();
        }
        this.sendEvent("reactorPulse", this.lastGenerationRate);
    }

    private void explode() {
        double normalizedEnergy = (double)this.containedEnergy / (double)WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED;
        int radius = (int)Math.round(6.0 * Math.pow(normalizedEnergy, 0.125));
        double chanceOfRemoval = 0.1 * Math.pow(normalizedEnergy, 0.125);
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(this + " Explosion radius is " + radius + ", Chance of removal is " + chanceOfRemoval);
        }
        if (radius > 1) {
            float bedrockExplosionResistance = Blocks.field_150357_h.func_149638_a(null);
            for (int x = this.field_145851_c - radius; x <= this.field_145851_c + radius; ++x) {
                for (int y = this.field_145848_d - radius; y <= this.field_145848_d + radius; ++y) {
                    for (int z = this.field_145849_e - radius; z <= this.field_145849_e + radius; ++z) {
                        if (z == this.field_145849_e && y == this.field_145848_d && x == this.field_145851_c || !(this.field_145850_b.field_73012_v.nextDouble() < chanceOfRemoval) || !(this.field_145850_b.func_147439_a(x, y, z).func_149638_a(null) >= bedrockExplosionResistance)) continue;
                        this.field_145850_b.func_147468_f(x, y, z);
                    }
                }
            }
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (int i = 0; i < 3; ++i) {
            this.field_145850_b.func_72885_a((Entity)null, (double)(this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(3)) - 0.5, (double)(this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(3)) - 0.5, (double)(this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(3)) - 0.5, 4.0f + (float)this.field_145850_b.field_73012_v.nextInt(3), true, true);
        }
    }

    private void updateSideTextures() {
        double maxInstability = 0.0;
        double[] dArray = this.instabilityValues;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double ins = dArray[i];
            if (!(ins > maxInstability)) continue;
            maxInstability = ins;
        }
        int instabilityNibble = (int)Math.max(0L, Math.min(3L, Math.round(maxInstability / 25.0)));
        int energyNibble = (int)Math.max(0L, Math.min(3L, Math.round(4.0 * (double)this.containedEnergy / (double)WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED)));
        int metadata = 4 * instabilityNibble + energyNibble;
        if (this.func_145832_p() != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 3);
        }
    }

    private boolean shouldExplode() {
        boolean exploding = false;
        for (int i = 0; i < 4; ++i) {
            exploding = exploding || this.instabilityValues[i] >= 100.0;
        }
        if (exploding &= this.field_145850_b.field_73012_v.nextInt(4) == 2) {
            WarpDrive.logger.info(this + String.format(" Explosion triggered, Instability is [%.2f, %.2f, %.2f, %.2f], Energy stored is %d, Laser received is %.2f, %s", this.instabilityValues[0], this.instabilityValues[1], this.instabilityValues[2], this.instabilityValues[3], this.containedEnergy, Float.valueOf(this.lasersReceived), this.active ? "ACTIVE" : "INACTIVE"));
            this.active = false;
        }
        return exploding;
    }

    @Override
    public void updatedNeighbours() {
        super.updatedNeighbours();
        int[] offsetsX = new int[]{0, 0, -2, 2};
        int[] offsetsZ = new int[]{2, -2, 0, 0};
        for (int i = 0; i < 4; ++i) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + offsetsX[i], this.field_145848_d, this.field_145849_e + offsetsZ[i]);
            if (!(tileEntity instanceof TileEntityEnanReactorLaser)) continue;
            ((TileEntityEnanReactorLaser)tileEntity).scanForReactor();
        }
    }

    @Override
    public Object[] energy() {
        return new Object[]{this.containedEnergy, WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED, this.releasedLastCycle / WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] active(Context context, Arguments arguments) throws Exception {
        return this.active(this.argumentsOCtoCC(arguments));
    }

    private Object[] active(Object[] arguments) throws Exception {
        if (arguments.length == 1) {
            boolean activate;
            try {
                activate = TileEntityEnanReactorCore.toBool(arguments[0]);
            }
            catch (Exception exception) {
                throw new Exception("Function expects a boolean value");
            }
            if (this.active && !activate) {
                this.sendEvent("reactorDeactivation", new Object[0]);
            } else if (!this.active && activate) {
                this.sendEvent("reactorActivation", new Object[0]);
            }
            this.active = activate;
        }
        if (this.releaseMode == 0 || this.releaseMode == 1) {
            return new Object[]{this.active, MODE_STRING[this.releaseMode], 0};
        }
        if (this.releaseMode == 2) {
            return new Object[]{this.active, MODE_STRING[this.releaseMode], this.releaseAbove};
        }
        return new Object[]{this.active, MODE_STRING[this.releaseMode], this.releaseRate};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] release(Context context, Arguments arguments) throws Exception {
        return this.release(this.argumentsOCtoCC(arguments));
    }

    private Object[] release(Object[] arguments) throws Exception {
        if (arguments.length > 0) {
            boolean doRelease;
            try {
                doRelease = TileEntityEnanReactorCore.toBool(arguments[0]);
            }
            catch (Exception exception) {
                throw new Exception("Function expects a boolean value");
            }
            this.releaseMode = doRelease ? 1 : 0;
            this.releaseAbove = 0;
            this.releaseRate = 0;
        }
        return new Object[]{this.releaseMode != 0};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] releaseRate(Context context, Arguments arguments) throws Exception {
        return this.releaseRate(this.argumentsOCtoCC(arguments));
    }

    private Object[] releaseRate(Object[] arguments) throws Exception {
        int rate;
        try {
            rate = TileEntityEnanReactorCore.toInt(arguments[0]);
        }
        catch (Exception exception) {
            throw new Exception("Function expects an integer value");
        }
        if (rate <= 0) {
            this.releaseMode = 0;
            this.releaseRate = 0;
        } else {
            this.releaseRate = rate;
            this.releaseMode = 3;
        }
        return new Object[]{MODE_STRING[this.releaseMode], this.releaseRate};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] releaseAbove(Context context, Arguments arguments) throws Exception {
        return this.releaseAbove(this.argumentsOCtoCC(arguments));
    }

    private Object[] releaseAbove(Object[] arguments) throws Exception {
        int above;
        try {
            above = TileEntityEnanReactorCore.toInt(arguments[0]);
        }
        catch (Exception exception) {
            throw new Exception("Function expects an integer value");
        }
        if (above <= 0) {
            this.releaseMode = 0;
            this.releaseAbove = 0;
        } else {
            this.releaseMode = 2;
            this.releaseAbove = above;
        }
        return new Object[]{MODE_STRING[this.releaseMode], this.releaseAbove};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] instability(Context context, Arguments arguments) throws Exception {
        this.hold = false;
        return new Double[]{this.instabilityValues[0], this.instabilityValues[1], this.instabilityValues[2], this.instabilityValues[3]};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        this.hold = false;
        String methodName = this.getMethodName(method);
        try {
            switch (methodName) {
                case "active": {
                    return this.active(arguments);
                }
                case "energy": {
                    return this.energy();
                }
                case "instability": {
                    Object[] retVal = new Object[4];
                    for (int i = 0; i < 4; ++i) {
                        retVal[i] = this.instabilityValues[i];
                    }
                    return retVal;
                }
                case "release": {
                    return this.release(arguments);
                }
                case "releaseRate": {
                    return this.releaseRate(arguments);
                }
                case "releaseAbove": {
                    return this.releaseAbove(arguments);
                }
            }
        }
        catch (Exception exception) {
            return new String[]{exception.getMessage()};
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public int energy_getPotentialOutput() {
        if (this.hold) {
            return 0;
        }
        int result = 0;
        int capacity = Math.max(0, 2 * this.lastGenerationRate - this.releasedThisTick);
        if (this.releaseMode == 1) {
            result = Math.min(Math.max(0, this.containedEnergy), capacity);
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("PotentialOutput Manual " + result + " RF (" + TileEntityEnanReactorCore.convertRFtoInternal_floor(result) + " internal) capacity " + capacity);
            }
        } else if (this.releaseMode == 2) {
            result = Math.min(Math.max(0, this.containedEnergy - this.releaseAbove), capacity);
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("PotentialOutput Above " + result + " RF (" + TileEntityEnanReactorCore.convertRFtoInternal_floor(result) + " internal) capacity " + capacity);
            }
        } else if (this.releaseMode == 3) {
            int remainingRate = Math.max(0, this.releaseRate - this.releasedThisTick);
            result = Math.min(Math.max(0, this.containedEnergy), Math.min(remainingRate, capacity));
            if (WarpDriveConfig.LOGGING_ENERGY) {
                WarpDrive.logger.info("PotentialOutput Rated " + result + " RF (" + TileEntityEnanReactorCore.convertRFtoInternal_floor(result) + " internal) remainingRate " + remainingRate + " RF/t capacity " + capacity);
            }
        }
        return TileEntityEnanReactorCore.convertRFtoInternal_floor(result);
    }

    @Override
    public boolean energy_canOutput(ForgeDirection from) {
        return from.equals((Object)ForgeDirection.UP) || from.equals((Object)ForgeDirection.DOWN);
    }

    @Override
    protected void energy_outputDone(int energyOutput_internal) {
        int energyOutput_RF = TileEntityEnanReactorCore.convertRFtoInternal_ceil(energyOutput_internal);
        this.containedEnergy -= energyOutput_RF;
        if (this.containedEnergy < 0) {
            this.containedEnergy = 0;
        }
        this.releasedThisTick += energyOutput_RF;
        this.releasedThisCycle += energyOutput_RF;
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info("OutputDone " + energyOutput_internal + " (" + energyOutput_RF + " RF)");
        }
    }

    @Override
    public int energy_getEnergyStored() {
        return TileEntityEnanReactorCore.convertRFtoInternal_floor(this.containedEnergy);
    }

    @Override
    public int energy_getMaxStorage() {
        return TileEntityEnanReactorCore.convertRFtoInternal_floor(WarpDriveConfig.ENAN_REACTOR_MAX_ENERGY_STORED);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("energy", this.containedEnergy);
        nbt.func_74768_a("releaseMode", this.releaseMode);
        nbt.func_74768_a("releaseRate", this.releaseRate);
        nbt.func_74768_a("releaseAbove", this.releaseAbove);
        nbt.func_74780_a("i0", this.instabilityValues[0]);
        nbt.func_74780_a("i1", this.instabilityValues[1]);
        nbt.func_74780_a("i2", this.instabilityValues[2]);
        nbt.func_74780_a("i3", this.instabilityValues[3]);
        nbt.func_74757_a("active", this.active);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.containedEnergy = nbt.func_74762_e("energy");
        this.releaseMode = nbt.func_74762_e("releaseMode");
        this.releaseRate = nbt.func_74762_e("releaseRate");
        this.releaseAbove = nbt.func_74762_e("releaseAbove");
        this.instabilityValues[0] = nbt.func_74769_h("i0");
        this.instabilityValues[1] = nbt.func_74769_h("i1");
        this.instabilityValues[2] = nbt.func_74769_h("i2");
        this.instabilityValues[3] = nbt.func_74769_h("i3");
        this.active = nbt.func_74767_n("active");
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.writeItemDropNBT(nbtTagCompound);
        nbtTagCompound.func_82580_o("energy");
        nbtTagCompound.func_82580_o("releaseMode");
        nbtTagCompound.func_82580_o("releaseRate");
        nbtTagCompound.func_82580_o("releaseAbove");
        nbtTagCompound.func_82580_o("i0");
        nbtTagCompound.func_82580_o("i1");
        nbtTagCompound.func_82580_o("i2");
        nbtTagCompound.func_82580_o("i3");
        nbtTagCompound.func_82580_o("active");
        return nbtTagCompound;
    }

    public String toString() {
        return String.format("%s '%s' @ '%s' (%d %d %d)", this.getClass().getSimpleName(), this.connectedComputers == null ? "~NULL~" : this.connectedComputers, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

