/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.energy.TileEntityEnergyBank;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.item.ItemTuningFork;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnergyBank
extends BlockAbstractContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockEnergyBank() {
        super(Material.field_151573_f);
        this.func_149663_c("warpdrive.energy.EnergyBank.");
        this.hasSubBlocks = true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityEnergyBank((byte)(metadata % 4));
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        for (byte tier = 0; tier < 4; tier = (byte)((byte)(tier + 1))) {
            ItemStack itemStack = new ItemStack(item, 1, (int)tier);
            list.add(itemStack);
            if (tier <= 0) continue;
            itemStack = new ItemStack(item, 1, (int)tier);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74774_a("tier", tier);
            nbtTagCompound.func_74768_a("energy", WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[tier - 1]);
            itemStack.func_77982_d(nbtTagCompound);
            list.add(itemStack);
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[12];
        this.icons[0] = iconRegister.func_94245_a("warpdrive:energy/energyBankCreativeDisabled");
        this.icons[1] = iconRegister.func_94245_a("warpdrive:energy/energyBankCreativeInput");
        this.icons[2] = iconRegister.func_94245_a("warpdrive:energy/energyBankCreativeOutput");
        this.icons[3] = iconRegister.func_94245_a("warpdrive:energy/energyBankBasicDisabled");
        this.icons[4] = iconRegister.func_94245_a("warpdrive:energy/energyBankBasicInput");
        this.icons[5] = iconRegister.func_94245_a("warpdrive:energy/energyBankBasicOutput");
        this.icons[6] = iconRegister.func_94245_a("warpdrive:energy/energyBankAdvancedDisabled");
        this.icons[7] = iconRegister.func_94245_a("warpdrive:energy/energyBankAdvancedInput");
        this.icons[8] = iconRegister.func_94245_a("warpdrive:energy/energyBankAdvancedOutput");
        this.icons[9] = iconRegister.func_94245_a("warpdrive:energy/energyBankSuperiorDisabled");
        this.icons[10] = iconRegister.func_94245_a("warpdrive:energy/energyBankSuperiorInput");
        this.icons[11] = iconRegister.func_94245_a("warpdrive:energy/energyBankSuperiorOutput");
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null || !(tileEntity instanceof TileEntityEnergyBank)) {
            return this.icons[3];
        }
        return this.icons[3 * ((TileEntityEnergyBank)tileEntity).getTier() + ((TileEntityEnergyBank)tileEntity).getMode(EnumFacing.func_82600_a((int)side))];
    }

    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[metadata * 3 + (side == 1 ? 1 : 2)];
    }

    @Override
    public byte getTier(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() != Item.func_150898_a((Block)this)) {
            return 1;
        }
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("tier")) {
            return nbtTagCompound.func_74771_c("tier");
        }
        return (byte)itemStack.func_77960_j();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityEnergyBank)) {
            return false;
        }
        TileEntityEnergyBank tileEntityEnergyBank = (TileEntityEnergyBank)tileEntity;
        ItemStack itemStackHeld = entityPlayer.func_70694_bm();
        EnumFacing facing = EnumFacing.func_82600_a((int)side);
        if (itemStackHeld != null && itemStackHeld.func_77973_b() instanceof ItemTuningFork) {
            if (entityPlayer.func_70093_af()) {
                tileEntityEnergyBank.setMode(facing, (byte)((tileEntityEnergyBank.getMode(facing) + 2) % 3));
            } else {
                tileEntityEnergyBank.setMode(facing, (byte)((tileEntityEnergyBank.getMode(facing) + 1) % 3));
            }
            ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)this), 1, world.func_72805_g(x, y, z));
            switch (tileEntityEnergyBank.getMode(facing)) {
                case 1: {
                    WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{StatCollector.func_74837_a((String)(itemStack.func_77977_a() + ".name"), (Object[])new Object[0])}) + StatCollector.func_74837_a((String)"warpdrive.energy.side.changedToInput", (Object[])new Object[]{facing.name()}));
                    return true;
                }
                case 2: {
                    WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{StatCollector.func_74837_a((String)(itemStack.func_77977_a() + ".name"), (Object[])new Object[0])}) + StatCollector.func_74837_a((String)"warpdrive.energy.side.changedToOutput", (Object[])new Object[]{facing.name()}));
                    return true;
                }
            }
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{StatCollector.func_74837_a((String)(itemStack.func_77977_a() + ".name"), (Object[])new Object[0])}) + StatCollector.func_74837_a((String)"warpdrive.energy.side.changedToDisabled", (Object[])new Object[]{facing.name()}));
            return true;
        }
        EnumComponentType enumComponentType = null;
        if (itemStackHeld != null && itemStackHeld.func_77973_b() instanceof ItemComponent) {
            enumComponentType = EnumComponentType.get(itemStackHeld.func_77960_j());
        }
        if (entityPlayer.func_70093_af()) {
            if (itemStackHeld == null || enumComponentType != null) {
                if (itemStackHeld == null || !tileEntityEnergyBank.hasUpgrade((Object)enumComponentType)) {
                    enumComponentType = (EnumComponentType)((Object)tileEntityEnergyBank.getFirstUpgradeOfType(EnumComponentType.class, null));
                }
                if (enumComponentType == null) {
                    WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.noUpgradeToDismount", (Object[])new Object[0]));
                    return true;
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    ItemStack itemStackDrop = ItemComponent.getItemStackNoCache(enumComponentType, 1);
                    EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, itemStackDrop);
                    entityItem.field_145804_b = 0;
                    world.func_72838_d((Entity)entityItem);
                }
                tileEntityEnergyBank.dismountUpgrade((Object)enumComponentType);
                WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.dismounted", (Object[])new Object[]{enumComponentType.name()}));
                return false;
            }
        } else {
            if (itemStackHeld == null) {
                WarpDrive.addChatMessage((ICommandSender)entityPlayer, tileEntityEnergyBank.getStatus());
                return true;
            }
            if (enumComponentType != null) {
                if (tileEntityEnergyBank.getUpgradeMaxCount((Object)enumComponentType) <= 0) {
                    WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.invalidUpgrade", (Object[])new Object[0]));
                    return true;
                }
                if (!tileEntityEnergyBank.canUpgrade((Object)enumComponentType)) {
                    WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.tooManyUpgrades", (Object[])new Object[]{tileEntityEnergyBank.getUpgradeMaxCount((Object)enumComponentType)}));
                    return true;
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    if (itemStackHeld.field_77994_a < 1) {
                        WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.notEnoughUpgrades", (Object[])new Object[0]));
                        return true;
                    }
                    --itemStackHeld.field_77994_a;
                }
                tileEntityEnergyBank.mountUpgrade((Object)enumComponentType);
                WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.mounted", (Object[])new Object[]{enumComponentType.name()}));
            }
        }
        return false;
    }
}

