/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CloakedArea;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Arrays;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCloakingCore
extends TileEntityAbstractEnergy {
    public boolean isEnabled = false;
    public byte tier = 1;
    final float[] innerCoilColor_r = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f};
    final float[] innerCoilColor_g = new float[]{0.0f, 0.25f, 0.75f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.5f, 0.25f, 0.0f, 0.0f};
    final float[] innerCoilColor_b = new float[]{0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f};
    private static final int innerCoilsDistance = 2;
    private final int[] outerCoilsDistance = new int[]{0, 0, 0, 0, 0, 0};
    public int minX = 0;
    public int minY = 0;
    public int minZ = 0;
    public int maxX = 0;
    public int maxY = 0;
    public int maxZ = 0;
    public boolean isValid = false;
    public boolean isCloaking = false;
    public int volume = 0;
    private int updateTicks = 0;
    private int laserDrawingTicks = 0;
    private boolean soundPlayed = false;
    private int soundTicks = 0;

    public TileEntityCloakingCore() {
        this.peripheralName = "warpdriveCloakingCore";
        this.addMethods(new String[]{"tier", "isAssemblyValid", "enable"});
        this.CC_scripts = Arrays.asList("cloak1", "cloak2", "uncloak");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.soundTicks;
        if (this.soundTicks >= 40) {
            this.soundTicks = 0;
            this.soundPlayed = false;
        }
        --this.updateTicks;
        if (this.updateTicks <= 0) {
            if (WarpDriveConfig.LOGGING_CLOAKING) {
                WarpDrive.logger.info(this + " Updating cloaking state...");
            }
            this.updateTicks = (this.tier == 1 ? 20 : (this.tier == 2 ? 10 : 20)) * WarpDriveConfig.CLOAKING_FIELD_REFRESH_INTERVAL_SECONDS;
            this.isValid = this.validateAssembly();
            this.isCloaking = WarpDrive.cloaks.isAreaExists(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!this.isEnabled) {
                if (this.isCloaking) {
                    if (WarpDriveConfig.LOGGING_CLOAKING) {
                        WarpDrive.logger.info(this + " Disabled, cloak field going down...");
                    }
                    this.disableCloakingField();
                }
            } else {
                boolean hasEnoughPower = this.countBlocksAndConsumeEnergy();
                if (!this.isCloaking) {
                    if (hasEnoughPower && this.isValid) {
                        CloakedArea area;
                        this.setCoilsState(true);
                        WarpDrive.cloaks.updateCloakedArea(this.field_145850_b, this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tier, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
                        if (!this.soundPlayed) {
                            this.soundPlayed = true;
                            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "warpdrive:cloak", 4.0f, 1.0f);
                        }
                        if ((area = WarpDrive.cloaks.getCloakedArea(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) != null) {
                            area.sendCloakPacketToPlayersEx(false);
                        } else if (WarpDriveConfig.LOGGING_CLOAKING) {
                            WarpDrive.logger.info("getCloakedArea1 returned null for " + this.field_145850_b + " " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e);
                        }
                    }
                } else if (!this.isValid) {
                    if (WarpDriveConfig.LOGGING_CLOAKING) {
                        WarpDrive.logger.info(this + " Coil(s) lost, cloak field is collapsing...");
                    }
                    this.energy_consume(this.energy_getEnergyStored());
                    this.disableCloakingField();
                } else if (hasEnoughPower) {
                    CloakedArea area = WarpDrive.cloaks.getCloakedArea(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    if (area != null) {
                        area.sendCloakPacketToPlayersEx(false);
                    } else if (WarpDriveConfig.LOGGING_CLOAKING) {
                        WarpDrive.logger.info("getCloakedArea2 returned null for " + this.field_145850_b + " " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e);
                    }
                    this.setCoilsState(true);
                } else {
                    if (WarpDriveConfig.LOGGING_CLOAKING) {
                        WarpDrive.logger.info(this + " Low power, cloak field is collapsing...");
                    }
                    this.disableCloakingField();
                }
            }
        }
        if (this.laserDrawingTicks++ > 100) {
            this.laserDrawingTicks = 0;
            if (this.isEnabled && this.isValid) {
                this.drawLasers();
            }
        }
    }

    private void setCoilsState(boolean enabled) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, enabled ? 1 : 0, 2);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            this.setCoilState(2, direction, enabled);
            this.setCoilState(this.outerCoilsDistance[direction.ordinal()], direction, enabled);
        }
    }

    private void setCoilState(int distance, ForgeDirection direction, boolean enabled) {
        int x = this.field_145851_c + distance * direction.offsetX;
        int y = this.field_145848_d + distance * direction.offsetY;
        int z = this.field_145849_e + distance * direction.offsetZ;
        if (this.field_145850_b.func_147439_a(x, y, z).func_149667_c(WarpDrive.blockCloakingCoil)) {
            if (distance == 2) {
                this.field_145850_b.func_72921_c(x, y, z, enabled ? 9 : 1, 2);
            } else {
                this.field_145850_b.func_72921_c(x, y, z, (enabled ? 10 : 2) + direction.ordinal(), 2);
            }
        }
    }

    private void drawLasers() {
        float r = 0.0f;
        float g = 1.0f;
        float b = 0.0f;
        if (!this.isCloaking) {
            r = 0.75f;
            g = 0.5f;
            b = 0.5f;
        } else if (this.tier == 1) {
            r = 0.25f;
            g = 1.0f;
            b = 0.0f;
        } else if (this.tier == 2) {
            r = 0.0f;
            g = 0.25f;
            b = 1.0f;
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            PacketHandler.sendBeamPacketToPlayersInArea(this.field_145850_b, new Vector3(this.field_145851_c + 2 * direction.offsetX, this.field_145848_d + 2 * direction.offsetY, this.field_145849_e + 2 * direction.offsetZ).translate(0.5), new Vector3(this.field_145851_c + this.outerCoilsDistance[direction.ordinal()] * direction.offsetX, this.field_145848_d + this.outerCoilsDistance[direction.ordinal()] * direction.offsetY, this.field_145849_e + this.outerCoilsDistance[direction.ordinal()] * direction.offsetZ).translate(0.5), r, g, b, 110, 0, AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ));
        }
        for (int i = 0; i < 5; ++i) {
            ForgeDirection start = ForgeDirection.VALID_DIRECTIONS[i];
            for (int j = i + 1; j < 6; ++j) {
                ForgeDirection stop = ForgeDirection.VALID_DIRECTIONS[j];
                if (start.getOpposite() == stop) continue;
                int mapIndex = this.field_145850_b.field_73012_v.nextInt(this.innerCoilColor_b.length);
                r = this.innerCoilColor_r[mapIndex];
                g = this.innerCoilColor_g[mapIndex];
                b = this.innerCoilColor_b[mapIndex];
                PacketHandler.sendBeamPacketToPlayersInArea(this.field_145850_b, new Vector3(this.field_145851_c + 2 * start.offsetX, this.field_145848_d + 2 * start.offsetY, this.field_145849_e + 2 * start.offsetZ).translate(0.5), new Vector3(this.field_145851_c + 2 * stop.offsetX, this.field_145848_d + 2 * stop.offsetY, this.field_145849_e + 2 * stop.offsetZ).translate(0.5), r, g, b, 110, 0, AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ));
            }
        }
    }

    public void disableCloakingField() {
        this.setCoilsState(false);
        if (WarpDrive.cloaks.isAreaExists(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            WarpDrive.cloaks.removeCloakedArea(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!this.soundPlayed) {
                this.soundPlayed = true;
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "warpdrive:decloak", 4.0f, 1.0f);
            }
        }
    }

    public boolean countBlocksAndConsumeEnergy() {
        int energyToConsume;
        this.volume = 0;
        if (this.tier == 1) {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    for (int z = this.minZ; z <= this.maxZ; ++z) {
                        if (this.field_145850_b.func_147437_c(x, y, z)) continue;
                        ++this.volume;
                    }
                }
            }
            energyToConsume = this.volume * WarpDriveConfig.CLOAKING_TIER1_ENERGY_PER_BLOCK;
        } else {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int x = this.minX; x <= this.maxX; ++x) {
                    for (int z = this.minZ; z <= this.maxZ; ++z) {
                        if (this.field_145850_b.func_147439_a(x, y, z).func_149667_c(Blocks.field_150350_a)) continue;
                        ++this.volume;
                    }
                }
            }
            energyToConsume = this.volume * WarpDriveConfig.CLOAKING_TIER2_ENERGY_PER_BLOCK;
        }
        return this.energy_consume(energyToConsume, false);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tier = tag.func_74771_c("tier");
        this.isEnabled = tag.func_74767_n("enabled");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("tier", this.tier);
        tag.func_74757_a("enabled", this.isEnabled);
    }

    public boolean validateAssembly() {
        int maxOuterCoilDistance = WarpDriveConfig.CLOAKING_MAX_FIELD_RADIUS - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int oldZ;
            int oldY;
            int oldX;
            int oldCoilDistance;
            int x = this.field_145851_c + 2 * direction.offsetX;
            int y = this.field_145848_d + 2 * direction.offsetY;
            int z = this.field_145849_e + 2 * direction.offsetZ;
            if (!this.field_145850_b.func_147439_a(x, y, z).func_149667_c(WarpDrive.blockCloakingCoil)) {
                return false;
            }
            this.field_145850_b.func_72921_c(x, y, z, 1, 2);
            int newCoilDistance = 0;
            for (int distance = 3; distance < maxOuterCoilDistance; ++distance) {
                if (!this.field_145850_b.func_147439_a(x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ).func_149667_c(WarpDrive.blockCloakingCoil)) continue;
                this.field_145850_b.func_72921_c(x, y, z, 2 + direction.ordinal(), 2);
                newCoilDistance = distance;
                break;
            }
            if (newCoilDistance != (oldCoilDistance = this.outerCoilsDistance[direction.ordinal()]) && oldCoilDistance > 0 && this.field_145850_b.func_147439_a(oldX = this.field_145851_c + oldCoilDistance * direction.offsetX, oldY = this.field_145848_d + oldCoilDistance * direction.offsetY, oldZ = this.field_145849_e + oldCoilDistance * direction.offsetZ).func_149667_c(WarpDrive.blockCloakingCoil)) {
                this.field_145850_b.func_72921_c(oldX, oldY, oldZ, 0, 2);
            }
            if (newCoilDistance <= 0) {
                this.outerCoilsDistance[direction.ordinal()] = 0;
                if (WarpDriveConfig.LOGGING_CLOAKING) {
                    WarpDrive.logger.info("Invalid outer coil assembly at " + direction);
                }
                return false;
            }
            this.outerCoilsDistance[direction.ordinal()] = newCoilDistance;
        }
        this.minX = this.field_145851_c - this.outerCoilsDistance[4] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.maxX = this.field_145851_c + this.outerCoilsDistance[5] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.minY = Math.max(0, this.field_145848_d - this.outerCoilsDistance[0] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS);
        this.maxY = Math.min(255, this.field_145848_d + this.outerCoilsDistance[1] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS);
        this.minZ = this.field_145849_e - this.outerCoilsDistance[2] - WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        this.maxZ = this.field_145849_e + this.outerCoilsDistance[3] + WarpDriveConfig.CLOAKING_COIL_CAPTURE_BLOCKS;
        return true;
    }

    @Override
    public String getStatus() {
        if (this.field_145850_b == null) {
            return super.getStatus();
        }
        String unlocalizedStatus = !this.isValid ? "warpdrive.cloakingCore.invalidAssembly" : (!this.isEnabled ? "warpdrive.cloakingCore.disabled" : (!this.isCloaking ? "warpdrive.cloakingCore.lowPower" : "warpdrive.cloakingCore.cloaking"));
        return super.getStatus() + "\n" + StatCollector.func_74837_a((String)unlocalizedStatus, (Object[])new Object[]{this.tier, this.volume});
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] tier(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.tier = arguments.checkInteger(0) == 2 ? (byte)2 : (byte)1;
            this.func_70296_d();
        }
        return new Integer[]{this.tier};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isAssemblyValid(Context context, Arguments arguments) {
        return new Object[]{this.validateAssembly()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.isEnabled = arguments.checkBoolean(0);
            this.func_70296_d();
        }
        return new Object[]{this.isEnabled};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "tier": {
                if (arguments.length == 1) {
                    this.tier = TileEntityCloakingCore.toInt(arguments[0]) == 2 ? (byte)2 : (byte)1;
                    this.func_70296_d();
                }
                return new Integer[]{this.tier};
            }
            case "isAssemblyValid": {
                return new Object[]{this.validateAssembly()};
            }
            case "enable": {
                if (arguments.length == 1) {
                    this.isEnabled = TileEntityCloakingCore.toBool(arguments[0]);
                    this.func_70296_d();
                }
                return new Object[]{this.isEnabled};
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.CLOAKING_MAX_ENERGY_STORED;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }
}

