/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.collection;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityAbstractMiner
extends TileEntityAbstractLaser {
    protected ForgeDirection laserOutputSide = ForgeDirection.NORTH;
    protected boolean enableSilktouch = false;
    protected Vector3 laserOutput = null;

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.laserOutput = new Vector3(this).translate(0.5).translate(this.laserOutputSide, 0.5);
    }

    protected void stop() {
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(this + " Stop requested");
        }
    }

    protected void harvestBlock(VectorI valuable) {
        Block block = this.field_145850_b.func_147439_a(valuable.x, valuable.y, valuable.z);
        if (block == Blocks.field_150350_a) {
            return;
        }
        int blockMeta = this.field_145850_b.func_72805_g(valuable.x, valuable.y, valuable.z);
        if (block != null && block instanceof BlockLiquid) {
            this.field_145850_b.func_72908_a((double)valuable.x + 0.5, (double)valuable.y + 0.5, (double)valuable.z + 0.5, "random.fizz", 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
        } else {
            List<ItemStack> itemStacks = this.getItemStackFromBlock(valuable.x, valuable.y, valuable.z, block, blockMeta);
            if (this.addToConnectedInventories(itemStacks)) {
                this.stop();
            }
            this.field_145850_b.func_72889_a(null, 2001, valuable.x, valuable.y, valuable.z, Block.func_149682_b((Block)block) + (blockMeta << 12));
        }
        this.field_145850_b.func_147468_f(valuable.x, valuable.y, valuable.z);
    }

    private List<ItemStack> getItemStackFromBlock(int x, int y, int z, Block block, int blockMeta) {
        if (block == null) {
            WarpDrive.logger.error(this + " Invalid block at " + x + " " + y + " " + z);
            return null;
        }
        if (this.enableSilktouch) {
            boolean isSilkHarvestable = false;
            try {
                isSilkHarvestable = block.canSilkHarvest(this.field_145850_b, null, x, y, z, blockMeta);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (isSilkHarvestable) {
                ArrayList<ItemStack> isBlock = new ArrayList<ItemStack>();
                isBlock.add(new ItemStack(block, 1, blockMeta));
                return isBlock;
            }
        }
        try {
            return block.getDrops(this.field_145850_b, x, y, z, blockMeta, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.enableSilktouch = tag.func_74767_n("enableSilktouch");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("enableSilktouch", this.enableSilktouch);
    }
}

