/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IAirCanister;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.TileEntityAirGenerator;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockAirGenerator
extends BlockAbstractContainer {
    private IIcon[] iconBuffer;
    private static final int ICON_INACTIVE_SIDE = 0;
    private static final int ICON_BOTTOM = 1;
    private static final int ICON_SIDE_ACTIVATED = 2;

    public BlockAirGenerator() {
        super(Material.field_151573_f);
        this.func_149663_c("warpdrive.machines.AirGenerator");
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconBuffer = new IIcon[3];
        this.iconBuffer[0] = par1IconRegister.func_94245_a("warpdrive:airGeneratorSideInactive");
        this.iconBuffer[1] = par1IconRegister.func_94245_a("warpdrive:airGeneratorBottom");
        this.iconBuffer[2] = par1IconRegister.func_94245_a("warpdrive:airGeneratorSideActive");
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (metadata == 0) {
            return this.iconBuffer[0];
        }
        if (metadata == 1) {
            return this.iconBuffer[2];
        }
        return null;
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityAirGenerator();
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)this);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityAirGenerator) {
            IAirCanister airCanister;
            TileEntityAirGenerator airGenerator = (TileEntityAirGenerator)tileEntity;
            ItemStack heldItemStack = entityPlayer.func_70694_bm();
            if (heldItemStack == null) {
                WarpDrive.addChatMessage((ICommandSender)entityPlayer, airGenerator.getStatus());
                return true;
            }
            Item heldItem = heldItemStack.func_77973_b();
            if (heldItem != null && heldItem instanceof IAirCanister && (airCanister = (IAirCanister)heldItem).canContainAir(heldItemStack) && airGenerator.energy_consume(WarpDriveConfig.AIRGEN_ENERGY_PER_CANISTER, true)) {
                entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
                ItemStack toAdd = airCanister.fullDrop(heldItemStack);
                if (toAdd != null) {
                    if (!entityPlayer.field_71071_by.func_70441_a(toAdd)) {
                        EntityItem ie = new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, toAdd);
                        entityPlayer.field_70170_p.func_72838_d((Entity)ie);
                    }
                    ((EntityPlayerMP)entityPlayer).func_71120_a(entityPlayer.field_71069_bz);
                    airGenerator.energy_consume(WarpDriveConfig.AIRGEN_ENERGY_PER_CANISTER, false);
                }
            }
        }
        return false;
    }
}

