/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockUpdateDetector;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import defense.api.IEMPBlock;
import defense.api.IExplosion;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="defense.api.IEMPBlock", modid="DefenseTech")})
public abstract class BlockAbstractContainer
extends BlockContainer
implements IEMPBlock {
    protected boolean isRotating = false;
    protected boolean hasSubBlocks = false;

    protected BlockAbstractContainer(Material material) {
        super(material);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(WarpDrive.creativeTabWarpDrive);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IBlockUpdateDetector) {
            ((IBlockUpdateDetector)tileEntity).updatedNeighbours();
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        if (this.isRotating && entityLiving != null) {
            int metadata;
            if (entityLiving.field_70125_A > 65.0f) {
                metadata = 1;
            } else if (entityLiving.field_70125_A < -65.0f) {
                metadata = 0;
            } else {
                int direction = Math.round(entityLiving.field_70177_z / 90.0f) & 3;
                switch (direction) {
                    case 0: {
                        metadata = 2;
                        break;
                    }
                    case 1: {
                        metadata = 5;
                        break;
                    }
                    case 2: {
                        metadata = 3;
                        break;
                    }
                    case 3: {
                        metadata = 4;
                        break;
                    }
                    default: {
                        metadata = 2;
                    }
                }
            }
            world.func_72921_c(x, y, z, metadata, 3);
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (itemStack.func_77942_o()) {
            NBTTagCompound nbtTagCompound = (NBTTagCompound)itemStack.func_77978_p().func_74737_b();
            nbtTagCompound.func_74768_a("x", x);
            nbtTagCompound.func_74768_a("y", y);
            nbtTagCompound.func_74768_a("z", z);
            tileEntity.func_145839_a(nbtTagCompound);
            world.func_147471_g(x, y, z);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(world, player, x, y, z, false);
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack itemStack) {
        if (itemStack.func_77973_b() == Item.func_150898_a((Block)this)) {
            itemStack.func_77964_b(this.func_149643_k(world, x, y, z));
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity == null) {
                WarpDrive.logger.error("Missing tile entity for " + (Object)((Object)this) + " at " + world + " " + x + " " + y + " " + z);
            } else if (tileEntity instanceof TileEntityAbstractBase) {
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                ((TileEntityAbstractBase)tileEntity).writeItemDropNBT(nbtTagCompound);
                itemStack.func_77982_d(nbtTagCompound);
            }
        }
        world.func_147468_f(x, y, z);
        super.func_149642_a(world, x, y, z, itemStack);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer entityPlayer) {
        ItemStack itemStack = super.getPickBlock(target, world, x, y, z, entityPlayer);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        if (tileEntity instanceof TileEntityAbstractBase) {
            ((TileEntityAbstractBase)tileEntity).writeItemDropNBT(nbtTagCompound);
            itemStack.func_77982_d(nbtTagCompound);
        }
        return itemStack;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        world.func_72921_c(x, y, z, axis.ordinal(), 3);
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IBlockUpdateDetector) {
            ((IBlockUpdateDetector)tileEntity).updatedNeighbours();
        }
    }

    @Optional.Method(modid="DefenseTech")
    public void onEMP(World world, int x, int y, int z, IExplosion explosiveEMP) {
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info("EMP received at " + x + " " + y + " " + z + " from " + explosiveEMP + " with energy " + explosiveEMP.getEnergy() + " and radius " + explosiveEMP.getRadius());
        }
        this.onEMP(world, x, y, z, explosiveEMP.getRadius() / 100.0f);
    }

    public void onEMP(World world, int x, int y, int z, float efficiency) {
        TileEntityAbstractEnergy tileEntityAbstractEnergy;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityAbstractEnergy && (tileEntityAbstractEnergy = (TileEntityAbstractEnergy)tileEntity).energy_getMaxStorage() > 0) {
            tileEntityAbstractEnergy.energy_consume(Math.round((float)tileEntityAbstractEnergy.energy_getEnergyStored() * efficiency), false);
        }
    }

    public byte getTier(ItemStack itemStack) {
        return 1;
    }

    EnumRarity getRarity(ItemStack itemStack, EnumRarity rarity) {
        switch (this.getTier(itemStack)) {
            case 0: {
                return EnumRarity.epic;
            }
            case 1: {
                return EnumRarity.common;
            }
            case 2: {
                return EnumRarity.uncommon;
            }
            case 3: {
                return EnumRarity.rare;
            }
        }
        return rarity;
    }
}

