/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class GravityManager {
    private static final double OVERWORLD_ENTITY_GRAVITY = 0.08;
    private static final double OVERWORLD_ITEM_GRAVITY = (double)0.04f;
    private static final double OVERWORLD_ITEM_GRAVITY2 = (double)0.98f;
    private static final double HYPERSPACE_FIELD_ENTITY_GRAVITY = 0.035;
    private static final double HYPERSPACE_VOID_ENTITY_JITTER = 0.005;
    private static final double SPACE_FIELD_ENTITY_GRAVITY = 0.025;
    private static final double SPACE_FIELD_ITEM_GRAVITY = 0.02;
    private static final double SPACE_FIELD_ITEM_GRAVITY2 = 0.6;
    private static final double SPACE_VOID_GRAVITY = 0.001;
    private static final double SPACE_VOID_GRAVITY_JETPACK_SNEAK = 0.02;
    private static final double SPACE_VOID_GRAVITY_RAW_SNEAK = 0.005;

    public static double getGravityForEntity(Entity entity) {
        boolean inHyperspace;
        boolean inSpace = entity.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID;
        boolean bl = inHyperspace = entity.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID;
        if (inSpace || inHyperspace) {
            EntityPlayer player;
            boolean insideGravField = GravityManager.isEntityInGraviField(entity);
            if (insideGravField) {
                if (inSpace) {
                    return 0.025;
                }
                return 0.035;
            }
            double jitter = (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 2.0 * 0.005;
            if (inSpace) {
                jitter = 0.0;
            }
            if (entity instanceof EntityPlayer && (player = (EntityPlayer)entity).func_70093_af()) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack armor = player.func_82169_q(i);
                    if (armor == null || !Dictionary.ITEMS_FLYINSPACE.contains(armor.func_77973_b())) continue;
                    return 0.02;
                }
                return 0.005;
            }
            return 0.001 + jitter;
        }
        return 0.08;
    }

    public static double getItemGravity(EntityItem entity) {
        if (entity.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID || entity.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID) {
            if (GravityManager.isEntityInGraviField((Entity)entity)) {
                return 0.02;
            }
            return 0.001;
        }
        return 0.04f;
    }

    public static double getItemGravity2(EntityItem entity) {
        if (entity.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID || entity.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID) {
            if (GravityManager.isEntityInGraviField((Entity)entity)) {
                return 0.6;
            }
            return 0.001;
        }
        return 0.98f;
    }

    public static boolean isEntityInGraviField(Entity entity) {
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int CHECK_DISTANCE = 20;
        for (int ny = y; ny > y - 20; --ny) {
            if (entity.field_70170_p.func_147437_c(x, ny, z)) continue;
            return true;
        }
        return false;
    }
}

