/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import openmods.calc.ICalculatorFrame;
import openmods.calc.IExecutable;
import openmods.calc.ISymbol;

public class SymbolReference<E>
implements IExecutable<E> {
    private final String id;
    private Optional<Integer> argCount;
    private Optional<Integer> returnCount;

    public SymbolReference(String id) {
        this.id = id;
        this.argCount = Optional.absent();
        this.returnCount = Optional.absent();
    }

    public SymbolReference(String id, int argumentCount, int returnCount) {
        this.id = id;
        this.argCount = Optional.of((Object)argumentCount);
        this.returnCount = Optional.of((Object)returnCount);
    }

    public SymbolReference<?> setArgumentsCount(int count) {
        this.argCount = Optional.of((Object)count);
        return this;
    }

    public SymbolReference<?> setReturnsCount(int count) {
        this.returnCount = Optional.of((Object)count);
        return this;
    }

    @Override
    public void execute(ICalculatorFrame<E> frame) {
        ISymbol<E> symbol = frame.getSymbol(this.id);
        Preconditions.checkNotNull(symbol, (String)"Unknown symbol: %s", (Object[])new Object[]{this.id});
        try {
            symbol.execute(frame, this.argCount, this.returnCount);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute symbol '" + this.id + "'", e);
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.argCount, this.returnCount});
    }

    public boolean equals(Object obj) {
        if (obj instanceof SymbolReference) {
            SymbolReference other = (SymbolReference)obj;
            return other.id.equals(this.id) && other.argCount.equals(this.argCount) && other.returnCount.equals(this.returnCount);
        }
        return false;
    }

    private static <T> String printOptional(Optional<T> value) {
        return value.isPresent() ? String.valueOf(value.get()) : "?";
    }

    public String toString() {
        return this.id + "[-" + SymbolReference.printOptional(this.argCount) + "+" + SymbolReference.printOptional(this.returnCount) + "]";
    }
}

