/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.Constant;
import openmods.calc.FixedSymbol;
import openmods.calc.ICalculatorFrame;
import openmods.calc.IExecutable;
import openmods.calc.LocalFrame;
import openmods.calc.StackValidationException;
import openmods.utils.Stack;

public class CompiledFunction<E>
extends FixedSymbol<E> {
    private final IExecutable<E> body;

    public CompiledFunction(int argCount, int resultCount, IExecutable<E> body) {
        super(argCount, resultCount);
        this.body = body;
    }

    @Override
    public void execute(ICalculatorFrame<E> frame) {
        LocalFrame<E> newFrame = new LocalFrame<E>(frame);
        Stack<E> argumentStack = frame.stack();
        for (int i = 1; i <= this.argCount; ++i) {
            E arg = argumentStack.pop();
            newFrame.setLocalSymbol("$" + i, Constant.create(arg));
        }
        this.body.execute(newFrame);
        Stack<E> resultStack = newFrame.stack();
        for (int i = 0; i < this.resultCount; ++i) {
            E result = resultStack.pop();
            argumentStack.push(result);
        }
        int left = resultStack.size();
        if (left != 0) {
            throw new StackValidationException("Stack not empty after execution (expected %s, left %s)", this.resultCount, left);
        }
    }
}

