/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWindGenerator
extends TileEntityGenerator
implements IBoundingBlock {
    public double angle;
    public float currentMultiplier;
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getMultiplier"};

    public TileEntityWindGenerator() {
        super("wind", "WindGenerator", 200000.0, MekanismConfig.generators.windGenerationMax * 2.0);
        this.inventory = new ItemStack[1];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge((int)0, (IStrictEnergyStorage)this);
            if (this.ticker % 20 == 0) {
                float f;
                this.currentMultiplier = this.getMultiplier();
                this.setActive(f > 0.0f);
            }
            if (this.getActive()) {
                this.setEnergy(this.electricityStored + MekanismConfig.generators.windGenerationMin * (double)this.currentMultiplier);
            }
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.currentMultiplier = dataStream.readFloat();
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(Float.valueOf(this.currentMultiplier));
        return data;
    }

    public float getMultiplier() {
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e)) {
            float minY = MekanismConfig.generators.windGenerationMinY;
            float maxY = MekanismConfig.generators.windGenerationMaxY;
            float minG = (float)MekanismConfig.generators.windGenerationMin;
            float maxG = (float)MekanismConfig.generators.windGenerationMax;
            float slope = (maxG - minG) / (maxY - minY);
            float intercept = minG - slope * minY;
            float clampedY = Math.min(maxY, Math.max(minY, (float)(this.field_145848_d + 4)));
            float toGen = slope * clampedY + intercept;
            return toGen / minG;
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getVolume() {
        return 1.5f * super.getVolume();
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.BASE_MAX_ENERGY};
            }
            case 3: {
                return new Object[]{this.BASE_MAX_ENERGY - this.electricityStored};
            }
            case 4: {
                return new Object[]{Float.valueOf(this.getMultiplier())};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.BASE_MAX_ENERGY && this.getMultiplier() > 0.0f && MekanismUtils.canFunction((TileEntity)this);
    }

    public void onPlace() {
        Coord4D pos = Coord4D.get((TileEntity)this);
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (Coord4D)pos.getFromSide(ForgeDirection.UP, 1), (Coord4D)pos);
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (Coord4D)pos.getFromSide(ForgeDirection.UP, 2), (Coord4D)pos);
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (Coord4D)pos.getFromSide(ForgeDirection.UP, 3), (Coord4D)pos);
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (Coord4D)pos.getFromSide(ForgeDirection.UP, 4), (Coord4D)pos);
    }

    public void onBreak() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }
}

