/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class GraveExtendedPlayer
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "IPGraveExtendedPlayer";
    private final EntityPlayer player;
    private NBTTagList graveitems;
    private boolean restoreitems;

    public GraveExtendedPlayer(EntityPlayer player) {
        this.player = player;
        this.graveitems = null;
        this.restoreitems = false;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new GraveExtendedPlayer(player));
    }

    public static final GraveExtendedPlayer get(EntityPlayer player) {
        return (GraveExtendedPlayer)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        if (this.graveitems != null) {
            properties.func_74782_a("GraveInventory", (NBTBase)this.graveitems);
            properties.func_74757_a("RestoreItems", this.restoreitems);
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        if (this.graveitems != null) {
            this.graveitems = properties.func_150295_c("GraveInventory", 10);
            this.restoreitems = properties.func_74767_n("RestoreItems");
        } else {
            GraveExtendedPlayer props = GraveExtendedPlayer.get(this.player);
            NBTTagList itemlist = new NBTTagList();
            for (int j = 0; j < this.player.field_71071_by.func_70302_i_(); ++j) {
                ItemStack itemstack = this.player.field_71071_by.func_70301_a(j);
                if (itemstack == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)j);
                itemstack.func_77955_b(nbttagcompound);
                itemlist.func_74742_a((NBTBase)nbttagcompound);
            }
            this.restoreitems = false;
        }
    }

    public void init(Entity entity, World world) {
    }

    public void storeDetails(NBTTagList graveitems, boolean restoreitems) {
        this.graveitems = graveitems;
        this.restoreitems = restoreitems;
    }

    public NBTTagList getGraveitems() {
        return this.graveitems;
    }

    public boolean getRestoreItems() {
        return this.restoreitems;
    }
}

