/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.items;

import blusunrize.immersiveengineering.common.Config;
import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import unwrittenfun.minecraft.immersiveintegration.ImmersiveIntegration;

public class ItemCapacitorBox
extends Item
implements IEnergyContainerItem {
    private static final String[] KEYS = new String[]{"LV", "MV", "HV", "Creative"};
    private static final int[] capacity = new int[]{Config.getInt((String)"capacitorLV_storage"), Config.getInt((String)"capacitorMV_storage"), Config.getInt((String)"capacitorHV_storage"), Integer.MAX_VALUE};
    private static final int[] maxReceive = new int[]{Config.getInt((String)"capacitorLV_input"), Config.getInt((String)"capacitorMV_input"), Config.getInt((String)"capacitorHV_input"), 100000};
    private static final int[] maxExtract = new int[]{Config.getInt((String)"capacitorLV_output"), Config.getInt((String)"capacitorMV_output"), Config.getInt((String)"capacitorHV_output"), 100000};
    protected IIcon[] icons;
    protected String key;

    public ItemCapacitorBox(String key) {
        this.key = key;
        this.func_111206_d(key);
        this.func_77655_b(key);
        this.func_77627_a(true);
        this.func_77637_a(ImmersiveIntegration.iiCreativeTab);
        this.func_77625_d(1);
    }

    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[KEYS.length];
        for (int i = 0; i < KEYS.length; ++i) {
            this.icons[i] = register.func_94245_a(this.key + KEYS[i]);
        }
    }

    public IIcon func_77617_a(int meta) {
        return this.icons[Math.min(meta, this.icons.length - 1)];
    }

    public String func_77667_c(ItemStack stack) {
        int meta = Math.min(stack.func_77960_j(), KEYS.length - 1);
        return this.func_77658_a() + KEYS[meta];
    }

    public void func_150895_a(Item item, CreativeTabs tab, List items) {
        for (int i = 0; i < KEYS.length; ++i) {
            items.add(new ItemStack(item, 1, i));
            if (i == 3) continue;
            ItemStack fullStack = new ItemStack(item, 1, i);
            fullStack.field_77990_d = new NBTTagCompound();
            fullStack.field_77990_d.func_74768_a("Energy", capacity[i]);
            items.add(fullStack);
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean idc) {
        if (stack.func_77960_j() == 3) {
            lines.add(StatCollector.func_74838_a((String)"immersiveintegration.tooltip.capacitor.infinite"));
        } else {
            lines.add(this.getEnergyStored(stack) + " / " + this.getMaxEnergyStored(stack) + " RF");
        }
        if (this.isActive(stack)) {
            lines.add(StatCollector.func_74838_a((String)"immersiveintegration.tooltip.capacitor.active0"));
            lines.add(StatCollector.func_74838_a((String)"immersiveintegration.tooltip.capacitor.active1"));
        } else {
            lines.add(StatCollector.func_74838_a((String)"immersiveintegration.tooltip.capacitor.rightClickActive0"));
            lines.add(StatCollector.func_74838_a((String)"immersiveintegration.tooltip.capacitor.rightClickActive1"));
        }
    }

    public boolean isActive(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74757_a("Active", false);
            return false;
        }
        return stack.field_77990_d.func_74767_n("Active");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            stack.field_77990_d.func_74757_a("Active", !this.isActive(stack));
        }
        return stack;
    }

    public boolean hasEffect(ItemStack stack, int pass) {
        return this.isActive(stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int meta, boolean p_77663_5_) {
        EntityPlayer player;
        ItemStack held;
        if (!world.field_72995_K && this.isActive(stack) && entity instanceof EntityPlayer && (held = (player = (EntityPlayer)entity).func_70694_bm()) != stack && held != null && held.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem energyContainer = (IEnergyContainerItem)held.func_77973_b();
            int energyToInsert = this.extractEnergy(stack, maxExtract[stack.func_77960_j()], true);
            int energyExtracted = energyContainer.receiveEnergy(held, energyToInsert, false);
            this.extractEnergy(stack, energyExtracted, false);
        }
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int meta = Math.min(container.func_77960_j(), KEYS.length - 1);
        if (meta == 3) {
            return maxReceive;
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(capacity[meta] - energy, Math.min(ItemCapacitorBox.maxReceive[meta], maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int meta = Math.min(container.func_77960_j(), KEYS.length - 1);
        if (meta == 3) {
            return maxExtract;
        }
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(ItemCapacitorBox.maxExtract[meta], maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        int meta = Math.min(container.func_77960_j(), KEYS.length - 1);
        if (meta == 3) {
            return this.getMaxEnergyStored(container);
        }
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        int meta = Math.min(container.func_77960_j(), KEYS.length - 1);
        return capacity[meta];
    }
}

