/*
 * Decompiled with CFR 0.152.
 */
package hu.NVL.NVLWarpdriveExtensions.Registries;

import hu.NVL.NVLWarpdriveExtensions.Common.NVLCommonFunctions;
import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLCoordinates;
import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLDockProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;

public final class NVLDockListRegistry {
    private static final String DOCKFILENAME = "Docks.csv";
    private NVLCommonFunctions Logger = null;
    private File dbf;
    private ArrayList<NVLDockProperties> docks = new ArrayList();
    private boolean ServerType;

    public NVLDockListRegistry(NVLCommonFunctions Common) {
        this.Logger = Common;
        this.ServerType = NVLCommonFunctions.isServerDedicated();
        String baseFld = this.Logger.createNVLFolder();
        this.dbf = this.ServerType ? MinecraftServer.func_71276_C().func_71209_f(baseFld + "/" + DOCKFILENAME) : new File(baseFld + "/" + DOCKFILENAME);
        if (!this.dbf.exists()) {
            try {
                this.logLine("CreateFile result: " + this.dbf.createNewFile());
            }
            catch (IOException e) {
                this.logLine("CreateFile exception: " + e.toString());
            }
        }
        this.loadDocks();
    }

    private void logLine(String msg) {
        this.Logger.logLine("NVLDocksRegistry", msg);
    }

    private void saveDocks() {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.dbf));
            for (NVLDockProperties d : this.docks) {
                if (!d.isValid()) continue;
                out.println(d.toString());
            }
            out.close();
        }
        catch (IOException ex) {
            this.logLine("Exception: " + ex.toString());
        }
    }

    private void loadDocks() {
        try {
            String s1;
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.dbf));
            this.docks.clear();
            while ((s1 = bufferedreader.readLine()) != null) {
                this.docks.add(new NVLDockProperties(s1));
            }
            bufferedreader.close();
        }
        catch (IOException ex) {
            this.logLine("Exception: " + ex.toString());
        }
    }

    public String getDockNameAt(NVLCoordinates Coords, String Owner, String shipName) {
        String r = "";
        for (NVLDockProperties d : this.docks) {
            if (!d.getCoords().isMatch(Coords) || !d.getOwnerName().equals(Owner) || !d.getShipName().equals(shipName)) continue;
            r = d.getDockName();
        }
        return r;
    }

    public NVLCoordinates getDockCoordinatesByName(String Owner, String shipName, String dockName) {
        NVLCoordinates r = null;
        for (NVLDockProperties d : this.docks) {
            if (!dockName.equals(d.getDockName()) || !Owner.equals(d.getOwnerName()) || !shipName.equals(d.getShipName())) continue;
            r = new NVLCoordinates(d.getCoords());
        }
        return r;
    }

    public boolean addDock(NVLCoordinates newCoords, String newOwner, String newShipName, String newDockName) {
        boolean r = false;
        if (this.getDockNameAt(newCoords, newOwner, newShipName).isEmpty()) {
            NVLDockProperties d = new NVLDockProperties(newCoords, newOwner, newShipName, newDockName);
            this.docks.add(d);
            this.saveDocks();
            r = true;
        } else {
            r = this.updateDock(newCoords, newOwner, newShipName, newDockName);
        }
        this.updateOrientationOfShip(newOwner, newShipName, newCoords.ori);
        return r;
    }

    public boolean updateDock(NVLCoordinates coords, String Owner, String newShipName, String newDockName) {
        Boolean r = false;
        for (NVLDockProperties d : this.docks) {
            if (!d.getCoords().isMatch(coords) || !d.getOwnerName().equals(Owner)) continue;
            if (!newDockName.isEmpty()) {
                d.updateDockName(newDockName);
            }
            if (!newShipName.isEmpty()) {
                d.updateShipName(newShipName);
            }
            d.updateOrientation(coords.ori);
            this.saveDocks();
            r = true;
        }
        this.updateOrientationOfShip(Owner, newShipName, coords.ori);
        return r;
    }

    private void updateOrientationOfShip(String owner, String shipName, int newOri) {
        for (NVLDockProperties d : this.docks) {
            if (!d.getShipName().equals(shipName) || !owner.equals(d.getOwnerName()) || d.getCoords().ori != -1) continue;
            d.updateOrientation(newOri);
        }
    }

    public void renameShip(String Owner, String oldName, String newName) {
        for (NVLDockProperties d : this.docks) {
            if (!d.getShipName().equals(oldName) || !Owner.equals(d.getOwnerName())) continue;
            d.updateShipName(newName);
        }
        this.saveDocks();
    }

    public void removeDockByCoords(NVLCoordinates Coords, String Owner, String shipName) {
        for (int i = 0; i < this.docks.size(); ++i) {
            NVLDockProperties d = this.docks.get(i);
            if (!d.getCoords().isMatch(Coords) || !Owner.equals(d.getOwnerName()) || !shipName.equals(d.getShipName())) continue;
            this.docks.remove(i);
            this.saveDocks();
        }
    }

    public void removeDockByNames(String Owner, String shipName, String dockName) {
        for (int i = 0; i < this.docks.size(); ++i) {
            NVLDockProperties d = this.docks.get(i);
            if (!dockName.equals(d.getDockName()) || !shipName.equals(d.getShipName()) || !Owner.equals(d.getOwnerName())) continue;
            this.docks.remove(i);
            this.saveDocks();
        }
    }

    public String getDockList(String Owner, String shipName, int dimension) {
        String result = "";
        for (NVLDockProperties d : this.docks) {
            if (!Owner.equals(d.getOwnerName()) || !shipName.equals(d.getShipName()) || dimension != d.getCoords().dim) continue;
            result = result + d.toString() + ";";
        }
        return result;
    }
}

