/*
 * Decompiled with CFR 0.152.
 */
package hu.NVL.NVLWarpdriveExtensions;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hu.NVL.NVLWarpdriveExtensions.Common.NVLCommonFunctions;
import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLCoordinates;
import hu.NVL.NVLWarpdriveExtensions.Entities.NVLEntityDockingComputer;
import hu.NVL.NVLWarpdriveExtensions.Entities.NVLEntityShipyard;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class NVLPacketHandler {
    private NVLCommonFunctions Logger;
    private static final int PT_DOCK = 0;
    private static final int PT_SHIPY = 1;

    public NVLPacketHandler(NVLCommonFunctions Common) {
        this.Logger = Common;
    }

    private void logLine(String msg) {
        this.Logger.logLine("NVLPacketHandler", msg);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) throws IOException {
        String channelName = event.packet.channel();
        if (channelName.equals("NVLWDExt171015581")) {
            WorldClient w = Minecraft.func_71410_x().field_71441_e;
            ByteBuf buf = event.packet.payload();
            try {
                ByteBufInputStream bbis = new ByteBufInputStream(buf);
                int PacketType = bbis.readInt();
                if (PacketType == 0) {
                    this.processDockClientPacket((World)w, bbis);
                }
                if (PacketType == 1) {
                    this.processShipyardClientPacket((World)w, bbis);
                }
                bbis.close();
            }
            catch (IOException e) {
                this.logLine("onClientPacket: Exception: " + e.toString());
            }
        }
    }

    private void processDockClientPacket(World w, ByteBufInputStream bbis) {
        try {
            NVLCoordinates Coords = new NVLCoordinates(bbis.readUTF());
            String Props = bbis.readUTF();
            String DockList = bbis.readUTF();
            if (Coords.isValid().booleanValue()) {
                if (Coords.dim == w.field_73011_w.field_76574_g) {
                    TileEntity te = w.func_147438_o(Coords.x, Coords.y, Coords.z);
                    if (te != null) {
                        if (te instanceof NVLEntityDockingComputer) {
                            ((NVLEntityDockingComputer)te).decompileString(Props);
                            ((NVLEntityDockingComputer)te).setDockList(DockList);
                        } else {
                            this.logLine("processDockClientPacket: TileEntity is NOT a NVLEntityDockingComputer instance!");
                        }
                    } else {
                        this.logLine("processDockClientPacket: Could not find TileEntity at " + Coords.toString());
                    }
                } else {
                    this.logLine("processDockClientPacket: Target and world is not in the same dimension: " + Coords.dim + "," + w.field_73011_w.field_76574_g);
                }
            } else {
                this.logLine("processDockClientPacket: Self coordinates are invalid.");
            }
        }
        catch (IOException e) {
            this.logLine("processDockClientPacket: Exception: " + e.toString());
        }
    }

    private void processShipyardClientPacket(World w, ByteBufInputStream bbis) {
        try {
            NVLCoordinates Coords = new NVLCoordinates(bbis.readUTF());
            String owner = bbis.readUTF();
            boolean state = bbis.readBoolean();
            String engineerList = bbis.readUTF();
            String userList = bbis.readUTF();
            int eu = bbis.readInt();
            if (Coords.isValid().booleanValue()) {
                if (Coords.dim == w.field_73011_w.field_76574_g) {
                    TileEntity te = w.func_147438_o(Coords.x, Coords.y, Coords.z);
                    if (te != null) {
                        if (te instanceof NVLEntityShipyard) {
                            NVLEntityShipyard e = (NVLEntityShipyard)te;
                            e.setOwner(owner);
                            e.setEngineerList(engineerList);
                            e.setClientData(state, userList, eu);
                        } else {
                            this.logLine("procesShipyardClientPacket: TileEntity is NOT a NVLEntityDockingComputer instance!");
                        }
                    } else {
                        this.logLine("procesShipyardClientPacket: Could not find TileEntity at " + Coords.toString());
                    }
                } else {
                    this.logLine("procesShipyardClientPacket: Target and world is not in the same dimension: " + Coords.dim + "," + w.field_73011_w.field_76574_g);
                }
            } else {
                this.logLine("procesShipyardClientPacket: Self coordinates are invalid.");
            }
        }
        catch (IOException e) {
            this.logLine("procesShipyardClientPacket: Exception: " + e.toString());
        }
    }

    public FMLProxyPacket createDockServerPacket(NVLCoordinates SelfCoords, String Owner, String DockName, String TargetName) {
        ByteBufOutputStream bbos = new ByteBufOutputStream(Unpooled.buffer());
        FMLProxyPacket thePacket = null;
        try {
            bbos.writeInt(0);
            bbos.writeUTF(SelfCoords.toString());
            bbos.writeUTF(Owner);
            bbos.writeUTF(DockName);
            bbos.writeUTF(TargetName);
            thePacket = new FMLProxyPacket(bbos.buffer(), "NVLWDExt171015581");
            bbos.close();
        }
        catch (IOException e) {
            this.logLine("createDockServerUpdatePacket Exception: " + e.toString());
        }
        return thePacket;
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) throws IOException {
        String channelName = event.packet.channel();
        if (channelName.equals("NVLWDExt171015581")) {
            NetHandlerPlayServer theNetHandlerPlayServer = (NetHandlerPlayServer)event.handler;
            EntityPlayerMP thePlayer = theNetHandlerPlayServer.field_147369_b;
            WorldServer w = null;
            w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() ? MinecraftServer.func_71276_C().func_71218_a(thePlayer.field_71093_bK) : Minecraft.func_71410_x().func_71401_C().func_71218_a(thePlayer.field_71093_bK);
            ByteBuf buf = event.packet.payload();
            if (w != null) {
                try {
                    ByteBufInputStream bbis = new ByteBufInputStream(buf);
                    int PacketType = bbis.readInt();
                    if (PacketType == 0) {
                        this.processDockServerPacket((World)w, bbis, thePlayer);
                    }
                    if (PacketType == 1) {
                        this.processShipyardServerPacket((World)w, bbis, thePlayer);
                    }
                    bbis.close();
                }
                catch (IOException e) {
                    this.logLine("onServerPacket: Exception: " + e.toString());
                }
            }
        }
    }

    private void processDockServerPacket(World w, ByteBufInputStream bbis, EntityPlayerMP player) {
        try {
            NVLCoordinates Coords = new NVLCoordinates(bbis.readUTF());
            String Owner = bbis.readUTF();
            String DockName = bbis.readUTF();
            String TargetName = bbis.readUTF();
            if (Coords.isValid().booleanValue()) {
                if (Coords.dim == w.field_73011_w.field_76574_g) {
                    TileEntity te = w.func_147438_o(Coords.x, Coords.y, Coords.z);
                    if (te != null) {
                        if (te instanceof NVLEntityDockingComputer) {
                            if (!Owner.isEmpty()) {
                                if (!DockName.isEmpty()) {
                                    if (!TargetName.isEmpty()) {
                                        if (TargetName.equals("DELETE")) {
                                            ((NVLEntityDockingComputer)te).deleteDock(Owner, DockName, player);
                                        } else {
                                            ((NVLEntityDockingComputer)te).jumpToDock(Owner, TargetName);
                                        }
                                    } else {
                                        ((NVLEntityDockingComputer)te).updateDock(Owner, DockName, player);
                                    }
                                } else {
                                    ((NVLEntityDockingComputer)te).sendDockListToClient(Owner, player);
                                }
                            }
                        } else {
                            this.logLine("processDockServerPacket: TileEntity is NOT a NVLEntityDockingComputer instance!");
                        }
                    } else {
                        this.logLine("processDockServerPacket: Could not find TileEntity at " + Coords.toString());
                    }
                } else {
                    this.logLine("processDockServerPacket: Target and world is not in the same dimension: " + Coords.dim + "," + w.field_73011_w.field_76574_g);
                }
            } else {
                this.logLine("processDockServerPacket: Self coordinates are invalid.");
            }
        }
        catch (IOException e) {
            this.logLine("processDockServerPacket: Exception: " + e.toString());
        }
    }

    public FMLProxyPacket createDockPacketForClient(NVLCoordinates selfCoords, String Props, String DockList) {
        ByteBufOutputStream bbos = new ByteBufOutputStream(Unpooled.buffer());
        FMLProxyPacket thePacket = null;
        try {
            bbos.writeInt(0);
            bbos.writeUTF(selfCoords.toString());
            bbos.writeUTF(Props);
            bbos.writeUTF(DockList);
            thePacket = new FMLProxyPacket(bbos.buffer(), "NVLWDExt171015581");
            bbos.close();
        }
        catch (IOException e) {
            this.logLine("createDockPacketForClient Exception: " + e.toString());
        }
        return thePacket;
    }

    private void processShipyardServerPacket(World w, ByteBufInputStream bbis, EntityPlayerMP player) {
        try {
            NVLCoordinates Coords = new NVLCoordinates(bbis.readUTF());
            String owner = bbis.readUTF();
            boolean state = bbis.readBoolean();
            String engineerList = bbis.readUTF();
            String userList = bbis.readUTF();
            if (Coords.isValid().booleanValue()) {
                if (Coords.dim == w.field_73011_w.field_76574_g) {
                    TileEntity te = w.func_147438_o(Coords.x, Coords.y, Coords.z);
                    if (te != null) {
                        if (te instanceof NVLEntityShipyard) {
                            NVLEntityShipyard e = (NVLEntityShipyard)te;
                            if (!owner.isEmpty()) {
                                if (owner.equals("-DELETE-")) {
                                    owner = "";
                                }
                                e.setOwner(owner);
                            } else if (userList.equals("-SETSTATE-")) {
                                if (!state) {
                                    e.turnOff(player);
                                } else {
                                    e.turnOn(player);
                                }
                            } else if (engineerList.isEmpty()) {
                                e.updateClient(player);
                            } else if (engineerList.equals("-DELETE-")) {
                                e.setEngineerList("");
                            } else {
                                e.setEngineerList(engineerList);
                            }
                        } else {
                            this.logLine("processShipyardServerPacket: TileEntity is NOT a NVLEntityDockingComputer instance!");
                        }
                    } else {
                        this.logLine("processShipyardServerPacket: Could not find TileEntity at " + Coords.toString());
                    }
                } else {
                    this.logLine("processShipyardServerPacket: Target and world is not in the same dimension: " + Coords.dim + "," + w.field_73011_w.field_76574_g);
                }
            } else {
                this.logLine("processShipyardServerPacket: Self coordinates are invalid.");
            }
        }
        catch (IOException e) {
            this.logLine("processShipyardServerPacket: Exception: " + e.toString());
        }
    }

    public FMLProxyPacket createShipyardPacket(NVLCoordinates selfCoords, String Owner, boolean State, String EngineerList, String UserList, int EU) {
        ByteBufOutputStream bbos = new ByteBufOutputStream(Unpooled.buffer());
        FMLProxyPacket thePacket = null;
        try {
            bbos.writeInt(1);
            bbos.writeUTF(selfCoords.toString());
            bbos.writeUTF(Owner);
            bbos.writeBoolean(State);
            bbos.writeUTF(EngineerList);
            bbos.writeUTF(UserList);
            bbos.writeInt(EU);
            thePacket = new FMLProxyPacket(bbos.buffer(), "NVLWDExt171015581");
            bbos.close();
        }
        catch (IOException e) {
            this.logLine("createShipyardPacketForClient Exception: " + e.toString());
        }
        return thePacket;
    }
}

