/*
 * Decompiled with CFR 0.152.
 */
package hu.NVL.NVLWarpdriveExtensions;

import cpw.mods.fml.common.FMLCommonHandler;
import hu.NVL.NVLWarpdriveExtensions.Common.NVLCommonFunctions;
import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLBlockRef;
import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLStructureObject;
import hu.NVL.NVLWarpdriveExtensions.NVLWarpdriveExtensions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class NVLCommandStructures
extends CommandBase {
    File fld;

    public NVLCommandStructures() {
        this.fld = new File(NVLWarpdriveExtensions.instance.NVLFolderPath);
    }

    private static void logLine(String msg) {
        NVLWarpdriveExtensions.NVLCommon.logLine("NVLCommandStructures", msg);
    }

    public String func_71517_b() {
        return "structures";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "/" + this.func_71517_b() + " list, place name, save width height depth name, clear width height depth";
    }

    public void func_71515_b(ICommandSender icommandsender, String[] params) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            EntityPlayerMP player = (EntityPlayerMP)icommandsender;
            if (params.length > 0) {
                int d;
                int h;
                int w;
                String func = params[0];
                NVLCommonFunctions.addChatMessage((ICommandSender)player, func);
                if (func.equals("list")) {
                    this.getList(player);
                }
                if (func.equals("save") && params.length == 5) {
                    w = Integer.parseInt(params[1]);
                    h = Integer.parseInt(params[2]);
                    d = Integer.parseInt(params[3]);
                    this.saveStruct(w, h, d, params[4], player);
                }
                if (func.equals("place") && params.length == 2) {
                    this.createStruct(params[1], player);
                }
                if (func.equals("clear") && params.length == 4) {
                    w = Integer.parseInt(params[1]);
                    h = Integer.parseInt(params[2]);
                    d = Integer.parseInt(params[3]);
                    this.clearSpace(w, h, d, player);
                }
            } else {
                NVLCommonFunctions.addChatMessage((ICommandSender)player, this.func_71518_a(icommandsender));
            }
        }
    }

    private void clearSpace(int w, int h, int d, EntityPlayerMP e) {
        int Dir = NVLCommonFunctions.NVLGetPlayerDirection((EntityPlayer)e);
        NVLCommandStructures.logLine("clearSpace:" + w + "," + h + "," + d + "," + Dir);
        int ax = MathHelper.func_76128_c((double)e.field_70165_t);
        int ay = MathHelper.func_76128_c((double)e.field_70163_u);
        int az = MathHelper.func_76128_c((double)e.field_70161_v);
        WorldServer world = null;
        world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() ? MinecraftServer.func_71276_C().func_71218_a(e.field_71093_bK) : Minecraft.func_71410_x().func_71401_C().func_71218_a(e.field_71093_bK);
        NVLBlockRef b = new NVLBlockRef();
        b.block = Blocks.field_150350_a;
        NVLCommonFunctions.NVLSetBlocksByDirection((World)world, ax, ay, az, -(w / 2), 0, 1, w, h, d, Dir, 0, b);
    }

    private void createStruct(String name, EntityPlayerMP e) {
        ArrayList<NVLStructureObject> List2 = new ArrayList<NVLStructureObject>();
        int Dir = NVLCommonFunctions.NVLGetPlayerDirection((EntityPlayer)e);
        int ax = MathHelper.func_76128_c((double)e.field_70165_t);
        int ay = MathHelper.func_76128_c((double)e.field_70163_u);
        int az = MathHelper.func_76128_c((double)e.field_70161_v);
        File f = new File(NVLWarpdriveExtensions.instance.NVLFolderPath + "/" + name + ".str");
        if (f.exists()) {
            try {
                String s;
                BufferedReader r = new BufferedReader(new FileReader(f));
                int CurrentObjectIndex = 0;
                List2.add(new NVLStructureObject("Main"));
                while ((s = r.readLine()) != null) {
                    String[] params = s.split(",");
                    if (params.length == 1 && params[0].equals("E")) {
                        CurrentObjectIndex = 0;
                    }
                    if (params.length == 2) {
                        if (params[0].equals("O")) {
                            CurrentObjectIndex = this.getObjectIndex(List2, params[1], true);
                        }
                        if (params[0].equals("B")) {
                            List2.get(CurrentObjectIndex).addItem(s);
                        }
                    }
                    if (params.length != 5 && params.length != 6 && params.length != 8) continue;
                    ((NVLStructureObject)List2.get(CurrentObjectIndex)).addItem(s);
                }
                r.close();
                WorldServer w = null;
                w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() ? MinecraftServer.func_71276_C().func_71218_a(e.field_71093_bK) : Minecraft.func_71410_x().func_71401_C().func_71218_a(e.field_71093_bK);
                this.placeObject(List2, 0, (World)w, ax, ay, az, Dir, e);
                NVLCommonFunctions.addChatMessage((ICommandSender)e, "Structure " + name + " completed.");
            }
            catch (Exception ex) {
                NVLCommandStructures.logLine("saveStruct: could not load file: " + NVLWarpdriveExtensions.instance.NVLFolderPath + "/" + name + ".str: " + ex.toString() + "," + ex.getCause().toString());
            }
        } else {
            NVLCommonFunctions.addChatMessage((ICommandSender)e, "Structure " + name + " does not exist!");
        }
    }

    private void placeObject(ArrayList<NVLStructureObject> list, int ObjectIndex, World w, int bx, int by, int bz, int o, EntityPlayerMP e) {
        NVLBlockRef b = new NVLBlockRef();
        int lx = 0;
        int ly = 0;
        int lz = 0;
        int lo = 0;
        for (int idx = 0; idx < list.get(ObjectIndex).getCount(); ++idx) {
            String op;
            String[] params = list.get(ObjectIndex).getItem(idx).split(",");
            if (params.length == 2 && params[0].equals("B")) {
                if (!params[1].equals(list.get(ObjectIndex).getName())) {
                    int i = this.getObjectIndex(list, params[1], false);
                    if (i > -1) {
                        this.placeObject(list, i, w, bx + lx, by + ly, bz + lz, (o + lo) % 4, e);
                    } else {
                        NVLCommonFunctions.addChatMessage((ICommandSender)e, "Could not find object: " + params[1] + " in " + list.get(ObjectIndex).getName());
                    }
                } else {
                    NVLCommonFunctions.addChatMessage((ICommandSender)e, "Loop detected in " + params[1]);
                }
            }
            if (params.length == 5 && (op = params[0]).equals("P")) {
                lx = Integer.parseInt(params[1]);
                ly = Integer.parseInt(params[2]);
                lz = Integer.parseInt(params[3]);
                lo = Integer.parseInt(params[4]);
            }
            if (params.length < 6) continue;
            int x = Integer.parseInt(params[0]);
            int y = Integer.parseInt(params[1]);
            int z = Integer.parseInt(params[2]);
            int xn = 1;
            int yn = 1;
            int zn = 1;
            String bname = "";
            int meta = 0;
            if (params.length == 6) {
                zn = Integer.parseInt(params[3]);
                bname = params[4];
                meta = Integer.parseInt(params[5]);
            }
            if (params.length == 8) {
                xn = Integer.parseInt(params[3]);
                yn = Integer.parseInt(params[4]);
                zn = Integer.parseInt(params[5]);
                bname = params[6];
                meta = Integer.parseInt(params[7]);
            }
            b.block = Block.func_149684_b((String)bname);
            if (b.block != null) {
                NVLCommonFunctions.NVLSetBlocksByDirection(w, bx + lx, by + ly, bz + lz, x, y, z, xn, yn, zn, (o + lo) % 4, meta, b);
                continue;
            }
            NVLCommonFunctions.addChatMessage((ICommandSender)e, "Could not get block from name " + bname);
        }
    }

    private int getObjectIndex(ArrayList<NVLStructureObject> list, String NameToSearch, boolean Create) {
        int r = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getName().equals(NameToSearch)) continue;
            r = i;
        }
        if (r == -1 && Create) {
            list.add(new NVLStructureObject(NameToSearch));
            r = list.size() - 1;
        }
        return r;
    }

    private void saveStruct(int w, int h, int d, String name, EntityPlayerMP e) {
        int Dir = NVLCommonFunctions.NVLGetPlayerDirection((EntityPlayer)e);
        int ax = MathHelper.func_76128_c((double)e.field_70165_t);
        int ay = MathHelper.func_76128_c((double)e.field_70163_u);
        int az = MathHelper.func_76128_c((double)e.field_70161_v);
        File f = new File(NVLWarpdriveExtensions.instance.NVLFolderPath + "/" + name + ".str");
        Minecraft mc = Minecraft.func_71410_x();
        WorldServer world = null;
        if (mc.func_71401_C() != null) {
            world = mc.func_71401_C().func_71218_a(mc.field_71439_g.field_71093_bK);
        } else if (MinecraftServer.func_71276_C() != null) {
            world = MinecraftServer.func_71276_C().func_71218_a(mc.field_71439_g.field_71093_bK);
        }
        try {
            f.createNewFile();
            PrintWriter out = new PrintWriter(new FileWriter(f));
            out.println("dim," + w + "," + h + "," + d);
            for (int z = 0; z < d; ++z) {
                for (int y = 0; y < h; ++y) {
                    for (int x = -(w / 2); x < w / 2; ++x) {
                        NVLBlockRef b = NVLCommonFunctions.NVLGetBlockByDirection((World)world, ax, ay, az, x, y, z, Dir);
                        if (b.block == null || b.equalsTo(Blocks.field_150350_a).booleanValue()) continue;
                        out.println(x + "," + y + "," + z + ",1," + Block.field_149771_c.func_148750_c((Object)b.block) + "," + b.meta);
                    }
                }
            }
            out.close();
            NVLCommonFunctions.addChatMessage((ICommandSender)e, "Sturcture saved!");
        }
        catch (Exception ex) {
            NVLCommandStructures.logLine("saveStruct: could not create file: " + NVLWarpdriveExtensions.instance.NVLFolderPath + "/" + name + ".str");
        }
    }

    private void getList(EntityPlayerMP e) {
        File[] listOfFiles = this.fld.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file_notUsed, String name) {
                return name.endsWith(".str");
            }
        });
        String List2 = "";
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile()) continue;
            if (!List2.isEmpty()) {
                List2 = List2 + ",";
            }
            List2 = List2 + listOfFiles[i].getName().replace(".str", "");
        }
        NVLCommonFunctions.addChatMessage((ICommandSender)e, "Available structures: " + List2);
    }
}

