/*
 * Decompiled with CFR 0.152.
 */
package hu.NVL.NVLWarpdriveExtensions.Entities;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import hu.NVL.NVLWarpdriveExtensions.Common.NVLCommonFunctions;
import hu.NVL.NVLWarpdriveExtensions.Common.NVLTileEntity;
import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLCoordinates;
import hu.NVL.NVLWarpdriveExtensions.NVLWarpdriveExtensions;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.StringUtils;

public class NVLEntityShipyard
extends NVLTileEntity
implements IEnergySink {
    private static final int MAXENERGY = 1000000;
    private NVLCoordinates SelfCoords = new NVLCoordinates();
    private Boolean addedToEnergyNet = false;
    private long nextUpdate = 0L;
    private String ClientUsers = "";
    private boolean Active = false;
    private int CurrentEnergy = 0;
    private String EngineerList = "";
    private String Owner = "";

    private void doFirstConfig() {
        this.SelfCoords.getCoordsFromTileEntity(this);
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.addToEnergyNet();
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.sendUpdateRequestToServer();
        }
    }

    public void setOwner(String newOwner) {
        this.Owner = newOwner;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.updateClients();
        }
    }

    public void setEngineerList(String newList) {
        this.EngineerList = newList;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.updateClients();
        }
    }

    public boolean isActive() {
        return this.Active;
    }

    public String getClientOwner() {
        return this.Owner;
    }

    public String getClientUserList() {
        return this.ClientUsers;
    }

    public String getClientEngineerList() {
        return this.EngineerList;
    }

    public int getClientEnergy() {
        return this.CurrentEnergy;
    }

    public Boolean getUpdateMode() {
        return this.nextUpdate != 0L;
    }

    public Boolean isUserAllowed(String user) {
        boolean r = false;
        if (!this.EngineerList.isEmpty()) {
            String[] l = this.EngineerList.split(",");
            for (int i = 0; i < l.length && !r; ++i) {
                if (!l[i].equals(user)) continue;
                r = true;
            }
        }
        return r;
    }

    public Boolean useTool() {
        Boolean r = false;
        if (this.CurrentEnergy > 1000) {
            this.CurrentEnergy -= 1000;
            r = true;
        }
        return r;
    }

    public void sendUpdateRequestToServer() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (this.SelfCoords.isValid().booleanValue()) {
                NVLWarpdriveExtensions.channel.sendToServer(NVLWarpdriveExtensions.NVLPacketHandler.createShipyardPacket(this.SelfCoords, "", this.Active, "", "", 0));
                this.resetClientUpdateRequestCounter();
            } else {
                this.logLine("updateClient: self coordinates are invalid!");
            }
        }
    }

    public void sendUpdateToServer(String newOwner, Boolean newActive, String newEngineerList, String newUserList) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (this.SelfCoords.isValid().booleanValue()) {
                NVLWarpdriveExtensions.channel.sendToServer(NVLWarpdriveExtensions.NVLPacketHandler.createShipyardPacket(this.SelfCoords, newOwner, newActive, newEngineerList, newUserList, 0));
                this.resetClientUpdateRequestCounter();
            } else {
                this.logLine("updateClient: self coordinates are invalid!");
            }
        }
    }

    public void setClientData(boolean newActive, String newUserList, int newEnergyAmount) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.Active = newActive;
            this.ClientUsers = newUserList;
            this.CurrentEnergy = newEnergyAmount;
            this.nextUpdate = 0L;
        }
    }

    private void setMeta() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int m = 0;
            if (this.Active) {
                if (this.CurrentEnergy == 0) {
                    m = 1;
                }
                m = 1 + (int)Math.ceil(this.CurrentEnergy / 100000);
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, m, 2);
        }
    }

    public void turnOff(EntityPlayerMP p) {
        if (this.Active) {
            this.Active = false;
            this.setMeta();
            if (p != null) {
                NVLCommonFunctions.addChatMessage((ICommandSender)p, EnumChatFormatting.GREEN + "Shipyard successfully turned OFF");
            }
            this.updateClients();
        } else if (p != null) {
            NVLCommonFunctions.addChatMessage((ICommandSender)p, EnumChatFormatting.AQUA + "Shipyard is already OFF");
        }
    }

    public void turnOn(EntityPlayerMP p) {
        if (!this.scanForOtherShipyard()) {
            if (!this.Active) {
                this.Active = true;
                this.setMeta();
                NVLCommonFunctions.addChatMessage((ICommandSender)p, EnumChatFormatting.GREEN + "Shipyard successfully turned ON");
                this.updateClients();
            } else {
                NVLCommonFunctions.addChatMessage((ICommandSender)p, EnumChatFormatting.AQUA + "Shipyard is already ON");
            }
        } else {
            NVLCommonFunctions.addChatMessage((ICommandSender)p, EnumChatFormatting.RED + "Another active Shipyard found in range.\n" + EnumChatFormatting.RED + "Cannot activate!");
        }
    }

    private boolean scanForOtherShipyard() {
        boolean r = false;
        TileEntity e = null;
        for (int x = -100; x < 100 && !r; ++x) {
            for (int z = -100; z < 100 && !r; ++z) {
                int maxy;
                int miny = this.field_145848_d - 100;
                if (miny < 0) {
                    miny = 0;
                }
                if ((maxy = this.field_145848_d + 100) > 255) {
                    maxy = 256;
                }
                for (int y = miny; y < maxy && !r; ++y) {
                    e = this.field_145850_b.func_147438_o(this.field_145851_c + x, y, this.field_145849_e + z);
                    if (e == null || !(e instanceof NVLEntityShipyard)) continue;
                    r = ((NVLEntityShipyard)e).isActive();
                }
            }
        }
        return r;
    }

    private String getUsers() {
        Object[] Names = FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z();
        this.logLine("getUsers: Lines: " + StringUtils.join((Object[])Names, (char)','));
        return StringUtils.join((Object[])Names, (char)',');
    }

    public void updateClients() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (this.SelfCoords.isValid().booleanValue()) {
                NVLWarpdriveExtensions.channel.sendToAll(NVLWarpdriveExtensions.NVLPacketHandler.createShipyardPacket(this.SelfCoords, this.Owner, this.Active, this.EngineerList, this.getUsers(), this.CurrentEnergy));
            } else {
                this.logLine("updateClients: self coordinates are invalid!");
            }
        }
    }

    public void updateClient(EntityPlayerMP p) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (this.SelfCoords.isValid().booleanValue()) {
                NVLWarpdriveExtensions.channel.sendTo(NVLWarpdriveExtensions.NVLPacketHandler.createShipyardPacket(this.SelfCoords, this.Owner, this.Active, this.EngineerList, this.getUsers(), this.CurrentEnergy), p);
            } else {
                this.logLine("updateClient: self coordinates are invalid!");
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.Owner = tag.func_74779_i("owner");
        this.EngineerList = tag.func_74779_i("eng");
        this.CurrentEnergy = tag.func_74762_e("eu");
        this.Active = tag.func_74767_n("act");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74778_a("owner", this.Owner);
        tag.func_74778_a("eng", this.EngineerList);
        tag.func_74768_a("eu", this.CurrentEnergy);
        tag.func_74757_a("act", this.Active);
    }

    public void resetClientUpdateRequestCounter() {
        this.nextUpdate = this.field_145850_b.func_82737_E() + 5L;
    }

    public void func_145845_h() {
        if (!this.SelfCoords.isValid().booleanValue()) {
            this.doFirstConfig();
        }
        if (this.nextUpdate > 0L && this.nextUpdate < this.field_145850_b.func_82737_E()) {
            this.sendUpdateRequestToServer();
        }
    }

    private void addToEnergyNet() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && !this.addedToEnergyNet.booleanValue() && !this.field_145846_f) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    private void removeFromEnergyNet(String reason) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
            this.Active = false;
            this.setMeta();
        }
    }

    public void onChunkUnload() {
        this.removeFromEnergyNet("onChunkUnload");
        super.onChunkUnload();
    }

    public void func_145843_s() {
        this.removeFromEnergyNet("invalidate");
        super.func_145843_s();
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        return this.Active ? 1000000 - this.CurrentEnergy : 0;
    }

    public int getSinkTier() {
        return 2;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        int r = (int)amount;
        if (this.Active) {
            int newMetaVal;
            int metaVal = this.CurrentEnergy / 100000;
            this.CurrentEnergy = (int)((double)this.CurrentEnergy + amount);
            if (this.CurrentEnergy > 1000000) {
                r = this.CurrentEnergy - 1000000;
                this.CurrentEnergy = 1000000;
            }
            if (metaVal != (newMetaVal = this.CurrentEnergy / 100000)) {
                this.setMeta();
            }
        }
        return r;
    }
}

