/*
 * Decompiled with CFR 0.152.
 */
package hu.NVL.NVLWarpdriveExtensions.Entities;

import cpw.mods.fml.common.FMLCommonHandler;
import cr0s.warpdrive.block.movement.TileEntityShipController;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import hu.NVL.NVLWarpdriveExtensions.Common.NVLTileEntity;
import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLCoordinates;
import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLWarpControllerData;
import hu.NVL.NVLWarpdriveExtensions.NVLWarpdriveExtensions;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.DimensionManager;

public class NVLEntityDockingComputer
extends NVLTileEntity {
    private static final int DOCKINGRANGE = 64;
    private NVLWarpControllerData WCData;
    private String shipName = "";
    public String dockList = "";
    private NVLCoordinates Coords = new NVLCoordinates();
    private NVLCoordinates WCCoords = null;
    private NVLCoordinates WCoreCoords = null;

    public NVLEntityDockingComputer() {
        this.WCData = new NVLWarpControllerData();
        this.WCCoords = new NVLCoordinates();
        this.WCoreCoords = new NVLCoordinates();
    }

    private void doFirstConfig() {
        this.Coords.getCoordsFromTileEntity(this);
    }

    public NVLWarpControllerData getWCData() {
        return this.WCData;
    }

    public Boolean hasValidConfig() {
        return this.WCCoords.isValid() != false && this.WCoreCoords.isValid() != false;
    }

    public void setDockList(String newList) {
        this.dockList = newList;
    }

    public void decompileString(String line) {
        this.WCData.fillDataFromString(line);
    }

    public void requestSaveDock(String Owner, String newName) {
        this.sendRequestToServer(Owner, newName, "");
    }

    public void requestDeleteDock(String Owner, String dockName) {
        this.sendRequestToServer(Owner, dockName, "DELETE");
    }

    public void requestInitiateJump(String Owner, String dockName) {
        this.sendRequestToServer(Owner, dockName, dockName);
    }

    public void requestUpdate(String Owner) {
        this.sendRequestToServer(Owner, "", "");
    }

    private void sendRequestToServer(String Owner, String DockName, String TargetName) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (!this.Coords.isValid().booleanValue()) {
                this.doFirstConfig();
            }
            if (this.Coords.isValid().booleanValue()) {
                this.WCData.playerlist = "Request";
                NVLWarpdriveExtensions.channel.sendToServer(NVLWarpdriveExtensions.NVLPacketHandler.createDockServerPacket(this.Coords, Owner, DockName, TargetName));
            } else {
                this.logLine("sendRequestToServer: Coordinates are invalid!");
            }
        }
    }

    public void sendClientUpdate(EntityPlayerMP Player) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (!this.Coords.isValid().booleanValue()) {
                this.doFirstConfig();
            }
            if (this.Coords.isValid().booleanValue()) {
                NVLWarpdriveExtensions.channel.sendTo(NVLWarpdriveExtensions.NVLPacketHandler.createDockPacketForClient(this.Coords, this.WCData.toString(), this.dockList), Player);
            } else {
                this.logLine("sendClientUpdate: self coordinates are invalid!");
            }
        }
    }

    public void deleteDock(String Owner, String DockName, EntityPlayerMP Player) {
        NVLWarpdriveExtensions.NVLDocks.removeDockByNames(Owner, this.WCData.name, DockName);
        this.sendDockListToClient(Owner, Player);
    }

    public void jumpToDock(String owner, String targetName) {
        NVLCoordinates Coords = NVLWarpdriveExtensions.NVLDocks.getDockCoordinatesByName(owner, this.WCData.name, targetName);
        if (Coords != null) {
            if (Coords.isValid().booleanValue()) {
                this.doJump(Coords);
            } else {
                this.logLine("jumpToDock: target coordinates are invalid!");
            }
        } else {
            this.logLine("jumpToDock: could not find dock for names: " + owner + "," + this.WCData.name + "," + targetName);
        }
    }

    public void updateDock(String owner, String newTargetName, EntityPlayerMP player) {
        NVLWarpdriveExtensions.NVLDocks.addDock(this.WCoreCoords, owner, this.WCData.name, newTargetName);
        this.sendDockListToClient(owner, player);
    }

    public void sendDockListToClient(String Owner, EntityPlayerMP player) {
        this.dockList = this.getDockList(Owner, player);
        this.sendClientUpdate(player);
    }

    private String getDockList(String Owner, EntityPlayerMP player) {
        this.getControllerInfo();
        String r = "";
        if (!this.shipName.equals(this.WCData.name) && !this.shipName.isEmpty()) {
            NVLWarpdriveExtensions.NVLDocks.renameShip(Owner, this.shipName, this.WCData.name);
            this.shipName = this.WCData.name;
        }
        String temp = NVLWarpdriveExtensions.NVLDocks.getDockList(Owner, this.WCData.name, this.Coords.dim);
        String[] list = temp.split(";");
        if (this.WCoreCoords.isValid().booleanValue()) {
            for (int i = 0; i < list.length; ++i) {
                String[] item = list[i].split(",");
                if (item.length == 8) {
                    int ddim = Integer.parseInt(item[0]);
                    String dname = DimensionManager.getProvider((int)ddim).func_80007_l();
                    String isNear = "N";
                    if (this.field_145850_b.field_73011_w.field_76574_g == ddim) {
                        int x = Integer.parseInt(item[1]);
                        int y = Integer.parseInt(item[2]);
                        int z = Integer.parseInt(item[3]);
                        if (x < this.WCoreCoords.x + 64 && x > this.WCoreCoords.x - 64 && y < this.WCoreCoords.y + 64 && y > this.WCoreCoords.y - 64 && z < this.WCoreCoords.z + 64 && z > this.WCoreCoords.z - 64) {
                            isNear = "Y";
                        }
                        if (x == this.WCoreCoords.x && y == this.WCoreCoords.y && z == this.WCoreCoords.z) {
                            isNear = "S";
                        }
                    }
                    r = r + list[i] + "," + dname + "," + isNear + ";";
                    continue;
                }
                this.logLine("getDockList: item invalid, has " + item.length + " elements instead of 8");
            }
        } else {
            r = "NOCORE";
        }
        return r;
    }

    public void getControllerInfo() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            TileEntity e;
            if (!this.Coords.isValid().booleanValue()) {
                this.doFirstConfig();
            }
            if ((e = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) != null && e instanceof TileEntityShipController) {
                this.loadControllerConfig((TileEntityShipController)e);
            }
            if ((e = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) != null && e instanceof TileEntityShipController) {
                this.loadControllerConfig((TileEntityShipController)e);
            }
            if ((e = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) != null && e instanceof TileEntityShipController) {
                this.loadControllerConfig((TileEntityShipController)e);
            }
            if ((e = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) != null && e instanceof TileEntityShipController) {
                this.loadControllerConfig((TileEntityShipController)e);
            }
            if ((e = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) != null && e instanceof TileEntityShipController) {
                this.loadControllerConfig((TileEntityShipController)e);
            }
            if ((e = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) != null && e instanceof TileEntityShipController) {
                this.loadControllerConfig((TileEntityShipController)e);
            }
        }
    }

    private void loadControllerConfig(TileEntityShipController c) {
        this.WCCoords.dim = this.field_145850_b.field_73011_w.field_76574_g;
        this.WCCoords.x = c.field_145851_c;
        this.WCCoords.y = c.field_145848_d;
        this.WCCoords.z = c.field_145849_e;
        NBTTagCompound tag = new NBTTagCompound();
        c.func_145841_b(tag);
        this.WCData.mode = tag.func_74762_e("mode");
        this.WCData.front = tag.func_74762_e("front");
        this.WCData.right = tag.func_74762_e("right");
        this.WCData.up = tag.func_74762_e("up");
        this.WCData.back = tag.func_74762_e("back");
        this.WCData.left = tag.func_74762_e("left");
        this.WCData.down = tag.func_74762_e("down");
        this.WCData.distance = tag.func_74762_e("distance");
        this.WCData.direction = tag.func_74762_e("direction");
        this.WCData.playerlist = tag.func_74779_i("players");
        this.WCData.bfreq = tag.func_74779_i("bfreq");
        TileEntityShipCore core = this.findCoreBlock();
        if (core != null) {
            this.WCData.name = core.shipName;
            this.WCData.shipmass = core.shipMass;
            if (this.shipName.isEmpty()) {
                this.shipName = this.WCData.name;
            }
            this.WCData.direction = this.WCoreCoords.ori;
        } else {
            this.logLine("loadControllerConfig: could not find Core!");
        }
    }

    private TileEntityShipCore getCoreByTurn(int turn) {
        TileEntity r = null;
        int x = this.WCCoords.x;
        int y = this.WCCoords.y;
        int z = this.WCCoords.z;
        switch (turn) {
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++x;
                break;
            }
            case 0: {
                ++z;
                break;
            }
            case 1: {
                --x;
            }
        }
        r = this.field_145850_b.func_147438_o(x, y, z);
        if (r != null && r instanceof TileEntityShipCore) {
            this.WCoreCoords.setCoords(this.field_145850_b.field_73011_w.field_76574_g, x, y, z, turn);
        } else {
            r = null;
        }
        return (TileEntityShipCore)r;
    }

    private TileEntityShipCore findCoreBlock() {
        TileEntityShipCore r = null;
        if (this.WCCoords.isValid().booleanValue()) {
            this.WCoreCoords.reset();
            for (int i = 0; i < 4 && r == null; ++i) {
                r = this.getCoreByTurn(i);
            }
        }
        return r;
    }

    private int transformToRelativeFront(int srcX, int srcZ, int tgtX, int tgtZ, int ori) {
        int r = 0;
        switch (ori) {
            case 0: {
                r = srcZ - tgtZ;
                break;
            }
            case 1: {
                r = tgtX - srcX;
                break;
            }
            case 2: {
                r = tgtZ - srcZ;
                break;
            }
            case 3: {
                r = srcX - tgtX;
            }
        }
        return r;
    }

    private int transformToRelativeRight(int srcX, int srcZ, int tgtX, int tgtZ, int ori) {
        int r = 0;
        switch (ori) {
            case 0: {
                r = tgtX - srcX;
                break;
            }
            case 1: {
                r = tgtZ - srcZ;
                break;
            }
            case 2: {
                r = srcX - tgtX;
                break;
            }
            case 3: {
                r = srcZ - tgtZ;
            }
        }
        return r;
    }

    public void doJump(NVLCoordinates Target) {
        if (this.WCCoords.isValid().booleanValue() && this.WCoreCoords.ori >= 0 && this.WCoreCoords.ori < 4) {
            TileEntity te = this.field_145850_b.func_147438_o(this.WCCoords.x, this.WCCoords.y, this.WCCoords.z);
            if (te != null) {
                if (te instanceof TileEntityShipController) {
                    TileEntityShipController wc = (TileEntityShipController)te;
                    TileEntityShipCore Core = this.findCoreBlock();
                    if (Core != null) {
                        NBTTagCompound t = new NBTTagCompound();
                        wc.func_145841_b(t);
                        int front = this.transformToRelativeFront(this.WCoreCoords.x, this.WCoreCoords.z, Target.x, Target.z, this.WCoreCoords.ori);
                        t.func_74768_a("moveFront", front);
                        int up = Target.y - this.WCoreCoords.y;
                        t.func_74768_a("moveUp", up);
                        int right = this.transformToRelativeRight(this.WCoreCoords.x, this.WCoreCoords.z, Target.x, Target.z, this.WCoreCoords.ori);
                        t.func_74768_a("moveRight", right);
                        int turn = (Target.ori - this.WCoreCoords.ori + 4) % 4;
                        t.func_74774_a("rotationSteps", (byte)turn);
                        t.func_74768_a("mode", 1);
                        wc.func_145839_a(t);
                        wc.setJumpFlag(true);
                        this.logLine("doJump [" + this.WCData.name + "] " + front + "," + up + "," + right + "," + turn);
                    } else {
                        this.logLine("doJump: Could not find Core");
                    }
                } else {
                    this.logLine("doJump: wrong entity type " + te.toString());
                }
            } else {
                this.logLine("doJump: NULL entity at " + this.WCCoords.toString());
            }
        } else {
            this.logLine("doJump: Controller coordinates invalid!");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
    }

    public void func_145845_h() {
        if (!this.Coords.isValid().booleanValue()) {
            this.doFirstConfig();
        }
    }
}

